/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.ray2;

import de.grogra.graph.impl.Node;
import de.grogra.imp.IMP;
import de.grogra.imp.Renderer;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.IMP3D;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.imp3d.objects.Box;
import de.grogra.imp3d.objects.TextLabel;
import de.grogra.imp3d.ray2.SceneVisitor;
import de.grogra.pf.boot.Main;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FileTypeItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import de.grogra.ray.physics.Sensor;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray2.Options;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.ray2.Scene;
import de.grogra.ray2.antialiasing.NoAntialiasing;
import de.grogra.ray2.antialiasing.StochasticSupersampling;
import de.grogra.ray2.tracing.BiDirectionalProcessor;
import de.grogra.ray2.tracing.BidirectionalRenderer;
import de.grogra.ray2.tracing.DefaultRayProcessor;
import de.grogra.ray2.tracing.MetropolisProcessor;
import de.grogra.ray2.tracing.MetropolisRenderer;
import de.grogra.ray2.tracing.PathTracer;
import de.grogra.ray2.tracing.PhotonMapRayProcessor;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.Radiosity;
import de.grogra.ray2.tracing.RayProcessor;
import de.grogra.reflect.Type;
import de.grogra.util.EnumerationType;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.MeshVolume;
import de.grogra.vecmath.geom.Octree;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.StringTokenizer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Raytracer
extends Renderer
implements Runnable,
Options,
ImageObserver {
    public static final EnumerationType RAYPROCESSOR = new EnumerationType("ray.processor", IMP3D.I18N, new String[]{"standard", "pathtracer", "photonmap", "bidirectional", "radiosity", "metropolis"}, (Object[])new Class[]{DefaultRayProcessor.class, PathTracer.class, PhotonMapRayProcessor.class, BiDirectionalProcessor.class, Radiosity.class, MetropolisProcessor.class}, Type.CLASS);
    public static final EnumerationType ANTIALIASING = new EnumerationType("ray.antialiasing", IMP3D.I18N, new String[]{"no", "stochastic"}, (Object[])new Class[]{NoAntialiasing.class, StochasticSupersampling.class}, Type.CLASS);
    private Map params;
    private de.grogra.ray2.Renderer renderer;
    private SceneVisitor scene;
    private Matrix4d cameraTransform;
    private Camera camera;
    private ViewConfig3D view3D;
    private volatile boolean disposed;
    public static boolean DEBUG = false;
    private Vector3d tmp = new Vector3d();
    private Point3d min = new Point3d();
    private Point3d max = new Point3d();

    public Raytracer(Map map) {
        this.params = map;
    }

    public Raytracer(Workbench workbench, int n, int n2) {
        this((Map)Item.resolveItem((RegistryContext)workbench, (String)"/renderers/3d/ray2"));
        this.initialize(View3D.getDefaultView((Context)workbench), n, n2);
    }

    public Raytracer(Workbench workbench, ViewConfig3D viewConfig3D, int n, int n2) {
        this((Map)Item.resolveItem((RegistryContext)workbench, (String)"/renderers/3d/ray2"));
        this.initialize(null, n, n2);
        this.view3D = viewConfig3D;
    }

    public String getName() {
        return "Raytracer";
    }

    public Object get(String string, Object object) {
        String string2;
        if ("seed".equals(string) && (string2 = Main.getProperty((String)"raytracerseed")) != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return this.params.get((Object)string, object);
    }

    public void setRandomSeed(int n) {
        Main.getInstance().setProperty("raytracerseed", "" + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        Object object;
        Octree octree;
        Raytracer raytracer;
        if (this.view != null) {
            this.view3D = (View3D)this.view;
        }
        this.scene = new SceneVisitor(this.view3D.getWorkbench(), this.view3D.getGraph(), this.view3D.getEpsilon(), this, this.view3D, null, null, (Spectrum)new Spectrum3f());
        this.camera = this.view3D.getCamera();
        this.cameraTransform = new Matrix4d();
        this.cameraTransform.m33 = 1.0;
        Math2.invertAffine((Matrix4d)this.camera.getWorldToViewTransformation(), (Matrix4d)this.cameraTransform);
        if (DEBUG) {
            raytracer = this.scene.getOctree();
            octree = raytracer.getOctree();
            if (octree.getRoot().getVolumeCount() > 0 && octree.getRoot().getVolume(0, null) instanceof MeshVolume) {
                octree = ((MeshVolume)octree.getRoot().getVolume(0, null)).getOctree();
            }
            object = new TextLabel("DEBUG");
            this.getBoxes((Node)object, octree, octree.getRoot(), true, octree.getDepth());
            IMP.addNode(null, (Object)object, (Context)this.view);
        }
        raytracer = this;
        synchronized (raytracer) {
            if (this.disposed) {
                this.view.getWorkbench().clearStatusAndProgress((Object)this.scene);
                this.scene.dispose();
                this.scene = null;
                return;
            }
            this.renderer = new PixelwiseRenderer();
            this.renderer.initialize((Options)this, (ProgressMonitor)this.scene);
            octree = (RayProcessor)((PixelwiseRenderer)this.renderer).getClassOption("rayprocessor", (Object)new DefaultRayProcessor());
            if (octree instanceof MetropolisProcessor) {
                this.renderer = new MetropolisRenderer();
                this.renderer.initialize((Options)this, (ProgressMonitor)this.scene);
            } else if (octree instanceof BiDirectionalProcessor) {
                this.renderer = new BidirectionalRenderer();
                this.renderer.initialize((Options)this, (ProgressMonitor)this.scene);
            }
            object = new Thread((Runnable)this, this.getName());
            ((Thread)object).setPriority(1);
            ((Thread)object).start();
        }
    }

    private void getBoxes(Node node, Octree octree, Octree.Cell cell, boolean bl, int n) {
        if (cell.children != null) {
            for (int i = 0; i < 8; ++i) {
                this.getBoxes(node, octree, cell.children[i], false, n - 1);
            }
        }
        if (bl || cell.getVolumeCount() > 0) {
            cell.getExtent(octree, (Tuple3d)this.min, (Tuple3d)this.max);
            this.tmp.add((Tuple3d)this.min, (Tuple3d)this.max);
            this.tmp.scale(0.5);
            if (bl || this.tmp.y < 0.0) {
                // empty if block
            }
            Box box = new Box();
            box.setColor((int)(1.6777216E7 * Math.random()));
            box.setTransform(this.tmp.x, this.tmp.y, this.min.z);
            this.tmp.sub((Tuple3d)this.max, (Tuple3d)this.min);
            box.setLength((float)this.tmp.z);
            box.setHeight((float)this.tmp.y);
            box.setWidth((float)this.tmp.x);
            node.addEdgeBitsTo((Node)box, 512, null);
        }
    }

    public synchronized void dispose() {
        this.disposed = true;
        if (this.renderer != null) {
            this.renderer.stop();
            this.renderer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        de.grogra.ray2.Renderer renderer;
        Raytracer raytracer = this;
        synchronized (raytracer) {
            renderer = this.renderer;
        }
        if (renderer != null) {
            float f;
            this.view3D.getWorkbench().beginStatus((Object)this.scene);
            renderer.render((Scene)this.scene, (Sensor)this.camera, this.cameraTransform, this.width, this.height, (ImageObserver)this);
            if (renderer instanceof PixelwiseRenderer && this.params instanceof Item && !(raytracer = (PixelwiseRenderer)renderer).isStopped() && raytracer.getAutoAdjust() && (f = raytracer.getAdjustFactor()) > 0.0f && f < Float.POSITIVE_INFINITY) {
                ((Item)this.params).setOption("brightness", (Object)Float.valueOf(raytracer.getBrightness() * f));
            }
            if (this.view != null) {
                this.view.getViewComponent().disposeRenderer((Renderer)this);
            }
        } else {
            this.view3D.getWorkbench().clearStatusAndProgress((Object)this.scene);
        }
        this.scene.dispose();
        this.renderer = null;
        this.scene = null;
        this.camera = null;
    }

    public static void render(Item item, Object object, Context context) {
        StringTokenizer stringTokenizer = new StringTokenizer(String.valueOf(object));
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                final Dimension dimension = Utils.parseDimension((String)stringTokenizer.nextToken());
                if (stringTokenizer.hasMoreTokens()) {
                    final String string2 = stringTokenizer.nextToken();
                    final Workbench workbench = context.getWorkbench().open((FilterSource)FileSource.createFileSource((String)IO.toSystemId((File)new File(string)), (MimeType)IO.getMimeType((String)string), (RegistryContext)context.getWorkbench(), null), (Map)new StringMap());
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Handler
                    implements ImageObserver,
                    Command {
                        private Image renderedImage;

                        Handler() {
                        }

                        @Override
                        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                            if ((n & 0x20) == 0) {
                                return true;
                            }
                            this.renderedImage = image;
                            workbench.getJobManager().runLater((Command)this, null, (Context)workbench, 10000);
                            return false;
                        }

                        public String getCommandName() {
                            return null;
                        }

                        public void run(Object object, Context context) {
                            if (this.renderedImage != null) {
                                IMP.writeImage((Context)context, (RenderedImage)((RenderedImage)((Object)this.renderedImage)), (MimeType)FileTypeItem.get((RegistryContext)workbench, (String)string2).getMimeType(), (File)new File(string2));
                                IMP.getInstance().exit();
                                return;
                            }
                            Raytracer raytracer = new Raytracer(workbench, dimension.width, dimension.height);
                            raytracer.addImageObserver(this);
                            raytracer.view3D = View3D.getDefaultViewConfig((Context)workbench);
                            raytracer.render();
                        }
                    }
                    workbench.getJobManager().runLater((Command)new Handler(), null, (Context)workbench, 10000);
                    return;
                }
            }
        }
        System.err.println("Invalid argument " + object + ": use '<file> <width>x<height>");
    }
}

