/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.shading;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.shading.ChannelMapNodeVisitor;
import de.grogra.imp3d.shading.Material;
import de.grogra.imp3d.shading.ShaderVisitor;
import de.grogra.math.ChannelData;
import de.grogra.math.ChannelMap;
import de.grogra.math.ColorMap;
import de.grogra.math.Graytone;
import de.grogra.math.RGBColor;
import de.grogra.persistence.ManageableType;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Scattering;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Tests;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.vecmath.Math2;
import java.util.Random;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Phong
extends Material {
    public static final ColorMap DEFAULT_DIFFUSE = new Graytone(0.5f);
    public static final ColorMap DEFAULT_TRANSPARENCY = new Graytone(0.0f);
    public static final ColorMap DEFAULT_SPECULAR = new Graytone(0.0f);
    public static final ColorMap DEFAULT_DIFFUSE_TRANSPARENCY = new Graytone(0.0f);
    public static final ColorMap DEFAULT_AMBIENT = new Graytone(0.0f);
    public static final ColorMap DEFAULT_EMISSIVE = new Graytone(0.0f);
    public static final float MAX_SHININESS = 6.2831854E10f;
    public static final float DEFAULT_SHININESS = 4.0f;
    public static final float DEFAULT_TRANSPARENCY_SHININESS = 6.2831854E10f;
    ChannelMap diffuse = new RGBColor();
    ChannelMap specular = null;
    ChannelMap shininess = null;
    ChannelMap transparency = null;
    ChannelMap transparencyShininess = null;
    boolean interpolatedTransparency = true;
    ChannelMap diffuseTransparency = null;
    ChannelMap ambient = null;
    ChannelMap emissive = null;
    public static final Node.NType $TYPE = new Node.NType((Node)new Phong());
    public static final Node.NType.Field diffuse$FIELD = new _Field("diffuse", 0x400000, (Type)ClassAdapter.wrap(ChannelMap.class), null, 0);
    public static final Node.NType.Field specular$FIELD;
    public static final Node.NType.Field shininess$FIELD;
    public static final Node.NType.Field transparency$FIELD;
    public static final Node.NType.Field transparencyShininess$FIELD;
    public static final Node.NType.Field interpolatedTransparency$FIELD;
    public static final Node.NType.Field diffuseTransparency$FIELD;
    public static final Node.NType.Field ambient$FIELD;
    public static final Node.NType.Field emissive$FIELD;

    public static Phong createPhong() {
        Phong phong = new Phong();
        phong.setSpecular((ChannelMap)new Graytone(0.5f));
        return phong;
    }

    public int getAverageColor() {
        return (this.diffuse instanceof ColorMap ? (ColorMap)this.diffuse : DEFAULT_DIFFUSE).getAverageColor();
    }

    public int getFlags() {
        return 63;
    }

    public static float convertShininess(float f) {
        if ((f *= 2.0f - f) <= 0.0f) {
            return 0.0f;
        }
        if (f >= 1.0f) {
            return 6.2831854E10f;
        }
        return Math.min(-2.0f / (float)Math.log(f), 6.2831854E10f);
    }

    private static float shininessPow(float f, float f2) {
        return f >= 1.0f ? 1.0f : (float)Math.pow(f, f2);
    }

    private float computeEnv(Environment environment, Vector3f vector3f, ChannelData channelData, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, Tuple3f tuple3f4, Point2f point2f, boolean bl) {
        ChannelData channelData2 = this.getInputData(channelData);
        channelData2.getTuple3f((Tuple3f)vector3f2, channelData, 4);
        vector3f2.normalize();
        ChannelData channelData3 = channelData.getData((ChannelMap)(this.transparency != null ? this.transparency : DEFAULT_TRANSPARENCY));
        channelData3.getTuple3f(tuple3f3, channelData, 24);
        channelData3 = channelData.getData((ChannelMap)(this.diffuse != null ? this.diffuse : DEFAULT_DIFFUSE));
        channelData3.getTuple3f(tuple3f, channelData, 24);
        float f = channelData3.getFloatValue(channelData, 27);
        tuple3f3.x = 1.0f + f * (tuple3f3.x - 1.0f);
        tuple3f3.y = 1.0f + f * (tuple3f3.y - 1.0f);
        tuple3f3.z = 1.0f + f * (tuple3f3.z - 1.0f);
        if (this.interpolatedTransparency) {
            tuple3f.x *= 1.0f - tuple3f3.x;
            tuple3f.y *= 1.0f - tuple3f3.y;
            tuple3f.z *= 1.0f - tuple3f3.z;
        }
        channelData3 = channelData.getData((ChannelMap)(this.diffuseTransparency != null ? this.diffuseTransparency : DEFAULT_DIFFUSE_TRANSPARENCY));
        channelData3.getTuple3f(tuple3f4, channelData, 24);
        if (this.shininess != null) {
            channelData3 = channelData.getData(this.shininess);
            point2f.x = Phong.convertShininess(channelData3.getFloatValue(channelData, 24));
        } else {
            point2f.x = 4.0f;
        }
        if (this.transparencyShininess != null) {
            channelData3 = channelData.getData(this.transparencyShininess);
            point2f.y = Phong.convertShininess(channelData3.getFloatValue(channelData, 24));
        } else {
            point2f.y = 6.2831854E10f;
        }
        float f2 = Math2.fresnel((Vector3f)vector3f2, (Vector3f)vector3f, (float)channelData2.getFloatValue(channelData, 28), (Vector3f)vector3f3, (Vector3f)vector3f4);
        if (this.specular != null) {
            channelData3 = channelData.getData(this.specular);
            channelData3.getTuple3f(tuple3f2, channelData, 24);
            if (this.interpolatedTransparency) {
                tuple3f2.x *= 1.0f - tuple3f3.x;
                tuple3f2.y *= 1.0f - tuple3f3.y;
                tuple3f2.z *= 1.0f - tuple3f3.z;
            }
            tuple3f2.scaleAdd(f2, tuple3f3, tuple3f2);
        } else {
            tuple3f2.set(0.0f, 0.0f, 0.0f);
        }
        if (bl) {
            tuple3f3.scale(1.0f - f2);
        } else {
            float f3 = environment.iorRatio;
            if (environment.normal.dot(vector3f) > 0.0f) {
                f3 = 1.0f / f3;
            }
            tuple3f3.scale(f3 * f3 * (1.0f - f2));
            tuple3f4.scale(f3 * f3);
        }
        if (environment.normal.dot(vector3f) < 0.0f) {
            vector3f2.negate();
        }
        return f2;
    }

    public void shade(Environment environment, RayList rayList, Vector3f vector3f, Spectrum spectrum, Tuple3d tuple3d) {
        ChannelData channelData = this.getSource(environment);
        ChannelData channelData2 = channelData.getSink();
        Vector3f vector3f2 = channelData2.v3f0;
        Vector3f vector3f3 = channelData2.v3f1;
        Vector3f vector3f4 = channelData2.v3f2;
        Vector3f vector3f5 = channelData2.v3f3;
        Point3f point3f = channelData2.p3f0;
        Point3f point3f2 = channelData2.p3f1;
        Point3f point3f3 = channelData2.p3f2;
        Point3f point3f4 = channelData2.p3f3;
        Point3f point3f5 = channelData2.q3f0;
        Point2f point2f = channelData2.p2f0;
        this.computeEnv(environment, vector3f, channelData2, vector3f3, vector3f5, vector3f4, (Tuple3f)point3f, (Tuple3f)point3f2, (Tuple3f)point3f3, (Tuple3f)point3f5, point2f, true);
        Point3d point3d = environment.tmpPoint0;
        ChannelData channelData3 = channelData2.getData((ChannelMap)(this.emissive != null ? this.emissive : DEFAULT_EMISSIVE));
        channelData3.getTuple3f((Tuple3f)vector3f4, channelData2, 24);
        tuple3d.set((Tuple3f)vector3f4);
        channelData3 = channelData2.getData((ChannelMap)(this.ambient != null ? this.ambient : DEFAULT_AMBIENT));
        channelData3.getTuple3f((Tuple3f)point3f4, channelData2, 24);
        for (int i = 0; i < rayList.getSize(); ++i) {
            if (rayList.rays[i].ambient) {
                vector3f2.set((Tuple3f)point3f4);
            } else {
                Vector3f vector3f6 = rayList.rays[i].direction;
                float f = vector3f3.dot(vector3f6);
                if (f >= 0.0f == vector3f3.dot(vector3f) >= 0.0f) {
                    float f2;
                    vector3f2.set((Tuple3f)point3f);
                    if (point3f2.x + point3f2.y + point3f2.z > 0.0f && (f2 = vector3f5.dot(vector3f6)) > 0.0f) {
                        vector3f2.scaleAdd(Phong.shininessPow(f2, point2f.x), (Tuple3f)point3f2, (Tuple3f)vector3f2);
                    }
                    vector3f2.scale(f < 0.0f ? -f : f);
                } else {
                    vector3f2.set((Tuple3f)point3f3);
                    vector3f2.scaleAdd(f < 0.0f ? -f : f, (Tuple3f)point3f5, (Tuple3f)vector3f2);
                }
            }
            rayList.rays[i].spectrum.dot(spectrum, (Tuple3d)point3d);
            tuple3d.x += (double)vector3f2.x * point3d.x;
            tuple3d.y += (double)vector3f2.y * point3d.y;
            tuple3d.z += (double)vector3f2.z * point3d.z;
        }
    }

    public void computeMaxRays(Environment environment, Vector3f vector3f, Spectrum spectrum, Ray ray, Tuple3f tuple3f, Ray ray2, Tuple3f tuple3f2) {
        float f;
        ChannelData channelData = this.getSource(environment);
        ChannelData channelData2 = channelData.getSink();
        Vector3f vector3f2 = channelData2.v3f0;
        Vector3f vector3f3 = channelData2.v3f2;
        Point3f point3f = channelData2.p3f0;
        Point3f point3f2 = channelData2.p3f1;
        Point3f point3f3 = channelData2.p3f2;
        Point2f point2f = channelData2.p2f0;
        this.computeEnv(environment, vector3f, channelData2, vector3f2, ray.direction, ray2.direction, (Tuple3f)point3f, (Tuple3f)vector3f3, (Tuple3f)point3f2, (Tuple3f)point3f3, point2f, true);
        tuple3f2.x = f = 2.0f / (point2f.y + 3.0f);
        tuple3f2.y = f;
        tuple3f2.z = f;
        if (vector3f3.x + vector3f3.y + vector3f3.z <= 0.0f) {
            ray.direction.set((Tuple3f)vector3f2);
            tuple3f.x = 0.7337006f;
            tuple3f.y = 0.7337006f;
            tuple3f.z = 0.7337006f;
        } else {
            f = 2.0f / (point2f.x + 3.0f);
            point3f.set((Tuple3f)vector3f3);
            tuple3f.x = f;
            tuple3f.y = f;
            tuple3f.z = f;
        }
        ray.spectrum.set(spectrum);
        ray.spectrum.mul((Tuple3f)point3f);
        ray2.spectrum.set(spectrum);
        ray2.spectrum.mul((Tuple3f)point3f2);
    }

    static float dot(Tuple3f tuple3f, Tuple3f tuple3f2, boolean bl) {
        return bl ? 0.2989f * tuple3f.x * tuple3f2.x + 0.5866f * tuple3f.y * tuple3f2.y + 0.1145f * tuple3f.z * tuple3f2.z : tuple3f.x * tuple3f2.x + tuple3f.y * tuple3f2.y + tuple3f.z * tuple3f2.z;
    }

    public void generateRandomRays(Environment environment, Vector3f vector3f, Spectrum spectrum, RayList rayList, boolean bl, Random random) {
        ChannelData channelData = this.getSource(environment);
        ChannelData channelData2 = channelData.getSink();
        Vector3f vector3f2 = channelData2.v3f0;
        Vector3f vector3f3 = channelData2.v3f2;
        Vector3f vector3f4 = channelData2.v3f3;
        Point3f point3f = channelData2.p3f0;
        Point3f point3f2 = channelData2.p3f1;
        Point3f point3f3 = channelData2.p3f2;
        Point3f point3f4 = channelData2.p3f3;
        Vector3f vector3f5 = channelData2.w3f0;
        Point2f point2f = channelData2.p2f0;
        this.computeEnv(environment, vector3f, channelData2, vector3f2, vector3f3, vector3f4, (Tuple3f)point3f, (Tuple3f)point3f2, (Tuple3f)point3f3, (Tuple3f)point3f4, point2f, bl);
        float f = Math.abs(vector3f.dot(vector3f2));
        spectrum.get((Tuple3f)vector3f5);
        boolean bl2 = environment.type != 2;
        float f2 = Phong.dot((Tuple3f)vector3f5, (Tuple3f)point3f, bl2);
        float f3 = Phong.dot((Tuple3f)vector3f5, (Tuple3f)point3f2, bl2);
        float f4 = Phong.dot((Tuple3f)vector3f5, (Tuple3f)point3f4, bl2);
        float f5 = Phong.dot((Tuple3f)vector3f5, (Tuple3f)point3f3, bl2);
        float f6 = f2 + f3 + f4 + f5;
        f6 = (double)f6 < 1.0E-7 ? 0.0f : 1.0f / f6;
        f2 *= f6;
        f3 *= f6;
        f4 *= f6;
        f5 *= f6;
        Matrix3f matrix3f = null;
        Matrix3f matrix3f2 = null;
        Matrix3f matrix3f3 = null;
        for (int i = rayList.getSize() - 1; i >= 0; --i) {
            Vector3f vector3f6 = rayList.rays[i].direction;
            rayList.rays[i].valid = true;
            float f7 = (float)(2 * (random.nextInt() >>> 8) + 1) * 2.9802322E-8f;
            if (f6 == 0.0f) {
                vector3f5.set(0.0f, 0.0f, 0.0f);
                rayList.rays[i].direction.set(1.0f, 0.0f, 0.0f);
                rayList.rays[i].directionDensity = 1.0E10f;
                rayList.rays[i].valid = false;
            } else {
                float f8;
                float f9;
                float f10;
                Matrix3f matrix3f4;
                float f11;
                boolean bl3;
                boolean bl4;
                if (f7 <= f5) {
                    bl4 = true;
                    bl3 = true;
                    f11 = point2f.y;
                    matrix3f4 = matrix3f3;
                    if (matrix3f4 == null) {
                        matrix3f4 = matrix3f3 = environment.userMatrix3;
                        Math2.getOrthogonalBasis((Tuple3f)vector3f4, (Matrix3f)matrix3f3, (boolean)true);
                    }
                } else if (f7 <= f5 + f3) {
                    bl4 = false;
                    bl3 = true;
                    f11 = point2f.x;
                    matrix3f4 = matrix3f2;
                    if (matrix3f4 == null) {
                        matrix3f4 = matrix3f2 = environment.userMatrix2;
                        Math2.getOrthogonalBasis((Tuple3f)vector3f3, (Matrix3f)matrix3f2, (boolean)true);
                    }
                } else {
                    bl4 = f7 <= f5 + f3 + f4;
                    bl3 = false;
                    f11 = 0.0f;
                    matrix3f4 = matrix3f;
                    if (matrix3f4 == null) {
                        matrix3f4 = matrix3f = environment.userMatrix;
                        Math2.getOrthogonalBasis((Tuple3f)vector3f2, (Matrix3f)matrix3f, (boolean)true);
                    }
                }
                int n = random.nextInt();
                if (bl3) {
                    double d = 7.62939453125E-6 * (double)(2 * (n >>> 16) + 1);
                    f10 = (float)Math.pow(d, 1.0f / (f11 + 1.0f));
                    f9 = (float)Math.sqrt(1.0f - f10 * f10);
                    f8 = f10;
                } else {
                    f7 = (float)(2 * (n >>> 16)) * 7.6293945E-6f;
                    f10 = (float)Math.sqrt(f7);
                    f9 = (float)Math.sqrt(1.0f - f7);
                    if (bl4) {
                        f10 = -f10;
                    }
                    f8 = 0.0f;
                }
                char c = (char)n;
                vector3f6.set(Math2.ccos((char)c) * f9, Math2.csin((char)c) * f9, f10);
                matrix3f4.transform((Tuple3f)vector3f6);
                f10 = vector3f6.dot(vector3f2);
                if (bl4) {
                    f10 = -f10;
                }
                if (f10 > 0.0f) {
                    float f12;
                    vector3f5.scale(Math2.M_1_PI, (Tuple3f)(bl4 ? point3f4 : point3f));
                    f7 = (bl4 ? f4 : f2) * f10 * Math2.M_1_PI;
                    if (!bl3) {
                        f8 = vector3f6.dot(bl4 ? vector3f4 : vector3f3);
                    }
                    float f13 = f12 = bl4 ? f5 : f3;
                    if (f8 > 0.0f && f12 > 0.0f) {
                        f8 = Phong.shininessPow(f8, f11);
                        vector3f5.scaleAdd((f11 + 2.0f) * f8 * Math2.M_1_2PI / Math.max(f10, f), (Tuple3f)(bl4 ? point3f3 : point3f2), (Tuple3f)vector3f5);
                        f7 += f12 * (f11 + 1.0f) * f8 * Math2.M_1_2PI;
                    }
                    vector3f5.scale(f10 / f7);
                    rayList.rays[i].directionDensity = f7;
                } else {
                    vector3f5.set(0.0f, 0.0f, 0.0f);
                    rayList.rays[i].directionDensity = 1.0E10f;
                }
                rayList.rays[i].reflected = !bl4;
            }
            rayList.rays[i].spectrum.set(spectrum);
            rayList.rays[i].spectrum.mul((Tuple3f)vector3f5);
        }
    }

    public float computeBSDF(Environment environment, Vector3f vector3f, Spectrum spectrum, Vector3f vector3f2, boolean bl, Spectrum spectrum2) {
        float f;
        boolean bl2;
        float f2 = vector3f2.dot(environment.normal);
        float f3 = vector3f.dot(environment.normal);
        boolean bl3 = bl2 = f3 > 0.0f != f2 > 0.0f;
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        ChannelData channelData = this.getSource(environment);
        ChannelData channelData2 = channelData.getSink();
        Point2f point2f = channelData2.p2f0;
        Vector3f vector3f3 = channelData2.v3f1;
        Vector3f vector3f4 = channelData2.v3f2;
        Vector3f vector3f5 = channelData2.v3f3;
        Point3f point3f = channelData2.p3f0;
        Point3f point3f2 = channelData2.p3f1;
        Point3f point3f3 = channelData2.p3f2;
        Point3f point3f4 = channelData2.p3f3;
        Vector3f vector3f6 = channelData2.w3f0;
        this.computeEnv(environment, vector3f2, channelData2, vector3f3, vector3f5, vector3f4, (Tuple3f)point3f, (Tuple3f)point3f2, (Tuple3f)point3f3, (Tuple3f)point3f4, point2f, bl);
        f2 = vector3f2.dot(vector3f3);
        f3 = vector3f.dot(vector3f3);
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (bl2) {
            Point3f point3f5 = point3f4;
            point3f4 = point3f;
            point3f = point3f5;
            point3f5 = point3f3;
            point3f3 = point3f2;
            point3f2 = point3f5;
            f = point2f.y;
            vector3f5 = vector3f4;
        } else {
            f = point2f.x;
        }
        float f4 = point3f.x + point3f.y + point3f.z;
        float f5 = point3f2.x + point3f2.y + point3f2.z;
        float f6 = point3f3.x + point3f3.y + point3f3.z;
        float f7 = f4 + f5 + f6;
        if (f7 > 0.0f) {
            f7 = 1.0f / f7;
        }
        float f8 = vector3f5.epsilonEquals((Tuple3f)vector3f, 1.0E-6f) ? 1.0f : vector3f5.dot(vector3f);
        float f9 = f4 * f7 * f2 * Math2.M_1_PI;
        vector3f6.scale(Math2.M_1_PI * f2, (Tuple3f)point3f);
        if (f8 > 0.0f && f5 > 0.0f) {
            f8 = Phong.shininessPow(f8, f);
            vector3f6.scaleAdd((f + 2.0f) * f8 * Math2.M_1_2PI * ((f3 = Math.abs(f3)) > f2 ? f2 / f3 : 1.0f), (Tuple3f)point3f2, (Tuple3f)vector3f6);
            f9 += f5 * f7 * (f + 1.0f) * f8 * Math2.M_1_2PI;
        }
        spectrum2.set(spectrum);
        spectrum2.mul((Tuple3f)vector3f6);
        return f9;
    }

    public boolean isTransparent() {
        return this.transparency != null;
    }

    public static void main(String[] stringArray) {
        Phong phong = new Phong();
        phong.diffuse = new Graytone(0.0f);
        phong.specular = new Graytone(1.0f);
        phong.transparency = new Graytone(0.0f);
        phong.diffuseTransparency = new Graytone(0.0f);
        float f = 0.02f;
        System.out.println("# " + Phong.convertShininess(f));
        phong.shininess = new Graytone(f);
        Tests.computeAlbedo((Scattering)phong, (int)100, (int)400);
    }

    public Phong clone() {
        Phong phong = new Phong();
        phong.setAmbient(this.getAmbient());
        phong.setDiffuse(this.getDiffuse());
        phong.setDiffuseTransparency(this.getDiffuseTransparency());
        phong.setEmissive(this.getEmissive());
        phong.setShininess(this.getShininess());
        phong.setSpecular(this.getSpecular());
        phong.setTransparency(this.getTransparency());
        phong.setTransparencyShininess(this.getTransparencyShininess());
        return phong;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Phong();
    }

    public boolean isInterpolatedTransparency() {
        return this.interpolatedTransparency;
    }

    public void setInterpolatedTransparency(boolean bl) {
        this.interpolatedTransparency = bl;
    }

    public ChannelMap getDiffuse() {
        return this.diffuse;
    }

    public void setDiffuse(ChannelMap channelMap) {
        diffuse$FIELD.setObject((Object)this, (Object)channelMap);
    }

    public ChannelMap getSpecular() {
        return this.specular;
    }

    public void setSpecular(ChannelMap channelMap) {
        specular$FIELD.setObject((Object)this, (Object)channelMap);
    }

    public ChannelMap getShininess() {
        return this.shininess;
    }

    public void setShininess(ChannelMap channelMap) {
        shininess$FIELD.setObject((Object)this, (Object)channelMap);
    }

    public ChannelMap getTransparency() {
        return this.transparency;
    }

    public void setTransparency(ChannelMap channelMap) {
        transparency$FIELD.setObject((Object)this, (Object)channelMap);
    }

    public ChannelMap getTransparencyShininess() {
        return this.transparencyShininess;
    }

    public void setTransparencyShininess(ChannelMap channelMap) {
        transparencyShininess$FIELD.setObject((Object)this, (Object)channelMap);
    }

    public ChannelMap getDiffuseTransparency() {
        return this.diffuseTransparency;
    }

    public void setDiffuseTransparency(ChannelMap channelMap) {
        diffuseTransparency$FIELD.setObject((Object)this, (Object)channelMap);
    }

    public ChannelMap getAmbient() {
        return this.ambient;
    }

    public void setAmbient(ChannelMap channelMap) {
        ambient$FIELD.setObject((Object)this, (Object)channelMap);
    }

    public ChannelMap getEmissive() {
        return this.emissive;
    }

    public void setEmissive(ChannelMap channelMap) {
        emissive$FIELD.setObject((Object)this, (Object)channelMap);
    }

    public void accept(ShaderVisitor shaderVisitor) {
        shaderVisitor.visit(this);
    }

    public void accept(ChannelMapNodeVisitor channelMapNodeVisitor) {
        channelMapNodeVisitor.visit(this);
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)diffuse$FIELD);
        specular$FIELD = new _Field("specular", 0x400000, (Type)ClassAdapter.wrap(ChannelMap.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)specular$FIELD);
        shininess$FIELD = new _Field("shininess", 0x400000, (Type)ClassAdapter.wrap(ChannelMap.class), null, 2);
        $TYPE.addManagedField((ManageableType.Field)shininess$FIELD);
        transparency$FIELD = new _Field("transparency", 0x400000, (Type)ClassAdapter.wrap(ChannelMap.class), null, 3);
        $TYPE.addManagedField((ManageableType.Field)transparency$FIELD);
        transparencyShininess$FIELD = new _Field("transparencyShininess", 0x400000, (Type)ClassAdapter.wrap(ChannelMap.class), null, 4);
        $TYPE.addManagedField((ManageableType.Field)transparencyShininess$FIELD);
        interpolatedTransparency$FIELD = new _Field("interpolatedTransparency", 0x200000, Type.BOOLEAN, null, 5);
        $TYPE.addManagedField((ManageableType.Field)interpolatedTransparency$FIELD);
        diffuseTransparency$FIELD = new _Field("diffuseTransparency", 0x400000, (Type)ClassAdapter.wrap(ChannelMap.class), null, 6);
        $TYPE.addManagedField((ManageableType.Field)diffuseTransparency$FIELD);
        ambient$FIELD = new _Field("ambient", 0x400000, (Type)ClassAdapter.wrap(ChannelMap.class), null, 7);
        $TYPE.addManagedField((ManageableType.Field)ambient$FIELD);
        emissive$FIELD = new _Field("emissive", 0x400000, (Type)ClassAdapter.wrap(ChannelMap.class), null, 8);
        $TYPE.addManagedField((ManageableType.Field)emissive$FIELD);
        $TYPE.setSpecialEdgeField(diffuse$FIELD, 3);
        $TYPE.setSpecialEdgeField(specular$FIELD, 8);
        $TYPE.setSpecialEdgeField(shininess$FIELD, 9);
        $TYPE.setSpecialEdgeField(transparency$FIELD, 4);
        $TYPE.setSpecialEdgeField(transparencyShininess$FIELD, 5);
        $TYPE.setSpecialEdgeField(diffuseTransparency$FIELD, 10);
        $TYPE.setSpecialEdgeField(ambient$FIELD, 6);
        $TYPE.setSpecialEdgeField(emissive$FIELD, 7);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        public void setBoolean(Object object, boolean bl) {
            switch (this.id) {
                case 5: {
                    ((Phong)object).interpolatedTransparency = bl;
                    return;
                }
            }
            super.setBoolean(object, bl);
        }

        public boolean getBoolean(Object object) {
            switch (this.id) {
                case 5: {
                    return ((Phong)object).isInterpolatedTransparency();
                }
            }
            return super.getBoolean(object);
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((Phong)object).diffuse = (ChannelMap)object2;
                    return;
                }
                case 1: {
                    ((Phong)object).specular = (ChannelMap)object2;
                    return;
                }
                case 2: {
                    ((Phong)object).shininess = (ChannelMap)object2;
                    return;
                }
                case 3: {
                    ((Phong)object).transparency = (ChannelMap)object2;
                    return;
                }
                case 4: {
                    ((Phong)object).transparencyShininess = (ChannelMap)object2;
                    return;
                }
                case 6: {
                    ((Phong)object).diffuseTransparency = (ChannelMap)object2;
                    return;
                }
                case 7: {
                    ((Phong)object).ambient = (ChannelMap)object2;
                    return;
                }
                case 8: {
                    ((Phong)object).emissive = (ChannelMap)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((Phong)object).getDiffuse();
                }
                case 1: {
                    return ((Phong)object).getSpecular();
                }
                case 2: {
                    return ((Phong)object).getShininess();
                }
                case 3: {
                    return ((Phong)object).getTransparency();
                }
                case 4: {
                    return ((Phong)object).getTransparencyShininess();
                }
                case 6: {
                    return ((Phong)object).getDiffuseTransparency();
                }
                case 7: {
                    return ((Phong)object).getAmbient();
                }
                case 8: {
                    return ((Phong)object).getEmissive();
                }
            }
            return super.getObject(object);
        }
    }
}

