/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidMenuItemUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class LiquidMenuUI
extends LiquidMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private static MenuListener sharedMenuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static boolean crossMenuMnemonic;

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidMenuUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JMenu jMenu = (JMenu)jComponent;
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIManager.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    void updateMnemonicBinding() {
        int n;
        int n2 = this.menuItem.getModel().getMnemonic();
        int[] nArray = (int[])UIManager.get("Menu.shortcutKeys");
        if (n2 == this.lastMnemonic || nArray == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (n = 0; n < nArray.length; ++n) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, nArray[n], false));
            }
        }
        if (n2 != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (n = 0; n < nArray.length; ++n) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n2, nArray[n], false), "selectMenu");
            }
        }
        this.lastMnemonic = n2;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null) {
            actionMap.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return actionMap;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        if (sharedMenuListener == null) {
            sharedMenuListener = new MenuHandler();
        }
        return sharedMenuListener;
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    private static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i = menuElementArray.length - 1; i >= 0; --i) {
            MenuElement menuElement = menuElementArray[i];
            if (!(menuElement instanceof JPopupMenu)) continue;
            return (JPopupMenu)menuElement;
        }
        return null;
    }

    static {
        crossMenuMnemonic = true;
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private int[] indexes;
        private char lastMnemonic;
        private int lastIndex;
        private int matches;

        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            JPopupMenu jPopupMenu;
            if (!crossMenuMnemonic && (jPopupMenu = LiquidMenuUI.getActivePopupMenu()) != null && jPopupMenu != LiquidMenuUI.this.menuItem.getParent()) {
                return;
            }
            int n = LiquidMenuUI.this.menuItem.getMnemonic();
            if (n == 0) {
                return;
            }
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            if (this.lower((char)n) == this.lower(menuKeyEvent.getKeyChar())) {
                JPopupMenu jPopupMenu2 = ((JMenu)LiquidMenuUI.this.menuItem).getPopupMenu();
                MenuElement[] menuElementArray2 = jPopupMenu2.getSubElements();
                if (menuElementArray2.length > 0) {
                    MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                    MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 2];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                    menuElementArray3[menuElementArray.length] = jPopupMenu2;
                    menuElementArray3[menuElementArray.length + 1] = menuElementArray2[0];
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                }
                menuKeyEvent.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            char c = menuKeyEvent.getKeyChar();
            if (!Character.isLetterOrDigit(c)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            for (int i = menuElementArray2.length - 1; i >= 0; --i) {
                if (menuElementArray2[i] != LiquidMenuUI.this.menuItem) continue;
                JPopupMenu jPopupMenu = ((JMenu)LiquidMenuUI.this.menuItem).getPopupMenu();
                MenuElement[] menuElementArray3 = jPopupMenu.getSubElements();
                if (this.indexes == null || this.lastMnemonic != c) {
                    this.matches = 0;
                    this.lastIndex = 0;
                    this.indexes = new int[menuElementArray3.length];
                    for (int j = 0; j < menuElementArray3.length; ++j) {
                        int n = ((JMenuItem)menuElementArray3[j]).getMnemonic();
                        if (this.lower((char)n) != this.lower(c)) continue;
                        this.indexes[this.matches++] = j;
                    }
                    this.lastMnemonic = c;
                }
                if (this.matches != 0) {
                    if (this.matches == 1) {
                        JMenuItem jMenuItem = (JMenuItem)menuElementArray3[this.indexes[0]];
                        if (!(jMenuItem instanceof JMenu)) {
                            menuSelectionManager.clearSelectedPath();
                            jMenuItem.doClick();
                        }
                    } else {
                        if (this.lastIndex == this.matches) {
                            this.lastIndex = 0;
                        }
                        MenuElement menuElement = menuElementArray3[this.indexes[this.lastIndex++]];
                        MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                        menuElementArray4[menuElementArray.length] = jPopupMenu;
                        menuElementArray4[menuElementArray.length + 1] = menuElement;
                        menuSelectionManager.setSelectedPath(menuElementArray4);
                    }
                }
                menuKeyEvent.consume();
                return;
            }
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char lower(char c) {
            return Character.toLowerCase(c);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!LiquidMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < LiquidMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < LiquidMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)LiquidMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        LiquidMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        LiquidMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public LiquidMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu jMenu, LiquidMenuUI liquidMenuUI2) {
            this.menu = jMenu;
            this.ui = liquidMenuUI2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    private static class MenuHandler
    implements MenuListener {
        private MenuHandler() {
        }

        public void menuSelected(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.isComponentPartOfCurrentMenu(jMenu)) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            JMenu jMenu = (JMenu)LiquidMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = jMenu.getParent();
                    if (object != null && object instanceof JMenuBar) {
                        MenuElement[] menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    LiquidMenuUI.appendPath(object, jMenu.getPopupMenu());
                } else {
                    LiquidMenuUI.this.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)LiquidMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)LiquidMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            jMenu.putClientProperty("rollover", Boolean.TRUE);
            jMenu.repaint();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        LiquidMenuUI.appendPath(LiquidMenuUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(LiquidMenuUI.this.getPath());
                        LiquidMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
            jMenu.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)LiquidMenuUI.this.menuItem;
            jMenu.putClientProperty("rollover", Boolean.FALSE);
            jMenu.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)LiquidMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("mnemonic")) {
                LiquidMenuUI.this.updateMnemonicBinding();
            }
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu jMenu, boolean bl) {
            this.menu = jMenu;
            this.force = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!crossMenuMnemonic && (object = LiquidMenuUI.getActivePopupMenu()) != null && object != this.menu.getParent()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] menuElementArray2 = menuElementArray.length > 0 ? new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]} : new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu()};
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray2);
                }
            } else {
                MenuElement[] menuElementArray = ((MenuSelectionManager)object).getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    LiquidMenuUI.appendPath(menuElementArray, this.menu.getPopupMenu());
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }
}

