/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidScrollButton;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.skin.SkinSimpleButtonIndexModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class LiquidScrollBarUI
extends BasicScrollBarUI {
    private int orientation = -1;
    private int minExtent;
    private int minValue;
    private final int MIN_THUMB_SIZE = 14;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    private boolean freeStanding = false;
    int scrollBarWidth;
    private static Skin skinTrackVert;
    private static Skin skinTrackHoriz;
    private Skin skinTrack;
    private static Skin skinThumbVert;
    private static Skin skinThumbHoriz;
    private Skin skinThumb;
    private SkinSimpleButtonIndexModel skinThumbIndexModel = new SkinSimpleButtonIndexModel();
    JButton decreaseButton;
    JButton increaseButton;

    protected void installDefaults() {
        this.scrollBarWidth = LiquidScrollButton.getSkinUp().getHsize();
        super.installDefaults();
        this.scrollbar.setBorder(null);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidScrollBarUI();
    }

    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new LiquidScrollButton(n, this.scrollBarWidth, this.freeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new LiquidScrollButton(n, this.scrollBarWidth, this.freeStanding);
        return this.increaseButton;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        int n4 = this.decrButton.getPreferredSize().height;
        int n5 = insets.top;
        int n6 = this.incrButton.getPreferredSize().height;
        int n7 = dimension.height - (insets.bottom + n6);
        int n8 = insets.top + insets.bottom;
        int n9 = n4 + n6;
        float f = dimension.height - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n10 = f4 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().height);
        if ((n10 = Math.min(n10, this.getMaximumThumbSize().height)) < 14) {
            n10 = 14;
        }
        int n11 = n7 - n10;
        if (jScrollBar.getValue() < jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
            n11 += n5 + n4;
        }
        if ((n = dimension.height - n8) < n9) {
            n6 = n4 = n / 2;
            n7 = dimension.height - (insets.bottom + n6);
        }
        this.decrButton.setBounds(n3, n5, n2, n4);
        this.incrButton.setBounds(n3, n7, n2, n6);
        int n12 = n5 + n4;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n3, n12, n2, n13);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n11 + n10 > n7) {
                n11 = n7 - n10;
            }
            if (n11 < n5 + n4) {
                n11 = n5 + n4 + 1;
            }
            this.setThumbBounds(n3, n11, n2, n10);
        }
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        int n;
        int n2;
        boolean bl;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n3 = dimension.height - (insets.top + insets.bottom);
        int n4 = insets.top;
        int n5 = ((bl = jScrollBar.getComponentOrientation().isLeftToRight()) ? this.decrButton : this.incrButton).getPreferredSize().width;
        int n6 = (bl ? this.incrButton : this.decrButton).getPreferredSize().width;
        int n7 = insets.left;
        int n8 = dimension.width - (insets.right + n6);
        int n9 = insets.left + insets.right;
        int n10 = n5 + n6;
        float f = dimension.width - (n9 + n10);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getMaximum();
        float f4 = jScrollBar.getVisibleAmount();
        float f5 = f3 - f2;
        float f6 = jScrollBar.getValue();
        int n11 = f5 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f * (f4 / f5));
        n11 = Math.max(n11, this.getMinimumThumbSize().width);
        if ((n11 = Math.min(n11, this.getMaximumThumbSize().width)) < 14) {
            n11 = 14;
        }
        int n12 = n2 = bl ? n8 - n11 : n7 + n5;
        if ((float)jScrollBar.getValue() < f3 - (float)jScrollBar.getVisibleAmount()) {
            float f7 = f - (float)n11;
            n2 = bl ? (int)(0.5f + f7 * ((f6 - f2) / (f5 - f4))) : (int)(0.5f + f7 * ((f3 - f4 - f6) / (f5 - f4)));
            n2 += n7 + n5;
        }
        if ((n = dimension.width - n9) < n10) {
            n6 = n5 = n / 2;
            n8 = dimension.width - (insets.right + n6);
        }
        (bl ? this.decrButton : this.incrButton).setBounds(n7, n4, n5, n3);
        (bl ? this.incrButton : this.decrButton).setBounds(n8, n4, n6, n3);
        int n13 = n7 + n5;
        int n14 = n8 - n13;
        this.trackRect.setBounds(n13, n4, n14, n3);
        if (n11 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n2 + n11 > n8) {
                n2 = n8 - n11;
            }
            if (n2 < n7 + n5) {
                n2 = n7 + n5 + 1;
            }
            this.setThumbBounds(n2, n4, n11, n3);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.orientation == -1) {
            this.orientation = this.scrollbar.getOrientation();
        }
        Rectangle rectangle = this.getTrackBounds();
        this.getSkinTrack().draw(graphics, 0, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Rectangle rectangle2 = this.getThumbBounds();
        int n = this.skinThumbIndexModel.getIndexForState(jComponent.isEnabled(), this.isRollover, this.isDragging);
        int n2 = this.orientation == 1 ? rectangle2.x + 1 : rectangle2.x;
        int n3 = this.orientation == 1 ? rectangle2.y : rectangle2.y + 1;
        int n4 = this.orientation == 1 ? rectangle2.width - 2 : rectangle2.width;
        int n5 = this.orientation == 1 ? rectangle2.height : rectangle2.height - 2;
        this.getSkinThumb().draw(graphics, n, n2, n3, n4, n5);
    }

    public boolean isThumbVisible() {
        if (this.scrollbar.getOrientation() == 1) {
            return this.getThumbBounds().height != 0;
        }
        return this.getThumbBounds().width != 0;
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    public static Skin getSkinThumbHoriz() {
        if (skinThumbHoriz == null) {
            skinThumbHoriz = new Skin("scrollbarthumbhoriz.png", 4, 8, 6, 8, 8);
        }
        return skinThumbHoriz;
    }

    public static Skin getSkinThumbVert() {
        if (skinThumbVert == null) {
            skinThumbVert = new Skin("scrollbarthumbvert.png", 4, 6, 8, 8, 7);
        }
        return skinThumbVert;
    }

    public static Skin getSkinTrackHoriz() {
        if (skinTrackHoriz == null) {
            skinTrackHoriz = new Skin("scrollbartrackhoriz.png", 1, 7);
        }
        return skinTrackHoriz;
    }

    public static Skin getSkinTrackVert() {
        if (skinTrackVert == null) {
            skinTrackVert = new Skin("scrollbartrackvert.png", 1, 7);
        }
        return skinTrackVert;
    }

    public Skin getSkinTrack() {
        if (this.skinTrack == null) {
            this.skinTrack = this.scrollbar.getOrientation() == 1 ? LiquidScrollBarUI.getSkinTrackVert() : LiquidScrollBarUI.getSkinTrackHoriz();
        }
        return this.skinTrack;
    }

    public Skin getSkinThumb() {
        if (this.skinThumb == null) {
            this.skinThumb = this.scrollbar.getOrientation() == 1 ? LiquidScrollBarUI.getSkinThumbVert() : LiquidScrollBarUI.getSkinThumbHoriz();
        }
        return this.skinThumb;
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(LiquidScrollBarUI.this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            LiquidScrollBarUI.this.scrollbar.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            LiquidScrollBarUI.this.scrollbar.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            LiquidScrollBarUI.this.isRollover = false;
            LiquidScrollBarUI.this.wasRollover = false;
            if (LiquidScrollBarUI.this.getThumbBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                LiquidScrollBarUI.this.isRollover = true;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            LiquidScrollBarUI.this.isRollover = false;
            if (LiquidScrollBarUI.this.isRollover != LiquidScrollBarUI.this.wasRollover) {
                LiquidScrollBarUI.this.scrollbar.repaint();
                LiquidScrollBarUI.this.wasRollover = LiquidScrollBarUI.this.isRollover;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (LiquidScrollBarUI.this.getThumbBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                LiquidScrollBarUI.this.isRollover = true;
            }
            super.mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (LiquidScrollBarUI.this.getThumbBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                LiquidScrollBarUI.this.isRollover = true;
                if (LiquidScrollBarUI.this.isRollover != LiquidScrollBarUI.this.wasRollover) {
                    LiquidScrollBarUI.this.scrollbar.repaint();
                    LiquidScrollBarUI.this.wasRollover = LiquidScrollBarUI.this.isRollover;
                }
            } else {
                LiquidScrollBarUI.this.isRollover = false;
                if (LiquidScrollBarUI.this.isRollover != LiquidScrollBarUI.this.wasRollover) {
                    LiquidScrollBarUI.this.scrollbar.repaint();
                    LiquidScrollBarUI.this.wasRollover = LiquidScrollBarUI.this.isRollover;
                }
            }
        }
    }
}

