/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.LiquidLookAndFeel;
import com.birosoft.liquid.skin.Skin;
import com.birosoft.liquid.util.Colors;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicToolBarUI;

public class LiquidToolBarUI
extends BasicToolBarUI {
    private Border border = new EmptyBorder(4, 4, 4, 4);
    private int orientation = -1;
    private boolean changeBorder = true;
    private Skin vbarHandler = new Skin("vtoolbarhandler.png", 1, 8, 3, 8, 3);
    private Skin hbarHandler = new Skin("htoolbarhandler.png", 1, 3, 8, 3, 8);
    private Insets insets = new Insets(2, 2, 2, 2);

    public static ComponentUI createUI(JComponent jComponent) {
        return new LiquidToolBarUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (LiquidLookAndFeel.panelTransparency) {
            if (LiquidLookAndFeel.areStipplesUsed() && jComponent.getParent() instanceof JPanel) {
                jComponent.setOpaque(false);
            } else {
                jComponent.setOpaque(true);
            }
        }
        if (jComponent.isOpaque()) {
            Colors.drawStipples(graphics, jComponent, jComponent.getBackground());
        }
        if (!this.isFloating()) {
            if (this.toolBar.getOrientation() != this.orientation) {
                if (this.toolBar.getOrientation() == 0) {
                    if (this.toolBar.isFloatable()) {
                        this.toolBar.setBorder(new EmptyBorder(2, 11, 2, 2));
                    } else {
                        this.toolBar.setBorder(new EmptyBorder(2, 2, 2, 2));
                    }
                } else if (this.toolBar.isFloatable()) {
                    this.toolBar.setBorder(new EmptyBorder(12, 2, 2, 2));
                } else {
                    this.toolBar.setBorder(new EmptyBorder(2, 2, 2, 2));
                }
                this.orientation = this.toolBar.getOrientation();
                this.changeBorder = true;
            }
            if (this.toolBar.getOrientation() == 0) {
                if (this.toolBar.isFloatable()) {
                    this.vbarHandler.draw(graphics, 0, 1, 2, 8, jComponent.getHeight() - 4);
                }
            } else if (this.toolBar.isFloatable()) {
                this.hbarHandler.draw(graphics, 0, 1, 2, jComponent.getWidth() - 4, 8);
            }
        } else if (this.changeBorder) {
            this.toolBar.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.changeBorder = false;
            this.orientation = -1;
        }
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.getBorder() instanceof BasicBorders.MarginBorder) {
                abstractButton.setBorder(this.border);
            }
            abstractButton.setFocusable(false);
            abstractButton.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        }
    }

    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.getBorder() instanceof BasicBorders.MarginBorder) {
                abstractButton.setBorder(this.border);
            }
            abstractButton.setFocusable(false);
            abstractButton.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        }
    }
}

