/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.skin;

import com.birosoft.liquid.skin.SecretLoader;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class SkinImageCache {
    private static SkinImageCache instance = new SkinImageCache();
    static GraphicsConfiguration conf;
    private HashMap map = new HashMap();
    private HashMap iconMap = new HashMap();
    private HashMap bufferedMap = new HashMap();

    protected SkinImageCache() {
    }

    public Image getAutomaticImage(String string) {
        Image image = (Image)this.map.get(string);
        if (image == null) {
            Image image2 = SecretLoader.loadImage(string);
            this.map.put(string, image2);
            return image2;
        }
        return image;
    }

    public Image getImage(String string) {
        return this.getAutomaticImage(string);
    }

    public BufferedImage getBufferedImage(String string) {
        BufferedImage bufferedImage = (BufferedImage)this.bufferedMap.get(string);
        if (bufferedImage != null) {
            return bufferedImage;
        }
        Image image = this.getImage(string);
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage2 = conf.createCompatibleImage(n, n2);
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(image, 0, 0, n, n2, 0, 0, n, n2, null);
        this.bufferedMap.put(string, bufferedImage2);
        return bufferedImage2;
    }

    public static SkinImageCache getInstance() {
        return instance;
    }

    static {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        conf = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }
}

