/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.greenlab;

import de.grogra.graph.impl.GraphManager;
import de.grogra.greenlab.GreenLabEnvironmentPanel;
import de.grogra.greenlab.GreenLabGeometryPanel;
import de.grogra.greenlab.GreenLabGlobalPanel;
import de.grogra.greenlab.GreenLabGrowthPanel;
import de.grogra.greenlab.GreenLabOutputPanel;
import de.grogra.greenlab.GreenLabTooltipPanel;
import de.grogra.greenlab.GreenLabTopologyPanel;
import de.grogra.greenlab.conf.GreenLabPropertyFileReader;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.TypeItem;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIToolkit;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.swing.PanelSupport;
import de.grogra.pf.ui.swing.SwingPanel;
import de.grogra.pf.ui.swing.WindowSupport;
import de.grogra.reflect.Type;
import de.grogra.rgg.Reference;
import de.grogra.util.I18NBundle;
import de.grogra.util.Map;
import de.grogra.vfs.MemoryFileSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class GreenLabGUI {
    private GreenLabTopologyPanel topologyPanel;
    private GreenLabGrowthPanel growthPanel;
    private GreenLabGeometryPanel geomatryPanel;
    private GreenLabEnvironmentPanel environmentPanel;
    private GreenLabOutputPanel outputPanel;
    private GreenLabGlobalPanel globalPanel;
    private static I18NBundle thisI18NBundle;
    public static GreenLabTooltipPanel tooltipPanel;

    public GreenLabGUI(Context context) {
        GreenLabPropertyFileReader.get().setFile(context);
        HashMap hashMap = GreenLabGUI.getParameter(context);
        GreenLabPropertyFileReader.get().reloadRgg(hashMap);
        thisI18NBundle = context.getWorkbench().getRegistry().getPluginDescriptor("de.grogra.greenlab").getI18NBundle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getParameter(Context context) {
        DecimalFormat decimalFormat;
        Object object;
        Item item = context.getWorkbench().getRegistry().getItem("/classes");
        Field[] fieldArray = null;
        Class clazz = null;
        for (object = (Item)item.getBranch(); object != null; object = (Item)object.getSuccessor()) {
            if (!object.getName().endsWith("Parameter")) continue;
            decimalFormat = (Type)((TypeItem)object).getObject();
            clazz = decimalFormat.getImplementationClass();
            fieldArray = clazz.getDeclaredFields();
            break;
        }
        object = new HashMap();
        decimalFormat = new DecimalFormat("0.0");
        decimalFormat.setMaximumFractionDigits(10);
        decimalFormat.setMinimumFractionDigits(0);
        try {
            for (int i = 0; i < fieldArray.length; ++i) {
                int n;
                String[] stringArray;
                Field field = fieldArray[i];
                Class<?> clazz2 = fieldArray[i].getType();
                String string = "";
                String string2 = clazz2.getSimpleName();
                if (string2.contains("[][]")) {
                    stringArray = fieldArray[i].get(clazz);
                    n = Array.getLength(stringArray);
                    for (int j = 0; j < n; ++j) {
                        Object object2 = Array.get(stringArray, j);
                        int n2 = Array.getLength(object2);
                        for (int k = 0; k < n2; ++k) {
                            Object object3 = Array.get(object2, k);
                            String string3 = "";
                            try {
                                string3 = decimalFormat.format(object3);
                                continue;
                            }
                            catch (Exception exception) {
                                string3 = object3.toString();
                                continue;
                            }
                            finally {
                                string = string + string3 + " ";
                            }
                        }
                    }
                } else if (string2.contains("[]")) {
                    stringArray = fieldArray[i].get(clazz);
                    String string4 = stringArray.toString();
                    int n3 = Array.getLength(stringArray);
                    for (int j = 0; j < n3; ++j) {
                        Object object4 = Array.get(stringArray, j);
                        String string5 = "";
                        try {
                            string5 = decimalFormat.format(object4);
                            continue;
                        }
                        catch (Exception exception) {
                            string5 = object4.toString();
                            continue;
                        }
                        finally {
                            string = string + string5 + " ";
                        }
                    }
                } else if (string2.contains("Reference")) {
                    stringArray = (Reference)fieldArray[i].get(clazz);
                    string = stringArray.getName();
                } else {
                    stringArray = fieldArray[i].get(clazz);
                    String string6 = "";
                    try {
                        string6 = decimalFormat.format(stringArray);
                    }
                    catch (Exception exception) {
                        string6 = stringArray.toString();
                    }
                    finally {
                        string = string6;
                    }
                }
                stringArray = string.replaceAll("\\s+$", "").replaceAll("^\\s+", "").split("\\s+");
                string = "";
                for (n = 0; n < stringArray.length; ++n) {
                    try {
                        String string7 = decimalFormat.format(Double.parseDouble(stringArray[n].replace(",", "."))) + " ";
                        string = string + string7;
                        continue;
                    }
                    catch (Exception exception) {
                        string = string + stringArray[n] + " ";
                    }
                }
                ((HashMap)object).put(fieldArray[i].getName(), string.replaceAll("\\s+$", "").replaceAll("^\\s+", "").replaceAll("false", "0").replaceAll("true", "1"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return object;
    }

    private void createObjectInspector(Panel panel, final Context context, GraphManager graphManager, Map map) {
        Container container = ((SwingPanel)panel.getComponent()).getContentPane();
        ((PanelSupport)panel).initialize((WindowSupport)context.getWindow(), map);
        UIToolkit uIToolkit = UIToolkit.get((Context)context);
        this.topologyPanel = new GreenLabTopologyPanel();
        this.growthPanel = new GreenLabGrowthPanel();
        this.geomatryPanel = new GreenLabGeometryPanel();
        this.environmentPanel = new GreenLabEnvironmentPanel();
        this.outputPanel = new GreenLabOutputPanel();
        this.globalPanel = new GreenLabGlobalPanel(this.topologyPanel, this.growthPanel, this.geomatryPanel, this.environmentPanel, this.outputPanel);
        JTabbedPane jTabbedPane = (JTabbedPane)uIToolkit.createTabbedPane(new String[]{thisI18NBundle.getString("tab0.Name"), thisI18NBundle.getString("tab1.Name"), thisI18NBundle.getString("tab2.Name"), thisI18NBundle.getString("tab3.Name"), thisI18NBundle.getString("tab4.Name")}, new Object[]{this.globalPanel, this.topologyPanel, this.growthPanel, this.geomatryPanel, this.environmentPanel});
        JButton jButton = new JButton(thisI18NBundle.getString("applyButton.Name"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        GreenLabGUI.this.writeParameterToParameterFile(context);
                    }
                });
            }
        });
        JButton jButton2 = new JButton(thisI18NBundle.getString("resetButton.Name"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        GreenLabPropertyFileReader.get().reset();
                        GreenLabGUI.this.globalPanel.updateValue();
                        GreenLabGUI.this.topologyPanel.updateValue();
                        GreenLabGUI.this.environmentPanel.updateValue();
                        GreenLabGUI.this.growthPanel.updateValue();
                        GreenLabGUI.this.outputPanel.updateValue();
                        GreenLabGUI.this.geomatryPanel.updateValue();
                    }
                });
            }
        });
        JButton jButton3 = new JButton(thisI18NBundle.getString("openParameterFileButton.Name"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Workbench workbench = context.getWorkbench();
                FileChooserResult fileChooserResult = workbench.chooseFileToOpen(thisI18NBundle.getString("filedialog.openparameterfile", "Open Parameter File"), IOFlavor.SCI_FLAVOR);
                if (fileChooserResult != null) {
                    FileSource fileSource = fileChooserResult.createFileSource(workbench.getRegistry(), null);
                    GreenLabPropertyFileReader.get().setFile(fileSource);
                    GreenLabGUI.this.globalPanel.updateValue();
                    GreenLabGUI.this.topologyPanel.updateValue();
                    GreenLabGUI.this.environmentPanel.updateValue();
                    GreenLabGUI.this.growthPanel.updateValue();
                    GreenLabGUI.this.outputPanel.updateValue();
                    GreenLabGUI.this.geomatryPanel.updateValue();
                }
            }
        });
        JButton jButton4 = new JButton(thisI18NBundle.getString("exportParameterButton.Name"));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Workbench workbench = context.getWorkbench();
                FileChooserResult fileChooserResult = workbench.chooseFileToSave(UI.I18N.getString("filedialog.openparameterfile", "Export Parameter"), IOFlavor.SCI_FLAVOR, null);
                if (fileChooserResult != null) {
                    FileSource fileSource = fileChooserResult.createFileSource(workbench.getRegistry(), null);
                    try {
                        OutputStream outputStream = fileSource.getOutputStream(false);
                        outputStream.write(GreenLabPropertyFileReader.get().getSci().getBytes());
                        outputStream.flush();
                        fileSource.streamClosed();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalStrut(23));
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(Box.createVerticalStrut(5));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createVerticalStrut(5));
        JScrollPane jScrollPane = new JScrollPane(jTabbedPane);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        tooltipPanel = new GreenLabTooltipPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)jPanel2, "North");
        container.add((Component)jScrollPane, "Center");
        container.add((Component)tooltipPanel, "South");
    }

    public static Panel createPanel(Context context, Map map) {
        GraphManager graphManager = context.getWorkbench().getRegistry().getProjectGraph();
        UIToolkit uIToolkit = UIToolkit.get((Context)context);
        Panel panel = uIToolkit.createPanel(context, null, map);
        GreenLabGUI greenLabGUI = new GreenLabGUI(context);
        greenLabGUI.createObjectInspector(panel, context, graphManager, map);
        return panel;
    }

    private void writeParameterToParameterFile(Context context) {
        Registry registry = context.getWorkbench().getRegistry();
        MemoryFileSystem memoryFileSystem = (MemoryFileSystem)registry.getFileSystem();
        OutputStream outputStream = memoryFileSystem.getOutputStream(memoryFileSystem.getFile("Parameter.rgg"), false);
        try {
            outputStream.write(GreenLabPropertyFileReader.get().getRgg().getBytes());
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error in GreenLabGUI (writeParameterToParameterFile)");
            iOException.printStackTrace();
        }
        Workbench.refreshJEdit((Workbench)context.getWorkbench(), (String)"Parameter.rgg");
    }

    public static String getString(String string) {
        String string2 = string;
        try {
            string2 = thisI18NBundle.getString(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }
}

