/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.greenlab.ui.elements;

import de.grogra.greenlab.GreenLabGUI;
import de.grogra.greenlab.conf.GreenLabPropertyFileReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GreenLabColorBox
extends JPanel {
    private static final long serialVersionUID = -5954356931969610472L;
    private JLabel colorLabel;
    private JButton colorButton;
    private String key;
    private int pos;
    private int r;
    private int g;
    private int b;
    private JColorChooser colorChooser;
    private JFrame colorFrame;
    private String keyString = "defaultTooltip";

    public GreenLabColorBox(String string, String string2, int n) {
        this.keyString = string;
        this.key = string2;
        this.pos = n;
        this.colorButton = new JButton(GreenLabGUI.getString("Change"));
        this.colorLabel = new JLabel("oo");
        this.colorLabel.setOpaque(true);
        this.colorChooser();
        final String string3 = this.keyString;
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GreenLabGUI.tooltipPanel.updateValue(string3);
                GreenLabColorBox.this.colorFrame.setVisible(true);
            }
        });
        this.add(this.colorLabel);
        this.add(this.colorButton);
        final String string4 = this.keyString;
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                GreenLabGUI.tooltipPanel.updateValue(string4);
            }
        });
        this.update();
    }

    private void colorChooser() {
        this.colorChooser = new JColorChooser(new Color(this.r, this.g, this.b));
        this.colorFrame = new JFrame(GreenLabGUI.getString("Color_Chooser"));
        this.colorFrame.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.colorFrame.add(jPanel);
        jPanel.add((Component)this.colorChooser, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(GreenLabGUI.getString("Confirm"));
        JButton jButton2 = new JButton(GreenLabGUI.getString("Cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GreenLabColorBox.this.colorFrame.setVisible(false);
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GreenLabColorBox.this.colorFrame.setVisible(false);
                GreenLabColorBox.this.colorLabel.setBackground(GreenLabColorBox.this.colorChooser.getColor());
                GreenLabColorBox.this.colorLabel.setForeground(GreenLabColorBox.this.colorChooser.getColor());
                GreenLabColorBox.this.r = GreenLabColorBox.this.colorChooser.getColor().getRed();
                GreenLabColorBox.this.g = GreenLabColorBox.this.colorChooser.getColor().getGreen();
                GreenLabColorBox.this.b = GreenLabColorBox.this.colorChooser.getColor().getBlue();
                String[] stringArray = GreenLabPropertyFileReader.get().getProperty(GreenLabColorBox.this.key).split("\\s+");
                String string = "";
                DecimalFormat decimalFormat = new DecimalFormat("0.0");
                decimalFormat.setMaximumFractionDigits(10);
                decimalFormat.setMinimumFractionDigits(0);
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        double d = NumberFormat.getInstance(Locale.US).parse(stringArray[i]).doubleValue();
                        if (i == GreenLabColorBox.this.pos * 3) {
                            d = (double)GreenLabColorBox.this.r / 255.0;
                        } else if (i == GreenLabColorBox.this.pos * 3 + 1) {
                            d = (double)GreenLabColorBox.this.g / 255.0;
                        } else if (i == GreenLabColorBox.this.pos * 3 + 2) {
                            d = (double)GreenLabColorBox.this.b / 255.0;
                        }
                        string = string + " " + decimalFormat.format(d).toString();
                        continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                GreenLabPropertyFileReader.get().setProperty(GreenLabColorBox.this.key, string.substring(1));
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this.colorFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.colorFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.colorFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public void setText(String string, int n) {
        this.key = string;
        this.pos = n;
        String[] stringArray = GreenLabPropertyFileReader.get().getProperty(this.key).split("\\s+");
        try {
            this.r = (int)(NumberFormat.getInstance(Locale.US).parse(stringArray[this.pos * 3]).doubleValue() * 255.0);
            this.g = (int)(NumberFormat.getInstance(Locale.US).parse(stringArray[this.pos * 3 + 1]).doubleValue() * 255.0);
            this.b = (int)(NumberFormat.getInstance(Locale.US).parse(stringArray[this.pos * 3 + 2]).doubleValue() * 255.0);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.colorLabel.setBackground(new Color(this.r, this.g, this.b));
    }

    public void update() {
        String[] stringArray = GreenLabPropertyFileReader.get().getProperty(this.key).split("\\s+");
        try {
            this.r = (int)(NumberFormat.getInstance(Locale.US).parse(stringArray[this.pos * 3]).doubleValue() * 255.0);
            this.g = (int)(NumberFormat.getInstance(Locale.US).parse(stringArray[this.pos * 3 + 1]).doubleValue() * 255.0);
            this.b = (int)(NumberFormat.getInstance(Locale.US).parse(stringArray[this.pos * 3 + 2]).doubleValue() * 255.0);
            this.colorLabel.setBackground(new Color(this.r, this.g, this.b));
            this.colorLabel.setForeground(new Color(this.r, this.g, this.b));
            this.colorChooser.setColor(new Color(this.r, this.g, this.b));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setEnabled(boolean bl) {
        this.colorButton.setEnabled(bl);
    }
}

