/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.openalea;

import de.grogra.ext.openalea.HttpData;
import de.grogra.ext.openalea.OpenAleaCommand;
import de.grogra.graph.impl.GraphManager;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Workbench;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class RequestListenerThread
extends Thread {
    private final ServerSocket serversocket;
    private final HttpParams params;
    private final Context ctx;

    public RequestListenerThread(Context context, int n) throws IOException {
        this.serversocket = new ServerSocket(n);
        this.params = new BasicHttpParams();
        this.params.setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"HttpComponents/1.1");
        this.ctx = context;
    }

    public void run() {
        System.out.println("Listening on port " + this.serversocket.getLocalPort());
        while (!Thread.interrupted()) {
            try {
                Socket socket = this.serversocket.accept();
                Workbench workbench = this.ctx.getWorkbench();
                Registry registry = workbench.getRegistry();
                GraphManager graphManager = registry.getProjectGraph();
                HttpData httpData = new HttpData(socket, this.params);
                OpenAleaCommand openAleaCommand = new OpenAleaCommand(graphManager);
                this.ctx.getWorkbench().getJobManager().runLater((Command)openAleaCommand, (Object)httpData, this.ctx, 10000);
            }
            catch (InterruptedIOException interruptedIOException) {
                break;
            }
            catch (IOException iOException) {
                System.err.println("I/O error initialising connection thread: " + iOException.getMessage());
                break;
            }
        }
    }
}

