/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import antlr.collections.AST;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.XClass;
import de.grogra.reflect.XField;
import de.grogra.xl.compiler.AccessMethod;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.CompilerBase;
import de.grogra.xl.compiler.Resolvable;
import de.grogra.xl.compiler.Resolver;
import de.grogra.xl.compiler.Serialization;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.property.CompiletimeModel;
import de.grogra.xl.property.RuntimeModelFactory;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.query.Query;
import de.grogra.xl.query.RuntimeModel;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.vmx.AbruptCompletion;
import de.grogra.xl.vmx.RoutineBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.asm.Label;

public class CClass
extends XClass
implements Resolvable {
    Expression rateAssignmentInitializer;
    private int nextAccessorId;
    private final HashSet accessors = new HashSet();
    private final HashMap accessMethods = new HashMap();
    private CClass routineClass;
    private ObjectList routines;
    private AST extNode;
    private AST implNode;
    private Compiler compiler;
    private Type superTypeToCheck;
    private Type[] implementedTypes = null;
    static final Type ROUTINE_BASE = ClassAdapter.wrap(RoutineBase.class);
    static final Type RETURN_TYPE = ClassAdapter.wrap(AbruptCompletion.Return.class);
    static final Type MODEL = ClassAdapter.wrap(RuntimeModel.class);
    static final Type MODEL_FACTORY = ClassAdapter.wrap(de.grogra.xl.query.RuntimeModelFactory.class);
    static final Type PMODEL = ClassAdapter.wrap(de.grogra.xl.property.RuntimeModel.class);
    static final Type PMODEL_FACTORY = ClassAdapter.wrap(RuntimeModelFactory.class);
    static final Type QUERY = ClassAdapter.wrap(Query.class);
    private HashMap<String, CClass> modelClasses;
    private XField fieldForModel;
    private String model;
    private Type factoryType;
    private HashMap<String, XField> properties;
    private HashMap<String, Query> queries;
    private static final Type[] LOADER = new Type[]{ClassAdapter.wrap(ClassLoader.class)};
    private boolean resolvingInterfaceCount;

    CClass(String string, String string2, int n, CClass cClass, Type type, AST aST, Type[] typeArray, AST aST2, CompilerBase compilerBase) {
        super(string, string2, n, (Type)cClass, false);
        this.superTypeToCheck = type;
        this.implementedTypes = typeArray;
        this.compiler = (Compiler)compilerBase;
        this.extNode = aST;
        this.implNode = aST2;
    }

    public CClass(String string, String string2, int n, CClass cClass, boolean bl) {
        super(string, string2, n, (Type)cClass, bl);
    }

    private Expression createBody() {
        return new Expression(){

            protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
                CClass.this.writeMethod((XMethod)this.getAxisParent(), bytecodeWriter);
            }
        };
    }

    private CClass getRoutineClass() {
        CClass cClass = (CClass)Reflection.getTopLevelType((Type)this);
        if (cClass != this) {
            return cClass.getRoutineClass();
        }
        if (this.routineClass == null) {
            String string = Reflection.getSyntheticName((Member[])Reflection.getDeclaredTypes((Type)this), (String)"Routine");
            this.routineClass = new CClass(string, this.getBinaryName() + '$' + string, 4120, this, false);
            this.routineClass.initSupertype(ROUTINE_BASE);
            this.declareType(this.routineClass);
            new XMethod("<init>", 0L, this.routineClass, new Type[]{Type.INT, Type.INT, Type.INT}, Type.VOID, this.routineClass.createBody());
            new XMethod("<clinit>", 8L, this.routineClass, Type.TYPE_0, Type.VOID, this.routineClass.createBody());
            new XMethod("execute", 1L, this.routineClass, new Type[]{CompilerBase.VMX_TYPE}, RETURN_TYPE, this.routineClass.createBody());
            this.routineClass.routines = new ObjectList();
        }
        return this.routineClass;
    }

    private CClass getModelClass(String string, Type type, Type type2) {
        CClass cClass;
        CClass cClass2 = (CClass)Reflection.getTopLevelType((Type)this);
        if (cClass2 != this) {
            return cClass2.getModelClass(string, type, type2);
        }
        if (this.modelClasses == null) {
            this.modelClasses = new HashMap();
        }
        if ((cClass = this.modelClasses.get(string)) == null) {
            String string2 = Reflection.getSyntheticName((Member[])Reflection.getDeclaredTypes((Type)this), (String)"Model");
            cClass = new CClass(string2, this.getBinaryName() + '$' + string2, 4120, this, false);
            cClass.initSupertype(Type.OBJECT);
            cClass.fieldForModel = cClass.declareAuxField("MODEL", 24, type);
            cClass.model = string;
            cClass.factoryType = type2;
            this.modelClasses.put(string, cClass);
            this.declareType(cClass);
            new XMethod("<clinit>", 8L, cClass, Type.TYPE_0, Type.VOID, cClass.createBody());
        }
        return cClass;
    }

    public XField getFieldForModel(de.grogra.xl.query.CompiletimeModel compiletimeModel) {
        return this.getModelClass((String)compiletimeModel.getRuntimeName(), (Type)CClass.MODEL, (Type)CClass.MODEL_FACTORY).fieldForModel;
    }

    public XField getFieldForQuery(de.grogra.xl.query.CompiletimeModel compiletimeModel, Query query) {
        return this.getModelClass(compiletimeModel.getRuntimeName(), MODEL, MODEL_FACTORY).getFieldForQuery(query);
    }

    public XField getFieldForPropertyModel(CompiletimeModel compiletimeModel) {
        return this.getModelClass((String)compiletimeModel.getRuntimeName(), (Type)CClass.PMODEL, (Type)CClass.PMODEL_FACTORY).fieldForModel;
    }

    public XField getFieldForProperty(CompiletimeModel.Property property) {
        return this.getModelClass(property.getModel().getRuntimeName(), PMODEL, PMODEL_FACTORY).getFieldForPropertyImpl(property);
    }

    private XField getFieldForPropertyImpl(CompiletimeModel.Property property) {
        XField xField;
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((xField = this.properties.get(property.getRuntimeName())) == null) {
            xField = this.declareAuxField("PROPERTY", 24, property.getRuntimeType());
            this.properties.put(property.getRuntimeName(), xField);
        }
        return xField;
    }

    private XField getFieldForQuery(Query query) {
        if (this.queries == null) {
            this.queries = new HashMap();
        }
        XField xField = this.declareAuxField("QUERY", 24, QUERY);
        new XMethod(xField.getSimpleName(), 8L, this, LOADER, QUERY, this.createBody());
        this.queries.put(xField.getSimpleName(), query);
        return xField;
    }

    public CClass getCallbackClass() {
        return Reflection.isInterface((Type)this) ? this.getRoutineClass() : this;
    }

    XField addRoutine(XMethod xMethod) {
        CClass cClass = this.getRoutineClass();
        cClass.routines.add((Object)xMethod);
        return cClass.declareAuxField(xMethod.getSimpleName(), 0x18 | xMethod.getModifiers() & 7, (Type)cClass);
    }

    private void writeModelMethod(BytecodeWriter bytecodeWriter) {
        bytecodeWriter.visitMethodInsn(this.factoryType, "getInstance");
        bytecodeWriter.visitaconst(this.model);
        bytecodeWriter.visitaconst(this);
        bytecodeWriter.visitMethodInsn(Type.CLASS, "getClassLoader");
        bytecodeWriter.visitInsn(89);
        bytecodeWriter.visitVarInsn(58, 0);
        bytecodeWriter.visitMethodInsn(this.factoryType, "modelForName");
        bytecodeWriter.visitInsn(89);
        bytecodeWriter.visitVarInsn(58, 1);
        bytecodeWriter.visitFieldInsn(179, (Field)this.fieldForModel, null);
        if (this.properties != null) {
            for (Map.Entry object : this.properties.entrySet()) {
                bytecodeWriter.visitVarInsn(25, 1);
                bytecodeWriter.visitaconst(object.getKey());
                bytecodeWriter.visitVarInsn(25, 0);
                bytecodeWriter.visitMethodInsn(Reflection.findMethodWithPrefixInTypes((Type)PMODEL, (String)"mpropertyForName;(Ljava/lang/String;Lj", (boolean)false, (boolean)true));
                bytecodeWriter.visitCheckCast(((XField)object.getValue()).getType());
                bytecodeWriter.visitFieldInsn(179, (Field)object.getValue(), null);
            }
        }
        if (this.queries != null) {
            for (String string : this.queries.keySet()) {
                XField xField = this.getDeclaredField(string);
                bytecodeWriter.visitVarInsn(25, 0);
                bytecodeWriter.visitMethodInsn(Reflection.getDeclaredMethod((Type)this, (String)xField.getSimpleName()));
                bytecodeWriter.visitFieldInsn(179, (Field)xField, null);
            }
        }
    }

    private void writeRoutineMethod(XMethod xMethod, BytecodeWriter bytecodeWriter) {
        if (xMethod.getName().equals("<init>")) {
            bytecodeWriter.visitLoad(0, 0);
            bytecodeWriter.visitLoad(1, 6);
            bytecodeWriter.visiticonst(0);
            bytecodeWriter.visitLoad(2, 6);
            bytecodeWriter.visiticonst(0);
            bytecodeWriter.visitLoad(3, 6);
            bytecodeWriter.visitMethodInsn(ROUTINE_BASE, "<init>");
            bytecodeWriter.visitInsn(177);
        } else if (xMethod.getName().equals("<clinit>")) {
            for (int i = 0; i < this.routines.size(); ++i) {
                XMethod xMethod2 = (XMethod)this.routines.get(i);
                bytecodeWriter.visitTypeInsn(187, (Type)this);
                bytecodeWriter.visitInsn(89);
                bytecodeWriter.visiticonst(i);
                bytecodeWriter.visiticonst(xMethod2.getParameterSize());
                bytecodeWriter.visiticonst(xMethod2.getFrameSize());
                bytecodeWriter.visitMethodInsn((Type)this, "<init>");
                bytecodeWriter.visitFieldInsn(179, xMethod2.getRoutineField(), null);
            }
            bytecodeWriter.visitInsn(177);
        } else {
            int n;
            Label label = new Label();
            Label[] labelArray = new Label[this.routines.size()];
            for (n = 0; n < this.routines.size(); ++n) {
                labelArray[n] = new Label();
            }
            bytecodeWriter.visitLoad(0, 0);
            bytecodeWriter.visitFieldInsn(180, Reflection.getDeclaredField((Type)ROUTINE_BASE, (String)"id"), null);
            bytecodeWriter.visitTableSwitchInsn(0, this.routines.size() - 1, label, labelArray);
            for (n = 0; n < this.routines.size(); ++n) {
                bytecodeWriter.visitLabel(labelArray[n]);
                XMethod xMethod3 = (XMethod)this.routines.get(n);
                bytecodeWriter.visitLoad(1, 0);
                if (xMethod3.getReturnType().getTypeId() != 1) {
                    bytecodeWriter.visitInsn(89);
                }
                bytecodeWriter.visitMethodInsn(xMethod3);
                if (xMethod3.getReturnType().getTypeId() != 1) {
                    bytecodeWriter.visitMethodInsn(CompilerBase.VMX_TYPE, Reflection.getJVMPrefix((Type)xMethod3.getReturnType()) + "return");
                } else {
                    bytecodeWriter.visitInsn(1);
                }
                bytecodeWriter.visitInsn(176);
            }
            bytecodeWriter.visitLabel(label);
            bytecodeWriter.visitTypeInsn(187, Compiler.ASSERTION_ERROR);
            bytecodeWriter.visitInsn(89);
            bytecodeWriter.visitMethodInsn(Compiler.ASSERTION_INIT);
            bytecodeWriter.visitInsn(191);
        }
    }

    void writeMethod(XMethod xMethod, BytecodeWriter bytecodeWriter) {
        if (xMethod.getReturnType() == QUERY) {
            try {
                Serialization serialization = new Serialization(this, bytecodeWriter, 0, 1);
                this.queries.get(xMethod.getSimpleName()).write((BytecodeSerialization)serialization);
                serialization.flush();
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            bytecodeWriter.visitReturn(0);
        } else if (this.fieldForModel != null) {
            this.writeModelMethod(bytecodeWriter);
        } else if (xMethod.getDeclaringType().getSupertype() == ROUTINE_BASE) {
            this.writeRoutineMethod(xMethod, bytecodeWriter);
        } else {
            throw new AssertionError();
        }
    }

    int getAccessMethodDescriptor(StringBuffer stringBuffer, Member member) {
        boolean bl = "<init>".equals(member.getName());
        int n = 0;
        if (!Reflection.isStatic((Member)member) && !bl) {
            stringBuffer.insert(stringBuffer.indexOf("(") + 1, this.getDescriptor());
        }
        while (true) {
            int n2;
            block6: {
                String string;
                if (this.accessors.add(string = stringBuffer.toString())) {
                    for (n2 = this.getDeclaredMethodCount() - 1; n2 >= 0; --n2) {
                        if (!this.getDeclaredMethod(n2).getDescriptor().startsWith(string)) {
                            continue;
                        }
                        break block6;
                    }
                    return n;
                }
            }
            if (bl) {
                stringBuffer.insert(stringBuffer.lastIndexOf(")"), "Ljava/lang/Math;");
                ++n;
                continue;
            }
            n2 = stringBuffer.indexOf(";");
            stringBuffer.insert(n2, this.nextAccessorId++).insert(n2, '$');
        }
    }

    public Iterator getAccessMethods() {
        for (int i = this.getDeclaredMethodCount() - 1; i >= 0; --i) {
            if (((XMethod)this.getDeclaredMethod((int)i)).accessMethod == null) continue;
            this.accessMethods.put(i, ((XMethod)this.getDeclaredMethod((int)i)).accessMethod);
        }
        return this.accessMethods.values().iterator();
    }

    public AccessMethod getAccessMethodFor(Member member, boolean bl) {
        AccessMethod accessMethod;
        if (member.getDeclaringType() == this && member instanceof XMethod) {
            accessMethod = ((XMethod)member).accessMethod;
            if (accessMethod == null) {
                ((XMethod)member).accessMethod = accessMethod = new AccessMethod(this, member, bl);
            }
        } else {
            String string;
            StringBuffer stringBuffer = new StringBuffer(member.getDeclaringType().getBinaryName());
            stringBuffer.append(';').append(member.getDescriptor());
            if (bl) {
                stringBuffer.append('.');
            }
            if ((accessMethod = (AccessMethod)this.accessMethods.get(string = stringBuffer.toString())) == null) {
                accessMethod = new AccessMethod(this, member, bl);
                this.accessMethods.put(string, accessMethod);
            }
        }
        return accessMethod;
    }

    public int getDeclaredInterfaceCount() {
        if (this.implementedTypes != null) {
            this.resolveInterfaceCount(new Resolver(this.compiler));
        }
        return super.getDeclaredInterfaceCount();
    }

    public void resolve() {
        if (this.implementedTypes != null) {
            this.resolveInterfaceCount(this.compiler.resolver);
        }
        if (!Reflection.isInvalid((Type)this.superTypeToCheck)) {
            if (this.compiler.getRun() < 2) {
                this.compiler.toResolveBeforeCompilation.add((Object)this);
                return;
            }
            if (Reflection.isInterface((Type)this.superTypeToCheck)) {
                this.compiler.problems.addSemanticError(Compiler.I18N.msg("compiler.class-extends-interface", (Object)this.superTypeToCheck.getName()), this.extNode);
            } else if (this.compiler.legalSupertype != null && !Reflection.isSupertype((Type)this.compiler.legalSupertype, (Type)this.superTypeToCheck)) {
                this.compiler.problems.addSemanticError(Compiler.I18N.msg("compiler.illegal-superclass", (Object)this.superTypeToCheck.getName()), this.extNode);
            } else if (Reflection.isFinal((Member)this.superTypeToCheck)) {
                this.compiler.problems.addSemanticError(Compiler.I18N.msg("compiler.class-extends-final", (Object)this.superTypeToCheck.getName()), this.extNode);
            }
            this.superTypeToCheck = null;
        }
    }

    private void resolveInterfaceCount(Resolver resolver) {
        if (this.resolvingInterfaceCount) {
            throw new Error("Circularity");
        }
        this.resolvingInterfaceCount = true;
        if (this.implementedTypes != null) {
            AST aST = this.implNode;
            for (int i = 0; i < this.implementedTypes.length; ++i) {
                Type type = this.implementedTypes[i];
                if (!Reflection.isInvalid((Type)type)) {
                    if (Reflection.isInterface((Type)type)) {
                        this.addInterface(type);
                    } else {
                        this.compiler.problems.addSemanticError(Compiler.I18N.msg("compiler.no-interface-type", (Object)type.getName()), aST);
                    }
                }
                aST = aST.getNextSibling();
            }
        }
        this.implementedTypes = null;
    }

    public void dispose() {
        int n;
        this.accessMethods.clear();
        this.accessors.clear();
        this.properties = null;
        this.queries = null;
        this.routines = null;
        for (n = this.getDeclaredMethodCount() - 1; n >= 0; --n) {
            ((XMethod)this.getDeclaredMethod(n)).dispose();
        }
        for (n = this.getDeclaredTypeCount() - 1; n >= 0; --n) {
            ((CClass)this.getDeclaredType(n)).dispose();
        }
    }
}

