/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler;

import antlr.TreeParser;
import antlr.collections.AST;
import de.grogra.grammar.ASTWithToken;
import de.grogra.grammar.RecognitionException;
import de.grogra.grammar.RecognitionExceptionList;
import de.grogra.reflect.Annotation;
import de.grogra.reflect.AnnotationImpl;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Field;
import de.grogra.reflect.FieldDecorator;
import de.grogra.reflect.IntersectionType;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Signature;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeDecorator;
import de.grogra.reflect.XClass;
import de.grogra.reflect.XField;
import de.grogra.util.I18NBundle;
import de.grogra.util.Int2IntMap;
import de.grogra.util.Utils;
import de.grogra.util.WrapException;
import de.grogra.vfs.FileSystem;
import de.grogra.xl.compiler.ASMType;
import de.grogra.xl.compiler.ArgumentTransformations;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.CClass;
import de.grogra.xl.compiler.ClassNotReadyException;
import de.grogra.xl.compiler.CompilationUnit;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.CompilerOptions;
import de.grogra.xl.compiler.CompilerTokenTypes;
import de.grogra.xl.compiler.Extension;
import de.grogra.xl.compiler.FieldInitializer;
import de.grogra.xl.compiler.OpenArgument;
import de.grogra.xl.compiler.ProblemReporter;
import de.grogra.xl.compiler.Resolvable;
import de.grogra.xl.compiler.Resolver;
import de.grogra.xl.compiler.ShiftedMethod;
import de.grogra.xl.compiler.XMethod;
import de.grogra.xl.compiler.pattern.ArgumentDescription;
import de.grogra.xl.compiler.pattern.PatternBuilder;
import de.grogra.xl.compiler.pattern.PatternWrapper;
import de.grogra.xl.compiler.scope.BlockScope;
import de.grogra.xl.compiler.scope.ClassPath;
import de.grogra.xl.compiler.scope.CompilationUnitScope;
import de.grogra.xl.compiler.scope.InstanceScope;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.compiler.scope.Package;
import de.grogra.xl.compiler.scope.ProduceScope;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.SingleStaticImport;
import de.grogra.xl.compiler.scope.StaticImportOnDemand;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.expr.ArrayGenerator;
import de.grogra.xl.expr.ArrayInit;
import de.grogra.xl.expr.AssignField;
import de.grogra.xl.expr.AssignLocal;
import de.grogra.xl.expr.Block;
import de.grogra.xl.expr.BooleanConst;
import de.grogra.xl.expr.Break;
import de.grogra.xl.expr.ByteConst;
import de.grogra.xl.expr.Cast;
import de.grogra.xl.expr.CharConst;
import de.grogra.xl.expr.CheckNonNull;
import de.grogra.xl.expr.ClassConst;
import de.grogra.xl.expr.Constant;
import de.grogra.xl.expr.DisposeDescriptor;
import de.grogra.xl.expr.EvalExpression;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.ExpressionFactory;
import de.grogra.xl.expr.ExpressionList;
import de.grogra.xl.expr.FilterGuard;
import de.grogra.xl.expr.Generator;
import de.grogra.xl.expr.GetDescriptor;
import de.grogra.xl.expr.GetField;
import de.grogra.xl.expr.GetLocal;
import de.grogra.xl.expr.GetProperty;
import de.grogra.xl.expr.GetPropertyInstance;
import de.grogra.xl.expr.If;
import de.grogra.xl.expr.IllegalCastException;
import de.grogra.xl.expr.IllegalOperandTypeException;
import de.grogra.xl.expr.IntConst;
import de.grogra.xl.expr.Invoke;
import de.grogra.xl.expr.InvokeSpecial;
import de.grogra.xl.expr.InvokeStatic;
import de.grogra.xl.expr.InvokeVirtual;
import de.grogra.xl.expr.LocalValue;
import de.grogra.xl.expr.New;
import de.grogra.xl.expr.NoBytecode;
import de.grogra.xl.expr.NonlocalGenerator;
import de.grogra.xl.expr.ObjectConst;
import de.grogra.xl.expr.Pop;
import de.grogra.xl.expr.PopIntArray;
import de.grogra.xl.expr.PushInts;
import de.grogra.xl.expr.Return;
import de.grogra.xl.expr.SetThis;
import de.grogra.xl.expr.ShortConst;
import de.grogra.xl.expr.Super;
import de.grogra.xl.expr.SwapBytecode;
import de.grogra.xl.expr.Switch;
import de.grogra.xl.expr.Throw;
import de.grogra.xl.expr.TypeConst;
import de.grogra.xl.expr.Variable;
import de.grogra.xl.expr.Yield;
import de.grogra.xl.lang.Aggregate;
import de.grogra.xl.lang.ConversionConstructor;
import de.grogra.xl.lang.ConversionType;
import de.grogra.xl.lang.Filter;
import de.grogra.xl.ode.RateAssignment;
import de.grogra.xl.parser.Parser;
import de.grogra.xl.property.CompiletimeModel;
import de.grogra.xl.query.CompiletimeModel;
import de.grogra.xl.query.EdgeDirection;
import de.grogra.xl.query.UserDefinedPattern;
import de.grogra.xl.util.IntHashMap;
import de.grogra.xl.util.LongHashMap;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.vmx.RoutineDescriptor;
import de.grogra.xl.vmx.VMXState;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompilerBase
extends TreeParser
implements CompilerTokenTypes,
Members.Resolution {
    public static final I18NBundle I18N = ProblemReporter.I18N;
    public static final int TYPE_AND_FIELD_DECLARATION = 0;
    public static final int METHOD_DECLARATION = 1;
    public static final int COMPILATION = 2;
    int run;
    Package currentPackage;
    public CompilationUnitScope currentCompilationUnitScope;
    TypeScope currentTypeScope;
    public CompilerOptions options = new CompilerOptions();
    public static final int EXPR_FINAL = 1;
    public static final int EXPR_THIS = 2;
    static final int ABSTRACT_METHOD_INCOMPATIBLE = 2362;
    public static final long MOD_ITERATING = 0x100000000L;
    public static final long MOD_PARAMETER = 0x200000000L;
    public static final long MOD_ROUTINE = 0x400000000L;
    public static final long MOD_CONSTRUCTOR = 0x800000000L;
    public static final long MOD_THIS_PARAMETER = 0x1000000000L;
    public static final long MOD_INITIALIZER = 0x2000000000L;
    public static final long MOD_CONST = 0x4000000000L;
    public static final long MOD_INSTANTIATOR = 0x8000000000L;
    public static final long MOD_MODULE = 0x10000000000L;
    public static final long MOD_IMPLICIT_ARGUMENT = 0x20000000000L;
    public static final long MOD_STATIC_MEMBER_CLASSES = 0x40000000000L;
    public static final long ROUTINE_MODIFIERS = 17179873304L;
    static final int TOP_LEVEL_MODULE_MODIFIERS = 3089;
    static final int MEMBER_MODULE_MODIFIERS = 3103;
    private static final LongHashMap extModifiers = new LongHashMap();
    static final ArgumentTransformations METHOD_ARGS;
    CClass shell;
    Resolver resolver = new Resolver((Compiler)this);
    HashMap<Field, FieldInitializer> initializersToCompile = new HashMap();
    HashMap<AST, CompilationUnitScope> units = new HashMap();
    ObjectList toResolveBeforeMethodDeclaration = new ObjectList();
    ObjectList toResolveBeforeCompilation = new ObjectList();
    HashSet<String> accessedShellFields = new HashSet();
    Type legalSupertype;
    PrintWriter out;
    public ProblemReporter problems = new ProblemReporter(-1L, 0L);
    public static final long WARN_ON_IMPLICIT_MODIFIER = 2L;
    private Type methodPatternTermType;
    private final ArgumentTransformations methodPatternArgs = new ArgumentTransformations(new Type[][]{ArgumentTransformations.NO_IMPLICIT, ArgumentTransformations.GENERATOR, ArgumentTransformations.AGGREGATE, ArgumentTransformations.FILTER, ArgumentTransformations.FIRST_TERM}, null){

        int getApplicableOption(Signature signature, Members.Applicability applicability, Expression[] expressionArray, Scope scope) {
            int n = super.getApplicableOption(signature, applicability, expressionArray, scope);
            if (n < 0) {
                return -1;
            }
            if (this.types[n] == ArgumentTransformations.FIRST_TERM && ((Method)signature).getReturnType().getTypeId() != 2) {
                return -1;
            }
            return n;
        }

        Expression createImplicitArgument(int n, int n2, Type type, Scope scope, AST aST) {
            if (this.types[n] == ArgumentTransformations.FIRST_TERM && n2 == 0) {
                CompilerBase.this.methodPatternTermType = type;
                return PatternBuilder.createArgument(type);
            }
            return super.createImplicitArgument(n, n2, type, scope, aST);
        }
    };
    final ProduceImplicit produceArgs = new ProduceImplicit();
    static final int CV_TYPE_NONE = 0;
    static final int CV_TYPE_USER_DEFINED = 1;
    static final int CV_TYPE_D2F = 2;
    static final int CV_TYPE_STANDARD = 3;
    private int implCvType;
    private Scope implCvScope;
    private Expression implCvSrc;
    private Type implCvDestType;
    private ObjectList<Method> implCvMethods = new ObjectList();
    private static final Expression OK;
    private final Set<Type> implTypesToCheck = new HashSet<Type>();
    private final Members members = new Members((Compiler)this);
    private Expression argList;
    private Type[] implicitOption;
    private Method invokable;
    static final int OP_INC = 1;
    static final int OP_POST = 2;
    static final int OP_ISCOPE = 4;
    boolean ambiguousOperatorOverload;
    static final Type[] GENERATOR_TYPES;
    private static final int METHOD_RES = 0;
    private static final int PREDICATE_RES = 1;
    private static final int EDGE_PREDICATE_RES = 2;
    private static final int UNDIR_EDGE_PREDICATE_RES = 3;
    private int resolution;
    private ArgumentTransformations resolutionImplicit;
    private Expression[] resolutionArgs;
    static final int APPLICABLE_BY_WIDENING_CONVERSION_PHASE = 0;
    static final int APPLICABLE_BY_METHOD_INVOCATION_CONVERSION_PHASE = 1;
    static final int APPLICABLE_BY_ENHANCED_METHOD_INVOCATION_CONVERSION_PHASE = 2;
    static final int APPLICABLE_BY_VARIABLE_ARITY_PHASE = 3;
    int resolutionPhase = 0;
    static final Type FIELD_TYPE;
    static final Type AGGREGATE_TYPE;
    static final Type DESCRIPTOR_TYPE;
    static final Type ANNOTATION_ARRAY_TYPE;
    static final Type FILTER_TYPE;
    static final Type ASSERTION_ERROR;
    static final Type VMX_TYPE;
    static final Method ASSERTION_INIT;
    static final Field INT_0;
    private final ConstructorImplicit constrImplicit = new ConstructorImplicit();
    private final EPImplicit directedEPImplicit = new EPImplicit(false);
    private final EPImplicit undirectedEPImplicit = new EPImplicit(true);
    private final MEPImplicit mepImplicit = new MEPImplicit();
    private final ObjectList stack = new ObjectList(20, false);
    public static final String PRODUCER_GET_ROOT = "producer$getRoot";
    public static final String PRODUCER_BEGIN = "producer$begin";
    public static final String PRODUCER_END = "producer$end";
    public static final String PRODUCER_PUSH = "producer$push";
    public static final String PRODUCER_POP = "producer$pop";
    public static final String PRODUCER_SEPARATE = "producer$separate";
    static final IntHashMap<String> unaryOperators;
    static final IntHashMap<String> binaryOperators;
    public static final String OPERATOR_NAME_NEG = "operator$neg";
    public static final String OPERATOR_NAME_POS = "operator$pos";
    public static final String OPERATOR_NAME_NOT = "operator$not";
    public static final String OPERATOR_NAME_COM = "operator$com";
    public static final String OPERATOR_NAME_INC = "operator$inc";
    public static final String OPERATOR_NAME_DEC = "operator$dec";
    public static final String OPERATOR_NAME_POST_INC = "operator$postInc";
    public static final String OPERATOR_NAME_POST_DEC = "operator$postDec";
    public static final String OPERATOR_NAME_ADD = "operator$add";
    public static final String OPERATOR_NAME_SUB = "operator$sub";
    public static final String OPERATOR_NAME_MUL = "operator$mul";
    public static final String OPERATOR_NAME_DIV = "operator$div";
    public static final String OPERATOR_NAME_REM = "operator$rem";
    public static final String OPERATOR_NAME_POW = "operator$pow";
    public static final String OPERATOR_NAME_COR = "operator$cor";
    public static final String OPERATOR_NAME_CAND = "operator$cand";
    public static final String OPERATOR_NAME_ADD_ASSIGN = "operator$addAssign";
    public static final String OPERATOR_NAME_SUB_ASSIGN = "operator$subAssign";
    public static final String OPERATOR_NAME_MUL_ASSIGN = "operator$mulAssign";
    public static final String OPERATOR_NAME_DIV_ASSIGN = "operator$divAssign";
    public static final String OPERATOR_NAME_REM_ASSIGN = "operator$remAssign";
    public static final String OPERATOR_NAME_POW_ASSIGN = "operator$powAssign";
    public static final String OPERATOR_NAME_SHL = "operator$shl";
    public static final String OPERATOR_NAME_SHR = "operator$shr";
    public static final String OPERATOR_NAME_USHR = "operator$ushr";
    public static final String OPERATOR_NAME_SHL_ASSIGN = "operator$shlAssign";
    public static final String OPERATOR_NAME_SHR_ASSIGN = "operator$shrAssign";
    public static final String OPERATOR_NAME_USHR_ASSIGN = "operator$ushrAssign";
    public static final String OPERATOR_NAME_XOR = "operator$xor";
    public static final String OPERATOR_NAME_OR = "operator$or";
    public static final String OPERATOR_NAME_AND = "operator$and";
    public static final String OPERATOR_NAME_XOR_ASSIGN = "operator$xorAssign";
    public static final String OPERATOR_NAME_OR_ASSIGN = "operator$orAssign";
    public static final String OPERATOR_NAME_AND_ASSIGN = "operator$andAssign";
    public static final String OPERATOR_NAME_EQUALS = "operator$eq";
    public static final String OPERATOR_NAME_NOT_EQUALS = "operator$neq";
    public static final String OPERATOR_NAME_LT = "operator$lt";
    public static final String OPERATOR_NAME_LE = "operator$le";
    public static final String OPERATOR_NAME_GT = "operator$gt";
    public static final String OPERATOR_NAME_GE = "operator$ge";
    public static final String OPERATOR_NAME_CMP = "operator$cmp";
    public static final String OPERATOR_NAME_RANGE = "operator$range";
    public static final String OPERATOR_NAME_IN = "operator$in";
    public static final String OPERATOR_NAME_GUARD = "operator$guard";
    public static final String OPERATOR_NAME_ARROW = "operator$arrow";
    public static final String OPERATOR_NAME_LEFT_ARROW = "operator$leftArrow";
    public static final String OPERATOR_NAME_LONG_ARROW = "operator$longArrow";
    public static final String OPERATOR_NAME_LONG_LEFT_ARROW = "operator$longLeftArrow";
    public static final String OPERATOR_NAME_LONG_LEFT_RIGHT_ARROW = "operator$longLeftRightArrow";
    public static final String OPERATOR_NAME_PLUS_LEFT_ARROW = "operator$plusLeftArrow";
    public static final String OPERATOR_NAME_PLUS_ARROW = "operator$plusArrow";
    public static final String OPERATOR_NAME_PLUS_LEFT_RIGHT_ARROW = "operator$plusLeftRightArrow";
    public static final String OPERATOR_NAME_PLUS_LINE = "operator$plusLine";
    public static final String OPERATOR_NAME_SLASH_LEFT_ARROW = "operator$slashLeftArrow";
    public static final String OPERATOR_NAME_SLASH_ARROW = "operator$slashArrow";
    public static final String OPERATOR_NAME_SLASH_LEFT_RIGHT_ARROW = "operator$slashLeftRightArrow";
    public static final String OPERATOR_NAME_SLASH_LINE = "operator$slashLine";
    public static final String OPERATOR_NAME_LEFT_RIGHT_ARROW = "operator$leftRightArrow";
    public static final String OPERATOR_NAME_X_LEFT_RIGHT_ARROW = "operator$xLeftRightArrow";
    public static final String OPERATOR_NAME_LINE = "operator$line";
    public static final String OPERATOR_NAME_INDEX = "operator$index";
    public static final String OPERATOR_NAME_INVOKE = "operator$invoke";
    public static final String OPERATOR_NAME_QUOTE = "operator$quote";
    public static final String OPERATOR_NAME_SPACE = "operator$space";
    public static final String OPERATOR_NAME_DEFERRED_ASSIGN = "operator$defAssign";
    public static final String OPERATOR_NAME_DEFERRED_RATE_ASSIGN = "operator$defRateAssign";
    public static final String OPERATOR_NAME_DEFERRED_POW = "operator$defPowAssign";
    public static final String OPERATOR_NAME_DEFERRED_MUL = "operator$defMulAssign";
    public static final String OPERATOR_NAME_DEFERRED_DIV = "operator$defDivAssign";
    public static final String OPERATOR_NAME_DEFERRED_REM = "operator$defRemAssign";
    public static final String OPERATOR_NAME_DEFERRED_ADD = "operator$defAddAssign";
    public static final String OPERATOR_NAME_DEFERRED_SUB = "operator$defSubAssign";
    public static final String OPERATOR_NAME_DEFERRED_SHL = "operator$defShlAssign";
    public static final String OPERATOR_NAME_DEFERRED_SHR = "operator$defShrAssign";
    public static final String OPERATOR_NAME_DEFERRED_USHR = "operator$defUshrAssign";
    public static final String OPERATOR_NAME_DEFERRED_AND = "operator$defAndAssign";
    public static final String OPERATOR_NAME_DEFERRED_XOR = "operator$defXorAssign";
    public static final String OPERATOR_NAME_DEFERRED_OR = "operator$defOrAssign";

    void setRun(int n) {
        if (n == 0) {
            this.members.reset();
            this.resolver.reset();
            this.units.clear();
            this.initializersToCompile.clear();
            this.argList = null;
        }
        this.setLocalRun(n);
    }

    void setLocalRun(int n) {
        this.run = n;
        switch (n) {
            case 1: {
                CompilerBase.resolve(this.toResolveBeforeMethodDeclaration);
                break;
            }
            case 2: {
                CompilerBase.resolve(this.toResolveBeforeCompilation);
                this.compileInitializers();
                this.initializersToCompile.clear();
            }
        }
    }

    public int getRun() {
        return this.run;
    }

    public Object compile(ClassPath classPath, Scope scope, Parser parser, CClass cClass) throws IOException, RecognitionException {
        CompilationUnitScope compilationUnitScope;
        parser.parse();
        try {
            this.setRun(0);
            this.compile(classPath, parser.getAST(), parser.getFilename(), scope, null, cClass);
            this.setRun(1);
            this.compile(classPath, parser.getAST(), parser.getFilename(), scope, null, cClass);
            this.setRun(2);
            compilationUnitScope = this.compile(classPath, parser.getAST(), parser.getFilename(), scope, null, cClass);
        }
        catch (antlr.RecognitionException recognitionException) {
            if (recognitionException instanceof RecognitionException) {
                throw (RecognitionException)recognitionException;
            }
            throw new WrapException((Throwable)recognitionException);
        }
        this.problems.addAll(parser.getExceptionList());
        this.problems.check();
        return compilationUnitScope;
    }

    protected abstract CompilationUnitScope compile(ClassPath var1, AST var2, String var3, Scope var4, Annotation[] var5, CClass var6) throws antlr.RecognitionException;

    public CompilationUnitScope[] compile(CompilationUnit[] compilationUnitArray, CClass cClass, BytecodeWriter bytecodeWriter, FileSystem fileSystem, Object object, boolean bl) throws IOException {
        CompilationUnitScope[] compilationUnitScopeArray = new CompilationUnitScope[compilationUnitArray.length];
        try {
            for (int i = 0; i <= 2; ++i) {
                this.setRun(i);
                for (int j = 0; j < compilationUnitArray.length; ++j) {
                    this.options = compilationUnitArray[j].options;
                    compilationUnitScopeArray[j] = this.compile(compilationUnitArray[j].classPath, compilationUnitArray[j].tree, compilationUnitArray[j].source, compilationUnitArray[j].defaultImports, compilationUnitArray[j].annotations, cClass);
                    this.clearTemporaries();
                    if (i != 2) continue;
                    if (bytecodeWriter != null && !this.problems.containsErrors()) {
                        bytecodeWriter.write(compilationUnitScopeArray[j], fileSystem, object);
                    }
                    if (bl) continue;
                    compilationUnitScopeArray[j].dispose();
                }
                if (this.out == null) continue;
                Utils.printTime((String)("Run " + i + " completed."));
            }
        }
        catch (antlr.RecognitionException recognitionException) {
            throw new WrapException((Throwable)recognitionException);
        }
        return compilationUnitScopeArray;
    }

    void clearTemporaries() {
        this.argList = null;
        this.constrImplicit.enclosing = null;
        this.currentCompilationUnitScope = null;
        this.currentPackage = null;
        this.currentTypeScope = null;
        this.implCvScope = null;
        this.implCvSrc = null;
        this.invokable = null;
        this.members.reset();
        this.resolver.reset();
        this.resolutionArgs = null;
    }

    public boolean supportsVersion(int n) {
        return this.options.supportsVersion(n);
    }

    public Package getPackage() {
        return this.currentPackage;
    }

    public CompilationUnitScope getCompilationUnitScope() {
        return this.currentCompilationUnitScope;
    }

    public TypeScope getTypeScope() {
        return this.currentTypeScope;
    }

    public static final String modifiersToString(long l) {
        StringBuffer stringBuffer = new StringBuffer(Reflection.modifiersToString((int)((int)l)));
        for (long i = 0x100000000L; i != 0L; i <<= 1) {
            Object object;
            if ((l & i) == 0L || (object = extModifiers.get(i, null)) == null) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, ' ');
            }
            stringBuffer.insert(0, object);
        }
        return stringBuffer.toString();
    }

    static Type getClasspathClassFor(Type type) {
        if (type == null) {
            return null;
        }
        return (type = TypeDecorator.undecorate((Type)Reflection.getBinaryType((Type)type))) instanceof ClassAdapter || type instanceof ASMType ? type : null;
    }

    boolean isClassReady(Type type) {
        return this.run == 2 || CompilerBase.getClasspathClassFor(type) != null;
    }

    void checkClassReady(Type type) {
        if (!Reflection.isInvalid((Type)type) && !this.isClassReady(type)) {
            throw ClassNotReadyException.INSTANCE;
        }
    }

    public static void copyInfo(Expression expression, Expression expression2) {
        if (expression != expression2 && expression.aval != null) {
            expression2.aval = expression.aval instanceof ExprInfo ? ((ExprInfo)expression.aval).dup() : expression.aval;
        }
    }

    private static ExprInfo setInfo(Expression expression) {
        if (expression.aval instanceof ExprInfo) {
            return (ExprInfo)expression.aval;
        }
        ExprInfo exprInfo = new ExprInfo();
        if (expression.aval instanceof BlockScope) {
            exprInfo.scope = (BlockScope)expression.aval;
        } else {
            exprInfo.ast = (AST)expression.aval;
        }
        expression.aval = exprInfo;
        return exprInfo;
    }

    public static void setBlockScope(Expression expression, BlockScope blockScope) {
        if (expression.aval == null || expression.aval instanceof BlockScope) {
            expression.aval = blockScope;
        } else {
            CompilerBase.setInfo((Expression)expression).scope = blockScope;
        }
    }

    public static BlockScope getBlockScope(Expression expression) {
        while (!(expression.aval instanceof BlockScope)) {
            if (expression.aval instanceof ExprInfo && ((ExprInfo)expression.aval).scope != null) {
                return ((ExprInfo)expression.aval).scope;
            }
            expression = (Expression)expression.getAxisParent();
        }
        return (BlockScope)expression.aval;
    }

    public static Expression setAST(Expression expression, AST aST) {
        if (expression == null) {
            return null;
        }
        if (expression.aval == null || expression.aval instanceof AST) {
            expression.aval = aST;
        } else {
            CompilerBase.setInfo((Expression)expression).ast = aST;
        }
        return expression;
    }

    public static AST getAST(Expression expression) {
        while (expression != null) {
            if (expression.aval instanceof AST) {
                return (AST)expression.aval;
            }
            if (expression.aval instanceof ExprInfo && ((ExprInfo)expression.aval).ast != null) {
                return ((ExprInfo)expression.aval).ast;
            }
            expression = (Expression)expression.getAxisParent();
        }
        return null;
    }

    CompilerBase() {
    }

    public void setLegalSupertype(Type type) {
        this.legalSupertype = type;
    }

    public void setVerbose(PrintWriter printWriter) {
        this.out = printWriter;
    }

    void fieldAccessed(Field field) {
        if (this.shell != null && field.getDeclaringType() == this.shell) {
            this.accessedShellFields.add(field.getDescriptor());
        }
    }

    private static void resolve(ObjectList objectList) {
        for (int i = 0; i < objectList.size(); ++i) {
            ((Resolvable)objectList.get(i)).resolve();
        }
        objectList.clear();
    }

    static String qualifiedName(AST aST) {
        StringBuffer stringBuffer = new StringBuffer();
        while (aST.getType() == 82) {
            aST = aST.getFirstChild();
            stringBuffer.insert(0, aST.getNextSibling().getText()).insert(0, '.');
        }
        return stringBuffer.insert(0, aST.getText()).toString();
    }

    void process(TypeScope typeScope, boolean bl) {
        if (this.run == 0) {
            return;
        }
        Extension extension = typeScope.getExtension();
        if (extension != null) {
            if (bl) {
                extension.postprocess(typeScope, this.run);
            } else {
                extension.preprocess(typeScope, this.run);
            }
        }
    }

    static AST simpleNameAST(AST aST) {
        return aST.getType() == 82 ? aST.getFirstChild().getNextSibling() : aST;
    }

    Local declareLocal(BlockScope blockScope, AST aST, int n, Type type) {
        return this.declareLocal(blockScope, aST.getText(), aST, n, type);
    }

    Local declareLocal(BlockScope blockScope, String string, AST aST, int n, Type type) {
        return blockScope.declareLocal(this.verifyNotDeclared(string, blockScope, aST), n, type, aST);
    }

    public String verifyNotDeclared(AST aST, BlockScope blockScope) {
        return this.verifyNotDeclared(aST.getText(), blockScope, aST);
    }

    public String verifyNotDeclared(String string, BlockScope blockScope, AST aST) {
        if (blockScope.findLocal(string, false) != null) {
            this.problems.addSemanticError(I18N.msg("compiler.duplicate-local-declaration", (Object)string), aST);
            return blockScope.getUniqueName(string);
        }
        return string;
    }

    public void intersect(IntersectionType intersectionType, Type type, AST aST) {
        if (!Reflection.isCastableFrom((Type)type, (Type)intersectionType)) {
            if (Reflection.isInvalid((Type)type)) {
                return;
            }
            this.problems.addSemanticError(I18N.msg("compiler.empty-type-intersection", (Object)intersectionType.getName(), (Object)type.getName()), aST);
            return;
        }
        intersectionType.intersect(type);
    }

    void addExpression(PatternBuilder patternBuilder, Expression expression, AST aST, AST aST2) {
        if (expression == null) {
            return;
        }
        patternBuilder.addExpression(aST, expression, aST2);
    }

    void addMethodPattern(PatternBuilder patternBuilder, AST aST, AST aST2, Expression[] expressionArray, AST aST3) {
        this.methodPatternTermType = null;
        Expression expression = this.compileMethodInvocation(aST2, this.methodPatternArgs, expressionArray, 0, patternBuilder.getScope(), aST3);
        if (this.methodPatternTermType == null) {
            this.addExpression(patternBuilder, expression, aST, aST3);
        } else if (expression != null) {
            patternBuilder.addGuard(aST, expression, aST3);
        }
    }

    void addMethodPattern(PatternBuilder patternBuilder, AST aST, Expression expression, String string, Expression[] expressionArray, AST aST2) {
        this.methodPatternTermType = null;
        Expression expression2 = this.compileMethodInvocation(expression, string, this.methodPatternArgs, expressionArray, 0, (Scope)patternBuilder.getScope(), aST2);
        if (this.methodPatternTermType == null) {
            this.addExpression(patternBuilder, expression2, aST, aST2);
        } else if (expression2 != null) {
            patternBuilder.addGuard(aST, expression2, aST2);
        }
    }

    public Type getWrapperTypeFor(Type type, CompiletimeModel compiletimeModel, AST aST) {
        Type type2 = compiletimeModel.getWrapperTypeFor(type);
        if (type2 == null) {
            this.problems.addSemanticError(I18N.msg("compiler.wrappable-type-expected", (Object)type.getName()), aST);
            return Type.INVALID;
        }
        return type2;
    }

    Expression compileProduceName(AST aST, BlockScope blockScope, AST aST2) {
        Object object = this.resolver.resolveExpressionOrMethodOrTypeName(aST, blockScope);
        if (object instanceof Method) {
            return this.compileMethodInvocation(aST, this.produceArgs, Expression.EXPR_0, 0, blockScope, aST2);
        }
        if (object instanceof Expression) {
            return (Expression)object;
        }
        if (object instanceof Type && !Reflection.isInvalid((Type)((Type)object))) {
            return this.compileConstructorInvocation(new New((Type)object), null, Expression.EXPR_0, blockScope, aST2, false);
        }
        return null;
    }

    Expression compileProduceInvocation(AST aST, Expression expression, AST aST2, Expression[] expressionArray, BlockScope blockScope, AST aST3) {
        if (aST != null) {
            Member member = this.resolver.resolveMethodOrTypeName(aST, blockScope);
            if (member instanceof Method) {
                return this.compileMethodInvocation(aST, this.produceArgs, expressionArray, 0, blockScope, aST3);
            }
            if (member instanceof Type) {
                return this.compileConstructorInvocation(new New((Type)member), null, expressionArray, blockScope, aST3, false);
            }
        } else if (expression != null) {
            return this.compileMethodInvocation(expression, aST2.getText(), (ArgumentTransformations)this.produceArgs, expressionArray, 0, (Scope)blockScope, aST3);
        }
        return null;
    }

    public Expression castingConversion(Expression expression, Type type, Scope scope, AST aST) {
        return this.castingConversion(expression, type, scope, aST, "compiler.illegal-cast", false);
    }

    private Expression wideningConversion(Expression expression, Type type, Scope scope, AST aST, String string) {
        if (expression == null) {
            return new Expression(type);
        }
        if (Reflection.equal((Type)expression.getType(), (Type)type)) {
            return expression;
        }
        if (Reflection.isWideningConversion((Type)expression.getType(), (Type)type)) {
            return expression.cast(type);
        }
        if (string == null) {
            return null;
        }
        this.problems.addSemanticError(I18N.msg(string, (Object)expression.getType(), (Object)type), aST);
        return new Expression(type);
    }

    public Expression wideningConversion(Expression expression, Type type, Scope scope, AST aST) {
        return this.wideningConversion(expression, type, scope, aST, "compiler.unexpected-type");
    }

    public Expression methodInvocationConversion(Expression expression, Type type, Scope scope, AST aST) {
        if (expression == null) {
            return new Expression(type);
        }
        if (expression instanceof OpenArgument) {
            return expression.setType(type);
        }
        if (expression.etype == 0 && type.getTypeId() == 0 && Reflection.isAssignableFrom((Type)type, (Type)expression.getType())) {
            return expression;
        }
        return this.implicitConversion(expression, type, true, scope, aST, "compiler.unexpected-type", false);
    }

    Expression assignmentConversion(Expression expression, Type type, Scope scope, AST aST, String string) {
        block13: {
            if (CompilerBase.checkInvalid(expression, type)) {
                return new Expression(type);
            }
            if (expression instanceof Constant) {
                int n;
                switch (expression.etype) {
                    case 3: {
                        n = expression.evaluateByte(null);
                        break;
                    }
                    case 4: {
                        n = expression.evaluateShort(null);
                        break;
                    }
                    case 5: {
                        n = expression.evaluateChar(null);
                        break;
                    }
                    case 6: {
                        n = expression.evaluateInt(null);
                        break;
                    }
                    default: {
                        break block13;
                    }
                }
                switch ((Reflection.isPrimitive((Type)type) ? type : Reflection.getUnwrappedType((Type)type)).getTypeId()) {
                    case 3: {
                        if (-128 > n || n > 127) break;
                        expression = new ByteConst((byte)n);
                        break;
                    }
                    case 4: {
                        if (Short.MIN_VALUE > n || n > Short.MAX_VALUE) break;
                        expression = new ShortConst((short)n);
                        break;
                    }
                    case 5: {
                        if (0 > n || n > 65535) break;
                        expression = new CharConst((char)n);
                    }
                }
            }
        }
        return this.implicitConversion(expression, type, true, scope, aST, string, false);
    }

    public Expression assignmentConversion(Expression expression, Type type, Scope scope, AST aST) {
        return this.assignmentConversion(expression, type, scope, aST, "compiler.illegal-assignment-conversion");
    }

    public Expression returnConversion(Expression expression, Type type, Scope scope, AST aST) {
        return this.assignmentConversion(expression, type, scope, aST, "compiler.illegal-return-conversion");
    }

    private Expression boxingExpression(Type type) {
        Invoke invoke;
        Type type2 = Reflection.getUnwrappedType((Type)type);
        if (this.supportsVersion(49)) {
            invoke = new InvokeStatic(Reflection.getDeclaredMethod((Type)type, (String)("mvalueOf;(" + type2.getDescriptor() + ")" + type.getDescriptor())));
        } else {
            invoke = new InvokeSpecial(Reflection.getDeclaredMethod((Type)type, (String)("m<init>;(" + type2.getDescriptor() + ")V")));
            invoke.add(new New(type));
        }
        return invoke;
    }

    public Type typeForType(Type type) {
        try {
            return ClassPath.get(this.currentCompilationUnitScope).typeForType(type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return type;
        }
    }

    public <T extends java.lang.annotation.Annotation> Annotation<T> getAnnotation(Member member, Class<T> clazz, boolean bl) {
        Type type;
        block10: {
            if (member instanceof ClassAdapter) {
                member = this.typeForType((Type)member);
            } else if (member.getDeclaringType() instanceof ClassAdapter) {
                Field field;
                type = this.typeForType(member.getDeclaringType());
                String string = member.getDescriptor();
                switch (string.charAt(0)) {
                    case 'f': {
                        field = Reflection.getDeclaredField((Type)type, (String)string);
                        break;
                    }
                    case 'm': {
                        field = Reflection.getDeclaredMethod((Type)type, (String)string);
                        break;
                    }
                    default: {
                        break block10;
                    }
                }
                if (field != null) {
                    member = field;
                }
            }
        }
        while (member != null) {
            type = Reflection.getDeclaredAnnotation((Member)member, clazz);
            if (type != null || !bl || Reflection.isInterface((Type)((Type)member))) {
                return type;
            }
            member = ((Type)member).getSupertype();
        }
        return null;
    }

    private static Type getConversionType(Method method, boolean bl) {
        if (bl) {
            return Reflection.isCtor((Method)method) ? method.getDeclaringType() : method.getReturnType();
        }
        return method.getParameterCount() == 1 ? method.getParameterType(0) : method.getDeclaringType();
    }

    private void checkCvCandidate(Method method) {
        Type type = CompilerBase.getConversionType(method, false);
        if (this.standardImplicitConversion(this.implCvSrc, type, false, this.implCvScope, null, null, true) != null && this.standardImplicitConversion(new Expression(CompilerBase.getConversionType(method, true)), this.implCvDestType, false, this.implCvScope, null, null, true) != null && Reflection.isAccessible((Member)method.getDeclaringType(), null, (Type)this.implCvScope.getDeclaredType()) && Reflection.isAccessible((Member)method, (Type)type, (Type)this.implCvScope.getDeclaredType())) {
            for (int i = this.implCvMethods.size() - 1; i >= 0; --i) {
                Method method2 = (Method)this.implCvMethods.get(i);
                int n = CompilerBase.lessThanIfEqualSig(method, method2);
                if (n > 0) {
                    return;
                }
                if (n >= 0 || CompilerBase.lessThanIfEqualSig(method2, method) <= 0) continue;
                this.implCvMethods.remove(i);
            }
            this.implCvMethods.add((Object)method);
        }
    }

    private Type findMostSpecificType(ObjectList<Method> objectList, boolean bl) {
        Type type;
        int n;
        Type type2 = CompilerBase.getConversionType((Method)objectList.get(0), bl);
        for (n = objectList.size() - 1; n >= 1; --n) {
            type = CompilerBase.getConversionType((Method)objectList.get(n), bl);
            if (this.standardImplicitConversion(new Expression(bl ? type2 : type), bl ? type : type2, false, this.implCvScope, null, null, true) == null) continue;
            type2 = type;
        }
        for (n = objectList.size() - 1; n >= 0; --n) {
            type = CompilerBase.getConversionType((Method)objectList.get(n), bl);
            if (this.standardImplicitConversion(new Expression(bl ? type : type2), bl ? type2 : type, false, this.implCvScope, null, null, true) != null) continue;
            return null;
        }
        return type2;
    }

    public Expression implicitConversion(Expression expression, Type type, boolean bl, Scope scope, AST aST, String string, boolean bl2) {
        block22: {
            Method method;
            Type type2;
            Object object;
            Expression expression2 = this.standardImplicitConversion(expression, type, bl, scope, aST, null, bl2);
            if (expression2 != null) {
                return expression2;
            }
            this.implCvScope = scope;
            this.implCvSrc = expression;
            this.implCvDestType = type;
            this.implCvMethods.clear();
            for (int i = type.getDeclaredMethodCount() - 1; i >= 0; --i) {
                object = type.getDeclaredMethod(i);
                if (object.getParameterCount() != 1) continue;
                if (Reflection.isStatic((Member)object)) {
                    if (!object.getSimpleName().equals("valueOf") || !scope.isEnabledConversion(ConversionType.VALUE_OF)) continue;
                    this.checkCvCandidate((Method)object);
                    continue;
                }
                if (!Reflection.isCtor((Method)object) || Reflection.isInner((Type)type) || Reflection.isAbstract((Member)type) || !scope.isEnabledConversion(ConversionType.CONSTRUCTOR) && (!scope.isEnabledConversion(ConversionType.CONVERSION_CONSTRUCTOR) || this.getAnnotation((Member)object, ConversionConstructor.class, false) == null)) continue;
                this.checkCvCandidate((Method)object);
            }
            this.addConversionMethods(expression.getType());
            if (scope.isEnabledConversion(ConversionType.TO_TYPE_IN_SCOPE)) {
                String string2 = CompilerBase.getToTypeMethodName(type);
                for (object = scope; object != null; object = ((Scope)object).getEnclosingScope()) {
                    if (object instanceof SingleStaticImport) {
                        SingleStaticImport singleStaticImport = (SingleStaticImport)object;
                        if (!string2.equals(singleStaticImport.getImportedMembers())) continue;
                        type2 = singleStaticImport.getImportedType();
                    } else if (object instanceof StaticImportOnDemand) {
                        type2 = ((StaticImportOnDemand)object).getImportedType();
                    } else {
                        if (!(object instanceof ProduceScope)) continue;
                        type2 = ((ProduceScope)object).getType();
                    }
                    while (type2 != null) {
                        for (int i = 0; i < type2.getDeclaredMethodCount(); ++i) {
                            method = type2.getDeclaredMethod(i);
                            if (!method.getSimpleName().equals(string2) || !Reflection.isStatic((Member)method) || method.getParameterCount() != 1) continue;
                            this.checkCvCandidate(method);
                        }
                        type2 = type2.getSupertype();
                    }
                }
            }
            if (this.implCvMethods.size() > 1) {
                Type type3 = this.findMostSpecificType(this.implCvMethods, false);
                object = this.findMostSpecificType(this.implCvMethods, true);
                if (type3 != null && object != null) {
                    type2 = null;
                    for (int i = this.implCvMethods.size() - 1; i >= 0; --i) {
                        method = (Method)this.implCvMethods.get(i);
                        if (!Reflection.equal((Type)CompilerBase.getConversionType(method, false), (Type)type3) || !Reflection.equal((Type)CompilerBase.getConversionType(method, true), (Type)object)) continue;
                        if (type2 == null) {
                            type2 = method;
                            continue;
                        }
                        break block22;
                    }
                    if (type2 != null) {
                        this.implCvMethods.clear();
                        this.implCvMethods.add((Object)type2);
                    }
                }
            }
        }
        if (this.implCvMethods.size() == 1) {
            this.implCvType = 1;
            if (bl2) {
                return OK;
            }
            Method method = (Method)this.implCvMethods.get(0);
            expression = this.standardImplicitConversion(expression, CompilerBase.getConversionType(method, false), true, scope, aST, string, false);
            expression = Reflection.isCtor((Method)method) ? this.compileConstructorInvocation(method, new Expression[]{expression}, scope, aST) : (Reflection.isStatic((Member)method) ? this.compileMethodInvocation(method, null, ArgumentTransformations.NO_IMPLICIT_ARGS, Members.Applicability.DEFAULT, new Expression[]{expression}, scope, aST) : this.compileMethodInvocation(method, expression, ArgumentTransformations.NO_IMPLICIT_ARGS, Members.Applicability.DEFAULT, new Expression[0], scope, aST));
            expression = this.standardImplicitConversion(expression, type, true, scope, aST, string, false);
            this.implCvType = 1;
            return expression;
        }
        this.implCvType = 0;
        if (string == null) {
            return null;
        }
        if (this.implCvMethods.isEmpty()) {
            this.problems.addSemanticError(I18N.msg(string, (Object)expression.getType(), (Object)type), aST);
        } else {
            String[] stringArray = new String[this.implCvMethods.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = Reflection.getDescription((Member)((Member)this.implCvMethods.get(i)));
            }
            this.problems.addSemanticError(I18N.msg("compiler.ambiguous-conversion", (Object)ProblemReporter.enumerate(stringArray)), aST);
        }
        return new Expression(type);
    }

    private static String getToTypeMethodName(Type type) {
        if (Reflection.isPrimitive((Type)type)) {
            return type.getSimpleName() + "Value";
        }
        if (Reflection.isArray((Type)type)) {
            StringBuilder stringBuilder = new StringBuilder();
            while (Reflection.isArray((Type)type)) {
                stringBuilder.append("Array");
                type = type.getComponentType();
            }
            stringBuilder.insert(0, type.getSimpleName());
            if (Reflection.isPrimitive((Type)type)) {
                stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
            }
            return stringBuilder.insert(0, "to").toString();
        }
        return "to" + type.getSimpleName();
    }

    private void addConversionMethods(Type type) {
        while (type != null) {
            int n;
            for (n = type.getDeclaredMethodCount() - 1; n >= 0; --n) {
                Method method = type.getDeclaredMethod(n);
                if (method.getParameterCount() != 0 || Reflection.isStatic((Member)method)) continue;
                String string = method.getSimpleName();
                Type type2 = method.getReturnType();
                if ((!Reflection.isArray((Type)type2) || !string.startsWith("to") || !string.endsWith("Array")) && !string.equals(CompilerBase.getToTypeMethodName(type2))) continue;
                this.checkCvCandidate(method);
            }
            for (n = type.getDeclaredInterfaceCount() - 1; n >= 0; --n) {
                this.addConversionMethods(type.getDeclaredInterface(n));
            }
            type = type.getSupertype();
        }
    }

    private static boolean checkInvalid(Expression expression, Type type) {
        return expression == null || Reflection.isInvalid((Type)type) || Reflection.isInvalid((Type)expression.getType());
    }

    public Expression castingConversion(Expression expression, Type type, Scope scope, AST aST, String string, boolean bl) {
        if (CompilerBase.checkInvalid(expression, type)) {
            return new Expression(type);
        }
        if (Reflection.equal((Type)expression.getType(), (Type)type)) {
            return expression;
        }
        int n = type.getTypeId();
        boolean bl2 = false;
        switch (n) {
            case 0: {
                bl2 = expression.etype == 0 && Reflection.isCastableFrom((Type)type, (Type)expression.getType());
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = (1 << expression.etype & 0x3F8) != 0 && (1 << n & 0x3F8) != 0;
            }
        }
        Expression expression2 = null;
        if (bl2) {
            if (bl) {
                return OK;
            }
            expression2 = new Cast(type).add(expression);
        } else {
            if (n == 0) {
                if (Reflection.isPrimitive((Type)expression.getType()) && Reflection.equal((Class)Reflection.getWrapperClass((int)expression.etype), (Type)type)) {
                    if (bl) {
                        return OK;
                    }
                    expression2 = this.boxingExpression(type).add(expression);
                }
            } else if (Reflection.equal((Type)Reflection.getUnwrappedType((Type)expression.getType()), (Type)type)) {
                if (bl) {
                    return OK;
                }
                expression2 = expression.unboxingConversion();
            }
            if (expression2 == null) {
                expression2 = this.implicitConversion(expression, type, false, scope, aST, string, bl);
            }
        }
        expression2 = expression2.toConst();
        Compiler.copyInfo(expression, expression2);
        return expression2;
    }

    static int stdCvType(Type type, Type type2, boolean bl, Scope scope) {
        if (Reflection.isWideningConversion((Type)type, (Type)type2)) {
            return 3;
        }
        if (bl && type.getTypeId() == 9 && type2.getTypeId() == 8 && scope.isD2FImplicit()) {
            return 2;
        }
        return 0;
    }

    public Expression standardImplicitConversion(Expression expression, Type type, boolean bl, Scope scope, AST aST, String string, boolean bl2) {
        this.implCvType = 0;
        if (CompilerBase.checkInvalid(expression, type)) {
            this.implCvType = 3;
            return new Expression(type);
        }
        if (Reflection.equal((Type)expression.getType(), (Type)type)) {
            this.implCvType = 3;
            return expression;
        }
        int n = CompilerBase.stdCvType(expression.getType(), type, bl, scope);
        if (n != 0) {
            this.implCvType = n;
            if (bl2) {
                return OK;
            }
            return expression.cast(type);
        }
        if (Reflection.isPrimitive((Type)expression.getType())) {
            ClassAdapter classAdapter = ClassAdapter.wrap((Class)Reflection.getWrapperClass((int)expression.getType().getTypeId()));
            if (Reflection.isWideningConversion((Type)classAdapter, (Type)type)) {
                this.implCvType = 3;
                if (bl2) {
                    return OK;
                }
                Expression expression2 = this.boxingExpression((Type)classAdapter);
                expression2.add(expression);
                return expression2.cast(type);
            }
        } else {
            Type type2 = Reflection.getUnwrappedType((Type)expression.getType());
            if (type2 != Type.INVALID && (n = CompilerBase.stdCvType(type2, type, bl, scope)) != 0) {
                this.implCvType = n;
                if (bl2) {
                    return OK;
                }
                return expression.unboxingConversion().cast(type);
            }
        }
        if (string == null) {
            return null;
        }
        this.problems.addSemanticError(I18N.msg(string, (Object)expression.getType(), (Object)type), aST);
        return new Expression(type);
    }

    void checkIfCanonical(AST aST, Type type) {
        if (!type.getName().equals(CompilerBase.qualifiedName(aST))) {
            this.problems.addSemanticError(I18N.msg("compiler.name-not-canonical", (Object)CompilerBase.qualifiedName(aST), (Object)type), aST);
        }
    }

    void checkMember(Scope scope, long l, AST aST) {
        TypeScope typeScope;
        if (!((l & 8L) == 0L || (typeScope = TypeScope.get(scope)) == null || typeScope.isStatic() && typeScope.isNonlocal())) {
            this.problems.addSemanticError(I18N, "compiler.static-member-in-inner", aST);
        }
    }

    boolean checkTopLevelType(AST aST, Type type, Scope scope) {
        Type type2 = (Type)this.resolver.resolveIfDeclared(aST, 288, scope);
        if (type2 != null && type2 != type && (!Reflection.equal((Type)type2, (Type)type) || type2 instanceof CClass && type instanceof CClass)) {
            this.problems.addSemanticError(I18N.msg("compiler.top-level-type-conflict", (Object)aST.getText()), aST);
            return false;
        }
        return true;
    }

    private void recursivelyAddAllImplementedInterfaces(Set<Type> set, Type type) {
        for (int i = 0; i < type.getDeclaredInterfaceCount(); ++i) {
            Type type2 = type.getDeclaredInterface(i);
            this.implTypesToCheck.add(type2);
            this.recursivelyAddAllImplementedInterfaces(set, type2);
        }
    }

    void checkForUnimplementedMethod(AST aST, TypeScope typeScope) {
        CClass cClass = typeScope.getDeclaredType();
        if (!Reflection.isAbstract((Member)cClass) && !Reflection.isInterface((Type)cClass)) {
            this.implTypesToCheck.clear();
            this.recursivelyAddAllImplementedInterfaces(this.implTypesToCheck, (Type)cClass);
            for (Type type = cClass.getSupertype(); type != null; type = type.getSupertype()) {
                this.implTypesToCheck.add(type);
                this.recursivelyAddAllImplementedInterfaces(this.implTypesToCheck, type);
            }
            for (Type type : this.implTypesToCheck) {
                for (int i = 0; i < type.getDeclaredMethodCount(); ++i) {
                    Method method = type.getDeclaredMethod(i);
                    if (!Reflection.isAbstract((Member)method) || (method = Reflection.findMethodWithPrefixInTypes((Type)cClass, (String)method.getDescriptor(), (boolean)false, (boolean)false)) != null && !Reflection.isAbstract((Member)method)) continue;
                    this.problems.addSemanticError(I18N.msg("compiler.unimplemented-method", (Object)aST.getText(), (Object)(type.getName() + "." + method.getSimpleName())), aST);
                }
            }
            this.implTypesToCheck.clear();
        }
    }

    static EdgeDirection edgeDirection(AST aST) {
        switch (aST.getType()) {
            case 85: {
                return EdgeDirection.UNDIRECTED;
            }
            case 86: {
                return EdgeDirection.BACKWARD;
            }
            case 87: {
                return EdgeDirection.FORWARD;
            }
            case 88: {
                return EdgeDirection.BOTH;
            }
        }
        throw new AssertionError();
    }

    ProduceScope createProduceScope(BlockScope blockScope, Expression expression, Expression expression2, AST aST) {
        Type type = expression2 != null ? expression2.getType() : Type.INVALID;
        Local local = blockScope.declareLocal("state.", 0L, type, aST);
        ProduceScope produceScope = new ProduceScope(blockScope, local);
        expression.add(local.createSet().add(expression2));
        return produceScope;
    }

    void initModuleSuperclass(TypeScope typeScope) {
        if (!typeScope.getDeclaredType().hasSupertypeBeenSet()) {
            typeScope.getDeclaredType().initSupertype(typeScope.getDefaultModuleSuperclass());
        }
    }

    public <T> T createModel(Class<T> clazz, Type<?> type, AST aST) {
        if (type == null) {
            return null;
        }
        if (Reflection.isAbstract(type)) {
            this.problems.addSemanticError(I18N.msg("compiler.concrete-class-expected", (Object)type.getName()), aST);
            return null;
        }
        if (!Reflection.isSupertypeOrSame(clazz, type)) {
            this.problems.addSemanticError(I18N.msg("compiler.incompatible-types", (Object)type.getName(), (Object)clazz.getName()), aST);
            return null;
        }
        if (!Reflection.isPublic(type)) {
            this.problems.addSemanticError(I18N.msg("compiler.public-class-expected", (Object)type.getName()), aST);
            return null;
        }
        Method method = Reflection.getDefaultConstructor(type);
        if (method == null) {
            this.problems.addSemanticError(I18N.msg("compiler.no-default-constructor", (Object)type.getName()), aST);
            return null;
        }
        if (!Reflection.isPublic((Member)method)) {
            this.problems.addSemanticError(I18N.msg("compiler.default-constructor-not-public", (Object)type.getName()), aST);
            return null;
        }
        try {
            return clazz.cast(method.invoke(null, null));
        }
        catch (Exception exception) {
            Throwable throwable = exception instanceof InvocationTargetException ? exception.getCause() : exception;
            this.problems.addSemanticError(I18N.msg("compiler.instantiation-exception", (Object)type.getName(), (Object)throwable.getClass().getName(), (Object)throwable.getMessage()), aST);
            return null;
        }
    }

    Type getDefaultSuperclass() {
        return Type.OBJECT;
    }

    TypeScope createAndDeclareType(Scope scope, long l, AST aST, AST aST2, Type[] typeArray, AST aST3, Type[] typeArray2) {
        CClass cClass;
        Scope scope2;
        Type type;
        Object object;
        boolean bl = false;
        if ((l & 0x200L) != 0L) {
            object = Type.OBJECT;
            typeArray2 = typeArray;
            aST3 = aST2;
        } else if (typeArray.length == 0) {
            object = (l & 0x10000000000L) != 0L ? null : this.getDefaultSuperclass();
        } else {
            object = typeArray[0];
            if (!Reflection.isInvalid((Type)object)) {
                bl = true;
            }
        }
        Object object2 = type = bl ? object : null;
        if (scope instanceof CompilationUnitScope) {
            scope2 = (CompilationUnitScope)scope;
            if (this.shell != null) {
                cClass = this.shell;
            } else {
                cClass = new CClass(aST.getText(), scope2.getPackage().getCanonicalName(aST.getText()), (int)l, null, type, aST2, typeArray2, aST3, this);
                this.checkTopLevelType(aST, (Type)cClass, scope);
            }
            ((CompilationUnitScope)scope2).declareType(cClass);
        } else if (scope instanceof TypeScope) {
            scope2 = (TypeScope)scope;
            CClass cClass2 = ((TypeScope)scope2).getDeclaredType();
            for (int i = cClass2.getDeclaredTypeCount() - 1; i >= 0; --i) {
                if (!cClass2.getDeclaredType(i).getSimpleName().equals(aST.getText())) continue;
                this.problems.addSemanticError(I18N.msg("compiler.duplicate-type-declaration", (Object)aST.getText()), aST);
                break;
            }
            cClass = new CClass(aST.getText(), cClass2.getBinaryName() + '$' + aST.getText(), (int)l, cClass2, type, aST2, typeArray2, aST3, this);
            cClass2.declareType(cClass);
        } else {
            String string;
            scope2 = (BlockScope)scope;
            TypeScope typeScope = TypeScope.get(scope);
            CClass cClass3 = typeScope.getDeclaredType();
            if (aST != null) {
                string = aST.getText();
                if (((BlockScope)scope2).findClass(string) != null) {
                    this.problems.addSemanticError(I18N.msg("compiler.duplicate-type-declaration", (Object)string), aST);
                }
            } else {
                string = "";
            }
            cClass = new CClass(string, cClass3.getBinaryName() + '$' + typeScope.nextLocalClassId() + string, (int)l | 0x80000, cClass3, type, aST2, typeArray2, aST3, this);
            CompilationUnitScope.get(typeScope).declareLocalClass(cClass);
        }
        if (object != null && this.shell != cClass) {
            cClass.initSupertype((Type)object);
        }
        this.toResolveBeforeMethodDeclaration.add((Object)cClass);
        if (cClass != this.shell) {
            cClass.initTypeLoader(ClassPath.get(scope));
        }
        scope2 = new TypeScope(scope, cClass, l, (Compiler)this, aST);
        if ((cClass.getModifiers() & 0x80000) != 0) {
            ((BlockScope)scope).declareLocalClass((TypeScope)scope2);
        }
        return scope2;
    }

    void createDefaultConstructor(ClassInfo classInfo, boolean bl) {
        Extension extension;
        CClass cClass = classInfo.scope.getDeclaredType();
        if (bl || classInfo.defaultConstructorScope == null && Reflection.getDefaultConstructor((Type)cClass) == null && (extension = classInfo.scope.getExtension()) != null && extension.forcesDefaultConstructorFor((Type<?>)cClass)) {
            classInfo.defaultConstructorScope = classInfo.scope.createMethodScope((long)(cClass.getModifiers() & 7) | 0x800000000L);
            classInfo.defaultConstructorScope.createAndDeclareMethod("<init>", Type.VOID);
        }
    }

    Local declareParameter(MethodScope methodScope, AST aST, long l, Type type) {
        String string = aST.getText();
        if (methodScope.findLocal(string, false) != null) {
            this.problems.addSemanticError(I18N.msg("compiler.duplicate-parameter-declaration", (Object)string), aST);
            string = methodScope.getUniqueName(string);
        }
        return methodScope.declareParameter(string, l, type);
    }

    private Expression compileBuiltInOperator(Expression expression, Expression[] expressionArray, Scope scope) {
        try {
            return (expressionArray.length == 1 ? expression.compile(scope, expressionArray[0]) : expression.compile(scope, expressionArray[0], expressionArray[1])).toConst();
        }
        catch (RuntimeException runtimeException) {
            expressionArray[0].removeFromChain();
            if (expressionArray.length == 2) {
                expressionArray[1].removeFromChain();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Expression compileOperator(Expression expression, String string, Expression[] expressionArray, int n, Scope scope, AST aST) {
        String string2;
        Expression expression2;
        Expression expression3;
        this.ambiguousOperatorOverload = false;
        boolean bl = false;
        if (OPERATOR_NAME_EQUALS.equals(string) || OPERATOR_NAME_NOT_EQUALS.equals(string) || OPERATOR_NAME_IN.equals(string)) {
            for (int i = 0; i < expressionArray.length; ++i) {
                if (expressionArray[i].etype != 0) continue;
                bl = true;
                break;
            }
        }
        if (expression != null && !bl && (expression3 = this.compileBuiltInOperator(expression, expressionArray, scope)) != null) {
            return expression3;
        }
        if (string != null) {
            RecognitionExceptionList recognitionExceptionList;
            Expression expression4;
            if ((n & 3) == 1) {
                expressionArray = new Expression[]{expressionArray[0]};
            }
            try {
                this.problems.disableAdd();
                expression4 = this.compileMethodInvocation((AST)new ASTWithToken(11, string), ArgumentTransformations.NO_IMPLICIT_ARGS, expressionArray, (n & 4) != 0 ? 196608 : 163840, scope, aST);
            }
            finally {
                recognitionExceptionList = this.problems.enableAdd();
            }
            if (recognitionExceptionList.containsErrors()) {
                if (this.members.haveApplicable()) {
                    this.problems.addAll(recognitionExceptionList);
                    return null;
                }
            } else if (expression4 != null) {
                return expression4;
            }
        }
        if (expression != null && bl && (expression2 = this.compileBuiltInOperator(expression, expressionArray, scope)) != null) {
            return expression2;
        }
        switch (aST.getType()) {
            case 196: {
                string2 = "[]";
                break;
            }
            case 194: {
                string2 = "()";
                break;
            }
            case 159: {
                string2 = "``";
                break;
            }
            default: {
                string2 = aST.getText();
            }
        }
        if (expressionArray.length == 1 || (n & 1) != 0) {
            this.problems.addSemanticError(I18N.msg("compiler.illegal-unop-type", (Object)string2, (Object)expressionArray[0].getType()), aST);
        } else {
            this.problems.addSemanticError(I18N.msg("compiler.illegal-binop-type", (Object)string2, (Object)expressionArray[0].getType(), (Object)expressionArray[1].getType()), aST);
        }
        return null;
    }

    Expression compileCompoundAssignment(Expression expression, String string, Expression expression2, Expression expression3, int n, Scope scope, AST aST, AST aST2) {
        if (expression2 == null) {
            return null;
        }
        if (expression3 == null) {
            return new Expression(expression2.getType());
        }
        try {
            Expression expression4 = expression.compile(scope, new Pop(expression2.getType()), expression3).cast(expression2.getType());
            if (!(expression2 instanceof Variable)) {
                this.problems.addSemanticError(I18N, (n & 1) != 0 ? "compiler.inc-variable" : "compiler.lhs-variable", aST);
            } else if (expression3 != null) {
                return ((Variable)expression2).toAssignment((n & 2) != 0 ? 2 : 1).add(expression4);
            }
            return new Expression(expression2.getType());
        }
        catch (IllegalOperandTypeException illegalOperandTypeException) {
            expression3.removeFromChain();
        }
        catch (IllegalCastException illegalCastException) {
            expression3.removeFromChain();
        }
        Expression expression5 = this.compileOperator(null, string, new Expression[]{expression2, expression3}, n, scope, aST2);
        return expression5 != null ? expression5 : new Expression(expression2.getType());
    }

    Expression compileAssignment(Expression expression, Expression expression2, AST aST, AST aST2, Scope scope) {
        if (expression == null) {
            return null;
        }
        if (!(expression instanceof Variable)) {
            this.problems.addSemanticError(I18N, "compiler.lhs-variable", aST);
            return new Expression(expression.getType());
        }
        if (expression2 == null) {
            return new Expression(expression.getType());
        }
        expression2 = this.assignmentConversion(expression2, expression.getType(), scope, aST2);
        return ((Variable)expression).toAssignment(0).add(expression2);
    }

    Expression compileDeferredAssignment(String string, Expression expression, Expression expression2, BlockScope blockScope, AST aST, AST aST2) {
        ExpressionList expressionList;
        Expression expression3;
        Object object;
        Field field;
        Local local;
        if (expression == null || expression2 == null) {
            return null;
        }
        Expression expression4 = expression;
        if (expression instanceof GetLocal && (local = ((GetLocal)expression).getLocal((int)0).wrapper) != null) {
            field = local.wrapped.getPatternBuilder().getModel().getWrapProperty(local.getType());
            if (field != null) {
                field = field.getTypeCastProperty(expression.getType());
                expression = new GetProperty((CompiletimeModel.Property)field).add(local.createExpression(blockScope, aST));
            }
        } else if (expression instanceof GetField && !Reflection.isStatic((Member)(field = ((GetField)expression).getField())) && (object = blockScope.getPropertyModel((expression3 = expression.getFirstExpression()).getType(), (Compiler)this, aST)) != null && (expressionList = object.getDirectProperty(expression3.getType(), field.getSimpleName())) != null) {
            expression.removeAll(null);
            expression = new GetProperty((CompiletimeModel.Property)expressionList).add(expression3);
        }
        if (expression instanceof GetProperty) {
            field = ((GetProperty)expression).getProperty();
            if (!Reflection.isPrimitive((Type)field.getType())) {
                expression2 = this.assignmentConversion(expression2, field.getType(), blockScope, aST2);
            }
            int n = expression.getExpressionCount() - 1;
            object = expression.getFirstExpression();
            expressionList = new ExpressionList(((Expression)object).getType(), true);
            EvalExpression evalExpression = n > 0 ? new PopIntArray(n) : new GetField(INT_0);
            this.problems.disableAdd();
            Expression expression5 = this.compileOperator(null, string, new Expression[]{new GetPropertyInstance((CompiletimeModel.Property)field), expressionList, evalExpression, expression2}, 0, blockScope, aST2);
            RecognitionExceptionList recognitionExceptionList = this.problems.enableAdd();
            if (expression5 != null) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                this.problems.addAll(recognitionExceptionList);
                expressionList.receiveChildren(expression);
                if (n > 0) {
                    object5 = ((Expression)object).getNextExpression();
                    ((Expression)object).setNextSibling(null);
                    expressionList.add(new PushInts().add((Expression)object5));
                    object4 = evalExpression.getLeastCommonAncestor(expression2);
                    if (object4 != null) {
                        object3 = ((Expression)object4).getLastExpression();
                        object2 = (Expression)object3.getPredecessor();
                        assert (((Expression)object3).getLeastCommonAncestor(expression2) == object3);
                        assert (((Expression)object2).getLeastCommonAncestor(evalExpression) == object2);
                        new NoBytecode(((Expression)object2).getType()).substitute((Expression)object2).add((Expression)object2);
                        new SwapBytecode(((Expression)object3).getType(), (Expression)object2).substitute((Expression)object3).add((Expression)object3);
                    }
                }
                if (OPERATOR_NAME_DEFERRED_RATE_ASSIGN.equals(string)) {
                    object5 = TypeScope.getNonlocal(blockScope);
                    while (TypeScope.get(((Scope)object5).getEnclosingScope()) != null) {
                        object5 = TypeScope.get(((Scope)object5).getEnclosingScope());
                    }
                    object4 = ((TypeScope)object5).getDeclaredType();
                    object3 = null;
                    object2 = "$ODEHelper";
                    for (int i = object4.getDeclaredTypeCount() - 1; i >= 0; --i) {
                        if (!object4.getDeclaredType(i).getSimpleName().equals(object2)) continue;
                        object3 = (CClass)object4.getDeclaredType(i);
                        break;
                    }
                    if (object3 == null) {
                        object3 = new CClass((String)object2, object4.getBinaryName() + "$" + (String)object2, 4121, (CClass)object4, false);
                        object3.initSupertype(Type.OBJECT);
                        object4.declareType((XClass)object3);
                        XField xField = object3.declareField("TABLE", 25, (Type)ClassAdapter.wrap(RateAssignment[].class));
                        ((CClass)object3).rateAssignmentInitializer = new ArrayInit(xField.getType());
                        new XMethod("<clinit>", 8L, (CClass)object3, Type.TYPE_0, Type.VOID, new AssignField((Field)xField, 0).add(((CClass)object3).rateAssignmentInitializer));
                    }
                    Type type = ((Expression)object).getType();
                    InvokeStatic invokeStatic = new InvokeStatic(Reflection.findMethodInClasses((Type)ClassAdapter.wrap(RateAssignment.class), (String)"create"));
                    invokeStatic.complete(null);
                    GetPropertyInstance getPropertyInstance = new GetPropertyInstance((CompiletimeModel.Property)field);
                    getPropertyInstance.complete((CClass)object4);
                    ((CClass)object3).rateAssignmentInitializer.add(invokeStatic.add(getPropertyInstance).add(new ObjectConst(type, Type.CLASS)));
                }
                return expression5;
            }
            if (this.ambiguousOperatorOverload) {
                this.problems.addAll(recognitionExceptionList);
                return null;
            }
        }
        return this.compileOperator(null, string, new Expression[]{expression4, expression2}, 0, blockScope, aST2);
    }

    Expression compileArrayGenerator(Expression expression, BlockScope blockScope, AST aST) {
        Type type = expression.getType();
        if (Reflection.isArray((Type)type)) {
            return new ArrayGenerator(type.getComponentType(), blockScope.declareLocal("array.", 16L, type, aST), blockScope.declareLocal("counter.", 0L, Type.INT, aST)).add(expression);
        }
        int n = -1;
        for (int i = 0; i < 10; ++i) {
            if (!Reflection.isSupertypeOrSame((Type)GENERATOR_TYPES[i], (Type)type)) continue;
            if (n >= 0) {
                n = -1;
                break;
            }
            n = i;
        }
        if (n < 0) {
            this.problems.addSemanticError(I18N.msg("compiler.no-array-type", (Object)type), aST);
            return null;
        }
        InvokeVirtual invokeVirtual = new InvokeVirtual(Reflection.findMethodWithPrefixInTypes((Type)GENERATOR_TYPES[n], (String)"mevaluate", (boolean)false, (boolean)true));
        invokeVirtual.add(expression);
        invokeVirtual.setGenerator();
        CompilerBase.setAST(invokeVirtual, aST);
        return invokeVirtual;
    }

    Expression compileAggregateBooleanOr(Expression expression, BlockScope blockScope, AST aST) {
        if (expression == null) {
            return new Expression(Type.BOOLEAN);
        }
        ExpressionList expressionList = new ExpressionList(Type.BOOLEAN);
        BlockScope blockScope2 = new BlockScope((Scope)blockScope, expressionList);
        Local local = blockScope2.declareLocal("or.", 0L, Type.BOOLEAN, aST);
        expressionList.add(local.createSet().add(new BooleanConst(false)));
        MethodScope methodScope = blockScope.getMethodScope();
        methodScope.enterBreakTarget(null);
        Block block = Block.createSequentialBlock();
        block.add(local.createSet().add(expression));
        block.add(new If().add(local.createGet()).add(new Break(methodScope.getTargetId(null, false))));
        methodScope.leave(block);
        expressionList.add(block);
        expressionList.add(local.createGet());
        blockScope2.receiveLocals(blockScope, aST);
        return expressionList;
    }

    @Override
    public boolean allowsAmbiguousMembers(Member member) {
        return false;
    }

    @Override
    public boolean isApplicable(Member member, Members.Applicability applicability, Scope scope) {
        ArgumentTransformations argumentTransformations = this.resolution == 1 ? (((PatternWrapper)member).isFirstInOut() ? ArgumentTransformations.PREDICATE_ARGS : ArgumentTransformations.NO_IMPLICIT_ARGS) : this.resolutionImplicit;
        return argumentTransformations.getApplicableOption((Signature)member, applicability, this.resolutionArgs, scope) >= 0;
    }

    @Override
    public Type[] getArgumentTypes() {
        Type[] typeArray = new Type[this.resolutionArgs.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = this.resolutionArgs[i].getType();
            if (typeArray[i] != null) continue;
            typeArray[i] = Type.INVALID;
        }
        return typeArray;
    }

    private static int lessThanIfEqualSig(Method method, Method method2) {
        if (method instanceof ShiftedMethod) {
            method = ((ShiftedMethod)method).getMethod();
        }
        if (method2 instanceof ShiftedMethod) {
            method2 = ((ShiftedMethod)method2).getMethod();
        }
        if (!Reflection.equal((Signature)method, (Signature)method2)) {
            return 0;
        }
        if (Reflection.equal((Type)method.getReturnType(), (Type)method2.getReturnType())) {
            return !Reflection.isAbstract((Member)method2) || Reflection.isSuperclassOrSame((Type)method.getDeclaringType(), (Type)method2.getDeclaringType()) || !Reflection.isSuperclassOrSame((Type)method2.getDeclaringType(), (Type)method.getDeclaringType()) && Reflection.isAbstract((Member)method) ? 1 : -1;
        }
        return Reflection.isSupertypeOrSame((Type)method.getReturnType(), (Type)method2.getReturnType()) ? 1 : -1;
    }

    @Override
    public boolean isLessThan(Member member, Members.Applicability applicability, Member member2, Members.Applicability applicability2, Scope scope) {
        int n;
        if (applicability.scope != applicability2.scope && applicability.scope != null && applicability2.scope != null) {
            return false;
        }
        if (applicability.varArity != applicability2.varArity) {
            return false;
        }
        if (applicability.implicitCount != applicability2.implicitCount) {
            return applicability.implicitCount < applicability2.implicitCount;
        }
        Signature signature = (Signature)member;
        Signature signature2 = (Signature)member2;
        if (applicability.matchSet == applicability2.matchSet && signature instanceof Method && (n = CompilerBase.lessThanIfEqualSig((Method)member, (Method)member2)) != 0) {
            return n > 0;
        }
        return this.isMoreSpecific(signature2, applicability2, signature, applicability, scope) && !this.isMoreSpecific(signature, applicability, signature2, applicability2, scope);
    }

    private boolean isMoreSpecific(Signature signature, Members.Applicability applicability, Signature signature2, Members.Applicability applicability2, Scope scope) {
        assert (applicability.varArity || signature.getParameterCount() == signature2.getParameterCount());
        for (int i = Math.max(signature.getParameterCount(), signature2.getParameterCount()) - 1; i >= 0; --i) {
            Type type;
            if (i == 1) {
                if (applicability.array2Generator && !applicability2.array2Generator) continue;
                if (applicability2.array2Generator && !applicability.array2Generator) {
                    return false;
                }
            }
            if (!Reflection.equal((Type)(type = (Type)applicability.actualArguments.get(i)), (Type)((Type)applicability2.actualArguments.get(i)))) {
                type = null;
            }
            Type type2 = Reflection.getParameterType((Signature)signature, (int)i, (boolean)applicability.varArity);
            Type type3 = Reflection.getParameterType((Signature)signature2, (int)i, (boolean)applicability2.varArity);
            if (type != null) {
                this.implicitConversion(new Expression(type), type2, true, scope, null, null, true);
                int n = this.implCvType;
                this.implicitConversion(new Expression(type), type3, true, scope, null, null, true);
                int n2 = this.implCvType;
                if (n2 > n) {
                    return false;
                }
                if (n2 < n) continue;
            }
            if (Reflection.isWideningConversion((Type)type2, (Type)type3)) continue;
            return false;
        }
        return true;
    }

    private Method findMostSpecificMethod(ArgumentTransformations argumentTransformations, Expression[] expressionArray) throws RecognitionException {
        this.resolution = 0;
        this.resolutionImplicit = argumentTransformations;
        this.resolutionArgs = expressionArray;
        RecognitionException recognitionException = null;
        this.resolutionPhase = 0;
        while (this.resolutionPhase <= 3) {
            try {
                return (Method)this.members.resolve(this);
            }
            catch (RecognitionException recognitionException2) {
                recognitionException = recognitionException2;
                ++this.resolutionPhase;
            }
        }
        throw recognitionException;
    }

    Expression getArgumentList() {
        return this.argList;
    }

    Type[] getImplicitOption() {
        return this.implicitOption;
    }

    Method getInvokable() {
        return this.invokable;
    }

    private Expression compileInvocation(Method method, Invoke invoke, ArgumentTransformations argumentTransformations, Members.Applicability applicability, Expression[] expressionArray, Scope scope, AST aST) {
        int n;
        Expression expression;
        int n2;
        int n3 = applicability.transformationAlternative;
        assert (n3 >= 0);
        this.invokable = method;
        this.implicitOption = argumentTransformations.types[n3];
        assert (applicability.varArity || this.implicitOption.length + expressionArray.length == method.getParameterCount()) : method + " " + this.implicitOption.length + " " + expressionArray.length;
        this.argList = invoke.getFirstExpression();
        boolean bl = argumentTransformations.isGenerator(n3);
        boolean bl2 = argumentTransformations.isAggregate(n3);
        boolean bl3 = argumentTransformations.isFilter(n3);
        if (bl) {
            invoke.setGenerator();
        }
        if ((bl2 || bl3) && applicability.array2Generator) {
            expressionArray[0] = new ArrayGenerator(expressionArray[0].getType().getComponentType(), ((BlockScope)scope).declareLocal("array.", 16L, expressionArray[0].getType(), aST), ((BlockScope)scope).declareLocal("counter.", 0L, Type.INT, aST)).add(expressionArray[0]);
        }
        EvalExpression evalExpression = invoke;
        if (bl2 || bl3) {
            ExpressionFactory expressionFactory;
            BlockScope blockScope;
            Type type = method.getReturnType();
            n2 = type.getTypeId() == 1 ? 1 : 0;
            if (n2 != 0 || Reflection.equal(Array.class, (Type)type)) {
                expressionArray[0] = this.methodInvocationConversion(expressionArray[0], method.getParameterType(1), scope, Compiler.getAST(expressionArray[0]));
                type = expressionArray[0].getType();
                if (n2 == 0) {
                    type = type.getArrayType();
                }
            }
            evalExpression = new ExpressionList(type);
            if (bl2) {
                ExpressionFactory expressionFactory2;
                blockScope = new BlockScope(scope, evalExpression);
                expressionFactory = (Invoke)invoke.clone();
                if (!Reflection.isStatic((Member)method)) {
                    expressionFactory2 = invoke.getFirstExpression();
                    invoke.setBranch(null);
                    Local local = blockScope.declareLocal("instance.", 16L, ((Expression)expressionFactory2).getType(), aST);
                    evalExpression.add(local.createSet().add((Expression)expressionFactory2));
                    invoke.add(local.createGet());
                    ((Expression)expressionFactory).add(local.createGet());
                }
                expressionFactory2 = blockScope.declareLocal("aggr.", 16L, AGGREGATE_TYPE, aST);
                evalExpression.add(((Local)expressionFactory2).createSet().add(new InvokeStatic(Reflection.findMethodInClasses((Type)AGGREGATE_TYPE, (String)"allocate")).add(new ClassConst(type))));
                invoke.add(((Local)expressionFactory2).createGet());
                ((Expression)expressionFactory).add(((Local)expressionFactory2).createGet());
                for (int i = 1; i < method.getParameterCount(); ++i) {
                    ((Expression)expressionFactory).add(Expression.createConst(method.getParameterType(i), null));
                }
                MethodScope methodScope = blockScope.getMethodScope();
                methodScope.enterBreakTarget(null);
                Block block = new Block();
                Block block2 = Block.createSequentialBlock();
                block2.add(invoke).add(new If().add(new InvokeVirtual(Reflection.findMethodInClasses((Type)AGGREGATE_TYPE, (String)"isFinished")).add(((Local)expressionFactory2).createGet())).add(new Break(methodScope.getTargetId(null, false))));
                block.add(block2);
                block.add(new InvokeVirtual(Reflection.getDeclaredMethod((Type)AGGREGATE_TYPE, (String)"setFinished")).add(((Local)expressionFactory2).createGet()));
                block.add((Expression)expressionFactory);
                methodScope.leave(block);
                evalExpression.add(block);
                expression = new InvokeStatic(Reflection.getDeclaredMethod((Type)AGGREGATE_TYPE, (String)(Reflection.getJVMPrefix((Type)type) + "val"))).add(((Local)expressionFactory2).createGet());
                blockScope.receiveLocals((BlockScope)scope, aST);
            } else {
                blockScope = (BlockScope)scope;
                expressionFactory = blockScope.declareLocal("filter.", 16L, FILTER_TYPE, aST);
                evalExpression.add(((Local)expressionFactory).createSet().add(new InvokeStatic(Reflection.getDeclaredMethod((Type)FILTER_TYPE, (String)"allocate")).add(new ClassConst(type))));
                invoke.add(((Local)expressionFactory).createGet());
                expression = new FilterGuard(type, (Local)expressionFactory).add(invoke);
            }
            if (expression.getType().getTypeId() != type.getTypeId() || type.getTypeId() == 0 && !Reflection.equal((Type)Type.OBJECT, (Type)type)) {
                expression = expression.cast(type);
            }
            evalExpression.add(expression);
        }
        expressionArray = argumentTransformations.complete((Signature)method, n3, expressionArray, applicability.varArity, scope, aST);
        int n4 = n = applicability.varArity ? method.getParameterCount() - 1 : expressionArray.length;
        assert (n >= 0) : method;
        for (n2 = 0; n2 < n; ++n2) {
            if (n2 <= 0 && (bl || bl2 || bl3)) continue;
            expressionArray[n2] = this.methodInvocationConversion(expressionArray[n2], method.getParameterType(n2), scope, Compiler.getAST(expressionArray[n2]));
            if (n2 == 0 && Reflection.isCtor((Method)method) && (expression = method.getDeclaringType()).getDeclaringType() != null && !Reflection.isStatic((Member)expression)) {
                expressionArray[n2] = new CheckNonNull(expressionArray[n2].getType()).add(expressionArray[n2]);
            }
            invoke.add(expressionArray[n2]);
        }
        if (applicability.varArity) {
            Type type = method.getParameterType(n);
            expression = new ArrayInit(type);
            type = type.getComponentType();
            for (int i = n; i < expressionArray.length; ++i) {
                expressionArray[i] = this.methodInvocationConversion(expressionArray[i], type, scope, Compiler.getAST(expressionArray[i]));
                expression.add(expressionArray[i]);
            }
            invoke.add(expression);
        }
        this.argList = this.argList == null ? invoke.getFirstExpression() : this.argList.getNextExpression();
        CClass cClass = CompilerBase.getClassForAccessMethod((Member)method, scope, invoke.getFirstExpression());
        if (cClass != null) {
            invoke.useAccessMethod(cClass);
        }
        CompilerBase.setAST(evalExpression, aST);
        return evalExpression;
    }

    private static CClass getClassForAccessMethod(Member member, Scope scope, Expression expression) {
        if (Reflection.isPrivate((Member)member)) {
            if (Reflection.equal((Type)member.getDeclaringType(), (Type)scope.getDeclaredType())) {
                return null;
            }
            return (CClass)member.getDeclaringType();
        }
        if (Reflection.isProtected((Member)member)) {
            TypeScope typeScope = TypeScope.get(scope);
            scope = typeScope;
            if (member.getDeclaringType().getPackage().equals(typeScope.getDeclaredType().getPackage())) {
                return null;
            }
            TypeScope typeScope2 = null;
            while (typeScope != null) {
                if (Reflection.isSupertypeOrSame((Type)member.getDeclaringType(), (Type)typeScope.getDeclaredType()) && (expression == null || Reflection.isStatic((Member)member) || Reflection.isSupertypeOrSame((Type)typeScope.getDeclaredType(), (Type)expression.getType())) && (typeScope2 = typeScope) == scope) {
                    return null;
                }
                typeScope = TypeScope.get(typeScope.getEnclosingScope());
            }
            return typeScope2.getDeclaredType();
        }
        return null;
    }

    Expression compileMethodInvocation(Type type, ExpressionFactory expressionFactory, String string, ArgumentTransformations argumentTransformations, Expression[] expressionArray, int n, Scope scope, AST aST) {
        if (Reflection.isInvalid((Type)type) || expressionArray == null) {
            return null;
        }
        try {
            this.members.resetName(string, aST);
            this.members.addMatches(scope, type, n | (expressionFactory instanceof Super ? 8328 : 8));
            return this.compileMethodInvocation(this.findMostSpecificMethod(argumentTransformations, expressionArray), expressionFactory, argumentTransformations, this.members.getApplicability(), expressionArray, scope, aST);
        }
        catch (RecognitionException recognitionException) {
            this.problems.add(recognitionException);
            return null;
        }
    }

    Expression compileMethodInvocation(Method method, ExpressionFactory expressionFactory, ArgumentTransformations argumentTransformations, Members.Applicability applicability, Expression[] expressionArray, Scope scope, AST aST) {
        Invoke invoke;
        Expression expression;
        if (Reflection.isStatic((Member)method)) {
            expression = expressionFactory instanceof Expression && !((Expression)expressionFactory).evaluatesWithoutSideeffect() ? (Expression)expressionFactory : null;
            invoke = new InvokeStatic(method);
        } else {
            if (expressionFactory != null) {
                expression = expressionFactory.createExpression(scope, aST);
            } else {
                this.problems.addSemanticError(I18N.msg("compiler.nonstatic-in-static-context", (Object)Members.getMemberTypeDescription((Member)method), (Object)Reflection.getDescription((Member)method)), aST);
                expression = new Expression(method.getDeclaringType());
            }
            if (expression instanceof Super || Reflection.isPrivate((Member)method)) {
                invoke = new InvokeSpecial(method);
                if (Reflection.isAbstract((Member)method)) {
                    this.problems.addSemanticError(I18N.msg("compiler.abstract-method-invocation", (Object)Reflection.getDescription((Member)method)), aST);
                }
            } else {
                invoke = new InvokeVirtual(method);
            }
            invoke.add(expression);
            expression = null;
        }
        Expression expression2 = this.compileInvocation(method, invoke, argumentTransformations, applicability, expressionArray, scope, aST);
        return expression == null ? expression2 : new ExpressionList(expression2.getType()).add(expression).add(expression2);
    }

    Expression compileMethodInvocation(AST aST, ArgumentTransformations argumentTransformations, Expression[] expressionArray, int n, Scope scope, AST aST2) {
        if (expressionArray == null) {
            return null;
        }
        switch (aST.getType()) {
            case 11: {
                Expression expression;
                Members.Applicability applicability;
                Method method;
                String string = aST.getText();
                this.members.resetName(string, aST2);
                if (((n |= 8) & 0x20000) != 0) {
                    this.members.addMatches(scope, expressionArray[0].getType(), n | 0x40000);
                    for (int i = 0; i < expressionArray.length; ++i) {
                        this.members.addMatches(scope, expressionArray[i].getType(), n);
                    }
                }
                this.members.addMatches(scope, n);
                try {
                    method = this.findMostSpecificMethod(argumentTransformations, expressionArray);
                    applicability = this.members.getApplicability();
                }
                catch (RecognitionException recognitionException) {
                    this.problems.add(recognitionException);
                    return null;
                }
                if (method instanceof ShiftedMethod) {
                    method = ((ShiftedMethod)method).getMethod();
                    expression = expressionArray[0];
                    Expression[] expressionArray2 = expressionArray;
                    expressionArray = new Expression[expressionArray.length - 1];
                    System.arraycopy(expressionArray2, 1, expressionArray, 0, expressionArray.length);
                } else {
                    expression = this.compileInstance((Member)method, this.members.getScopeForResult(), scope, aST2);
                }
                return this.compileMethodInvocation(method, expression, argumentTransformations, applicability, expressionArray, scope, aST2);
            }
            case 82: {
                aST = aST.getFirstChild();
                Object object = this.resolver.resolveExpressionOrTypeName(aST, scope);
                if (object == null) {
                    return null;
                }
                aST = aST.getNextSibling();
                assert (aST.getType() == 11);
                if (object instanceof Expression) {
                    return this.compileMethodInvocation((Expression)object, aST.getText(), argumentTransformations, expressionArray, n, scope, aST2);
                }
                return this.compileMethodInvocation((Type)object, null, aST.getText(), argumentTransformations, expressionArray, n, scope, aST2);
            }
        }
        throw new AssertionError();
    }

    Expression compileMethodInvocation(ExpressionFactory expressionFactory, String string, ArgumentTransformations argumentTransformations, Expression[] expressionArray, int n, Scope scope, AST aST) {
        if (expressionFactory == null || expressionArray == null) {
            return null;
        }
        return this.compileMethodInvocation(expressionFactory.getType(), expressionFactory, string, argumentTransformations, expressionArray, n, scope, aST);
    }

    private ArgumentTransformations getImplArgsForConstructor(Type type, Expression expression, Scope scope, AST aST, String string) {
        if (type.getDeclaringType() != null && !Reflection.isStatic((Member)type)) {
            if (expression == null) {
                expression = this.compileInstance((Member)type, null, scope, aST);
            } else if (!expression.hasType(type.getDeclaringType())) {
                this.problems.addSemanticError(I18N.msg("compiler.unexpected-type", (Object)expression.getType().getName(), (Object)type.getDeclaringType().getName()), aST.getFirstChild());
                return null;
            }
            this.constrImplicit.setEnclosing(expression);
            return this.constrImplicit;
        }
        if (expression != null) {
            this.problems.addSemanticError(I18N.msg(string, (Object)type.getName()), aST);
            return null;
        }
        return ArgumentTransformations.NO_IMPLICIT_ARGS;
    }

    private void compileLocalClassConstructor(Scope scope, Invoke invoke) {
        Type type = invoke.getType();
        if ((type.getModifiers() & 0x80000) != 0) {
            BlockScope blockScope = (BlockScope)scope;
            TypeScope typeScope = blockScope.getTypeScope(type);
            MethodScope methodScope = MethodScope.get(blockScope);
            boolean bl = typeScope.encloses(blockScope);
            if (!bl) {
                bl = methodScope.isConstructor();
                ObjectList<Local> objectList = typeScope.getEnclosingLocals();
                for (int i = 0; i < objectList.size(); ++i) {
                    Expression expression = ((Local)objectList.get(i)).createExpression(blockScope, null);
                    if (bl) continue;
                    invoke.add(expression);
                }
            }
            if (bl) {
                CompilerBase.setBlockScope(invoke, blockScope);
                TypeScope.getNonlocal(typeScope).addIncompleteConstructorInvocation(invoke);
            }
        }
    }

    Expression compileConstructorInvocation(Method method, Expression[] expressionArray, Scope scope, AST aST) {
        Type type = method.getDeclaringType();
        assert (!Reflection.isAbstract((Member)type));
        if (expressionArray == null) {
            return new Expression(type);
        }
        ArgumentTransformations argumentTransformations = this.getImplArgsForConstructor(type, null, scope, aST, "compiler.qualified-new-of-static");
        if (argumentTransformations == null) {
            return new Expression(type);
        }
        Invoke invoke = new InvokeSpecial(method);
        invoke.add(new New(type));
        Members.Applicability applicability = new Members.Applicability();
        argumentTransformations.getApplicableOption((Signature)method, applicability, expressionArray, scope);
        invoke = (Invoke)this.compileInvocation(method, invoke, argumentTransformations, applicability, expressionArray, scope, aST);
        this.compileLocalClassConstructor(scope, invoke);
        return invoke;
    }

    Expression compileConstructorInvocation(Expression expression, Expression expression2, Expression[] expressionArray, Scope scope, AST aST, boolean bl) {
        Type type = expression.getType();
        if (Reflection.isInvalid((Type)type)) {
            return null;
        }
        if (expressionArray == null) {
            return new Expression(type);
        }
        if (!bl && Reflection.isAbstract((Member)type)) {
            this.problems.addSemanticError(I18N.msg("compiler.abstract-instantiation", (Object)type.getName()), aST);
        }
        try {
            ArgumentTransformations argumentTransformations = this.getImplArgsForConstructor(type, expression2, scope, aST, "compiler.qualified-new-of-static");
            if (argumentTransformations == null) {
                return new Expression(type);
            }
            this.members.resetName("<init>", aST);
            this.members.addMatches(scope, type, 2064);
            Method method = this.findMostSpecificMethod(argumentTransformations, expressionArray);
            Members.Applicability applicability = this.members.getApplicability();
            Invoke invoke = new InvokeSpecial(method);
            invoke.add(expression);
            invoke = (Invoke)this.compileInvocation(method, invoke, argumentTransformations, applicability, expressionArray, scope, aST);
            this.compileLocalClassConstructor(scope, invoke);
            return invoke;
        }
        catch (RecognitionException recognitionException) {
            this.problems.add(recognitionException);
            return new Expression(type);
        }
    }

    Expression compileSuperConstructorInvocation(Expression expression, Expression expression2, Expression[] expressionArray, BlockScope blockScope, AST aST) {
        CClass cClass = blockScope.getDeclaredType();
        if (expressionArray == null || Reflection.isInvalid((Type)cClass) || Reflection.isInvalid((Type)cClass.getSupertype())) {
            return null;
        }
        try {
            ArgumentTransformations argumentTransformations = this.getImplArgsForConstructor(cClass.getSupertype(), expression2, blockScope, aST, "compiler.qualified-super-of-static");
            if (argumentTransformations == null) {
                return null;
            }
            this.members.resetName("<init>", aST);
            this.members.addMatches(blockScope, (Type)cClass, 10256);
            Method method = this.findMostSpecificMethod(argumentTransformations, expressionArray);
            Members.Applicability applicability = this.members.getApplicability();
            Invoke invoke = new InvokeSpecial(method);
            invoke.add(expression);
            invoke = (Invoke)this.compileInvocation(method, invoke, argumentTransformations, applicability, expressionArray, blockScope, aST);
            this.compileLocalClassConstructor(blockScope, invoke);
            return invoke;
        }
        catch (RecognitionException recognitionException) {
            this.problems.add(recognitionException);
            return null;
        }
    }

    public Expression compileFieldExpression(Field field, Expression expression, Scope scope, AST aST) {
        if (expression == null && !Reflection.isStatic((Member)field)) {
            this.problems.addSemanticError(I18N.msg("compiler.nonstatic-in-static-context", (Object)Members.getMemberTypeDescription((Member)field), (Object)Reflection.getDescription((Member)field)), aST);
            expression = new Expression(field.getDeclaringType());
        }
        if (expression != null && (field.getModifiers() & 0x40008) != 0 && expression.evaluatesWithoutSideeffect()) {
            expression = null;
        }
        if ((field.getModifiers() & 0x40000) != 0) {
            Expression expression2;
            try {
                expression2 = Expression.createConst(field.getType(), Reflection.get(null, (Field)field));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException.getMessage());
            }
            if (expression != null) {
                expression2 = new ExpressionList(field.getType()).add(expression).add(expression2);
            }
            return expression2;
        }
        Expression expression3 = new GetField(field).add(expression);
        this.fieldAccessed(field);
        CClass cClass = CompilerBase.getClassForAccessMethod((Member)field, scope, expression3.getFirstExpression());
        if (cClass != null) {
            ((GetField)expression3).useAccessMethod(cClass);
        }
        return expression3;
    }

    Expression compileInstance(Type type, BlockScope blockScope, AST aST, boolean bl) {
        Expression expression;
        MethodScope methodScope = blockScope.getMethodScope();
        if (methodScope.isStatic()) {
            this.problems.addSemanticError(I18N, bl ? "compiler.super-in-static-context" : "compiler.this-in-static-context", aST);
            expression = new Expression((Type)(type == null ? methodScope.getDeclaredType() : type));
        } else {
            if (type != null && Reflection.isInvalid((Type)type)) {
                return new Expression(Type.INVALID);
            }
            expression = methodScope.createThis();
            TypeScope typeScope = TypeScope.get(methodScope);
            if (type != null && !Reflection.equal((Type)typeScope.getDeclaredType(), (Type)type)) {
                if (methodScope.enclosingInstance != null) {
                    expression = methodScope.enclosingInstance.createGet();
                    typeScope = TypeScope.get(typeScope.getEnclosingScope());
                }
                while (!Reflection.equal((Type)typeScope.getDeclaredType(), (Type)type)) {
                    if (typeScope.isStatic()) {
                        this.problems.addSemanticError(I18N.msg("compiler.no-enclosing-instance", (Object)type.getName()), aST);
                        expression = new Expression(type);
                        break;
                    }
                    expression = this.compileFieldExpression((Field)typeScope.enclosingInstance, expression, blockScope, aST);
                    typeScope = TypeScope.get(typeScope.getEnclosingScope());
                }
            }
        }
        return bl ? new Super(expression.getType()).add(expression) : expression;
    }

    public Expression compileInstance(Member member, Scope scope, Scope scope2, AST aST) {
        MethodScope methodScope;
        if (Reflection.isStatic((Member)member)) {
            return null;
        }
        if (scope instanceof InstanceScope) {
            return ((InstanceScope)scope).createExpression(scope2, aST);
        }
        Type type = member.getDeclaringType();
        if (!(scope2 instanceof BlockScope) || (methodScope = ((BlockScope)scope2).getMethodScope()).isStatic()) {
            this.problems.addSemanticError(I18N.msg("compiler.nonstatic-in-static-context", (Object)Members.getMemberTypeDescription(member), (Object)member.getSimpleName()), aST);
            return new Expression(type);
        }
        Expression expression = methodScope.createThis();
        TypeScope typeScope = TypeScope.get(methodScope);
        if (scope != null ? typeScope == scope : Reflection.isSuperclassOrSame((Type)type, (Type)typeScope.getDeclaredType())) {
            return expression;
        }
        if (methodScope.enclosingInstance != null) {
            expression = methodScope.enclosingInstance.createGet();
            typeScope = TypeScope.get(typeScope.getEnclosingScope());
        }
        while (scope != null ? typeScope != scope : !Reflection.isSuperclassOrSame((Type)type, (Type)typeScope.getDeclaredType())) {
            if (typeScope.isStatic()) {
                this.problems.addSemanticError(I18N.msg("compiler.no-enclosing-instance-for-member", (Object)Members.getMemberTypeDescription(member), (Object)member.getSimpleName(), (Object)type.getName()), aST);
                return new Expression(type);
            }
            expression = this.compileFieldExpression((Field)typeScope.enclosingInstance, expression, scope2, aST);
            typeScope = TypeScope.get(typeScope.getEnclosingScope());
        }
        return expression;
    }

    private void setMembers(AST aST, Scope scope, int n) {
        if (aST.getType() == 82) {
            aST = aST.getFirstChild();
            Object object = this.resolver.resolveExpressionOrTypeName(aST, scope);
            aST = aST.getNextSibling();
            this.members.resetName(aST);
            if (object instanceof Expression) {
                this.members.addMatches(scope, ((Expression)object).getType(), n);
            } else {
                this.members.addMatches(scope, (Type)object, n);
            }
        } else {
            this.members.resetName(aST);
            this.members.addMatches(scope, n);
        }
    }

    void compilePattern(AST aST, Expression[] expressionArray, AST aST2, PatternBuilder patternBuilder, AST aST3) {
        this.resolution = 1;
        this.setMembers(aST, patternBuilder.getScope(), 4);
        this.resolutionArgs = expressionArray;
        try {
            int n;
            PatternWrapper patternWrapper = (PatternWrapper)this.members.resolve(this);
            if (patternWrapper == null) {
                return;
            }
            int n2 = n = this.members.getApplicability().transformationAlternative > 0 ? 1 : 0;
            if (n > 0) {
                Expression[] expressionArray2 = new Expression[expressionArray.length + 1];
                System.arraycopy(expressionArray, 0, expressionArray2, 1, expressionArray.length);
                expressionArray2[0] = null;
                expressionArray = expressionArray2;
            }
            for (int i = n; i < expressionArray.length; ++i) {
                if (expressionArray[i].etype == 0) continue;
                expressionArray[i] = this.methodInvocationConversion(expressionArray[i], patternWrapper.getParameterType(i), patternBuilder.getScope(), Compiler.getAST(expressionArray[i]));
            }
            if (n > 0) {
                patternBuilder.addNodePattern(aST3, patternWrapper, ArgumentDescription.create(expressionArray), aST2);
            } else {
                patternBuilder.addPattern(aST3, patternWrapper, ArgumentDescription.create(expressionArray), aST2);
            }
        }
        catch (RecognitionException recognitionException) {
            this.problems.add(recognitionException);
        }
    }

    void compileEdgePattern(AST aST, Expression[] expressionArray, AST aST2, PatternBuilder patternBuilder, BlockScope blockScope, AST aST3, EdgeDirection edgeDirection) {
        this.resolution = edgeDirection == EdgeDirection.UNDIRECTED ? 3 : 2;
        this.setMembers(aST, blockScope, 4);
        EPImplicit ePImplicit = edgeDirection == EdgeDirection.UNDIRECTED ? this.undirectedEPImplicit : this.directedEPImplicit;
        this.resolutionImplicit = ePImplicit;
        this.resolutionArgs = expressionArray;
        try {
            PatternWrapper patternWrapper = (PatternWrapper)this.members.resolve(this);
            if (patternWrapper == null) {
                return;
            }
            expressionArray = this.resolutionImplicit.complete(patternWrapper, this.members.getApplicability().transformationAlternative, expressionArray, false, blockScope, aST2);
            for (int i = 0; i < expressionArray.length; ++i) {
                if (expressionArray[i] == null || expressionArray[i].etype == 0) continue;
                expressionArray[i] = this.methodInvocationConversion(expressionArray[i], patternWrapper.getParameterType(i), patternBuilder.getScope(), Compiler.getAST(expressionArray[i]));
            }
            if (ePImplicit.object) {
                patternBuilder.addEdgePattern(aST3, patternWrapper, ArgumentDescription.create(expressionArray), edgeDirection, aST2);
            } else {
                patternBuilder.addRelationPattern(aST3, patternWrapper, ArgumentDescription.create(expressionArray), edgeDirection == EdgeDirection.BACKWARD, aST2);
            }
        }
        catch (RecognitionException recognitionException) {
            this.problems.add(recognitionException);
        }
    }

    void compileMethodEdgePattern(AST aST, Expression[] expressionArray, AST aST2, PatternBuilder patternBuilder, BlockScope blockScope, AST aST3, EdgeDirection edgeDirection, boolean bl) {
        this.mepImplicit.undirected = edgeDirection == EdgeDirection.UNDIRECTED;
        this.mepImplicit.useThis = bl;
        Expression expression = this.compileMethodInvocation(aST, this.mepImplicit, expressionArray, 0, blockScope, aST2);
        if (expression != null) {
            if (this.mepImplicit.relation) {
                patternBuilder.addRelation(aST3, expression, edgeDirection == EdgeDirection.BACKWARD, aST2);
            } else if (this.mepImplicit.path) {
                patternBuilder.addPathExpression(aST3, expression, edgeDirection == EdgeDirection.BACKWARD, aST2);
            } else {
                patternBuilder.addEdge(aST3, edgeDirection, expression, aST);
            }
        }
    }

    void compileMethodEdgePattern(Expression expression, String string, Expression[] expressionArray, AST aST, PatternBuilder patternBuilder, AST aST2, EdgeDirection edgeDirection) {
        this.mepImplicit.undirected = edgeDirection == EdgeDirection.UNDIRECTED;
        this.mepImplicit.useThis = false;
        Expression expression2 = this.compileMethodInvocation(expression, string, (ArgumentTransformations)this.mepImplicit, expressionArray, 0, (Scope)patternBuilder.getScope(), aST);
        if (expression2 != null) {
            if (this.mepImplicit.relation) {
                patternBuilder.addRelation(aST2, expression2, edgeDirection == EdgeDirection.BACKWARD, aST);
            } else if (this.mepImplicit.path) {
                patternBuilder.addPathExpression(aST2, expression2, edgeDirection == EdgeDirection.BACKWARD, aST);
            } else {
                patternBuilder.addEdge(aST2, edgeDirection, expression2, aST);
            }
        }
    }

    Expression[] resolveOpenArguments(Expression[] expressionArray, Scope scope) {
        if (expressionArray != null) {
            for (int i = 0; i < expressionArray.length; ++i) {
                if (!(expressionArray[i] instanceof OpenArgument)) continue;
                expressionArray[i] = this.resolver.resolveExpressionName(CompilerBase.getAST(expressionArray[i]), scope);
                if (expressionArray[i] != null) continue;
                return null;
            }
        }
        return expressionArray;
    }

    Local pushProducer(BlockScope blockScope, AST aST) {
        ProduceScope produceScope = ProduceScope.get(blockScope);
        if (produceScope == null) {
            return null;
        }
        produceScope.push();
        return (Local)produceScope.getInstance();
    }

    Local popProducer(BlockScope blockScope, AST aST) {
        ProduceScope produceScope = ProduceScope.get(blockScope);
        if (produceScope == null) {
            return null;
        }
        produceScope.pop();
        return (Local)produceScope.getInstance();
    }

    Expression popAndJoinProducer(BlockScope blockScope, AST aST) {
        ProduceScope produceScope = ProduceScope.get(blockScope);
        if (produceScope == null) {
            return null;
        }
        ExpressionFactory expressionFactory = produceScope.getInstance();
        produceScope.pop();
        Local local = (Local)produceScope.getInstance();
        if (expressionFactory == local) {
            return null;
        }
        Expression expression = local.createSet(blockScope, aST);
        expression.add(this.assignmentConversion(expressionFactory.createExpression(blockScope, aST), local.getType(), blockScope, aST));
        return expression;
    }

    Expression setProducer(BlockScope blockScope, Expression expression, AST aST) {
        if (expression == null) {
            return null;
        }
        if (expression.getType().getTypeId() == 1) {
            this.problems.addSemanticError(I18N, "compiler.void-producer", aST);
            return new Expression(blockScope.getProduceScope().getInstance().getType());
        }
        Local local = blockScope.declareLocal("prod.", 16L, expression.getType(), aST);
        blockScope.getProduceScope().setInstance(local);
        return local.createSet(blockScope, aST).add(expression);
    }

    void compileInitializers() {
        try {
            for (FieldInitializer fieldInitializer : this.initializersToCompile.values()) {
                this.compile(fieldInitializer);
            }
        }
        catch (antlr.RecognitionException recognitionException) {
            throw new WrapException((Throwable)recognitionException);
        }
    }

    private void compile(FieldInitializer fieldInitializer) throws antlr.RecognitionException {
        if (!fieldInitializer.compiled) {
            CompilerOptions compilerOptions = this.options;
            TypeScope typeScope = this.currentTypeScope;
            CompilationUnitScope compilationUnitScope = this.currentCompilationUnitScope;
            Package package_ = this.currentPackage;
            this.options = fieldInitializer.options;
            fieldInitializer.compiled = true;
            this.currentTypeScope = TypeScope.get(fieldInitializer.scope);
            this.currentCompilationUnitScope = CompilationUnitScope.get(this.currentTypeScope);
            this.currentPackage = this.currentCompilationUnitScope.getPackage();
            fieldInitializer.expr = this.compileConstants(((Compiler)this).initializer(fieldInitializer.ast, fieldInitializer.scope, fieldInitializer.field.getType()));
            if (fieldInitializer.expr.isPrimitiveOrStringConstant() && Reflection.isPrimitiveOrString((Type)fieldInitializer.field.getType())) {
                Expression expression = this.assignmentConversion(fieldInitializer.expr, fieldInitializer.field.getType(), fieldInitializer.scope, fieldInitializer.ast);
                if (expression.isPrimitiveOrStringConstant()) {
                    fieldInitializer.field.setConstant(expression.evaluateAsObject(null));
                    fieldInitializer.expr = null;
                } else {
                    fieldInitializer.expr = expression;
                }
            }
            this.options = compilerOptions;
            this.currentTypeScope = typeScope;
            this.currentCompilationUnitScope = compilationUnitScope;
            this.currentPackage = package_;
        }
    }

    private Expression compileConstants(Expression expression) throws antlr.RecognitionException {
        Expression expression2;
        if (expression instanceof GetField) {
            FieldInitializer fieldInitializer;
            expression2 = FieldDecorator.undecorate((Field)((GetField)expression).getField());
            if (expression2 instanceof XField && (expression2.getModifiers() & 0x40000) == 0 && (fieldInitializer = this.initializersToCompile.get(expression2)) != null) {
                this.compile(fieldInitializer);
            }
            if ((expression2.getModifiers() & 0x40000) != 0) {
                try {
                    return Expression.createConst(expression2.getType(), Reflection.get(null, (Field)expression2));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw (antlr.RecognitionException)new antlr.RecognitionException().initCause((Throwable)illegalAccessException);
                }
            }
        }
        if ((expression2 = expression.getFirstExpression()) == null) {
            return expression;
        }
        boolean bl = true;
        while (expression2 != null) {
            Expression expression3 = expression2;
            expression2 = expression2.getNextExpression();
            Expression expression4 = this.compileConstants(expression3);
            if (expression4 != expression3) {
                expression4.substitute(expression3);
            }
            if (expression4.isPrimitiveOrStringConstant()) continue;
            bl = false;
        }
        return bl ? expression.toConst() : expression;
    }

    private Block compileIterations(Expression expression, Block block) {
        Local local;
        Expression expression2;
        Expression expression3;
        Block block2;
        Object object;
        if (expression instanceof Block && ((Block)expression).isSequentialBlock()) {
            block = (Block)expression;
        }
        Expression expression4 = expression.getFirstExpression();
        Block block3 = block;
        while (expression4 != null) {
            object = expression4.getNextExpression();
            block = this.compileIterations(expression4, block);
            expression4 = object;
        }
        if (!(expression instanceof Generator) || ((Generator)((Object)expression)).getGeneratorType() == 0) {
            return block;
        }
        object = MethodScope.get(expression);
        if (expression instanceof Invoke && expression.getAxisParent() instanceof Yield && expression.etype == XMethod.getGeneratorType(((MethodScope)object).getMethod()).getTypeId()) {
            Yield yield = (Yield)expression.getAxisParent();
            expression.removeFromChain();
            ((Invoke)expression).receiveConsumer(((MethodScope)object).consumer.createGet());
            expression.substitute(yield);
            ((MethodScope)object).createVMXFrame();
            return block;
        }
        boolean bl = ((Generator)((Object)expression)).getGeneratorType() == 2;
        MethodScope methodScope = bl ? new MethodScope((MethodScope)object) : null;
        block = block2 = Block.createSequentialBlock();
        Expression expression5 = expression;
        Expression expression6 = (Expression)expression.getAxisParent();
        boolean bl2 = expression6.isRequired(expression.getIndex());
        Local local2 = expression6 instanceof AssignLocal ? ((AssignLocal)expression6).getLocal(0) : null;
        this.stack.clear();
        while (true) {
            if ((expression6 = (Expression)expression5.getAxisParent()) instanceof Block && ((Block)expression6).isSequentialBlock()) {
                assert (expression6.getBranch() == expression5);
                break;
            }
            int n = expression5.getIndex();
            if (!expression6.allowsIteration(n)) {
                this.problems.addSemanticError(I18N, "compiler.no-iteration-target", Compiler.getAST(expression));
                return block;
            }
            expression4 = expression5;
            while (--n >= 0) {
                if ((expression4 = (Expression)expression4.getPredecessor()) instanceof Constant || expression4 instanceof New || expression4 instanceof GetField && (expression3 = (GetField)expression4).getExpressionCount() == 0 && (((GetField)expression3).getField().getModifiers() & 0x18) == 24 || ((int)expression4.lval & 1) != 0 && (!bl || expression4 instanceof LocalValue)) continue;
                this.stack.push((Object)expression6.isRequired(n));
                this.stack.push((Object)expression4);
            }
            expression5 = expression6;
        }
        expression4 = expression6.getFirstExpression();
        expression6.setBranch(null);
        block2.add(expression4);
        while (this.stack.size > 0) {
            expression4 = (Expression)this.stack.pop();
            if (this.stack.pop() == Boolean.TRUE) {
                assert (expression4.getType().getTypeId() != 1);
                Local local3 = ((BlockScope)object).declareLocal("param.", 16L, expression4.getType(), null);
                expression3 = local3.createGet();
                expression2 = local3.createSet();
                expression3.substitute(expression4);
                expression2.setBranch(expression4);
                expression6.add(expression2);
                continue;
            }
            expression4.removeFromChain();
            expression6.add(expression4);
        }
        Block block4 = new Block();
        expression3 = expression;
        if (expression.etype == 1) {
            expression2 = new Block();
        } else if (bl) {
            expression2 = methodScope.declareParameter("value.", 16L, expression.getType()).createGet();
        } else if (!bl2) {
            expression2 = new Block();
            block4.add(new Pop(expression.getType()));
        } else {
            if (local2 == null) {
                local = ((BlockScope)object).declareLocal("val.", 16L, expression.getType(), null);
            } else {
                local = local2;
                expression3 = (Expression)expression.getAxisParent();
                new Expression().substitute(expression);
            }
            block4.add(local.createSet().add(new Pop(expression.getType())));
            expression2 = local.createGet();
        }
        expression2.substitute(expression3);
        block4.add(block2);
        if (bl) {
            local = ((BlockScope)object).declareLocal("rd.", 16L, DESCRIPTOR_TYPE, null);
            XMethod xMethod = methodScope.createAndDeclareMethod(((MethodScope)object).getMethod().getName(), Type.VOID);
            expression6.add(local.createSet().add(new GetDescriptor(xMethod, -1))).add(expression).add(new DisposeDescriptor().add(local.createGet()));
            ((NonlocalGenerator)((Object)expression)).receiveRoutine(TypeScope.get((Scope)object), local.createGet());
            expression.add(xMethod);
            methodScope.addExpression(block4);
        } else {
            expression6.add(expression);
            expression.add(block4);
        }
        if (!block3.isInitialized()) {
            ((MethodScope)object).enterBreakTarget(null);
            ((MethodScope)object).getTargetId(null, false);
            ((MethodScope)object).leave(block3);
        }
        ((Generator)((Object)expression)).setBreakTarget(block3);
        return block;
    }

    public void finish(TypeScope typeScope, AST aST) {
        int n;
        Object object;
        ObjectList objectList = typeScope.getConstructorScopes();
        ObjectList<Local> objectList2 = typeScope.getEnclosingLocals();
        for (int i = 0; i < objectList.size(); ++i) {
            MethodScope methodScope = (MethodScope)objectList.get(i);
            for (int j = 0; j < objectList2.size(); ++j) {
                object = (Local)objectList2.get(j);
                methodScope.prependExpression(new AssignField(typeScope.getFieldForEnclosingLocal((Local)object), 0).add(methodScope.createThis()).add(methodScope.getParameterForEnclosingLocal((Local)object).createGet()));
            }
        }
        ObjectList objectList3 = typeScope.getIncompleteConstructorInvocations();
        for (int i = 0; i < objectList3.size(); ++i) {
            Invoke invoke = (Invoke)objectList3.get(i);
            object = CompilerBase.getBlockScope(invoke);
            TypeScope typeScope2 = ((BlockScope)object).getTypeScope(invoke.getType());
            objectList2 = typeScope2.getEnclosingLocals();
            for (int j = 0; j < objectList2.size(); ++j) {
                invoke.add(((Local)objectList2.get(j)).createExpression((Scope)object, null));
            }
        }
        ObjectList objectList4 = typeScope.getAllContainedMethodScopes();
        for (n = 0; n < objectList4.size(); ++n) {
            object = (MethodScope)objectList4.get(n);
            if (!((MethodScope)object).isConstructor()) continue;
            ((MethodScope)object).getMethod().updateParameters();
        }
        for (n = 0; n < objectList4.size(); ++n) {
            this.compileMethod((MethodScope)objectList4.get(n));
        }
    }

    void compileMethod(MethodScope methodScope) {
        if (!this.problems.containsErrors()) {
            this.compileIterations(methodScope.getBlock(), null);
            methodScope.complete();
        }
    }

    void createModuleMethods(ClassInfo classInfo, Type[] typeArray) {
        MethodScope methodScope;
        MethodScope methodScope2;
        classInfo.predicateConstructorScope = methodScope2 = classInfo.predicateScope.createMethodScope(0x800000001L);
        classInfo.signatureScope = methodScope = classInfo.predicateScope.createMethodScope(8L);
        Local local = methodScope.declareParameter("node", 0L, (Type)classInfo.scope.getDeclaredType());
        local.getDeclaredAnnotations().push((Object)new AnnotationImpl(UserDefinedPattern.In.class), (Object)new AnnotationImpl(UserDefinedPattern.Out.class));
        classInfo.getterMethods = new MethodScope[10];
        classInfo.switches = new Switch[10];
        classInfo.objects = new Local[10];
        for (int i = 0; i < typeArray.length; ++i) {
            MethodScope methodScope3;
            Type type = typeArray[i];
            int n = type.getTypeId();
            methodScope.declareParameter("f" + i, 0L, type);
            if (classInfo.getterMethods[n] != null) continue;
            classInfo.getterMethods[n] = methodScope3 = classInfo.predicateScope.createMethodScope(4L);
            classInfo.objects[n] = methodScope3.declareParameter("o", 0L, Type.OBJECT);
            Local local2 = methodScope3.declareParameter("i", 0L, Type.INT);
            methodScope3.createAndDeclareMethod("get" + Reflection.getTypeSuffix((int)n), Reflection.getType((int)n));
            classInfo.switches[n] = new Switch();
            methodScope3.addExpression(classInfo.switches[n].add(local2.createGet()));
            methodScope3.addExpression(new Throw().add(new InvokeSpecial(ASSERTION_INIT).add(new New(ASSERTION_ERROR))));
        }
        methodScope2.createAndDeclareMethod("<init>", Type.VOID);
        methodScope.createAndDeclareMethod("signature", Type.VOID);
        this.createDefaultConstructor(classInfo, false);
    }

    void compileModuleMethods(ClassInfo classInfo, Type[] typeArray, boolean[] blArray, AST[] aSTArray) {
        int n;
        Int2IntMap[] int2IntMapArray = new Int2IntMap[10];
        classInfo.parameterGetters = new Method[typeArray.length];
        for (n = 0; n < typeArray.length; ++n) {
            Expression expression;
            Type type;
            if (classInfo.moduleFields[n] != null) {
                typeArray[n] = classInfo.moduleFields[n].getType();
                if (!blArray[n]) {
                    classInfo.moduleConstructorScope.addExpression(new AssignField(classInfo.moduleFields[n], 0).add(classInfo.moduleConstructorScope.createThis()).add(classInfo.moduleConstructorScope.getParameter(n).createGet()));
                }
            }
            if ((type = typeArray[n]) == null) continue;
            int n2 = type.getTypeId();
            if (int2IntMapArray[n2] == null) {
                int2IntMapArray[n2] = new Int2IntMap();
            }
            if (classInfo.moduleFields[n] != null) {
                expression = this.compileFieldExpression(classInfo.moduleFields[n], classInfo.objects[n2].createGet().cast((Type)classInfo.scope.getDeclaredType()), classInfo.getterMethods[n2], classInfo.node);
            } else {
                if (aSTArray[n] == null) continue;
                Method method = Reflection.findMethodWithPrefixInTypes((Type)classInfo.scope.getDeclaredType(), (String)('m' + aSTArray[n].getText() + ";()"), (boolean)true, (boolean)false);
                if (method == null) {
                    this.problems.addSemanticError(I18N.msg("compiler.no-member-in-type", (Object)I18N.msg("member.method"), (Object)aSTArray[n].getText(), (Object)classInfo.scope.getDeclaredType().getName()), aSTArray[n]);
                    continue;
                }
                if (Reflection.isStatic((Member)method)) {
                    this.problems.addSemanticError(I18N.msg("compiler.non-instance-members", (Object)I18N.msg("member.method"), (Object)Reflection.getDescription((Member)method), (Object)1), aSTArray[n]);
                    continue;
                }
                classInfo.parameterGetters[n] = method;
                expression = this.compileMethodInvocation(method, classInfo.objects[n2].createGet().cast((Type)classInfo.scope.getDeclaredType()), ArgumentTransformations.NO_IMPLICIT_ARGS, Members.Applicability.DEFAULT, Expression.EXPR_0, (Scope)classInfo.getterMethods[n2], aSTArray[n]);
                expression = this.returnConversion(expression, type, classInfo.getterMethods[n2], aSTArray[n]);
            }
            int2IntMapArray[n2].put(n, classInfo.switches[n2].getExpressionCount());
            classInfo.switches[n2].add(new Return(classInfo.getterMethods[n2], null).add(expression));
        }
        for (n = 0; n < 10; ++n) {
            if (int2IntMapArray[n] == null) continue;
            classInfo.switches[n].initialize(int2IntMapArray[n], -1);
        }
        MethodScope methodScope = classInfo.predicateConstructorScope;
        methodScope.addExpression(new SetThis().add(this.compileSuperConstructorInvocation(methodScope.createThis(), null, new Expression[]{new TypeConst((Type)classInfo.predicateScope.getDeclaredType(), true), new IntConst(typeArray.length)}, methodScope, classInfo.node)));
    }

    static String getOperatorName(int n, boolean bl) {
        String string = bl ? (String)unaryOperators.get(n) : (String)binaryOperators.get(n);
        return string;
    }

    static boolean isUnaryOperator(int n) {
        return unaryOperators.containsKey(n);
    }

    static boolean isBinaryOperator(int n) {
        return binaryOperators.containsKey(n);
    }

    public static void checkOperatorFunction(AST aST, AST aST2, AST aST3, int n, RecognitionExceptionList recognitionExceptionList) {
        int n2 = aST.getNumberOfChildren();
        boolean bl = false;
        for (AST aST4 = aST2.getFirstChild(); aST4 != null; aST4 = aST4.getNextSibling()) {
            if (aST4.getType() != 204) continue;
            bl = true;
            break;
        }
        if (!bl) {
            ++n2;
        }
        boolean bl2 = true;
        if (n2 == 1) {
            if (CompilerBase.isUnaryOperator(n)) {
                String string = CompilerBase.getOperatorName(n, true);
                aST3.setText(string);
                bl2 = false;
            }
        } else if (n2 == 2) {
            if (186 == n || 187 == n) {
                AST aST5 = aST.getFirstChild();
                if (bl) {
                    aST5 = aST5.getNextSibling();
                }
                if ((aST5 = aST5.getFirstChild().getNextSibling()).getType() != 42) {
                    recognitionExceptionList.addSemanticError(I18N, "compiler.int-expected-for-dummy", aST5);
                }
                aST3.setText(186 == n ? OPERATOR_NAME_POST_INC : OPERATOR_NAME_POST_DEC);
                bl2 = false;
            } else if (CompilerBase.isBinaryOperator(n)) {
                String string = CompilerBase.getOperatorName(n, false);
                aST3.setText(string);
                bl2 = false;
            }
        } else if (n2 > 2) {
            if (196 == n) {
                aST3.setText(OPERATOR_NAME_INDEX);
                bl2 = false;
            } else if (194 == n) {
                aST3.setText(OPERATOR_NAME_INVOKE);
                bl2 = false;
            }
        }
        if (bl2) {
            recognitionExceptionList.addSemanticError(I18N, "compiler.wrong-operand-number-for-op", aST3);
        }
    }

    static {
        extModifiers.put(0x100000000L, (Object)"iterating");
        extModifiers.put(0x200000000L, (Object)"parameter");
        extModifiers.put(0x400000000L, (Object)"routine");
        extModifiers.put(0x4000000000L, (Object)"const");
        extModifiers.put(0x8000000000L, (Object)"instantiator");
        extModifiers.put(0x10000000000L, (Object)"module");
        METHOD_ARGS = new ArgumentTransformations(new Type[][]{ArgumentTransformations.NO_IMPLICIT, ArgumentTransformations.GENERATOR, ArgumentTransformations.AGGREGATE, ArgumentTransformations.FILTER}, null);
        OK = new Expression(Type.INVALID);
        GENERATOR_TYPES = new Type[10];
        for (int i = 0; i < 10; ++i) {
            try {
                CompilerBase.GENERATOR_TYPES[i] = ClassAdapter.wrap(Class.forName("de.grogra.xl.lang.VoidTo" + Reflection.getTypeSuffix((int)i) + "Generator"));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FIELD_TYPE = ClassAdapter.wrap(Field.class);
        AGGREGATE_TYPE = ClassAdapter.wrap(Aggregate.class);
        DESCRIPTOR_TYPE = ClassAdapter.wrap(RoutineDescriptor.class);
        ANNOTATION_ARRAY_TYPE = ClassAdapter.wrap(Annotation[].class);
        FILTER_TYPE = ClassAdapter.wrap(Filter.class);
        ASSERTION_ERROR = ClassAdapter.wrap(AssertionError.class);
        VMX_TYPE = ClassAdapter.wrap(VMXState.class);
        ASSERTION_INIT = Reflection.findMethodWithPrefixInTypes((Type)ASSERTION_ERROR, (String)"m<init>;()V", (boolean)false, (boolean)true);
        INT_0 = Reflection.findFieldInClasses((Type)VMX_TYPE, (String)"INT_0");
        unaryOperators = new IntHashMap();
        binaryOperators = new IntHashMap();
        unaryOperators.put(92, (Object)OPERATOR_NAME_POS);
        unaryOperators.put(85, (Object)OPERATOR_NAME_NEG);
        unaryOperators.put(105, (Object)OPERATOR_NAME_NOT);
        unaryOperators.put(104, (Object)OPERATOR_NAME_COM);
        unaryOperators.put(186, (Object)OPERATOR_NAME_INC);
        unaryOperators.put(187, (Object)OPERATOR_NAME_DEC);
        unaryOperators.put(159, (Object)OPERATOR_NAME_QUOTE);
        unaryOperators.put(194, (Object)OPERATOR_NAME_INVOKE);
        binaryOperators.put(92, (Object)OPERATOR_NAME_ADD);
        binaryOperators.put(85, (Object)OPERATOR_NAME_SUB);
        binaryOperators.put(91, (Object)OPERATOR_NAME_MUL);
        binaryOperators.put(108, (Object)OPERATOR_NAME_DIV);
        binaryOperators.put(109, (Object)OPERATOR_NAME_REM);
        binaryOperators.put(110, (Object)OPERATOR_NAME_POW);
        binaryOperators.put(122, (Object)OPERATOR_NAME_COR);
        binaryOperators.put(123, (Object)OPERATOR_NAME_CAND);
        binaryOperators.put(160, (Object)OPERATOR_NAME_ADD_ASSIGN);
        binaryOperators.put(161, (Object)OPERATOR_NAME_SUB_ASSIGN);
        binaryOperators.put(162, (Object)OPERATOR_NAME_MUL_ASSIGN);
        binaryOperators.put(163, (Object)OPERATOR_NAME_DIV_ASSIGN);
        binaryOperators.put(164, (Object)OPERATOR_NAME_REM_ASSIGN);
        binaryOperators.put(165, (Object)OPERATOR_NAME_POW_ASSIGN);
        binaryOperators.put(111, (Object)OPERATOR_NAME_SHL);
        binaryOperators.put(112, (Object)OPERATOR_NAME_SHR);
        binaryOperators.put(113, (Object)OPERATOR_NAME_USHR);
        binaryOperators.put(168, (Object)OPERATOR_NAME_SHL_ASSIGN);
        binaryOperators.put(166, (Object)OPERATOR_NAME_SHR_ASSIGN);
        binaryOperators.put(167, (Object)OPERATOR_NAME_USHR_ASSIGN);
        binaryOperators.put(120, (Object)OPERATOR_NAME_XOR);
        binaryOperators.put(119, (Object)OPERATOR_NAME_OR);
        binaryOperators.put(121, (Object)OPERATOR_NAME_AND);
        binaryOperators.put(170, (Object)OPERATOR_NAME_XOR_ASSIGN);
        binaryOperators.put(171, (Object)OPERATOR_NAME_OR_ASSIGN);
        binaryOperators.put(169, (Object)OPERATOR_NAME_AND_ASSIGN);
        binaryOperators.put(118, (Object)OPERATOR_NAME_EQUALS);
        binaryOperators.put(117, (Object)OPERATOR_NAME_NOT_EQUALS);
        binaryOperators.put(61, (Object)OPERATOR_NAME_LT);
        binaryOperators.put(114, (Object)OPERATOR_NAME_LE);
        binaryOperators.put(62, (Object)OPERATOR_NAME_GT);
        binaryOperators.put(115, (Object)OPERATOR_NAME_GE);
        binaryOperators.put(95, (Object)OPERATOR_NAME_RANGE);
        binaryOperators.put(190, (Object)OPERATOR_NAME_IN);
        binaryOperators.put(191, (Object)OPERATOR_NAME_GUARD);
        binaryOperators.put(87, (Object)OPERATOR_NAME_ARROW);
        binaryOperators.put(86, (Object)OPERATOR_NAME_LEFT_ARROW);
        binaryOperators.put(155, (Object)OPERATOR_NAME_LONG_ARROW);
        binaryOperators.put(154, (Object)OPERATOR_NAME_LONG_LEFT_ARROW);
        binaryOperators.put(156, (Object)OPERATOR_NAME_LONG_LEFT_RIGHT_ARROW);
        binaryOperators.put(65, (Object)OPERATOR_NAME_PLUS_LEFT_ARROW);
        binaryOperators.put(66, (Object)OPERATOR_NAME_PLUS_ARROW);
        binaryOperators.put(68, (Object)OPERATOR_NAME_PLUS_LEFT_RIGHT_ARROW);
        binaryOperators.put(67, (Object)OPERATOR_NAME_PLUS_LINE);
        binaryOperators.put(69, (Object)OPERATOR_NAME_SLASH_LEFT_ARROW);
        binaryOperators.put(70, (Object)OPERATOR_NAME_SLASH_ARROW);
        binaryOperators.put(72, (Object)OPERATOR_NAME_SLASH_LEFT_RIGHT_ARROW);
        binaryOperators.put(71, (Object)OPERATOR_NAME_SLASH_LINE);
        binaryOperators.put(63, (Object)OPERATOR_NAME_LINE);
        binaryOperators.put(64, (Object)OPERATOR_NAME_LEFT_RIGHT_ARROW);
        binaryOperators.put(88, (Object)OPERATOR_NAME_X_LEFT_RIGHT_ARROW);
        binaryOperators.put(196, (Object)OPERATOR_NAME_INDEX);
        binaryOperators.put(194, (Object)OPERATOR_NAME_INVOKE);
        binaryOperators.put(172, (Object)OPERATOR_NAME_DEFERRED_ASSIGN);
        binaryOperators.put(173, (Object)OPERATOR_NAME_DEFERRED_RATE_ASSIGN);
        binaryOperators.put(179, (Object)OPERATOR_NAME_DEFERRED_POW);
        binaryOperators.put(176, (Object)OPERATOR_NAME_DEFERRED_MUL);
        binaryOperators.put(177, (Object)OPERATOR_NAME_DEFERRED_DIV);
        binaryOperators.put(178, (Object)OPERATOR_NAME_DEFERRED_REM);
        binaryOperators.put(174, (Object)OPERATOR_NAME_DEFERRED_ADD);
        binaryOperators.put(175, (Object)OPERATOR_NAME_DEFERRED_SUB);
        binaryOperators.put(183, (Object)OPERATOR_NAME_DEFERRED_SHL);
        binaryOperators.put(184, (Object)OPERATOR_NAME_DEFERRED_SHR);
        binaryOperators.put(185, (Object)OPERATOR_NAME_DEFERRED_USHR);
        binaryOperators.put(181, (Object)OPERATOR_NAME_DEFERRED_AND);
        binaryOperators.put(182, (Object)OPERATOR_NAME_DEFERRED_XOR);
        binaryOperators.put(180, (Object)OPERATOR_NAME_DEFERRED_OR);
    }

    private static final class MEPImplicit
    extends ArgumentTransformations {
        private static final Type[] THIS_PATH_ARGS = new Type[0];
        private static final Type[] THIS_GPATH_ARGS = new Type[]{null};
        private static final Type[] THIS_PATH_DIR_ARGS = new Type[]{Type.BOOLEAN};
        private static final Type[] THIS_GPATH_DIR_ARGS = new Type[]{null, Type.BOOLEAN};
        private static final Type[] THIS_PATH_T_ARGS = new Type[]{Type.CLASS};
        private static final Type[] THIS_GPATH_T_ARGS = new Type[]{null, Type.CLASS};
        private static final Type[] THIS_PATH_DIR_T_ARGS = new Type[]{Type.BOOLEAN, Type.CLASS};
        private static final Type[] THIS_GPATH_DIR_T_ARGS = new Type[]{null, Type.BOOLEAN, Type.CLASS};
        private static final Type[] PATH_ARGS = new Type[]{null};
        private static final Type[] GPATH_ARGS = new Type[]{null, null};
        private static final Type[] PATH_DIR_ARGS = new Type[]{null, Type.BOOLEAN};
        private static final Type[] GPATH_DIR_ARGS = new Type[]{null, null, Type.BOOLEAN};
        private static final Type[] PATH_T_ARGS = new Type[]{null, Type.CLASS};
        private static final Type[] GPATH_T_ARGS = new Type[]{null, null, Type.CLASS};
        private static final Type[] PATH_DIR_T_ARGS = new Type[]{null, Type.BOOLEAN, Type.CLASS};
        private static final Type[] GPATH_DIR_T_ARGS = new Type[]{null, null, Type.BOOLEAN, Type.CLASS};
        private static final Type[] THIS_REL_ARGS = new Type[]{null};
        private static final Type[] THIS_REL_DIR_ARGS = new Type[]{null, Type.BOOLEAN};
        private static final Type[] REL_ARGS = new Type[]{null, null};
        private static final Type[] REL_DIR_ARGS = new Type[]{null, null, Type.BOOLEAN};
        private static final Type[][] THIS_PATH = new Type[][]{THIS_PATH_ARGS, THIS_GPATH_ARGS, THIS_PATH_DIR_ARGS, THIS_GPATH_DIR_ARGS, THIS_PATH_T_ARGS, THIS_GPATH_T_ARGS, THIS_PATH_DIR_T_ARGS, THIS_GPATH_DIR_T_ARGS};
        private static final Type[][] PATH = new Type[][]{PATH_ARGS, GPATH_ARGS, PATH_DIR_ARGS, GPATH_DIR_ARGS, PATH_T_ARGS, GPATH_T_ARGS, PATH_DIR_T_ARGS, GPATH_DIR_T_ARGS};
        private static final Type[][] THIS_REL = new Type[][]{THIS_REL_ARGS, THIS_REL_DIR_ARGS};
        private static final Type[][] REL = new Type[][]{REL_ARGS, REL_DIR_ARGS};
        boolean undirected;
        boolean useThis;
        boolean relation;
        boolean path;

        MEPImplicit() {
            super(null, null);
        }

        boolean isGenerator(int n) {
            return !this.relation && (n & 1) != 0;
        }

        int getApplicableOption(Signature signature, Members.Applicability applicability, Expression[] expressionArray, Scope scope) {
            switch (XMethod.getGeneratorOrReturnType((Method)signature).getTypeId()) {
                case 1: {
                    return -1;
                }
                case 2: {
                    this.types = this.useThis ? THIS_REL : REL;
                    this.relation = true;
                    this.path = false;
                    break;
                }
                default: {
                    this.types = this.useThis ? THIS_PATH : PATH;
                    this.relation = false;
                    this.path = true;
                }
            }
            return super.getApplicableOption(signature, applicability, expressionArray, scope);
        }

        Expression createImplicitArgument(int n, int n2, Type type, Scope scope, AST aST) {
            if (this.types[n][n2] == Type.BOOLEAN) {
                return new BooleanConst(this.undirected);
            }
            if (this.types[n][n2] == Type.CLASS) {
                return PatternBuilder.createTargetTypeArgument();
            }
            if (n2 == 0 && this.isGenerator(n)) {
                return null;
            }
            return PatternBuilder.createArgument(type);
        }
    }

    private static final class EPImplicit
    extends ArgumentTransformations {
        private static final Type[] EDGE_PRED_ARGS = new Type[2];
        private static final Type[] EDGE_PRED_DIR_ARGS = new Type[]{null, null, Type.BOOLEAN};
        private final boolean undirected;
        boolean object;

        EPImplicit(boolean bl) {
            Type[][] typeArrayArray;
            if (bl) {
                Type[][] typeArrayArray2 = new Type[2][];
                typeArrayArray2[0] = FIRST_TERM;
                typeArrayArray = typeArrayArray2;
                typeArrayArray2[1] = EDGE_PRED_DIR_ARGS;
            } else {
                Type[][] typeArrayArray3 = new Type[3][];
                typeArrayArray3[0] = FIRST_TERM;
                typeArrayArray3[1] = EDGE_PRED_ARGS;
                typeArrayArray = typeArrayArray3;
                typeArrayArray3[2] = EDGE_PRED_DIR_ARGS;
            }
            super(typeArrayArray);
            this.undirected = bl;
        }

        int getApplicableOption(Signature signature, Members.Applicability applicability, Expression[] expressionArray, Scope scope) {
            PatternWrapper patternWrapper = (PatternWrapper)signature;
            int n = patternWrapper.getInParameter();
            int n2 = patternWrapper.getOutParameter();
            if (n < 0 || n2 < 0) {
                return -1;
            }
            boolean bl = this.object = n == n2;
            if (this.object && !patternWrapper.isFirstInOut()) {
                return -1;
            }
            for (int i = 0; i < this.indices.length; ++i) {
                int[] nArray = this.indices[i];
                nArray[0] = n;
                if (nArray.length < 2) continue;
                nArray[1] = n2;
                if (nArray.length != 3) continue;
                nArray[2] = n2 + 1;
            }
            return super.getApplicableOption(signature, applicability, expressionArray, scope);
        }

        boolean isApplicable(Signature signature, Members.Applicability applicability, int n, Expression[] expressionArray, Scope scope) {
            return (!this.object || n == 0) && super.isApplicable(signature, applicability, n, expressionArray, scope);
        }

        Expression createImplicitArgument(int n, int n2, Type type, Scope scope, AST aST) {
            return n2 == 2 ? new BooleanConst(this.undirected) : null;
        }
    }

    private static class ConstructorImplicit
    extends ArgumentTransformations {
        private Expression enclosing;

        ConstructorImplicit() {
            super(new Type[1][1], null);
        }

        void setEnclosing(Expression expression) {
            this.types[0][0] = expression.getType();
            this.enclosing = expression;
        }

        Expression createImplicitArgument(int n, int n2, Type type, Scope scope, AST aST) {
            return this.enclosing;
        }

        boolean matchesImplicit(Type type, int n, int n2, Type type2) {
            return Reflection.isSuperclassOrSame((Type)type, (Type)type2);
        }
    }

    static final class ProduceImplicit
    extends ArgumentTransformations {
        private static final Type EDGE_DIR = ClassAdapter.wrap(EdgeDirection.class);
        boolean nodeUsed;
        private AST edge;
        private Expression node;
        private ExpressionFactory implExpr;
        private Type[][] origTypes;
        private static final Type[][][] typesArray = new Type[][][]{{Type.TYPE_0, {Type.INVALID}, AGGREGATE, {AGGREGATE_TYPE, Type.INVALID}}, {Type.TYPE_0, {Type.INVALID}, {EDGE_DIR}, {EDGE_DIR, Type.INVALID}, {null}, {null, Type.INVALID}, {null, EDGE_DIR}, {null, EDGE_DIR, Type.INVALID}}};

        ProduceImplicit() {
            super(null, null);
        }

        void setType(AST aST, Expression expression, ExpressionFactory expressionFactory) {
            this.origTypes = typesArray[aST != null ? 1 : 0];
            this.types = (Type[][])this.origTypes.clone();
            this.implExpr = expressionFactory;
            this.edge = aST;
            this.node = expression;
            this.nodeUsed = false;
            for (int i = this.types.length - 1; i >= 0; --i) {
                Type[] typeArray = (Type[])this.types[i].clone();
                this.types[i] = typeArray;
                for (int j = 0; j < typeArray.length; ++j) {
                    Type type = typeArray[j];
                    if (type == null) {
                        typeArray[j] = expression.getType();
                        continue;
                    }
                    if (type == AGGREGATE_TYPE || type == EDGE_DIR) continue;
                    typeArray[j] = expressionFactory.getType();
                }
            }
        }

        boolean matchesImplicit(Type type, int n, int n2, Type type2) {
            return Reflection.isSupertypeOrSame((Type)type, (Type)type2);
        }

        Expression createImplicitArgument(int n, int n2, Type type, Scope scope, AST aST) {
            Type type2 = this.origTypes[n][n2];
            if (type2 == EDGE_DIR) {
                return new GetField(Reflection.getDeclaredField((Type)EDGE_DIR, (String)CompilerBase.edgeDirection(this.edge).toString()));
            }
            if (type2 == null) {
                this.nodeUsed = true;
                return this.node;
            }
            if (type2 == AGGREGATE_TYPE) {
                return super.createImplicitArgument(n, n2, type, scope, aST);
            }
            return this.implExpr.createExpression(scope, aST);
        }
    }

    static final class ClassInfo {
        AST node;
        TypeScope scope;
        MethodScope defaultConstructorScope;
        MethodScope moduleConstructorScope;
        MethodScope instMethodScope;
        Local instState;
        MethodScope instIfaceMethodScope;
        Local instIfaceState;
        TypeScope predicateScope;
        MethodScope predicateConstructorScope;
        MethodScope signatureScope;
        Field[] moduleFields;
        Method[] parameterGetters;
        MethodScope[] getterMethods;
        Switch[] switches;
        Local[] objects;

        ClassInfo() {
        }
    }

    static class ExprInfo {
        AST ast;
        BlockScope scope;

        ExprInfo() {
        }

        ExprInfo dup() {
            ExprInfo exprInfo = new ExprInfo();
            exprInfo.ast = this.ast;
            exprInfo.scope = this.scope;
            return exprInfo;
        }
    }
}

