/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.pattern;

import antlr.collections.AST;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.pattern.Argument;
import de.grogra.xl.compiler.pattern.CompositeData;
import de.grogra.xl.compiler.pattern.PatternBuilder;
import de.grogra.xl.compiler.pattern.PatternData;
import de.grogra.xl.compiler.pattern.Place;
import de.grogra.xl.expr.Block;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.query.Pattern;
import de.grogra.xl.query.TransitiveTraversal;
import de.grogra.xl.util.ObjectList;
import java.util.Arrays;

public final class TraversalData
extends PatternData {
    Place[] places;
    final CompositeData child;
    final Expression min;
    final Expression max;
    private final Place inPlace;
    private final Place outPlace;
    private final boolean addFolding;
    private TransitiveTraversal predicate;
    private short[] mapping;
    private Place minPlace;
    private Place maxPlace;
    private final String identifier;

    TraversalData(CompositeData compositeData, int n, int n2, Expression expression, Expression expression2, AST aST, int n3, int n4, PatternBuilder patternBuilder, boolean bl) {
        super(null, n, n2, aST, n3, n4, patternBuilder);
        this.inPlace = patternBuilder.createPlace(null);
        this.outPlace = patternBuilder.createPlace(null);
        this.child = compositeData;
        this.min = expression;
        this.max = expression2;
        this.identifier = patternBuilder.getScope().nextUniqueId();
        this.addFolding = bl;
    }

    boolean hasInPlace() {
        return this.inPlace != null;
    }

    boolean hasOutPlace() {
        return this.outPlace != null;
    }

    Place getInPlace(boolean bl) {
        return this.inPlace != null ? this.inPlace.resolve() : null;
    }

    Place getOutPlace(boolean bl) {
        return this.outPlace != null ? this.outPlace.resolve() : null;
    }

    Type getLastNodeType() {
        return this.builder.nodeType;
    }

    int getLabelArgument() {
        return -1;
    }

    Place[] getPlaces() {
        return this.places;
    }

    public Pattern getPattern() {
        return this.predicate;
    }

    public String toString() {
        return "Traversal " + this.dataId + " [" + Arrays.toString(this.mapping) + ',' + this.child + ']';
    }

    Block getSubRoutines() {
        return this.child.getSubRoutines();
    }

    void complete(ObjectList objectList) {
        Argument argument;
        int n;
        objectList.add(0, (Object)this.child.getInPlace(false).getNodeArgument());
        objectList.add(1, (Object)this.child.getOutPlace(false).getNodeArgument());
        int n2 = objectList.size();
        this.mapping = new short[n2];
        for (n = 0; n < n2; ++n) {
            this.mapping[n] = -1;
        }
        this.places = new Place[n2 + 2];
        for (n = 0; n < n2; ++n) {
            argument = (Argument)objectList.get(n);
            int n3 = this.child.getPlaces().length;
            for (int n4 = 0; n4 < n3; n4 = (int)((short)(n4 + 1))) {
                if (argument != this.child.getArgument(n4)) continue;
                assert (this.mapping[n] == -1);
                this.mapping[n] = n4;
            }
            assert (this.mapping[n] >= 0);
            if (n < 2) continue;
            argument.place.map(this, n, null).initParam(argument);
        }
        this.minPlace.map(this, n2, null).initParam(this.minPlace.getArgument(7));
        this.maxPlace.map(this, n2 + 1, null).initParam(this.maxPlace.getArgument(7));
        this.predicate = new TransitiveTraversal(this.identifier, this.child.getPattern(), this.mapping);
        Place.Mapping mapping = this.getInPlace(false).map(this, 0, null);
        argument = this.getInPlace(false).getNodeArgument();
        if (argument != null) {
            mapping.initParam(argument);
        } else {
            this.getInPlace(false).mapToArguments();
        }
        mapping = this.getOutPlace(false).map(this, 1, null);
        argument = this.getOutPlace(false).getNodeArgument();
        if (argument != null) {
            mapping.initParam(argument);
        } else {
            this.getOutPlace(false).mapToArguments();
        }
        if (this.addFolding) {
            this.getOutPlace((boolean)false).placeFoldings.add((Object)this.getInPlace(false));
        }
    }

    String getIdentifier() {
        return this.identifier;
    }

    void createSubPatterns() {
        if (this.minPlace == null) {
            this.minPlace = this.addExpression(this.min, Type.LONG).getPlaces()[0];
        }
        if (this.max == null) {
            this.maxPlace = this.minPlace;
        } else if (this.maxPlace == null) {
            this.maxPlace = this.addExpression(this.max, Type.LONG).getPlaces()[0];
        }
    }

    void mapLabeledArgs() {
        this.minPlace = this.builder.getPlace(this.min);
        this.maxPlace = this.builder.getPlace(this.max);
    }

    void mapUnlabeledArgs() {
    }
}

