/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import antlr.collections.AST;
import de.grogra.reflect.Member;
import de.grogra.reflect.Type;
import de.grogra.reflect.XClass;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.compiler.scope.ProduceScope;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.expr.Block;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.util.ObjectList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockScope
extends Scope {
    private final HashMap<String, Local> locals = new HashMap(20);
    private Expression block;
    private boolean newScopeForQueries;
    private BlockScope scopeForLocals;
    private final ObjectList localClassScopes = new ObjectList();
    private final ProduceScope produceScope;

    public BlockScope(Scope scope) {
        this(scope, new Block());
    }

    public BlockScope(Scope scope, boolean bl) {
        this(scope, bl ? Block.createSequentialBlock() : new Block());
    }

    public BlockScope(Scope scope, Expression expression) {
        super(scope);
        this.setBlock(expression);
        this.produceScope = ProduceScope.get(this);
    }

    public ProduceScope getProduceScope() {
        return this.produceScope;
    }

    public void setUseNewScopeForQueries(boolean bl) {
        this.newScopeForQueries = bl;
    }

    public boolean useNewScopeForQueries() {
        return this.newScopeForQueries;
    }

    public void setScopeForLocals(BlockScope blockScope) {
        this.scopeForLocals = blockScope;
    }

    @Override
    public void findMembers(String string, int n, Members members) {
        Local local;
        if ((n & 1) != 0 && (local = this.locals.get(string)) != null) {
            members.add((Member)local, this, n);
            n &= 0xFFFFFFFE;
        }
        if ((n & 0x20) != 0) {
            for (int i = this.localClassScopes.size() - 1; i >= 0; --i) {
                if (!string.equals(((TypeScope)this.localClassScopes.get(i)).getDeclaredType().getSimpleName())) continue;
                members.add((Member)((TypeScope)this.localClassScopes.get(i)).getDeclaredType(), this, n);
                n &= 0xFFFFFFDB;
                break;
            }
        }
        if ((n & 0x7F) != 0) {
            super.findMembers(string, n, members);
        }
    }

    public Local findLocal(String string, boolean bl) {
        BlockScope blockScope = this;
        Local local;
        while ((local = blockScope.locals.get(string)) == null) {
            Scope scope = blockScope.getEnclosingScope();
            while (!(scope instanceof BlockScope)) {
                if (!bl) {
                    return null;
                }
                if ((scope = scope.getEnclosingScope()) != null) continue;
                return null;
            }
            blockScope = (BlockScope)scope;
        }
        return local;
    }

    public XClass findClass(String string) {
        BlockScope blockScope = this;
        while (true) {
            for (int i = blockScope.localClassScopes.size() - 1; i >= 0; --i) {
                TypeScope typeScope = (TypeScope)this.localClassScopes.get(i);
                if (!string.equals(typeScope.getDeclaredType().getSimpleName())) continue;
                return typeScope.getDeclaredType();
            }
            Scope scope = blockScope.getEnclosingScope();
            if (!(scope instanceof BlockScope)) {
                return null;
            }
            blockScope = (BlockScope)scope;
        }
    }

    public TypeScope getTypeScope(Type type) {
        BlockScope blockScope = this;
        while (true) {
            for (int i = blockScope.localClassScopes.size() - 1; i >= 0; --i) {
                TypeScope typeScope = (TypeScope)blockScope.localClassScopes.get(i);
                if (!typeScope.getDeclaredType().getBinaryName().equals(type.getBinaryName())) continue;
                return typeScope;
            }
            Scope scope = blockScope.getEnclosingScope();
            while (!(scope instanceof BlockScope)) {
                scope = scope.getEnclosingScope();
            }
            blockScope = (BlockScope)scope;
        }
    }

    public void declareLocalClass(TypeScope typeScope) {
        typeScope.getClass();
        this.localClassScopes.add((Object)typeScope);
    }

    public int getDeclaredClassCount() {
        return this.localClassScopes.size();
    }

    public void setDeclaredClassCount(int n) {
        if (n > this.localClassScopes.size()) {
            throw new IllegalArgumentException();
        }
        this.localClassScopes.setSize(n);
    }

    public void addExpression(Expression expression) {
        this.block.add(expression);
    }

    public void prependExpression(Expression expression) {
        this.block.insertBranchNode(0, expression);
    }

    public Expression getBlock() {
        return this.block;
    }

    public Expression setBlock(Expression expression) {
        if (expression != null) {
            if (this.block != null) {
                expression.appendBranchNode(this.block.getFirstExpression());
                this.block.removeAll(null);
            }
            this.block = expression;
            Compiler.setBlockScope(expression, this);
        }
        return expression;
    }

    public String nextUniqueId() {
        MethodScope methodScope = MethodScope.get(this);
        return methodScope.getMethod().getRoutineId() + '@' + methodScope.nextUniqueInt();
    }

    public final String getUniqueName(String string) {
        return string.charAt(string.length() - 1) == '.' ? string + this.getMethodScope().nextUniqueInt() : string + '.' + this.getMethodScope().nextUniqueInt();
    }

    public final Local declareLocal(String string, long l, Type type, AST aST) {
        if (this.scopeForLocals != null) {
            return this.scopeForLocals.declareLocal(string, l, type, aST);
        }
        if (string.charAt(string.length() - 1) == '.') {
            string = this.getUniqueName(string);
            l |= 0x1000L;
        }
        Local local = new Local(string, l, type, this, aST);
        this.locals.put(string, local);
        return local;
    }

    void printLocals() {
        System.out.println(this.locals.values());
    }

    public MethodScope getMethodScope() {
        return MethodScope.get(this);
    }

    public Expression createThis() {
        return this.getMethodScope().createThis();
    }

    public void receiveLocals(BlockScope blockScope, AST aST) {
        if (blockScope == this) {
            return;
        }
        Iterator<Map.Entry<String, Local>> iterator = blockScope.locals.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Local> entry = iterator.next();
            Local local = entry.getValue();
            if (aST != null && !local.isDeclaredBehind(aST)) continue;
            iterator.remove();
            local.scope = this;
            assert (!this.locals.containsKey(local.getSimpleName()));
            this.locals.put(local.getSimpleName(), local);
        }
    }

    public Collection<Local> getLocals() {
        return this.locals.values();
    }

    void dispose() {
        this.locals.clear();
        this.block.removeAll(null);
        this.block = null;
        this.scopeForLocals = null;
        this.localClassScopes.clear();
        this.insert(null);
    }
}

