/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import antlr.collections.AST;
import de.grogra.reflect.Annotation;
import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.MemberBase;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.pattern.PatternBuilder;
import de.grogra.xl.compiler.scope.BlockScope;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.expr.AssignLocal;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.ExpressionFactory;
import de.grogra.xl.expr.GetLocal;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.util.ObjectList;
import de.grogra.xl.vmx.VMXState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Local
extends MemberBase
implements ExpressionFactory {
    public int index = -1;
    public Local wrapper;
    public Local wrapped;
    BlockScope scope;
    private long modifiersHi;
    MethodScope methodScope;
    Expression firstAccess;
    Expression lastAccess;
    Expression accessRoot;
    int nesting = -1;
    Local ref;
    Type type;
    private Object constantValue;
    private PatternBuilder predBuilder;
    private final AST pos;
    public static final Local DUMMY = new Local("dummy", 0L, null, null, null);

    Local(String string, long l, Type type, BlockScope blockScope, AST aST) {
        super(string, null, (int)l | 1, null);
        this.pos = aST;
        this.modifiersHi = l;
        this.type = type;
        this.scope = blockScope;
        this.methodScope = null;
        if (blockScope != null) {
            blockScope.getMethodScope().receiveLocal(this);
        }
    }

    public final AssignLocal createSet() {
        return new AssignLocal(this, 0);
    }

    public final Expression createSet(Scope scope, AST aST) {
        Expression expression = this.createExpression(scope, aST);
        if (!(expression instanceof GetLocal)) {
            scope.getCompiler().problems.addSemanticError(Compiler.I18N.msg("compiler.assignment-to-final", (Object)this.getName()), aST);
            return expression;
        }
        return this.createSet();
    }

    public final GetLocal createGet() {
        GetLocal getLocal = new GetLocal(this);
        if ((this.modifiers & 0x10) != 0) {
            getLocal.lval |= 1L;
        }
        return getLocal;
    }

    @Override
    public final Expression createExpression(Scope scope, AST aST) {
        if ((this.modifiers & 0x40000) != 0) {
            return Expression.createConst(this.type, this.constantValue);
        }
        if (this.methodScope == MethodScope.get(scope)) {
            return this.createGet();
        }
        if (!Reflection.isFinal((Member)this)) {
            scope.getCompiler().problems.addSemanticError(Compiler.I18N.msg("compiler.nonfinal-local", (Object)this.getName()), aST);
            return new Expression(this.getType());
        }
        Field field = TypeScope.get(scope).getFieldForEnclosingLocal(this);
        Local local = MethodScope.get(scope).getParameterForEnclosingLocal(this);
        return local != null ? local.createGet() : scope.getCompiler().compileFieldExpression(field, scope.getCompiler().compileInstance((Member)field, null, scope, aST), scope, aST);
    }

    public void setConstant(Object object) {
        this.constantValue = object;
        this.modifiers |= 0x40000;
    }

    public final VMXState.Local createVMXLocal() {
        return new VMXState.Local(this.nesting, Math.max(this.nesting > 0 ? this.ref.index : this.index, 0));
    }

    final void setFinal() {
        this.modifiers |= 0x10;
    }

    public long getModifiersEx() {
        return (long)this.modifiers | this.modifiersHi & 0xFFFFFFFF00000000L;
    }

    public void setVariable(PatternBuilder patternBuilder) {
        this.predBuilder = patternBuilder;
    }

    public PatternBuilder getPatternBuilder() {
        return this.predBuilder;
    }

    public final MethodScope getMethodScope() {
        return this.methodScope;
    }

    public final BlockScope getScope() {
        return this.scope;
    }

    public final boolean isAccessed(Expression expression, int n) {
        if (!(expression instanceof LocalAccess)) {
            return false;
        }
        LocalAccess localAccess = (LocalAccess)((Object)expression);
        for (int i = localAccess.getLocalCount() - 1; i >= 0; --i) {
            if (this != localAccess.getLocal(i) || (localAccess.getAccessType(i) & n) == 0) continue;
            return true;
        }
        return false;
    }

    public final int getAccessesInTree(Expression expression) {
        int n = 0;
        if (expression instanceof LocalAccess) {
            LocalAccess localAccess = (LocalAccess)((Object)expression);
            for (int i = localAccess.getLocalCount() - 1; i >= 0; --i) {
                if (this != localAccess.getLocal(i)) continue;
                n |= localAccess.getAccessType(i);
            }
        }
        for (expression = expression.getFirstExpression(); expression != null; expression = expression.getNextExpression()) {
            n |= this.getAccessesInTree(expression);
        }
        return n;
    }

    final void unsetParameter() {
        this.modifiersHi &= 0xFFFFFFFDFFFFFFFFL;
        this.index = -1;
    }

    public final boolean isParameter() {
        return (this.modifiersHi & 0x200000000L) != 0L;
    }

    public final boolean isJavaLocal() {
        return this.nesting == -1;
    }

    public final boolean isVariable(PatternBuilder patternBuilder) {
        return this.predBuilder != null && this.predBuilder.enclosesOrEquals(patternBuilder);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public String toString() {
        return Compiler.modifiersToString(this.getModifiersEx()) + ' ' + this.type + ' ' + this.getName() + ' ' + this.createVMXLocal();
    }

    public AST getAST() {
        return this.pos;
    }

    private static boolean isDescendantOrSelf(AST aST, AST aST2) {
        if (aST == aST2) {
            return true;
        }
        for (aST2 = aST2.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (!Local.isDescendantOrSelf(aST, aST2)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeclaredBehind(AST aST) {
        if (this.pos == null) {
            return false;
        }
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (!Local.isDescendantOrSelf(this.pos, aST2)) continue;
            return true;
        }
        while ((aST = aST.getNextSibling()) != null) {
            if (!Local.isDescendantOrSelf(this.pos, aST)) continue;
            return true;
        }
        return false;
    }

    public ObjectList<Annotation> getDeclaredAnnotations() {
        if (this.annots == null) {
            this.annots = new ObjectList();
        }
        return this.annots;
    }

    public void setAnnotations(ObjectList<Annotation> objectList) {
        this.annots = objectList;
    }
}

