/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import antlr.collections.AST;
import de.grogra.grammar.RecognitionException;
import de.grogra.grammar.SemanticException;
import de.grogra.reflect.Field;
import de.grogra.reflect.Member;
import de.grogra.reflect.Method;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.I18NBundle;
import de.grogra.xl.compiler.Compiler;
import de.grogra.xl.compiler.ShiftedMethod;
import de.grogra.xl.compiler.pattern.PatternWrapper;
import de.grogra.xl.compiler.scope.ClassPath;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.Package;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.TypeScope;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.ObjectList;

public final class Members {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    public static final int PREDICATE = 4;
    public static final int METHOD = 8;
    public static final int CONSTRUCTOR = 16;
    public static final int TYPE = 32;
    public static final int SUB_PACKAGE = 64;
    public static final int MAX_MEMBER = 64;
    public static final int MEMBER_MASK = 127;
    public static final int EXCLUDE_INTERFACES = 128;
    public static final int EXCLUDE_TYPES_IN_PACKAGES = 256;
    public static final int STATIC_ONLY = 512;
    public static final int INSTANCE_ONLY = 1024;
    public static final int DECLARED_ONLY = 2048;
    public static final int TOP_LEVEL_PACKAGE = 4096;
    public static final int SUPER = 8192;
    public static final int FULLY_QUALIFIED = 16384;
    public static final int EXCLUDE_INSTANCE_SCOPES = 32768;
    public static final int INCLUDE_FIRST_INSTANCE_SCOPE = 65536;
    public static final int OPERATOR_METHODS = 131072;
    public static final int SHIFT_METHODS = 262144;
    public static final int DIFFERENT_PACKAGE = 524288;
    public static final int MIN_UNUSED = 0x100000;
    public static final int VARIABLE = 3;
    private static final int NOT_STATIC = 1;
    private static final int NOT_INSTANCE = 2;
    private static final int SHADOWED = 4;
    private static final int INACCESSIBLE = 8;
    private static final int HIDDEN = 16;
    private static final int NOT_APPLICABLE = 32;
    private static final int NOT_IN_SCOPE = 64;
    private static final int HAS_QUALIFIER = 128;
    private static final int REMOVED = 256;
    private static final int MATCH_SET_BIT = 9;
    private static final int INFO_BITS = -128;
    private static final I18NBundle I18N = Compiler.I18N;
    private final ObjectList<Member> list = new ObjectList();
    private final ObjectList<Applicability> applicabilities = new ObjectList();
    private final ObjectList<Scope> scopes = new ObjectList();
    private final IntList bits = new IntList();
    private Package contextPackage = null;
    private Type contextType = null;
    private Scope contextScope = null;
    private int flags = 0;
    private Type qualifier = null;
    private AST pos = null;
    private String name = null;
    private int matchSet;
    private final Compiler compiler;
    private boolean haveApplicable;

    public Members(Compiler compiler) {
        this.compiler = compiler;
    }

    public void resetName(String string, AST aST) {
        this.list.clear();
        this.scopes.clear();
        this.bits.clear();
        this.applicabilities.clear();
        this.contextPackage = null;
        this.contextType = null;
        this.contextScope = null;
        this.qualifier = null;
        this.name = string;
        this.pos = aST;
        this.matchSet = 0;
    }

    public void resetName(AST aST) {
        this.resetName(aST.getText(), aST);
    }

    public void reset() {
        this.resetName(null, null);
    }

    public void addMatches(Scope scope, int n) {
        this.addMatches(scope, null, n);
    }

    public void addMatches(Scope scope, Type type, int n) {
        this.contextPackage = scope.getPackage();
        if (this.contextPackage == null) {
            this.contextPackage = this.compiler.getPackage();
        }
        if ((n & 0x4000) != 0) {
            scope = ClassPath.get(scope).getPackage("", true);
        }
        this.contextScope = scope;
        this.contextType = scope.getDeclaredType();
        this.flags = n;
        this.qualifier = type;
        if (type != null) {
            TypeScope.findMembers(type, null, this.name, n, this, null);
        } else {
            this.contextScope.findMembers(this.name, n, this);
        }
        ++this.matchSet;
    }

    public AST getPosition() {
        return this.pos;
    }

    private void remove(int n) {
        this.list.remove(n);
        this.scopes.remove(n);
        this.bits.removeAt(n);
        if (n < this.applicabilities.size) {
            this.applicabilities.remove(n);
        }
    }

    public void add(Member member, Scope scope, int n) {
        Member member2;
        Member member3;
        int n2;
        int n3;
        assert (this.qualifier == null != (scope == null));
        if (member == null) {
            return;
        }
        int n4 = member.getModifiers();
        if ((n4 & 1) != 0) {
            n3 = 0;
        } else if ((n4 & 2) != 0) {
            n3 = this.contextType != null && Reflection.equal((Type)Reflection.getTopLevelType((Type)this.contextType), (Type)Reflection.getTopLevelType((Type)member.getDeclaringType())) ? 0 : 72;
        } else if ((n & 0x80000) == 0) {
            n3 = 0;
        } else if (this.contextType != null && (n4 & 4) != 0) {
            if (member.getDeclaringType().getPackage().equals(this.getPackage())) {
                n3 = 0;
            } else {
                Type type;
                Type type2 = type = this.qualifier != null ? this.qualifier : scope.getOwnerOf(member);
                assert (type != null || member instanceof Type) : member;
                n2 = (n4 & 8) == 0 && (member instanceof Field || member instanceof Method) ? 1 : 0;
                member3 = member.getDeclaringType();
                n3 = 72;
                for (member2 = this.contextType; member2 != null; member2 = member2.getDeclaringType()) {
                    if (!Reflection.isSuperclassOrSame((Type)member3, (Type)member2)) continue;
                    n3 &= 0xFFFFFFBF;
                    if (n2 != 0 && !Reflection.isSuperclassOrSame((Type)member2, (Type)type)) continue;
                    n3 = 0;
                    break;
                }
            }
        } else {
            n3 = 72;
        }
        if (this.qualifier != null) {
            n3 |= 0x80;
        }
        int n5 = Members.getMemberType(member);
        for (n2 = this.list.size() - 1; n2 >= 0; --n2) {
            member3 = member;
            member2 = (Member)this.list.get(n2);
            if (member3 instanceof ShiftedMethod && member2 instanceof ShiftedMethod) {
                member3 = ((ShiftedMethod)member).getMethod();
                member2 = ((ShiftedMethod)member2).getMethod();
            }
            Scope scope2 = (Scope)this.scopes.get(n2);
            if (Reflection.membersEqual((Member)member2, (Member)member3, (boolean)false) && (scope == scope2 || Reflection.isStatic((Member)member3))) {
                return;
            }
            if (((n3 ^ this.bits.elements[n2]) & 0x80) != 0) continue;
            if (Reflection.membersEqual((Member)member3, (Member)member2, (n5 == 8 && (n4 & 8) == 0 ? 1 : 0) != 0)) {
                if (scope != scope2) {
                    assert (scope2 != null && scope != null);
                    if (scope.isShadowedBy(scope2)) {
                        return;
                    }
                    if (!scope2.isShadowedBy(scope)) continue;
                    this.remove(n2);
                    continue;
                }
                Type type = member3.getDeclaringType();
                Type type3 = member2.getDeclaringType();
                if (type != null && type3 != null) {
                    if (Reflection.isSupertypeOrSame((Type)type, (Type)type3)) {
                        return;
                    }
                    if (Reflection.isSupertype((Type)type3, (Type)type)) {
                        this.remove(n2);
                        continue;
                    }
                }
            }
            if (n5 != Members.getMemberType(member2) && (n5 != 2 || !(member2 instanceof Local)) && (n5 != 1 || !(member2 instanceof Field))) continue;
            if (n5 != 8) {
                if ((this.bits.elements[n2] & 0x40) == 0 && Reflection.isSupertype((Type)member3.getDeclaringType(), (Type)member2.getDeclaringType())) {
                    n3 |= 0x10;
                } else if ((n3 & 0x40) == 0 && Reflection.isSupertype((Type)member2.getDeclaringType(), (Type)member3.getDeclaringType())) {
                    int n6 = n2;
                    this.bits.elements[n6] = this.bits.elements[n6] | 0x10;
                }
            }
            if (this.qualifier != null) continue;
            if ((this.bits.elements[n2] & 0x40) == 0 && scope.isShadowedBy(scope2)) {
                n3 |= 4;
                continue;
            }
            if ((n3 & 0x40) != 0 || !scope2.isShadowedBy(scope)) continue;
            int n7 = n2;
            this.bits.elements[n7] = this.bits.elements[n7] | 4;
        }
        if ((n & 0x200) != 0 && (n4 & 8) == 0) {
            n3 |= 1;
        }
        if ((n & 0x400) != 0 && (n4 & 8) != 0) {
            n3 |= 2;
        }
        this.list.add((Object)member);
        this.scopes.add((Object)scope);
        this.bits.add(n3 |= this.matchSet << 9);
    }

    public String getMemberName() {
        return this.name;
    }

    public String getPackage() {
        return this.contextPackage.getName();
    }

    public Type getQualifier() {
        return this.qualifier;
    }

    public Scope getContextScope() {
        return this.contextScope;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.list.size(); ++i) {
            if ((this.bits.elements[i] & 0x100) != 0) continue;
            if (stringBuilder.length() > 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(Reflection.getDescription((Member)((Member)this.list.get(i))));
        }
        return stringBuilder.append(']').toString();
    }

    public int size() {
        int n = 0;
        for (int i = this.list.size() - 1; i >= 0; --i) {
            if ((this.bits.elements[i] & 0x100) != 0) continue;
            ++n;
        }
        return n;
    }

    private int index(int n) {
        for (int i = 0; i < this.list.size(); ++i) {
            if ((this.bits.elements[i] & 0x100) != 0 || --n >= 0) continue;
            return i;
        }
        return this.list.size();
    }

    private String getDescription(int n) {
        Member member = (Member)this.list.get(this.index(n));
        if (member instanceof ShiftedMethod) {
            member = ((ShiftedMethod)member).getMethod();
        }
        return Members.getDescription(member);
    }

    private static String getDescription(Member member) {
        if (member instanceof ShiftedMethod) {
            member = ((ShiftedMethod)member).getMethod();
        }
        return Reflection.getDescription((Member)member);
    }

    private String msgForAll(String string, Object object) {
        String string2;
        int n = 0;
        for (int i = this.list.size - 1; i >= 0; --i) {
            if ((this.bits.elements[i] & 0x100) != 0) continue;
            n |= Members.getMemberType((Member)this.list.get(i));
        }
        int n2 = this.size();
        switch (n2) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                string2 = this.getDescription(0);
                break;
            }
            case 2: {
                string2 = I18N.msg("member.two-members", (Object)this.getDescription(0), (Object)this.getDescription(1));
                break;
            }
            default: {
                string2 = this.getDescription(0);
                int n3 = 0;
                while (++n3 < n2 - 2) {
                    string2 = I18N.msg("member.add-member", (Object)string2, (Object)this.getDescription(n3));
                }
                string2 = I18N.msg("member.three+-members", (Object)string2, (Object)this.getDescription(n3), (Object)this.getDescription(n3 + 1));
            }
        }
        return I18N.msg(string, (Object)Members.getMembersDescription(n, n2 > 1), (Object)string2, (Object)n2, object);
    }

    private void removeWhere(int n) {
        for (int i = this.list.size - 1; i >= 0; --i) {
            if ((this.bits.elements[i] & n & 0x7F) == 0) continue;
            int n2 = i;
            this.bits.elements[n2] = this.bits.elements[n2] | 0x100;
        }
    }

    private int markApplicability(Resolution resolution) {
        int n = Integer.MAX_VALUE;
        Applicability applicability = new Applicability();
        for (int i = this.list.size - 1; i >= 0; --i) {
            Member member = (Member)this.list.get(i);
            int n2 = this.bits.elements[i] & 0xFFFFFEBF;
            applicability.scope = (Scope)this.scopes.get(i);
            applicability.matchSet = n2 >> 9;
            if (resolution.isApplicable(member, applicability, this.contextScope)) {
                n2 &= 0xFFFFFFDF;
                this.applicabilities.set(i, (Object)applicability);
                applicability = new Applicability();
            } else {
                n2 |= 0x20;
            }
            this.bits.elements[i] = n2;
            if ((n2 &= 0x7F) >= n) continue;
            n = n2;
        }
        return n;
    }

    private void removeLessSpecific(Resolution resolution) {
        for (int i = this.list.size - 1; i >= 0; --i) {
            if ((this.bits.elements[i] & 0x100) != 0) continue;
            Member member = (Member)this.list.get(i);
            for (int j = this.list.size - 1; j >= 0; --j) {
                if (i == j || (this.bits.elements[j] & 0x100) != 0 || !resolution.isLessThan((Member)this.list.get(j), (Applicability)this.applicabilities.get(j), member, (Applicability)this.applicabilities.get(i), this.contextScope)) continue;
                int n = j;
                this.bits.elements[n] = this.bits.elements[n] | 0x100;
            }
        }
    }

    public Applicability getApplicability() {
        return (Applicability)this.applicabilities.get(this.index(0));
    }

    public Member resolve(Resolution resolution) throws RecognitionException {
        int n = this.markApplicability(resolution);
        boolean bl = this.haveApplicable = n < 32;
        if (this.haveApplicable) {
            if (n == 0) {
                this.removeWhere(-1);
                this.removeLessSpecific(resolution);
                if (this.size() == 1 || resolution.allowsAmbiguousMembers((Member)this.list.get(this.index(0)))) {
                    Member member = (Member)this.list.get(this.index(0));
                    if (!resolution.allowsAmbiguousMembers(member) && this.compiler.problems.isWarning(4L) && Reflection.getDeclaredAnnotation((Member)member, Deprecated.class) != null) {
                        this.compiler.problems.addSemanticWarning(I18N.msg("compiler.deprecated-member", (Object)Members.getMemberTypeDescription(member), (Object)Members.getDescription(member)), this.pos);
                    }
                    return member;
                }
                throw new SemanticException(this.msgForAll("compiler.ambiguous-members", null)).set(this.pos);
            }
            if (n < 2) {
                this.removeWhere(-2);
                throw new SemanticException(this.msgForAll("compiler.non-static-members", null)).set(this.pos);
            }
            if (n < 4) {
                this.removeWhere(-4);
                throw new SemanticException(this.msgForAll("compiler.non-instance-members", null)).set(this.pos);
            }
            if (n < 8) {
                this.removeWhere(-5);
                throw new SemanticException(this.msgForAll("compiler.shadowed-members", null)).set(this.pos);
            }
            if (n < 16) {
                this.removeWhere(-13);
                throw new SemanticException(this.msgForAll("compiler.inaccessible-members", null)).set(this.pos);
            }
            throw new SemanticException(this.msgForAll("compiler.hidden-members", null)).set(this.pos);
        }
        if (this.size() == 0) {
            String string = null;
            String string2 = "compiler.no-member-in-scope";
            if (this.qualifier != null) {
                Type type = this.qualifier;
                if ((this.flags & 0x2000) != 0 && (type = type.getSupertype()) == null) {
                    type = Type.INVALID;
                }
                string = type.getName();
                string2 = "compiler.no-member-in-type";
            } else if (this.contextScope instanceof Package) {
                string = this.contextPackage.getName();
                string2 = "compiler.no-member-in-package";
            }
            throw new SemanticException(I18N.msg(string2, (Object)Members.getMembersDescription(this.flags, false), (Object)this.name, (Object)string)).set(this.pos);
        }
        if ((n &= 0xFFFFFFDF) == 0) {
            this.removeWhere(-33);
            Type[] typeArray = resolution.getArgumentTypes();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < typeArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(typeArray[i].getName());
            }
            throw new SemanticException(this.msgForAll("compiler.inapplicable-members", stringBuffer)).set(this.pos);
        }
        throw new SemanticException(this.msgForAll("compiler.inapplicable-invisible-members", null)).set(this.pos);
    }

    public boolean haveApplicable() {
        return this.haveApplicable;
    }

    public Scope getScopeForResult() {
        return (Scope)this.scopes.get(this.index(0));
    }

    public static int getMemberType(Member member) {
        if (member instanceof Local) {
            return 1;
        }
        if (member instanceof Field) {
            return 2;
        }
        if (member instanceof Method) {
            return "<init>".equals(member.getSimpleName()) ? 16 : 8;
        }
        if (member instanceof Type) {
            return 32;
        }
        if (member instanceof Package) {
            return 64;
        }
        if (member instanceof PatternWrapper) {
            return 4;
        }
        throw new IllegalArgumentException(String.valueOf(member));
    }

    public static String getMemberTypeDescription(Member member) {
        return Members.getMembersDescription(Members.getMemberType(member), false);
    }

    public static String getMembersDescription(int n, boolean bl) {
        Object[] objectArray;
        if ((n & 0x1000) != 0) {
            n |= 0x40;
        }
        int n2 = 0;
        for (int i = 1; i <= 64; i <<= 1) {
            if ((i & n) == 0) continue;
            ++n2;
        }
        if (n2 > 3) {
            n2 = 0;
            objectArray = null;
        } else {
            objectArray = new String[n2];
            n2 = 0;
            if ((n & 1) != 0) {
                objectArray[n2++] = I18N.msg(bl ? "member.variables" : "member.variable");
                n &= 0xFFFFFFFD;
            }
            if ((n & 2) != 0) {
                objectArray[n2++] = I18N.msg(bl ? "member.fields" : "member.field");
            }
            if ((n & 8) != 0) {
                objectArray[n2++] = I18N.msg(bl ? "member.methods" : "member.method");
            }
            if ((n & 0x10) != 0) {
                objectArray[n2++] = I18N.msg(bl ? "member.constructors" : "member.constructor");
            }
            if ((n & 4) != 0) {
                objectArray[n2++] = I18N.msg(bl ? "member.patterns" : "member.pattern");
            }
            if ((n & 0x20) != 0) {
                objectArray[n2++] = I18N.msg(bl ? "member.types" : "member.type");
            }
            if ((n & 0x40) != 0) {
                objectArray[n2++] = I18N.msg(bl ? "member.packages" : "member.package");
            }
        }
        switch (n2) {
            case 0: {
                return I18N.msg(bl ? "member.members" : "member.member");
            }
            case 1: {
                return objectArray[0];
            }
            case 2: {
                return I18N.msg(bl ? "member.two-plurals" : "member.two-singulars", objectArray[0], objectArray[1]);
            }
            case 3: {
                return I18N.msg(bl ? "member.three-plurals" : "member.three-singulars", objectArray);
            }
        }
        throw new AssertionError();
    }

    public static interface Resolution {
        public boolean allowsAmbiguousMembers(Member var1);

        public boolean isApplicable(Member var1, Applicability var2, Scope var3);

        public Type[] getArgumentTypes();

        public boolean isLessThan(Member var1, Applicability var2, Member var3, Applicability var4, Scope var5);
    }

    public static final class Applicability {
        public static final Applicability DEFAULT = new Applicability();
        public Scope scope;
        public ObjectList<Type> actualArguments = new ObjectList();
        public boolean array2Generator;
        public int implicitCount;
        public boolean varArity;
        public int transformationAlternative;
        public int matchSet;
    }
}

