/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.compiler.scope;

import de.grogra.reflect.Annotation;
import de.grogra.reflect.Member;
import de.grogra.reflect.Type;
import de.grogra.xl.compiler.scope.ClassPath;
import de.grogra.xl.compiler.scope.Members;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.compiler.scope.TypeScope;
import java.util.HashMap;

public class Package
extends Scope
implements Member {
    private final HashMap types = new HashMap(32);
    private final HashMap declaredTypes = new HashMap(32);
    private final String name;
    private final String descriptor;

    public Package(ClassPath classPath, String string) {
        super(classPath);
        this.name = string;
        this.descriptor = 'P' + string + ';';
    }

    public Member getDeclaredEntity() {
        return this;
    }

    public final Package getPackage() {
        return this;
    }

    public void findMembers(String string, int n, Members members) {
        if ((n & 0x100) == 0) {
            this.findMembers(string, n, members, this);
        }
        super.findMembers(string, n, members);
    }

    void findMembers(String string, int n, Members members, Scope scope) {
        Type type;
        if (!this.name.equals(members.getPackage())) {
            n |= 0x80000;
        }
        if ((n & 0x24) != 0 && (type = this.findType(string)) != null) {
            TypeScope.addTypeOrPatterns(type, members, scope, n);
            return;
        }
        if ((n & 0x40) != 0) {
            members.add(((ClassPath)this.getEnclosingScope()).getPackage(this.getCanonicalName(string), false), this, n);
        }
    }

    public void declareType(Type type) {
        this.types.put(type.getSimpleName(), type);
        this.declaredTypes.put(type.getSimpleName(), type);
        ClassPath.get(this).declareType(type);
    }

    public Type findDeclaredType(String string) {
        return (Type)this.declaredTypes.get(string);
    }

    public Type findType(String string) {
        Type type = (Type)this.types.get(string);
        if (type == null && (type = this.loadType(string)) != null) {
            this.types.put(type.getSimpleName(), type);
        }
        return type;
    }

    protected Type loadType(String string) {
        return ((ClassPath)this.getEnclosingScope()).typeForNameOrNull(this.getCanonicalName(string));
    }

    public final String getCanonicalName(String string) {
        return this.name.length() == 0 ? string : this.name + '.' + string;
    }

    public final boolean contains(Member member) {
        return member instanceof Package ? this.equals(member) : this.name.equals((member instanceof Type ? (Type)member : member.getDeclaringType()).getPackage());
    }

    public final Type getDeclaringType() {
        return null;
    }

    public final int getModifiers() {
        return 1;
    }

    public final String getName() {
        return this.name;
    }

    public final String getSimpleName() {
        return this.name;
    }

    public final String getDescriptor() {
        return this.descriptor;
    }

    public final String toString() {
        return "package '" + this.name + '\'';
    }

    public final boolean equals(Object object) {
        return object instanceof Package && this.descriptor.equals(((Package)object).descriptor);
    }

    public int getDeclaredAnnotationCount() {
        return 0;
    }

    public Annotation getDeclaredAnnotation(int n) {
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }
}

