/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.AssignArrayGenerator;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Generator;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.expr.Variable;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public final class ArrayGenerator
extends Variable
implements Generator,
LocalAccess {
    private Expression expr;
    private Expression statement;
    private Local array;
    private Local counter;
    private VMXState.Local vmxArray;
    private VMXState.Local vmxCounter;

    public ArrayGenerator(Type type, Local local, Local local2) {
        super(type);
        this.array = local;
        this.counter = local2;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        boolean[] blArray = (boolean[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < blArray.length; ++i) {
            vMXState.ipush(blArray[i] ? 1 : 0);
            this.statement.evaluateAsVoid(vMXState);
        }
        return false;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        byte[] byArray = (byte[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < byArray.length; ++i) {
            vMXState.ipush((int)byArray[i]);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        short[] sArray = (short[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < sArray.length; ++i) {
            vMXState.ipush((int)sArray[i]);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        char[] cArray = (char[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < cArray.length; ++i) {
            vMXState.ipush((int)cArray[i]);
            this.statement.evaluateAsVoid(vMXState);
        }
        return '\u0000';
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        int[] nArray = (int[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < nArray.length; ++i) {
            vMXState.ipush(nArray[i]);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        long[] lArray = (long[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < lArray.length; ++i) {
            vMXState.lpush(lArray[i]);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0L;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        float[] fArray = (float[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < fArray.length; ++i) {
            vMXState.fpush(fArray[i]);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0.0f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        double[] dArray = (double[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < dArray.length; ++i) {
            vMXState.dpush(dArray[i]);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0.0;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Object[] objectArray = (Object[])this.expr.evaluateObject(vMXState);
        for (int i = 0; i < objectArray.length; ++i) {
            vMXState.apush(objectArray[i]);
            this.statement.evaluateAsVoid(vMXState);
        }
        return null;
    }

    public int getGeneratorType() {
        return 1;
    }

    public void setBreakTarget(BreakTarget breakTarget) {
    }

    public void link(boolean bl) {
        this.checkExpressionCount(2);
        this.expr = this.getObjectExpression(0, this.getType().getArrayType(), bl);
        this.statement = this.expr.getNextExpression();
    }

    public int getLocalCount() {
        return 2;
    }

    public int getAccessType(int n) {
        return 10;
    }

    public Local getLocal(int n) {
        return n == 0 ? this.array : this.counter;
    }

    public void setLocal(int n, Local local) {
        if (n == 0) {
            this.array = local;
        } else {
            this.counter = local;
        }
    }

    public void complete(MethodScope methodScope) {
        this.vmxArray = this.array.createVMXLocal();
        this.vmxCounter = this.counter.createVMXLocal();
    }

    public Expression toAssignment(int n) {
        return new AssignArrayGenerator(this.getType(), this.array, this.counter, n).receiveChildren(this);
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        assert (bl && this.vmxCounter.isJavaLocal());
        this.expr.write(bytecodeWriter, false);
        bytecodeWriter.visitStore(this.vmxArray, this.expr.getType());
        bytecodeWriter.visiticonst(0);
        bytecodeWriter.visitStore(this.vmxCounter, Type.INT);
        Label label = new Label();
        Label label2 = new Label();
        bytecodeWriter.visitJumpInsn(167, label2);
        bytecodeWriter.visitLabel(label);
        bytecodeWriter.visitLoad(this.vmxArray, this.expr.getType());
        bytecodeWriter.visitLoad(this.vmxCounter, Type.INT);
        bytecodeWriter.visitALoad(this.etype);
        bytecodeWriter.visitIincInsn(this.vmxCounter.getIndex(), 1);
        this.statement.write(bytecodeWriter, true);
        bytecodeWriter.visitLabel(label2);
        bytecodeWriter.visitLoad(this.vmxCounter, Type.INT);
        bytecodeWriter.visitLoad(this.vmxArray, this.expr.getType());
        bytecodeWriter.visitInsn(190);
        bytecodeWriter.visitJumpInsn(161, label);
    }
}

