/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.expr.EvalExpression;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.vmx.VMXState;
import java.lang.reflect.Array;

public final class CreateArray
extends EvalExpression {
    private final Type componentType;
    private final Class componentClass;
    private Type arrayType = null;
    private Expression[] dimensions;

    public CreateArray(Type type) {
        super(Type.OBJECT);
        this.componentType = type;
        this.componentClass = type.getImplementationClass();
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        int n = this.dimensions.length;
        for (int i = 0; i < n; ++i) {
            vMXState.ipush(this.dimensions[i].evaluateInt(vMXState));
        }
        return Array.newInstance(this.componentClass, vMXState.popIntArray(n));
    }

    public Type getType() {
        if (this.arrayType == null) {
            this.arrayType = this.componentType;
            for (int i = this.getExpressionCount(); i >= 1; --i) {
                this.arrayType = this.arrayType.getArrayType();
            }
        }
        return this.arrayType;
    }

    public void link(boolean bl) {
        this.dimensions = new Expression[this.getExpressionCount()];
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = this.getExpression(i, 6, bl);
        }
    }

    protected void writeOperator(BytecodeWriter bytecodeWriter) {
        if (this.dimensions.length == 1) {
            bytecodeWriter.visitNewArray(this.getType().getComponentType());
        } else {
            bytecodeWriter.visitMultiANewArrayInsn(bytecodeWriter.toName(this.getType()), this.dimensions.length);
        }
    }
}

