/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Field;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.reflect.TypeLoader;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.Completable;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.PropertyAssignment;
import de.grogra.xl.expr.Variable;
import de.grogra.xl.property.CompiletimeModel;
import de.grogra.xl.property.RuntimeModel;
import de.grogra.xl.property.RuntimeModelFactory;
import de.grogra.xl.vmx.VMXState;

public final class GetProperty
extends Variable
implements Completable {
    private Expression instance;
    private Expression indices;
    private int indexCount;
    private CompiletimeModel.Property property;
    private RuntimeModel.Property rtProperty;
    private String modelString;
    private String propertyString;
    private Field propertyField;

    public GetProperty(CompiletimeModel.Property property) {
        super(property.getType());
        this.property = property;
    }

    public CompiletimeModel.Property getProperty() {
        return this.property;
    }

    public void setProperty(CompiletimeModel.Property property) {
        this.property = property;
        this.setType(property.getType());
    }

    public void complete(MethodScope methodScope) {
        if (this.getExpressionCount() > 1) {
            methodScope.createLocalForVMX();
        }
        this.propertyField = methodScope.getDeclaredType().getFieldForProperty(this.property);
    }

    protected void checkSetType(Type type) {
    }

    private RuntimeModel.Property pushIndices(VMXState vMXState) {
        Expression expression;
        for (expression = this.indices; expression != null; expression = expression.getNextExpression()) {
            expression.push(vMXState);
        }
        if (this.rtProperty == null) {
            expression = this.getTypeLoader();
            this.rtProperty = RuntimeModelFactory.getInstance().modelForName(this.modelString, expression.getClassLoader()).propertyForName(this.propertyString, (TypeLoader)expression);
        }
        return this.rtProperty;
    }

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getBoolean(object, vMXState.popIntArray(this.indexCount));
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getByte(object, vMXState.popIntArray(this.indexCount));
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getShort(object, vMXState.popIntArray(this.indexCount));
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getChar(object, vMXState.popIntArray(this.indexCount));
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getInt(object, vMXState.popIntArray(this.indexCount));
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getLong(object, vMXState.popIntArray(this.indexCount));
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getFloat(object, vMXState.popIntArray(this.indexCount));
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getDouble(object, vMXState.popIntArray(this.indexCount));
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Object object = this.instance.evaluateObject(vMXState);
        return this.pushIndices(vMXState).getObject(object, vMXState.popIntArray(this.indexCount));
    }

    public void link(boolean bl) {
        this.instance = this.getExpression(0, 0, bl);
        this.indices = this.instance.getNextExpression();
        this.modelString = this.property.getModel().getRuntimeName();
        this.propertyString = this.property.getRuntimeName();
        this.indexCount = this.getExpressionCount() - 1;
    }

    public Expression toAssignment(int n) {
        return new PropertyAssignment(this, n).receiveChildren(this);
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        bytecodeWriter.visitFieldInsn(178, this.propertyField, null);
        this.instance.write(bytecodeWriter, false);
        if (this.indexCount > 0) {
            bytecodeWriter.visitVMX();
            for (Expression expression = this.indices; expression != null; expression = expression.getNextExpression()) {
                bytecodeWriter.visitInsn(89);
                expression.write(bytecodeWriter, false);
                bytecodeWriter.visitMethodInsn(VMX_TYPE, "ipush");
            }
            bytecodeWriter.visiticonst(this.indexCount);
            bytecodeWriter.visitMethodInsn(VMX_TYPE, "popIntArray");
        } else {
            bytecodeWriter.visitFieldInsn(178, VMXState.class, "INT_0", "[I");
        }
        bytecodeWriter.visitMethodInsn(this.propertyField.getType(), "get" + Reflection.getTypeSuffix((int)this.etype));
        if (bl) {
            bytecodeWriter.visitPop(this.etype);
        } else {
            bytecodeWriter.visitCheckCast(this.getType());
        }
    }
}

