/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Scope;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Generator;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public final class Guard
extends Expression
implements Generator {
    private Expression expr;
    private Expression condition;
    private Expression statement;

    protected boolean evaluateBooleanImpl(VMXState vMXState) {
        boolean bl = this.expr.evaluateBoolean(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.ipush(bl ? 1 : 0);
            this.statement.evaluateAsVoid(vMXState);
        }
        return false;
    }

    protected byte evaluateByteImpl(VMXState vMXState) {
        byte by = this.expr.evaluateByte(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.ipush((int)by);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected short evaluateShortImpl(VMXState vMXState) {
        short s = this.expr.evaluateShort(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.ipush((int)s);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected char evaluateCharImpl(VMXState vMXState) {
        char c = this.expr.evaluateChar(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.ipush((int)c);
            this.statement.evaluateAsVoid(vMXState);
        }
        return '\u0000';
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        int n = this.expr.evaluateInt(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.ipush(n);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        long l = this.expr.evaluateLong(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.lpush(l);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0L;
    }

    protected float evaluateFloatImpl(VMXState vMXState) {
        float f = this.expr.evaluateFloat(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.fpush(f);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0.0f;
    }

    protected double evaluateDoubleImpl(VMXState vMXState) {
        double d = this.expr.evaluateDouble(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.dpush(d);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0.0;
    }

    protected Object evaluateObjectImpl(VMXState vMXState) {
        Object object = this.expr.evaluateObject(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            vMXState.apush(object);
            this.statement.evaluateAsVoid(vMXState);
        }
        return null;
    }

    protected void evaluateVoidImpl(VMXState vMXState) {
        this.expr.evaluateAsVoid(vMXState);
        if (this.condition.evaluateBoolean(vMXState)) {
            this.statement.evaluateAsVoid(vMXState);
        }
    }

    public Expression compile(Scope scope, Expression expression, Expression expression2) {
        expression2 = expression2.implicitConversion(scope, Type.BOOLEAN);
        return this.setType(expression.getType()).add(expression).add(expression2);
    }

    public int getGeneratorType() {
        return 1;
    }

    public void setBreakTarget(BreakTarget breakTarget) {
    }

    public void link(boolean bl) {
        this.checkExpressionCount(3);
        this.expr = this.getExpression(0, this.etype, bl);
        this.condition = this.getExpression(1, 2, bl);
        this.statement = this.condition.getNextExpression();
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        this.expr.write(bytecodeWriter, this.etype == 1);
        Label label = new Label();
        this.condition.writeConditional(bytecodeWriter, label, null);
        this.statement.write(bytecodeWriter, true);
        Label label2 = new Label();
        bytecodeWriter.visitJumpInsn(167, label2);
        bytecodeWriter.visitLabel(label);
        if (this.etype != 1) {
            bytecodeWriter.visitPop(this.expr.etype);
        }
        bytecodeWriter.visitLabel(label2);
    }
}

