/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.reflect.Type;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.BinaryExpression;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.Generator;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public final class Range
extends BinaryExpression
implements Generator,
LocalAccess {
    private Expression statement;
    private Local max;
    private Local counter;
    private VMXState.Local vmxMax;
    private VMXState.Local vmxCounter;

    public void setLocals(Local local, Local local2) {
        this.counter = local;
        this.max = local2;
    }

    public int getSupportedTypes() {
        return 192;
    }

    protected int evaluateIntImpl(VMXState vMXState) {
        int n = this.expr1.evaluateInt(vMXState);
        int n2 = this.expr2.evaluateInt(vMXState);
        while (n <= n2) {
            vMXState.ipush(n++);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0;
    }

    protected long evaluateLongImpl(VMXState vMXState) {
        long l = this.expr1.evaluateLong(vMXState);
        long l2 = this.expr2.evaluateLong(vMXState);
        while (l <= l2) {
            vMXState.lpush(l++);
            this.statement.evaluateAsVoid(vMXState);
        }
        return 0L;
    }

    public void link(boolean bl) {
        this.checkExpressionCount(3);
        this.expr1 = this.getExpression(0, this.etype, bl);
        this.expr2 = this.getExpression(1, this.etype, bl);
        this.statement = this.expr2.getNextExpression();
    }

    public int getGeneratorType() {
        return 1;
    }

    public void setBreakTarget(BreakTarget breakTarget) {
    }

    public Expression toConst() {
        return this;
    }

    public int getLocalCount() {
        return 2;
    }

    public int getAccessType(int n) {
        return 18;
    }

    public Local getLocal(int n) {
        return n == 0 ? this.counter : this.max;
    }

    public void setLocal(int n, Local local) {
        if (n == 0) {
            this.counter = local;
        } else {
            this.max = local;
        }
    }

    public void complete(MethodScope methodScope) {
        this.vmxCounter = this.counter.createVMXLocal();
        this.vmxMax = this.max.createVMXLocal();
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        assert (bl && this.vmxCounter.isJavaLocal() && this.vmxMax.isJavaLocal());
        Label label = new Label();
        Label label2 = new Label();
        this.expr1.write(bytecodeWriter, false);
        this.expr2.write(bytecodeWriter, false);
        bytecodeWriter.visitStore(this.vmxMax, this.getType());
        bytecodeWriter.visitDup(this.etype);
        bytecodeWriter.visitStore(this.vmxCounter, this.getType());
        bytecodeWriter.visitJumpInsn(167, label2);
        bytecodeWriter.visitLabel(label);
        bytecodeWriter.visitLoad(this.vmxCounter, this.getType());
        this.statement.write(bytecodeWriter, true);
        if (this.etype == 6) {
            bytecodeWriter.visitIincInsn(this.vmxCounter.getIndex(), 1);
            bytecodeWriter.visitLoad(this.vmxCounter, Type.INT);
        } else {
            bytecodeWriter.visitLoad(this.vmxCounter, Type.LONG);
            bytecodeWriter.visitInsn(10);
            bytecodeWriter.visitInsn(97);
            bytecodeWriter.visitInsn(92);
            bytecodeWriter.visitStore(this.vmxCounter, Type.LONG);
        }
        bytecodeWriter.visitLabel(label2);
        bytecodeWriter.visitLoad(this.vmxMax, this.getType());
        if (this.etype == 6) {
            bytecodeWriter.visitJumpInsn(164, label);
        } else {
            bytecodeWriter.visitInsn(148);
            bytecodeWriter.visitJumpInsn(158, label);
        }
    }
}

