/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.util.Int2IntMap;
import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.expr.BreakTarget;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public final class Switch
extends BreakTarget {
    private Int2IntMap labelToIndex;
    private int defaultIndex;

    public void initialize(Int2IntMap int2IntMap, int n) {
        this.labelToIndex = int2IntMap;
        this.defaultIndex = n;
    }

    protected void evaluate(VMXState vMXState) {
        int n = this.labelToIndex.get(this.getFirstExpression().evaluateInt(vMXState));
        if (n == 0) {
            n = this.defaultIndex;
        }
        if (n > 0) {
            for (Expression expression = this.getExpression(n); expression != null; expression = expression.getNextExpression()) {
                expression.evaluateAsVoid(vMXState);
            }
        }
    }

    protected void writeOperator(BytecodeWriter bytecodeWriter) {
        int n;
        Label[] labelArray;
        Expression expression = this.getFirstExpression();
        expression.write(bytecodeWriter, false);
        Label[] labelArray2 = new Label[this.getExpressionCount()];
        for (int i = 0; i < labelArray2.length; ++i) {
            labelArray2[i] = new Label();
        }
        Label label = labelArray2[this.defaultIndex < 0 ? labelArray2.length - 1 : this.defaultIndex - 1];
        int[] nArray = this.labelToIndex.getKeys(null);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n2 = Math.min(n2, nArray[i]);
            n3 = Math.max(n3, nArray[i]);
        }
        if (nArray.length > 0 && (long)n3 - (long)n2 < (long)Math.max(10, 4 * nArray.length)) {
            labelArray = new Label[n3 - n2 + 1];
            for (n = 0; n < labelArray.length; ++n) {
                labelArray[n] = label;
            }
            for (n = 0; n < nArray.length; ++n) {
                labelArray[nArray[n] - n2] = labelArray2[this.labelToIndex.getValueAt(n) - 1];
            }
            bytecodeWriter.visitTableSwitchInsn(n2, n3, label, labelArray);
        } else {
            labelArray = new Label[nArray.length];
            for (n = 0; n < labelArray.length; ++n) {
                labelArray[n] = labelArray2[this.labelToIndex.getValueAt(n) - 1];
            }
            bytecodeWriter.visitLookupSwitchInsn(label, nArray, labelArray);
        }
        int n4 = 0;
        while ((expression = expression.getNextExpression()) != null) {
            bytecodeWriter.visitLabel(labelArray2[n4++]);
            expression.write(bytecodeWriter, true);
        }
        bytecodeWriter.visitLabel(labelArray2[labelArray2.length - 1]);
    }
}

