/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.expr;

import de.grogra.xl.compiler.BytecodeWriter;
import de.grogra.xl.compiler.scope.Local;
import de.grogra.xl.compiler.scope.MethodScope;
import de.grogra.xl.expr.ControlTransfer;
import de.grogra.xl.expr.Expression;
import de.grogra.xl.expr.LocalAccess;
import de.grogra.xl.expr.VoidExpression;
import de.grogra.xl.vmx.VMXState;
import org.objectweb.asm.Label;

public final class Synchronized
extends VoidExpression
implements LocalAccess {
    private Local mutex;
    private VMXState.Local vmxMutex;
    private Expression lock;
    private Expression statement;
    private Label start;
    private Label handler;

    public Synchronized(Local local) {
        this.mutex = local;
    }

    public int getLocalCount() {
        return 1;
    }

    public int getAccessType(int n) {
        return 10;
    }

    public Local getLocal(int n) {
        return this.mutex;
    }

    public void setLocal(int n, Local local) {
        this.mutex = local;
    }

    public void complete(MethodScope methodScope) {
        this.vmxMutex = this.mutex.createVMXLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evaluateVoidImpl(VMXState vMXState) {
        Object object = this.lock.evaluateObject(vMXState);
        synchronized (object) {
            this.statement.evaluateAsVoid(vMXState);
        }
    }

    public void link(boolean bl) {
        this.checkExpressionCount(2);
        this.lock = this.getExpression(0, 0, bl);
        this.statement = this.lock.getNextExpression();
    }

    protected void writeImpl(BytecodeWriter bytecodeWriter, boolean bl) {
        assert (bl && this.vmxMutex.isJavaLocal());
        this.lock.write(bytecodeWriter, false);
        bytecodeWriter.visitInsn(89);
        bytecodeWriter.visitVarInsn(58, this.vmxMutex.getIndex());
        bytecodeWriter.visitInsn(194);
        this.handler = null;
        this.start = new Label();
        bytecodeWriter.visitLabel(this.start);
        this.statement.write(bytecodeWriter, true);
        this.writeHandler(bytecodeWriter);
        bytecodeWriter.visitVarInsn(25, this.vmxMutex.getIndex());
        bytecodeWriter.visitInsn(195);
        if (this.handler != null) {
            Label label = new Label();
            bytecodeWriter.visitJumpInsn(167, label);
            bytecodeWriter.visitLabel(this.handler);
            bytecodeWriter.visitVarInsn(25, this.vmxMutex.getIndex());
            bytecodeWriter.visitInsn(195);
            bytecodeWriter.visitInsn(191);
            bytecodeWriter.visitLabel(label);
        }
    }

    private void writeHandler(BytecodeWriter bytecodeWriter) {
        Label label = new Label();
        bytecodeWriter.visitLabel(label);
        if (label.getOffset() == this.start.getOffset()) {
            return;
        }
        if (this.handler == null) {
            this.handler = new Label();
        }
        bytecodeWriter.visitTryCatchBlock(this.start, label, this.handler, null);
    }

    public void writeFinally(BytecodeWriter bytecodeWriter, int n, ControlTransfer controlTransfer) {
        this.writeHandler(bytecodeWriter);
        bytecodeWriter.visitVarInsn(25, this.vmxMutex.getIndex());
        bytecodeWriter.visitInsn(195);
        super.writeFinally(bytecodeWriter, n, controlTransfer);
        this.start = new Label();
        bytecodeWriter.visitLabel(this.start);
    }
}

