/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.exchangegraph;

import de.grogra.ext.exchangegraph.IOContext;
import de.grogra.ext.exchangegraph.nodes.XEGUnknown;
import de.grogra.ext.exchangegraph.xmlbeans.Edge;
import de.grogra.ext.exchangegraph.xmlbeans.ExtendsType;
import de.grogra.ext.exchangegraph.xmlbeans.Graph;
import de.grogra.ext.exchangegraph.xmlbeans.GraphDocument;
import de.grogra.ext.exchangegraph.xmlbeans.Node;
import de.grogra.ext.exchangegraph.xmlbeans.Property;
import de.grogra.ext.exchangegraph.xmlbeans.Root;
import de.grogra.ext.exchangegraph.xmlbeans.Type;
import de.grogra.graph.impl.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.reflect.Reflection;
import de.grogra.xl.util.BidirectionalHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XEGExport {
    private IOContext ctx;
    private de.grogra.graph.impl.Node startNode;

    public XEGExport(de.grogra.graph.impl.Node node, IOContext iOContext) {
        this.ctx = iOContext;
        this.startNode = node;
    }

    public String doExport() {
        GraphDocument graphDocument = this.extractGraph(this.startNode);
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setSavePrettyPrint();
        xmlOptions.setSavePrettyPrintIndent(2);
        return graphDocument.xmlText(xmlOptions);
    }

    private GraphDocument extractGraph(de.grogra.graph.impl.Node node) {
        GraphDocument graphDocument = GraphDocument.Factory.newInstance();
        Graph graph = graphDocument.addNewGraph();
        HashSet<String> hashSet = new HashSet<String>();
        BidirectionalHashMap<Integer, String> bidirectionalHashMap = this.ctx.getEdgeTypes();
        BidirectionalHashMap<Long, de.grogra.graph.impl.Node> bidirectionalHashMap2 = this.ctx.getNodeMap();
        BidirectionalHashMap<Long, de.grogra.graph.impl.Edge> bidirectionalHashMap3 = this.ctx.getEdgeMap();
        HashSet<de.grogra.graph.impl.Node> hashSet2 = new HashSet<de.grogra.graph.impl.Node>();
        this.visitNodes(hashSet2, node);
        long l = 0L;
        for (Long l2 : bidirectionalHashMap2.getKeyMap()) {
            if (l2 <= l) continue;
            l = l2;
        }
        ++l;
        long l3 = 0L;
        for (Long l4 : bidirectionalHashMap3.getKeyMap()) {
            if (l4 <= l3) continue;
            l3 = l4;
        }
        ++l3;
        for (de.grogra.graph.impl.Node node2 : hashSet2) {
            if (bidirectionalHashMap2.containsValue((Object)node2)) continue;
            bidirectionalHashMap2.put((Object)l++, (Object)node2);
        }
        hashSet2.remove(node);
        Root root = graph.addNewRoot();
        long l2 = bidirectionalHashMap2.getKey((Object)node) == null ? 0L : (Long)bidirectionalHashMap2.getKey((Object)node);
        root.setRootId(l2);
        for (de.grogra.graph.impl.Node node3 : hashSet2) {
            Class clazz;
            String string = this.writeType(hashSet, node3, graph);
            Node node4 = graph.addNewNode();
            node4.setId(((Long)bidirectionalHashMap2.getKey((Object)node3)).longValue());
            node4.setName(node3.getName());
            node4.setType(string);
            ArrayList<Class> arrayList = new ArrayList<Class>();
            boolean bl = true;
            Class<?> clazz2 = node3.getClass();
            ArrayList<Class> arrayList2 = new ArrayList<Class>();
            try {
                do {
                    if (IOContext.xegNodeTypes.containsKey(clazz2)) {
                        clazz = IOContext.xegNodeTypes.get(clazz2);
                        if (arrayList2.contains(clazz)) continue;
                        Method method = clazz.getMethod("handleExportProperties", de.grogra.graph.impl.Node.class, Node.class);
                        method.invoke(null, node3, node4);
                        bl = false;
                        arrayList2.add(clazz);
                        continue;
                    }
                    if (!bl) continue;
                    arrayList.add(clazz2);
                } while ((clazz2 = clazz2.getSuperclass()) != Object.class);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            XEGUnknown.handleExportProperties(node3, node4, arrayList);
            for (clazz = node3.getFirstEdge(); clazz != null; clazz = clazz.getNext(node3)) {
                Edge edge;
                long l4;
                if (clazz.getTarget() != node3) continue;
                long l5 = (Long)bidirectionalHashMap2.getKey((Object)clazz.getSource());
                long l6 = (Long)bidirectionalHashMap2.getKey((Object)clazz.getTarget());
                if (bidirectionalHashMap3.containsValue((Object)clazz)) {
                    l4 = (Long)bidirectionalHashMap3.getKey((Object)clazz);
                } else {
                    long l7 = l3;
                    l4 = l7;
                    l3 = l7 + 1L;
                }
                long l8 = l4;
                int n = clazz.getEdgeBits();
                if ((n & 0x100) == 256) {
                    edge = graph.addNewEdge();
                    edge.setId(l8);
                    edge.setSrcId(l5);
                    edge.setDestId(l6);
                    edge.setType("successor");
                }
                if ((n & 0x200) == 512) {
                    edge = graph.addNewEdge();
                    edge.setId(l8);
                    edge.setSrcId(l5);
                    edge.setDestId(l6);
                    edge.setType("branch");
                }
                for (int i = 0; i < 15; ++i) {
                    if ((n >> i & 0x20000) != 131072) continue;
                    Edge edge2 = graph.addNewEdge();
                    edge2.setId(l8);
                    edge2.setSrcId(l5);
                    edge2.setDestId(l6);
                    String string2 = (String)bidirectionalHashMap.get((Object)i);
                    if (string2 == null) {
                        string2 = "EDGE_" + String.valueOf(i);
                    }
                    edge2.setType(string2);
                }
            }
        }
        return graphDocument;
    }

    private String writeType(Set<String> set, de.grogra.graph.impl.Node node, Graph graph) {
        Node.NType nType = node.getNType();
        Class<?> clazz = node.getClass();
        String string = this.getTypeForNodeClass(clazz);
        String string2 = new String(string);
        while (!set.contains(string) && !IOContext.importNodeTypes.containsKey(string)) {
            set.add(string);
            Type type = graph.addNewType();
            type.setName(string);
            int n = nType.getManagedFieldCount();
            for (int i = 0; i < n; ++i) {
                ManageableType.Field field = nType.getManagedField(i);
                if (field.getDeclaringType() != nType || !Reflection.isPrimitiveOrString((de.grogra.reflect.Type)field.getType())) continue;
                Property property = type.addNewProperty();
                property.setName(field.getSimpleName());
                property.setType(field.getType().getSimpleName());
            }
            if (IOContext.exportNodeTypes.containsKey(clazz.getName())) continue;
            ExtendsType extendsType = type.addNewExtends();
            clazz = clazz.getSuperclass();
            nType = (Node.NType)nType.getManageableSupertype();
            string = this.getTypeForNodeClass(clazz);
            extendsType.setName(string);
        }
        return string2;
    }

    private String getTypeForNodeClass(Class clazz) {
        String string;
        String string2 = clazz.getName();
        if (string2.indexOf("$") != -1) {
            string2 = string2.substring(string2.indexOf("$") + 1);
        }
        if ((string = IOContext.exportNodeTypes.get(clazz.getName())) == null) {
            string = clazz.getSimpleName();
        }
        return string;
    }

    private void visitNodes(Set<de.grogra.graph.impl.Node> set, de.grogra.graph.impl.Node node) {
        if (!set.contains(node)) {
            set.add(node);
            for (de.grogra.graph.impl.Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                this.visitNodes(set, edge.getTarget());
            }
        }
    }
}

