/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.pdb;

import de.grogra.ext.pdb.ProteinFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class PDBAtomReader {
    BufferedReader reader;
    public final int ATOM_NAME_START = 12;
    public final int ATOM_NAME_END = 16;
    public final int AMINO_NAME_START = 17;
    public final int AMINO_NAME_END = 20;
    public final int CHAINID_POS = 21;
    public final int RESIDUE_NR_START = 22;
    public final int RESIDUE_NR_END = 26;
    public final int X_START = 30;
    public final int X_END = 38;
    public final int Y_START = 38;
    public final int Y_END = 46;
    public final int Z_START = 46;
    public final int Z_END = 54;
    public final int SYMBOL_START = 76;
    public final int SYMBOL_END = 78;

    public PDBAtomReader(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
    }

    public PDBAtomReader(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    public void read(ProteinFactory proteinFactory) {
        try {
            while (this.reader.ready()) {
                String string = this.reader.readLine();
                if (string.startsWith("ATOM  ") && (string.charAt(16) == 'A' || string.charAt(16) == ' ')) {
                    String string2 = string.substring(12, 16).trim();
                    char c = string.charAt(21);
                    String string3 = string.substring(17, 20).trim();
                    int n = Integer.valueOf(string.substring(22, 26).trim());
                    float f = Float.valueOf(string.substring(30, 38).trim()).floatValue();
                    float f2 = Float.valueOf(string.substring(38, 46).trim()).floatValue();
                    float f3 = Float.valueOf(string.substring(46, 54).trim()).floatValue();
                    proteinFactory.processAtomEntry(string2, string3, n, f, f2, f3);
                    continue;
                }
                if (!string.startsWith("TER")) continue;
            }
            proteinFactory.closeProtein();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

