/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.pdb.model;

import de.grogra.ext.pdb.model.Atom;
import java.util.HashMap;
import java.util.Vector;

public class AminoAcid {
    String name;
    int resSeqNr;
    Vector atoms;
    public static int numberOfAcids = 0;
    private static HashMap atomNames = null;
    Vector reference;

    public AminoAcid(String string, int n) {
        ++numberOfAcids;
        this.resSeqNr = n;
        this.name = string;
        this.atoms = new Vector();
        if (atomNames == null) {
            atomNames = new HashMap();
            AminoAcid.initAtomNames();
        }
        this.reference = (Vector)atomNames.get(string);
    }

    private static void initAtomNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        atomNames.put("ALA", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD");
        vector.add("NE");
        vector.add("CZ");
        vector.add("NH1");
        vector.add("NH2");
        atomNames.put("ARG", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("OD1");
        vector.add("ND2");
        atomNames.put("ASN", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("OD1");
        vector.add("OD2");
        atomNames.put("ASP", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("SG");
        atomNames.put("CYS", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD");
        vector.add("OE1");
        vector.add("NE2");
        atomNames.put("GLN", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD");
        vector.add("OE1");
        vector.add("OE2");
        atomNames.put("GLU", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        atomNames.put("GLY", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("ND1");
        vector.add("CD2");
        vector.add("CE1");
        vector.add("NE2");
        atomNames.put("HIS", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG1");
        vector.add("CG2");
        vector.add("CD1");
        atomNames.put("ILE", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD1");
        vector.add("CD2");
        atomNames.put("LEU", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD");
        vector.add("CE");
        vector.add("NZ");
        atomNames.put("LYS", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("SD");
        vector.add("CE");
        atomNames.put("MET", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD1");
        vector.add("CD2");
        vector.add("CE1");
        vector.add("CE2");
        vector.add("CZ");
        atomNames.put("PHE", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD");
        atomNames.put("PRO", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("OG");
        atomNames.put("SER", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("OG1");
        vector.add("CG2");
        atomNames.put("THR", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD1");
        vector.add("CD2");
        vector.add("NE1");
        vector.add("CE2");
        vector.add("CE3");
        vector.add("CZ2");
        vector.add("CZ3");
        vector.add("CH2");
        atomNames.put("TRP", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG");
        vector.add("CD1");
        vector.add("CD2");
        vector.add("CE1");
        vector.add("CE2");
        vector.add("CZ");
        vector.add("OH");
        atomNames.put("TYR", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        vector.add("CB");
        vector.add("CG1");
        vector.add("CG2");
        atomNames.put("VAL", vector);
        vector = new Vector();
        vector.add("N");
        vector.add("CA");
        vector.add("C");
        vector.add("O");
        atomNames.put("UNK", vector);
    }

    public Vector getAtoms() {
        return this.atoms;
    }

    public String getName() {
        return this.name;
    }

    public void setAtoms(Vector vector) {
        this.atoms = vector;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addAtom(Atom atom) {
        this.atoms.addElement(atom);
    }

    public void validate() {
        boolean bl = true;
        if (this.atoms.size() == this.reference.size()) {
            for (int i = 0; i < this.atoms.size(); ++i) {
                if (((Atom)this.atoms.get(i)).getAtomName().equals(this.reference.get(i))) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl && !((Atom)this.atoms.lastElement()).getAtomName().equals("OXT")) {
            System.out.println("found nonstandard amino acid: " + this.resSeqNr + " " + this.name);
        }
    }

    public int getResSeqNr() {
        return this.resSeqNr;
    }

    public void setResSeqNr(int n) {
        this.resSeqNr = n;
    }
}

