/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Variables;
import de.grogra.vecmath.geom.Volume;
import de.grogra.vecmath.geom.VolumeBase;
import java.util.ArrayList;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public abstract class CompoundVolume
extends VolumeBase {
    public ArrayList<Volume> volumes = new ArrayList();

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        for (int i = this.volumes.size() - 1; i >= 0; --i) {
            if (!this.volumes.get(i).boxContainsBoundary(boundingBox, tuple3d, d, variables)) continue;
            return true;
        }
        return false;
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        throw new UnsupportedOperationException();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        throw new UnsupportedOperationException();
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        throw new UnsupportedOperationException();
    }

    boolean computeIntersections(Line line, boolean bl, IntersectionList intersectionList, Intersection intersection, Intersection intersection2, int n) {
        int n2;
        boolean bl2;
        int n3;
        int n4 = this.volumes.size();
        int n5 = intersectionList.size;
        int n6 = intersectionList.ienter(n4);
        int n7 = intersectionList.ienter(n4);
        int n8 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            intersectionList.istack[n6 + n3] = intersectionList.size;
            if (this.volumes.get(n3).computeIntersections(line, 0, intersectionList, intersection, intersection2)) {
                ++n8;
            }
            intersectionList.istack[n7 + n3] = intersectionList.size;
        }
        n3 = intersectionList.size;
        boolean bl3 = bl2 = n8 >= n;
        while ((n2 = CompoundVolume.findClosestVolume(intersectionList, n4, n6, n7)) >= 0) {
            int n9;
            int n10 = n6 + n2;
            intersectionList.istack[n10] = intersectionList.istack[n10] + 1;
            Intersection intersection3 = intersectionList.elements[n9];
            if (intersection3.type == 0) continue;
            n8 = intersection3.type == 1 ? ++n8 : --n8;
            if (n8 >= n == bl2) continue;
            intersectionList.addSwap(n9);
            intersection3.solid = this;
            boolean bl4 = bl2 = !bl2;
            if (bl) continue;
            break;
        }
        intersectionList.remove(n5, n3);
        intersectionList.setISize(n6);
        return bl3;
    }

    static int findClosestVolume(IntersectionList intersectionList, int n, int n2, int n3) {
        double d = Double.POSITIVE_INFINITY;
        Intersection intersection = null;
        int n4 = -1;
        for (int i = 0; i < n; ++i) {
            Intersection intersection2;
            int n5 = intersectionList.istack[n2 + i];
            if (n5 >= intersectionList.istack[n3 + i]) continue;
            intersection = intersectionList.elements[n5];
            if (!(intersection2.parameter < d)) continue;
            n4 = i;
            d = intersection.parameter;
        }
        return n4;
    }

    static void sortIntersections(boolean bl, IntersectionList intersectionList, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = intersectionList.size;
        while ((n5 = CompoundVolume.findClosestVolume(intersectionList, n2, n3, n4)) >= 0) {
            int n7;
            int n8 = n3 + n5;
            intersectionList.istack[n8] = intersectionList.istack[n8] + 1;
            intersectionList.addSwap(n7);
            if (bl) continue;
            break;
        }
        intersectionList.remove(n, n6);
        intersectionList.setISize(n3);
    }
}

