/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Line {
    public Tuple3d origin;
    public Vector3d direction;
    public double start;
    public double end;
    public float directionDensity = 1.0f;
    public float originDensity = 1.0f;
    public Color3f spectrum;
    public boolean reflected;
    public float x;
    public float y;
    public boolean valid;

    public Line() {
        this.origin = new Point3d();
        this.direction = new Vector3d();
        this.spectrum = new Color3f();
        this.start = 0.0;
        this.end = Double.POSITIVE_INFINITY;
        this.reflected = true;
    }

    public Line(Tuple3d tuple3d, Vector3d vector3d, double d, double d2) {
        this.origin = tuple3d;
        this.direction = vector3d;
        this.start = d;
        this.end = d2;
        this.reflected = true;
    }

    public void setLineAttributes(double d, double d2) {
        this.start = d;
        this.end = d2;
    }

    public double lengthSquared() {
        double d = this.end - this.start;
        return this.direction.lengthSquared() * d * d;
    }

    public double length() {
        double d = this.end - this.start;
        return this.direction.length() * d;
    }

    public double distanceSquared(Tuple3d tuple3d) {
        double d = Math2.dot(tuple3d, this.origin, this.direction) / this.direction.lengthSquared();
        if (d > this.end) {
            d = this.end;
        } else if (d < this.start) {
            d = this.start;
        }
        double d2 = this.origin.x + d * this.direction.x - tuple3d.x;
        double d3 = d2 * d2;
        d2 = this.origin.y + d * this.direction.y - tuple3d.y;
        double d4 = d3 + d2 * d2;
        d2 = this.origin.z + d * this.direction.z - tuple3d.z;
        return d4 + d2 * d2;
    }

    public double distance(Tuple3d tuple3d) {
        return Math.sqrt(this.distanceSquared(tuple3d));
    }

    public Line deepCopy() {
        Line line = new Line();
        line.direction.set(this.direction);
        line.origin.set(this.origin);
        line.start = this.start;
        line.end = this.end;
        return line;
    }

    public String toString() {
        return this.origin + " " + this.direction + " " + this.start + " " + this.end + "  valid=" + this.valid + " direcDens=" + this.directionDensity + " spec=" + this.spectrum;
    }
}

