/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class Square
extends TransformableVolume {
    public float scaleU = 1.0f;
    public float scaleV = 1.0f;

    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        double d;
        if (intersection != null && intersection.volume == this) {
            return false;
        }
        if (intersection2 != null && intersection2.volume == this) {
            return false;
        }
        Point3d point3d = intersectionList.tmpPoint0;
        this.transformPoint(line.origin, point3d);
        Vector3d vector3d = intersectionList.tmpVector0;
        this.transformVector(line.direction, vector3d);
        if (vector3d.z != 0.0 && line.start <= (d = -point3d.z / vector3d.z) && d <= line.end) {
            vector3d.scaleAdd(d, point3d);
            if (vector3d.x >= 0.0 && vector3d.x <= 1.0 && vector3d.y >= 0.0 && vector3d.y <= 1.0) {
                intersectionList.add(this, line, d, 0);
            }
        }
        return false;
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        return false;
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        tuple3d2.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        Point3d point3d = variables.tmpPoint0;
        Point3d point3d2 = variables.tmpPoint1;
        point3d.z = 0.0;
        for (int i = 0; i <= 1; ++i) {
            point3d.x = i;
            for (int j = 0; j <= 1; ++j) {
                point3d.y = j;
                this.invTransformPoint(point3d, point3d2);
                Math2.min(tuple3d, point3d2);
                Math2.max(tuple3d2, point3d2);
            }
        }
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        Point3d point3d = variables.tmpPoint0;
        Point3d point3d2 = variables.tmpPoint1;
        Point3d point3d3 = variables.tmpPoint2;
        Point3d point3d4 = variables.tmpPoint3;
        Vector3d vector3d = variables.tmpVector1;
        Vector3d vector3d2 = variables.tmpVector2;
        Matrix3d matrix3d = variables.tmpMatrix3;
        double d2 = d * this.getFrobeniusNorm() + 0.707106781187;
        this.transformPoint(tuple3d, vector3d2);
        vector3d2.x -= 0.5;
        vector3d2.y -= 0.5;
        if (vector3d2.lengthSquared() > d2 * d2) {
            return false;
        }
        Matrix3d matrix3d2 = this.getObjectToWorldRotationScale();
        point3d4.x = this.t0;
        point3d4.y = this.t1;
        point3d4.z = this.t2;
        point3d.x = matrix3d2.m00 + this.t0;
        point3d.y = matrix3d2.m10 + this.t1;
        point3d.z = matrix3d2.m20 + this.t2;
        point3d2.x = matrix3d2.m00 + matrix3d2.m01 + this.t0;
        point3d2.y = matrix3d2.m10 + matrix3d2.m11 + this.t1;
        point3d2.z = matrix3d2.m20 + matrix3d2.m21 + this.t2;
        point3d3.x = matrix3d2.m01 + this.t0;
        point3d3.y = matrix3d2.m11 + this.t1;
        point3d3.z = matrix3d2.m21 + this.t2;
        return boundingBox.testParallelogram(point3d, point3d2, point3d3, point3d4, matrix3d, vector3d, vector3d2) == -1;
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        vector3d.x = this.m20;
        vector3d.y = this.m21;
        vector3d.z = this.m22;
        vector3d.normalize();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
        Vector3d vector3d = intersection.tmpVector0;
        this.transformPoint(intersection.getPoint(), vector3d);
        vector2d.x = vector3d.x * (double)this.scaleU;
        vector2d.y = vector3d.y * (double)this.scaleV;
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
        vector3d.set(1.0f / this.scaleU, 0.0, 0.0);
        vector3d2.set(0.0, 1.0f / this.scaleV, 0.0);
        this.getObjectToWorldRotationScale().transform(vector3d);
        this.getObjectToWorldRotationScale().transform(vector3d2);
    }
}

