/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Matrix3d
implements Serializable,
Cloneable {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3d(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.set(d, d2, d3, d4, d5, d6, d7, d8, d9);
    }

    public Matrix3d(double[] dArray) {
        this.set(dArray);
    }

    public Matrix3d(Matrix3d matrix3d) {
        this.set(matrix3d);
    }

    public Matrix3d(Matrix3f matrix3f) {
        this.set(matrix3f);
    }

    public Matrix3d() {
        this.setZero();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return "[" + string + "  [" + this.m00 + "\t" + this.m01 + "\t" + this.m02 + "]" + string + "  [" + this.m10 + "\t" + this.m11 + "\t" + this.m12 + "]" + string + "  [" + this.m20 + "\t" + this.m21 + "\t" + this.m22 + "] ]";
    }

    public final void setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public final void setScale(double d) {
        this.SVD(this);
        this.m00 *= d;
        this.m11 *= d;
        this.m22 *= d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setElement(int n, int n2, double d) {
        if (n == 0) {
            if (n2 == 0) {
                this.m00 = d;
                return;
            } else if (n2 == 1) {
                this.m01 = d;
                return;
            } else {
                if (n2 != 2) throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n2);
                this.m02 = d;
            }
            return;
        } else if (n == 1) {
            if (n2 == 0) {
                this.m10 = d;
                return;
            } else if (n2 == 1) {
                this.m11 = d;
                return;
            } else {
                if (n2 != 2) throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n2);
                this.m12 = d;
            }
            return;
        } else {
            if (n != 2) throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
            if (n2 == 0) {
                this.m20 = d;
                return;
            } else if (n2 == 1) {
                this.m21 = d;
                return;
            } else {
                if (n2 != 2) throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n2);
                this.m22 = d;
            }
        }
    }

    public final double getElement(int n, int n2) {
        if (n == 0) {
            if (n2 == 0) {
                return this.m00;
            }
            if (n2 == 1) {
                return this.m01;
            }
            if (n2 == 2) {
                return this.m02;
            }
            throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n2);
        }
        if (n == 1) {
            if (n2 == 0) {
                return this.m10;
            }
            if (n2 == 1) {
                return this.m11;
            }
            if (n2 == 2) {
                return this.m12;
            }
            throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n2);
        }
        if (n == 2) {
            if (n2 == 0) {
                return this.m20;
            }
            if (n2 == 1) {
                return this.m21;
            }
            if (n2 == 2) {
                return this.m22;
            }
            throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n2);
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
    }

    public final void setRow(int n, double d, double d2, double d3) {
        if (n == 0) {
            this.m00 = d;
            this.m01 = d2;
            this.m02 = d3;
        } else if (n == 1) {
            this.m10 = d;
            this.m11 = d2;
            this.m12 = d3;
        } else if (n == 2) {
            this.m20 = d;
            this.m21 = d2;
            this.m22 = d3;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void setRow(int n, Vector3d vector3d) {
        if (n == 0) {
            this.m00 = vector3d.x;
            this.m01 = vector3d.y;
            this.m02 = vector3d.z;
        } else if (n == 1) {
            this.m10 = vector3d.x;
            this.m11 = vector3d.y;
            this.m12 = vector3d.z;
        } else if (n == 2) {
            this.m20 = vector3d.x;
            this.m21 = vector3d.y;
            this.m22 = vector3d.z;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void setRow(int n, double[] dArray) {
        if (n == 0) {
            this.m00 = dArray[0];
            this.m01 = dArray[1];
            this.m02 = dArray[2];
        } else if (n == 1) {
            this.m10 = dArray[0];
            this.m11 = dArray[1];
            this.m12 = dArray[2];
        } else if (n == 2) {
            this.m20 = dArray[0];
            this.m21 = dArray[1];
            this.m22 = dArray[2];
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void getRow(int n, double[] dArray) {
        if (n == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m01;
            dArray[2] = this.m02;
        } else if (n == 1) {
            dArray[0] = this.m10;
            dArray[1] = this.m11;
            dArray[2] = this.m12;
        } else if (n == 2) {
            dArray[0] = this.m20;
            dArray[1] = this.m21;
            dArray[2] = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void getRow(int n, Vector3d vector3d) {
        if (n == 0) {
            vector3d.x = this.m00;
            vector3d.y = this.m01;
            vector3d.z = this.m02;
        } else if (n == 1) {
            vector3d.x = this.m10;
            vector3d.y = this.m11;
            vector3d.z = this.m12;
        } else if (n == 2) {
            vector3d.x = this.m20;
            vector3d.y = this.m21;
            vector3d.z = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException("row must be 0 to 2 and is " + n);
        }
    }

    public final void setColumn(int n, double d, double d2, double d3) {
        if (n == 0) {
            this.m00 = d;
            this.m10 = d2;
            this.m20 = d3;
        } else if (n == 1) {
            this.m01 = d;
            this.m11 = d2;
            this.m21 = d3;
        } else if (n == 2) {
            this.m02 = d;
            this.m12 = d2;
            this.m22 = d3;
        } else {
            throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n);
        }
    }

    public final void setColumn(int n, Vector3d vector3d) {
        if (n == 0) {
            this.m00 = vector3d.x;
            this.m10 = vector3d.y;
            this.m20 = vector3d.z;
        } else if (n == 1) {
            this.m01 = vector3d.x;
            this.m11 = vector3d.y;
            this.m21 = vector3d.z;
        } else if (n == 2) {
            this.m02 = vector3d.x;
            this.m12 = vector3d.y;
            this.m22 = vector3d.z;
        } else {
            throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n);
        }
    }

    public final void setColumn(int n, double[] dArray) {
        if (n == 0) {
            this.m00 = dArray[0];
            this.m10 = dArray[1];
            this.m20 = dArray[2];
        } else if (n == 1) {
            this.m01 = dArray[0];
            this.m11 = dArray[1];
            this.m21 = dArray[2];
        } else if (n == 2) {
            this.m02 = dArray[0];
            this.m12 = dArray[1];
            this.m22 = dArray[2];
        } else {
            throw new ArrayIndexOutOfBoundsException("col must be 0 to 2 and is " + n);
        }
    }

    public final void getColumn(int n, Vector3d vector3d) {
        if (n == 0) {
            vector3d.x = this.m00;
            vector3d.y = this.m10;
            vector3d.z = this.m20;
        } else if (n == 1) {
            vector3d.x = this.m01;
            vector3d.y = this.m11;
            vector3d.z = this.m21;
        } else if (n == 2) {
            vector3d.x = this.m02;
            vector3d.y = this.m12;
            vector3d.z = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n);
        }
    }

    public final void getColumn(int n, double[] dArray) {
        if (n == 0) {
            dArray[0] = this.m00;
            dArray[1] = this.m10;
            dArray[2] = this.m20;
        } else if (n == 1) {
            dArray[0] = this.m01;
            dArray[1] = this.m11;
            dArray[2] = this.m21;
        } else if (n == 2) {
            dArray[0] = this.m02;
            dArray[1] = this.m12;
            dArray[2] = this.m22;
        } else {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 2 and is " + n);
        }
    }

    public final double getScale() {
        return this.SVD(null);
    }

    public final void add(double d) {
        this.m00 += d;
        this.m01 += d;
        this.m02 += d;
        this.m10 += d;
        this.m11 += d;
        this.m12 += d;
        this.m20 += d;
        this.m21 += d;
        this.m22 += d;
    }

    public final void add(double d, Matrix3d matrix3d) {
        this.set(matrix3d);
        this.add(d);
    }

    public final void add(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.set(matrix3d.m00 + matrix3d2.m00, matrix3d.m01 + matrix3d2.m01, matrix3d.m02 + matrix3d2.m02, matrix3d.m10 + matrix3d2.m10, matrix3d.m11 + matrix3d2.m11, matrix3d.m12 + matrix3d2.m12, matrix3d.m20 + matrix3d2.m20, matrix3d.m21 + matrix3d2.m21, matrix3d.m22 + matrix3d2.m22);
    }

    public final void add(Matrix3d matrix3d) {
        this.m00 += matrix3d.m00;
        this.m01 += matrix3d.m01;
        this.m02 += matrix3d.m02;
        this.m10 += matrix3d.m10;
        this.m11 += matrix3d.m11;
        this.m12 += matrix3d.m12;
        this.m20 += matrix3d.m20;
        this.m21 += matrix3d.m21;
        this.m22 += matrix3d.m22;
    }

    public final void sub(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.set(matrix3d.m00 - matrix3d2.m00, matrix3d.m01 - matrix3d2.m01, matrix3d.m02 - matrix3d2.m02, matrix3d.m10 - matrix3d2.m10, matrix3d.m11 - matrix3d2.m11, matrix3d.m12 - matrix3d2.m12, matrix3d.m20 - matrix3d2.m20, matrix3d.m21 - matrix3d2.m21, matrix3d.m22 - matrix3d2.m22);
    }

    public final void sub(Matrix3d matrix3d) {
        this.m00 -= matrix3d.m00;
        this.m01 -= matrix3d.m01;
        this.m02 -= matrix3d.m02;
        this.m10 -= matrix3d.m10;
        this.m11 -= matrix3d.m11;
        this.m12 -= matrix3d.m12;
        this.m20 -= matrix3d.m20;
        this.m21 -= matrix3d.m21;
        this.m22 -= matrix3d.m22;
    }

    public final void transpose() {
        double d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        d = this.m02;
        this.m02 = this.m20;
        this.m20 = d;
        d = this.m12;
        this.m12 = this.m21;
        this.m21 = d;
    }

    public final void transpose(Matrix3d matrix3d) {
        this.set(matrix3d);
        this.transpose();
    }

    public final void set(Quat4d quat4d) {
        this.setFromQuat(quat4d.x, quat4d.y, quat4d.z, quat4d.w);
    }

    public final void set(AxisAngle4d axisAngle4d) {
        this.setFromAxisAngle(axisAngle4d.x, axisAngle4d.y, axisAngle4d.z, axisAngle4d.angle);
    }

    public final void set(Quat4f quat4f) {
        this.setFromQuat(quat4f.x, quat4f.y, quat4f.z, quat4f.w);
    }

    public final void set(AxisAngle4f axisAngle4f) {
        this.setFromAxisAngle(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z, axisAngle4f.angle);
    }

    public final void set(Matrix3d matrix3d) {
        this.m00 = matrix3d.m00;
        this.m01 = matrix3d.m01;
        this.m02 = matrix3d.m02;
        this.m10 = matrix3d.m10;
        this.m11 = matrix3d.m11;
        this.m12 = matrix3d.m12;
        this.m20 = matrix3d.m20;
        this.m21 = matrix3d.m21;
        this.m22 = matrix3d.m22;
    }

    public final void set(Matrix3f matrix3f) {
        this.m00 = matrix3f.m00;
        this.m01 = matrix3f.m01;
        this.m02 = matrix3f.m02;
        this.m10 = matrix3f.m10;
        this.m11 = matrix3f.m11;
        this.m12 = matrix3f.m12;
        this.m20 = matrix3f.m20;
        this.m21 = matrix3f.m21;
        this.m22 = matrix3f.m22;
    }

    public final void set(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public final void invert(Matrix3d matrix3d) {
        this.set(matrix3d);
        this.invert();
    }

    public final void invert() {
        double d = this.determinant();
        if (d == 0.0) {
            return;
        }
        d = 1.0 / d;
        this.set(this.m11 * this.m22 - this.m12 * this.m21, this.m02 * this.m21 - this.m01 * this.m22, this.m01 * this.m12 - this.m02 * this.m11, this.m12 * this.m20 - this.m10 * this.m22, this.m00 * this.m22 - this.m02 * this.m20, this.m02 * this.m10 - this.m00 * this.m12, this.m10 * this.m21 - this.m11 * this.m20, this.m01 * this.m20 - this.m00 * this.m21, this.m00 * this.m11 - this.m01 * this.m10);
        this.mul(d);
    }

    public final double determinant() {
        return this.m00 * (this.m11 * this.m22 - this.m21 * this.m12) - this.m01 * (this.m10 * this.m22 - this.m20 * this.m12) + this.m02 * (this.m10 * this.m21 - this.m20 * this.m11);
    }

    public final void set(double d) {
        this.m00 = d;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = d;
    }

    public final void rotX(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d2;
        this.m12 = -d3;
        this.m20 = 0.0;
        this.m21 = d3;
        this.m22 = d2;
    }

    public final void rotY(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = d3;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = -d3;
        this.m21 = 0.0;
        this.m22 = d2;
    }

    public final void rotZ(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = -d3;
        this.m02 = 0.0;
        this.m10 = d3;
        this.m11 = d2;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public final void mul(double d) {
        this.m00 *= d;
        this.m01 *= d;
        this.m02 *= d;
        this.m10 *= d;
        this.m11 *= d;
        this.m12 *= d;
        this.m20 *= d;
        this.m21 *= d;
        this.m22 *= d;
    }

    public final void mul(double d, Matrix3d matrix3d) {
        this.set(matrix3d);
        this.mul(d);
    }

    public final void mul(Matrix3d matrix3d) {
        this.mul(this, matrix3d);
    }

    public final void mul(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.set(matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m10 + matrix3d.m02 * matrix3d2.m20, matrix3d.m00 * matrix3d2.m01 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m21, matrix3d.m00 * matrix3d2.m02 + matrix3d.m01 * matrix3d2.m12 + matrix3d.m02 * matrix3d2.m22, matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m12 * matrix3d2.m20, matrix3d.m10 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m21, matrix3d.m10 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m12 * matrix3d2.m22, matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20, matrix3d.m20 * matrix3d2.m01 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21, matrix3d.m20 * matrix3d2.m02 + matrix3d.m21 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22);
    }

    public final void mulNormalize(Matrix3d matrix3d) {
        this.mul(matrix3d);
        this.SVD(this);
    }

    public final void mulNormalize(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.mul(matrix3d, matrix3d2);
        this.SVD(this);
    }

    public final void mulTransposeBoth(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.mul(matrix3d2, matrix3d);
        this.transpose();
    }

    public final void mulTransposeRight(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.set(matrix3d.m00 * matrix3d2.m00 + matrix3d.m01 * matrix3d2.m01 + matrix3d.m02 * matrix3d2.m02, matrix3d.m00 * matrix3d2.m10 + matrix3d.m01 * matrix3d2.m11 + matrix3d.m02 * matrix3d2.m12, matrix3d.m00 * matrix3d2.m20 + matrix3d.m01 * matrix3d2.m21 + matrix3d.m02 * matrix3d2.m22, matrix3d.m10 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m02, matrix3d.m10 * matrix3d2.m10 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m12 * matrix3d2.m12, matrix3d.m10 * matrix3d2.m20 + matrix3d.m11 * matrix3d2.m21 + matrix3d.m12 * matrix3d2.m22, matrix3d.m20 * matrix3d2.m00 + matrix3d.m21 * matrix3d2.m01 + matrix3d.m22 * matrix3d2.m02, matrix3d.m20 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m12, matrix3d.m20 * matrix3d2.m20 + matrix3d.m21 * matrix3d2.m21 + matrix3d.m22 * matrix3d2.m22);
    }

    public final void mulTransposeLeft(Matrix3d matrix3d, Matrix3d matrix3d2) {
        this.set(matrix3d.m00 * matrix3d2.m00 + matrix3d.m10 * matrix3d2.m10 + matrix3d.m20 * matrix3d2.m20, matrix3d.m00 * matrix3d2.m01 + matrix3d.m10 * matrix3d2.m11 + matrix3d.m20 * matrix3d2.m21, matrix3d.m00 * matrix3d2.m02 + matrix3d.m10 * matrix3d2.m12 + matrix3d.m20 * matrix3d2.m22, matrix3d.m01 * matrix3d2.m00 + matrix3d.m11 * matrix3d2.m10 + matrix3d.m21 * matrix3d2.m20, matrix3d.m01 * matrix3d2.m01 + matrix3d.m11 * matrix3d2.m11 + matrix3d.m21 * matrix3d2.m21, matrix3d.m01 * matrix3d2.m02 + matrix3d.m11 * matrix3d2.m12 + matrix3d.m21 * matrix3d2.m22, matrix3d.m02 * matrix3d2.m00 + matrix3d.m12 * matrix3d2.m10 + matrix3d.m22 * matrix3d2.m20, matrix3d.m02 * matrix3d2.m01 + matrix3d.m12 * matrix3d2.m11 + matrix3d.m22 * matrix3d2.m21, matrix3d.m02 * matrix3d2.m02 + matrix3d.m12 * matrix3d2.m12 + matrix3d.m22 * matrix3d2.m22);
    }

    public final void normalize() {
        this.SVD(this);
    }

    public final void normalize(Matrix3d matrix3d) {
        this.set(matrix3d);
        this.SVD(this);
    }

    public final void normalizeCP() {
        double d = Math.pow(Math.abs(this.determinant()), -0.3333333333333333);
        this.mul(d);
    }

    public final void normalizeCP(Matrix3d matrix3d) {
        this.set(matrix3d);
        this.normalizeCP();
    }

    public boolean equals(Matrix3d matrix3d) {
        return matrix3d != null && this.m00 == matrix3d.m00 && this.m01 == matrix3d.m01 && this.m02 == matrix3d.m02 && this.m10 == matrix3d.m10 && this.m11 == matrix3d.m11 && this.m12 == matrix3d.m12 && this.m20 == matrix3d.m20 && this.m21 == matrix3d.m21 && this.m22 == matrix3d.m22;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Matrix3d && this.equals((Matrix3d)object);
    }

    public boolean epsilonEquals(Matrix3d matrix3d, double d) {
        return Math.abs(this.m00 - matrix3d.m00) <= d && Math.abs(this.m01 - matrix3d.m01) <= d && Math.abs(this.m02 - matrix3d.m02) <= d && Math.abs(this.m10 - matrix3d.m10) <= d && Math.abs(this.m11 - matrix3d.m11) <= d && Math.abs(this.m12 - matrix3d.m12) <= d && Math.abs(this.m20 - matrix3d.m20) <= d && Math.abs(this.m21 - matrix3d.m21) <= d && Math.abs(this.m22 - matrix3d.m22) <= d;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.m00);
        int n = (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m01);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m02);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m10);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m11);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m12);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m20);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m21);
        n ^= (int)(l ^ l >> 32);
        l = Double.doubleToLongBits(this.m22);
        return n ^= (int)(l ^ l >> 32);
    }

    public final void setZero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
    }

    public final void negate() {
        this.m00 = -this.m00;
        this.m01 = -this.m01;
        this.m02 = -this.m02;
        this.m10 = -this.m10;
        this.m11 = -this.m11;
        this.m12 = -this.m12;
        this.m20 = -this.m20;
        this.m21 = -this.m21;
        this.m22 = -this.m22;
    }

    public final void negate(Matrix3d matrix3d) {
        this.set(matrix3d);
        this.negate();
    }

    public final void transform(Tuple3d tuple3d) {
        this.transform(tuple3d, tuple3d);
    }

    public final void transform(Tuple3d tuple3d, Tuple3d tuple3d2) {
        tuple3d2.set(this.m00 * tuple3d.x + this.m01 * tuple3d.y + this.m02 * tuple3d.z, this.m10 * tuple3d.x + this.m11 * tuple3d.y + this.m12 * tuple3d.z, this.m20 * tuple3d.x + this.m21 * tuple3d.y + this.m22 * tuple3d.z);
    }

    private void set(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    private double SVD(Matrix3d matrix3d) {
        double d = Math.sqrt((this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20 + this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21 + this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22) / 3.0);
        if (matrix3d != null) {
            double d2 = 1.0 / Math.sqrt(this.m00 * this.m00 + this.m10 * this.m10 + this.m20 * this.m20);
            matrix3d.m00 = this.m00 * d2;
            matrix3d.m10 = this.m10 * d2;
            matrix3d.m20 = this.m20 * d2;
            d2 = 1.0 / Math.sqrt(this.m01 * this.m01 + this.m11 * this.m11 + this.m21 * this.m21);
            matrix3d.m01 = this.m01 * d2;
            matrix3d.m11 = this.m11 * d2;
            matrix3d.m21 = this.m21 * d2;
            d2 = 1.0 / Math.sqrt(this.m02 * this.m02 + this.m12 * this.m12 + this.m22 * this.m22);
            matrix3d.m02 = this.m02 * d2;
            matrix3d.m12 = this.m12 * d2;
            matrix3d.m22 = this.m22 * d2;
        }
        return d;
    }

    private void setFromQuat(double d, double d2, double d3, double d4) {
        double d5 = d * d + d2 * d2 + d3 * d3 + d4 * d4;
        double d6 = d5 > 0.0 ? 2.0 / d5 : 0.0;
        double d7 = d * d6;
        double d8 = d2 * d6;
        double d9 = d3 * d6;
        double d10 = d4 * d7;
        double d11 = d4 * d8;
        double d12 = d4 * d9;
        double d13 = d * d7;
        double d14 = d * d8;
        double d15 = d * d9;
        double d16 = d2 * d8;
        double d17 = d2 * d9;
        double d18 = d3 * d9;
        this.m00 = 1.0 - (d16 + d18);
        this.m01 = d14 - d12;
        this.m02 = d15 + d11;
        this.m10 = d14 + d12;
        this.m11 = 1.0 - (d13 + d18);
        this.m12 = d17 - d10;
        this.m20 = d15 - d11;
        this.m21 = d17 + d10;
        this.m22 = 1.0 - (d13 + d16);
    }

    private void setFromAxisAngle(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        d5 = 1.0 / d5;
        d *= d5;
        d2 *= d5;
        d3 *= d5;
        double d6 = Math.cos(d4);
        double d7 = Math.sin(d4);
        double d8 = 1.0 - d6;
        this.m00 = d6 + d * d * d8;
        this.m11 = d6 + d2 * d2 * d8;
        this.m22 = d6 + d3 * d3 * d8;
        double d9 = d * d2 * d8;
        double d10 = d3 * d7;
        this.m01 = d9 - d10;
        this.m10 = d9 + d10;
        d9 = d * d3 * d8;
        d10 = d2 * d7;
        this.m02 = d9 + d10;
        this.m20 = d9 - d10;
        d9 = d2 * d3 * d8;
        d10 = d * d7;
        this.m12 = d9 - d10;
        this.m21 = d9 + d10;
    }

    public Object clone() {
        return new Matrix3d(this);
    }
}

