/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;

public class Quat4f
extends Tuple4f
implements Serializable {
    public Quat4f(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    public Quat4f(float[] fArray) {
        super(fArray);
    }

    public Quat4f(Quat4f quat4f) {
        super(quat4f);
    }

    public Quat4f(Quat4d quat4d) {
        super(quat4d);
    }

    public Quat4f(Tuple4d tuple4d) {
        super(tuple4d);
    }

    public Quat4f(Tuple4f tuple4f) {
        super(tuple4f);
    }

    public Quat4f() {
    }

    public final void conjugate(Quat4f quat4f) {
        this.x = -quat4f.x;
        this.y = -quat4f.y;
        this.z = -quat4f.z;
        this.w = quat4f.w;
    }

    public final void conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void mul(Quat4f quat4f, Quat4f quat4f2) {
        this.set(quat4f.x * quat4f2.w + quat4f.w * quat4f2.x + quat4f.y * quat4f2.z - quat4f.z * quat4f2.y, quat4f.y * quat4f2.w + quat4f.w * quat4f2.y + quat4f.z * quat4f2.x - quat4f.x * quat4f2.z, quat4f.z * quat4f2.w + quat4f.w * quat4f2.z + quat4f.x * quat4f2.y - quat4f.y * quat4f2.x, quat4f.w * quat4f2.w - quat4f.x * quat4f2.x - quat4f.y * quat4f2.y - quat4f.z * quat4f2.z);
    }

    public final void mul(Quat4f quat4f) {
        this.set(this.x * quat4f.w + this.w * quat4f.x + this.y * quat4f.z - this.z * quat4f.y, this.y * quat4f.w + this.w * quat4f.y + this.z * quat4f.x - this.x * quat4f.z, this.z * quat4f.w + this.w * quat4f.z + this.x * quat4f.y - this.y * quat4f.x, this.w * quat4f.w - this.x * quat4f.x - this.y * quat4f.y - this.z * quat4f.z);
    }

    public final void mulInverse(Quat4f quat4f, Quat4f quat4f2) {
        double d = this.norm();
        d = d == 0.0 ? d : 1.0 / d;
        this.set((float)((double)(quat4f.x * quat4f2.w - quat4f.w * quat4f2.x - quat4f.y * quat4f2.z + quat4f.z * quat4f2.y) * d), (float)((double)(quat4f.y * quat4f2.w - quat4f.w * quat4f2.y - quat4f.z * quat4f2.x + quat4f.x * quat4f2.z) * d), (float)((double)(quat4f.z * quat4f2.w - quat4f.w * quat4f2.z - quat4f.x * quat4f2.y + quat4f.y * quat4f2.x) * d), (float)((double)(quat4f.w * quat4f2.w + quat4f.x * quat4f2.x + quat4f.y * quat4f2.y + quat4f.z * quat4f2.z) * d));
    }

    public final void mulInverse(Quat4f quat4f) {
        double d = this.norm();
        d = d == 0.0 ? d : 1.0 / d;
        this.set((float)((double)(this.x * quat4f.w - this.w * quat4f.x - this.y * quat4f.z + this.z * quat4f.y) * d), (float)((double)(this.y * quat4f.w - this.w * quat4f.y - this.z * quat4f.x + this.x * quat4f.z) * d), (float)((double)(this.z * quat4f.w - this.w * quat4f.z - this.x * quat4f.y + this.y * quat4f.x) * d), (float)((double)(this.w * quat4f.w + this.x * quat4f.x + this.y * quat4f.y + this.z * quat4f.z) * d));
    }

    private final double norm() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public final void inverse(Quat4f quat4f) {
        double d = quat4f.norm();
        this.x = (float)((double)(-quat4f.x) / d);
        this.y = (float)((double)(-quat4f.y) / d);
        this.z = (float)((double)(-quat4f.z) / d);
        this.w = (float)((double)quat4f.w / d);
    }

    public final void inverse() {
        double d = this.norm();
        this.x = (float)((double)(-this.x) / d);
        this.y = (float)((double)(-this.y) / d);
        this.z = (float)((double)(-this.z) / d);
        this.w = (float)((double)this.w / d);
    }

    public final void normalize(Quat4f quat4f) {
        double d = Math.sqrt(quat4f.norm());
        this.x = (float)((double)quat4f.x / d);
        this.y = (float)((double)quat4f.y / d);
        this.z = (float)((double)quat4f.z / d);
        this.w = (float)((double)quat4f.w / d);
    }

    public final void normalize() {
        float f = (float)Math.sqrt(this.norm());
        this.x /= f;
        this.y /= f;
        this.z /= f;
        this.w /= f;
    }

    public final void set(Matrix4f matrix4f) {
        this.setFromMat(matrix4f.m00, matrix4f.m01, matrix4f.m02, matrix4f.m10, matrix4f.m11, matrix4f.m12, matrix4f.m20, matrix4f.m21, matrix4f.m22);
    }

    public final void set(Matrix4d matrix4d) {
        this.setFromMat(matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m20, matrix4d.m21, matrix4d.m22);
    }

    public final void set(Matrix3f matrix3f) {
        this.setFromMat(matrix3f.m00, matrix3f.m01, matrix3f.m02, matrix3f.m10, matrix3f.m11, matrix3f.m12, matrix3f.m20, matrix3f.m21, matrix3f.m22);
    }

    public final void set(Matrix3d matrix3d) {
        this.setFromMat(matrix3d.m00, matrix3d.m01, matrix3d.m02, matrix3d.m10, matrix3d.m11, matrix3d.m12, matrix3d.m20, matrix3d.m21, matrix3d.m22);
    }

    public final void set(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        float f = (float)(Math.sin(0.5 * (double)axisAngle4f.angle) / d);
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w = (float)Math.cos(0.5 * (double)axisAngle4f.angle);
    }

    public final void set(AxisAngle4d axisAngle4d) {
        this.x = (float)axisAngle4d.x;
        this.y = (float)axisAngle4d.y;
        this.z = (float)axisAngle4d.z;
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        float f = (float)(Math.sin(0.5 * axisAngle4d.angle) / d);
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w = (float)Math.cos(0.5 * axisAngle4d.angle);
    }

    public final void interpolate(Quat4f quat4f, double d) {
        this.normalize();
        double d2 = Math.sqrt(quat4f.norm());
        double d3 = (double)quat4f.x / d2;
        double d4 = (double)quat4f.y / d2;
        double d5 = (double)quat4f.z / d2;
        double d6 = (double)quat4f.w / d2;
        double d7 = (double)this.x * d3 + (double)this.y * d4 + (double)this.z * d5 + (double)this.w * d6;
        if (1.0 <= Math.abs(d7)) {
            return;
        }
        double d8 = Math.sin(d7 = Math.acos(d7));
        if (d8 == 0.0) {
            return;
        }
        double d9 = Math.sin((1.0 - d) * d7) / d8;
        d7 = Math.sin(d * d7) / d8;
        this.x = (float)(d9 * (double)this.x + d7 * d3);
        this.y = (float)(d9 * (double)this.y + d7 * d4);
        this.z = (float)(d9 * (double)this.z + d7 * d5);
        this.w = (float)(d9 * (double)this.w + d7 * d6);
    }

    public final void interpolate(Quat4f quat4f, Quat4f quat4f2, double d) {
        this.set(quat4f);
        this.interpolate(quat4f2, d);
    }

    private void setFromMat(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d + d5 + d9;
        if (d10 >= 0.0) {
            double d11 = Math.sqrt(d10 + 1.0);
            this.w = (float)(d11 * 0.5);
            d11 = 0.5 / d11;
            this.x = (float)((d8 - d6) * d11);
            this.y = (float)((d3 - d7) * d11);
            this.z = (float)((d4 - d2) * d11);
        } else {
            double d12 = Math.max(Math.max(d, d5), d9);
            if (d12 == d) {
                double d13 = Math.sqrt(d - (d5 + d9) + 1.0);
                this.x = (float)(d13 * 0.5);
                d13 = 0.5 / d13;
                this.y = (float)((d2 + d4) * d13);
                this.z = (float)((d7 + d3) * d13);
                this.w = (float)((d8 - d6) * d13);
            } else if (d12 == d5) {
                double d14 = Math.sqrt(d5 - (d9 + d) + 1.0);
                this.y = (float)(d14 * 0.5);
                d14 = 0.5 / d14;
                this.z = (float)((d6 + d8) * d14);
                this.x = (float)((d2 + d4) * d14);
                this.w = (float)((d3 - d7) * d14);
            } else {
                double d15 = Math.sqrt(d9 - (d + d5) + 1.0);
                this.z = (float)(d15 * 0.5);
                d15 = 0.5 / d15;
                this.x = (float)((d7 + d3) * d15);
                this.y = (float)((d6 + d8) * d15);
                this.w = (float)((d4 - d2) * d15);
            }
        }
    }

    public Object clone() {
        return new Quat4f(this);
    }
}

