/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.povray;

import de.grogra.ext.povray.POVAttribute;
import de.grogra.ext.povray.POVExport;
import de.grogra.ext.povray.POVWriter;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.ParallelProjection;
import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.imp3d.Projection;
import de.grogra.imp3d.objects.SceneTreeWithShader;
import de.grogra.vecmath.Math2;
import java.io.IOException;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class POVCamera
extends POVAttribute {
    public POVCamera() {
        super("camera");
    }

    protected void exportImpl(Object object, SceneTreeWithShader.Leaf leaf, POVExport pOVExport) throws IOException {
        Projection projection;
        Camera camera = (Camera)object;
        Matrix4d matrix4d = pOVExport.pool.m4d0;
        Math2.invertAffine((Matrix4d)camera.getWorldToViewTransformation(), (Matrix4d)matrix4d);
        Vector3d vector3d = pOVExport.pool.v3d0;
        Vector3d vector3d2 = pOVExport.pool.v3d1;
        Vector3d vector3d3 = pOVExport.pool.v3d2;
        vector3d.set(1.0, 0.0, 0.0);
        vector3d2.set(0.0, 1.0, 0.0);
        vector3d3.set(0.0, 0.0, -1.0);
        matrix4d.transform(vector3d);
        matrix4d.transform(vector3d2);
        matrix4d.transform(vector3d3);
        POVWriter pOVWriter = pOVExport.out;
        if (camera instanceof Camera) {
            projection = camera.getProjection();
            vector3d.scale((double)(2.0f / projection.getScaleX()));
            vector3d2.scale((double)(2.0f / projection.getScaleY()));
            if (projection instanceof ParallelProjection) {
                pOVWriter.print("orthographic");
                pOVWriter.println();
            } else if (projection instanceof PerspectiveProjection) {
                pOVWriter.print("perspective");
                pOVWriter.println();
            }
        } else {
            projection = null;
        }
        pOVWriter.print("location ");
        pOVWriter.print((float)matrix4d.m03, (float)matrix4d.m13, (float)matrix4d.m23);
        pOVWriter.println();
        pOVWriter.print("right ");
        pOVWriter.print((Tuple3d)vector3d);
        pOVWriter.println();
        pOVWriter.print("up ");
        float f = ((Float)pOVExport.getMetaData(POVExport.ASPECT, Float.valueOf(-1.0f))).floatValue();
        if (f > 0.0f) {
            pOVWriter.print(1.0f / f);
        } else {
            pOVWriter.write("(image_height/image_width)");
        }
        pOVWriter.write(42);
        pOVWriter.print((Tuple3d)vector3d2);
        pOVWriter.println();
        pOVWriter.print("direction ");
        pOVWriter.print((Tuple3d)vector3d3);
        pOVWriter.println();
        if (projection instanceof PerspectiveProjection) {
            pOVWriter.print("angle ");
            pOVWriter.print(((PerspectiveProjection)projection).getFieldOfView() * 57.295776f);
            pOVWriter.println();
        }
    }
}

