/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.povray;

import de.grogra.ext.povray.POVNode;
import de.grogra.ext.povray.POVPhong;
import de.grogra.ext.povray.POVWriter;
import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.imp.ExternalRenderer;
import de.grogra.imp.IMP;
import de.grogra.imp.View;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.View3D;
import de.grogra.imp3d.io.SceneGraphExport;
import de.grogra.imp3d.objects.Attributes;
import de.grogra.imp3d.objects.DirectionalLight;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.objects.PointLight;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.objects.SceneTreeWithShader;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.objects.SpotLight;
import de.grogra.imp3d.shading.Light;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.SideSwitchShader;
import de.grogra.math.ChannelMap;
import de.grogra.math.Pool;
import de.grogra.math.Tuple3fType;
import de.grogra.pf.io.FileWriterSource;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.StreamAdapter;
import de.grogra.pf.io.WriterSource;
import de.grogra.pf.ui.Context;
import de.grogra.util.MimeType;
import de.grogra.util.StringMap;
import de.grogra.vfs.FileSystem;
import de.grogra.vfs.LocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;

public class POVExport
extends SceneGraphExport
implements FileWriterSource,
WriterSource {
    public static final FilterSource.MetaDataKey<Float> FLATNESS = new FilterSource.MetaDataKey("flatness");
    public static final FilterSource.MetaDataKey<Boolean> LAYERS = new FilterSource.MetaDataKey("layers");
    public static final FilterSource.MetaDataKey<Float> ASPECT = new FilterSource.MetaDataKey("aspect");
    public static final FilterSource.MetaDataKey<Boolean> TEMPORARY = new FilterSource.MetaDataKey("temporary");
    public final Pool pool = new Pool();
    POVWriter out;
    private final Map declaredObjects = new IdentityHashMap();
    private final StringMap declaredNames = new StringMap(64, true);
    public static final MimeType MIME_TYPE = new MimeType("model/x-pov", null);
    public static final IOFlavor FLAVOR = new IOFlavor(MIME_TYPE, 64, null);
    private Object sky;
    private boolean skyIsNode;
    private boolean hasLights;
    private String objectType;
    POVNode phongNode;
    ChannelMap phongMapping;
    final Color3f tmpColor = new Color3f();
    private File outFile;
    private Collection<File> files;
    boolean temporary;
    public final PolygonArray polygons = new PolygonArray();
    private static final SceneGraphExport.NodeExport LIGHT_EXPORT = new POVNode("light_source"){

        protected void exportImpl(Object object, SceneTreeWithShader.Leaf leaf, POVExport pOVExport) throws IOException {
            pOVExport.hasLights = true;
            pOVExport.exportLight((Light)leaf.getObject(Attributes.LIGHT));
        }

        protected void exportFooter(Object object, SceneTreeWithShader.Leaf leaf, SceneTree.InnerNode innerNode, POVExport pOVExport) throws IOException {
            this.exportTransform(leaf, innerNode, pOVExport);
        }
    };
    private static final SceneGraphExport.NodeExport POLYGONIZABLE_EXPORT = new POVNode("mesh2", "object"){

        protected boolean shouldDeclareObject(Object object) {
            return !((ContextDependent)object).dependsOnContext() && super.shouldDeclareObject(object);
        }

        public void export(SceneTree.Leaf leaf, SceneTree.InnerNode innerNode, SceneGraphExport sceneGraphExport) throws IOException {
            sceneGraphExport.getGraphState().setObjectContext(leaf.object, leaf.asNode);
            ContextDependent contextDependent = ((Polygonizable)leaf.getObject(Attributes.SHAPE)).getPolygonizableSource(sceneGraphExport.getGraphState());
            if (contextDependent != null) {
                this.export(contextDependent, (SceneTreeWithShader.Leaf)leaf, innerNode, null, (POVExport)sceneGraphExport);
            }
        }

        protected void exportImpl(Object object, SceneTreeWithShader.Leaf leaf, POVExport pOVExport) throws IOException {
            GraphState graphState = pOVExport.getGraphState();
            graphState.setObjectContext(leaf.object, leaf.asNode);
            ((Polygonizable)leaf.getObject(Attributes.SHAPE)).getPolygonization().polygonize((ContextDependent)object, graphState, pOVExport.polygons, 3, ((Float)pOVExport.getMetaData(FLATNESS, Float.valueOf(1.0f))).floatValue());
            pOVExport.exportPolygons();
        }
    };
    private final float[] ftmp = new float[3];

    public POVExport(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    protected SceneTree createSceneTree(View3D view3D) {
        SceneTreeWithShader sceneTreeWithShader = new SceneTreeWithShader(view3D){

            protected boolean acceptLeaf(Object object, boolean bl) {
                return POVExport.this.getExportFor(object, bl) != null;
            }

            protected SceneTree.Leaf createLeaf(Object object, boolean bl, long l) {
                SceneTreeWithShader.Leaf leaf = new SceneTreeWithShader.Leaf(object, bl, l);
                this.init((SceneTree.Leaf)leaf);
                return leaf;
            }
        };
        sceneTreeWithShader.createTree(true, ((Boolean)this.getMetaData(LAYERS, true)).booleanValue());
        return sceneTreeWithShader;
    }

    protected void beginGroup(SceneTree.InnerNode innerNode) throws IOException {
        String string;
        switch (innerNode.flags & 7) {
            case 0: {
                string = "merge{";
                break;
            }
            case 1: {
                string = "intersection{";
                break;
            }
            case 2: {
                string = "difference{";
                break;
            }
            default: {
                string = "union{";
            }
        }
        this.out.print(string);
        this.out.println();
        this.out.indent();
    }

    protected void endGroup(SceneTree.InnerNode innerNode) throws IOException {
        this.out.print(innerNode);
        this.out.println();
        this.out.unindent();
        this.out.print('}');
        this.out.println();
    }

    protected FileSystem initFileSystem() throws IOException {
        return new LocalFileSystem(null, this.outFile.getParentFile());
    }

    protected Object initDirectory() throws IOException {
        File file = new File(this.outFile.getParentFile(), this.outFile.getName() + "-files");
        if (!file.isDirectory()) {
            if (file.exists()) {
                file.delete();
            }
            file.mkdir();
            if (!file.isDirectory()) {
                throw new IOException("Cannot create directory " + file);
            }
            if (this.files != null) {
                this.files.add(file);
            }
            if (this.temporary) {
                file.deleteOnExit();
            }
        }
        return file;
    }

    public Object getFile(String string) throws IOException {
        File file = (File)super.getFile(string);
        if (this.files != null) {
            this.files.add(file);
        }
        if (this.temporary) {
            file.deleteOnExit();
        }
        return file;
    }

    protected void write() throws IOException {
        this.out.print("#version 3.5;");
        this.out.println();
        super.write();
    }

    public void write(File file) throws IOException {
        this.outFile = file;
        this.files = (Collection)this.getMetaData(ExternalRenderer.FILELIST, null);
        this.temporary = (Boolean)this.getMetaData(TEMPORARY, false);
        StreamAdapter.write((WriterSource)this, (File)file);
    }

    public void write(Writer writer) throws IOException {
        Object object;
        Matrix4d matrix4d;
        this.out = new POVWriter(writer);
        this.write();
        if (this.sky != null) {
            this.out.print("sky_sphere{rotate <90,0,0>");
            this.out.println();
            this.out.indent();
            matrix4d = ((Sky)this.getGraphState().getObjectDefault(this.sky, this.skyIsNode, Attributes.SHAPE, null)).getShader();
            object = matrix4d instanceof SideSwitchShader ? ((SideSwitchShader)matrix4d).getFrontShader() : (matrix4d instanceof Phong ? matrix4d : null);
            if (!(object instanceof Phong) || !POVPhong.exportChannelMap(((Phong)object).getDiffuse(), this, "pigment", "image_map", 1, "")) {
                this.out.print("pigment{color rgbt");
                this.out.printRGBT(matrix4d != null ? matrix4d.getAverageColor() : -8355585);
                this.out.write("}");
            }
            this.out.println();
            Matrix4d matrix4d2 = this.pool.m4d0;
            GlobalTransformation.get((Object)this.sky, (boolean)this.skyIsNode, (GraphState)this.getGraphState(), (boolean)false).get(matrix4d2);
            matrix4d2.get(this.pool.m3f0);
            this.out.print(this.pool.m3f0);
            this.out.println();
            this.out.unindent();
            this.out.print('}');
            this.out.println();
        }
        if (!this.hasLights) {
            matrix4d = new Matrix4d();
            object = this.getView().getDefaultLight(matrix4d);
            this.out.print("light_source");
            this.out.write(123);
            this.out.println();
            this.out.indent();
            this.exportLight((Light)object);
            this.out.print(matrix4d);
            this.out.unindent();
            this.out.print('}');
            this.out.println();
        }
        this.export(this.getView().getCamera());
    }

    public String getDeclaredName(Object object) {
        return (String)this.declaredObjects.get(object);
    }

    public String declareObject(Object object, String string) {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            string = object.getClass().getName();
            stringBuffer.append(string);
            stringBuffer.delete(0, string.lastIndexOf(46) + 1);
        } else {
            stringBuffer.append(string);
        }
        int n2 = stringBuffer.length();
        for (n = 0; n < n2; ++n) {
            c = stringBuffer.charAt(n);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_') continue;
            stringBuffer.setCharAt(n, '_');
        }
        if (n2 == 0) {
            stringBuffer.append("Unnamed");
        } else {
            c = stringBuffer.charAt(0);
            if (c >= 'a' && c <= 'z') {
                stringBuffer.setCharAt(0, Character.toUpperCase(c));
            } else if (c < 'A' || c > 'Z') {
                stringBuffer.insert(0, "X_");
            }
        }
        n = -1;
        string = stringBuffer.toString();
        while (this.declaredNames.get(string) != null) {
            string = stringBuffer.append(++n).toString();
            stringBuffer.setLength(n2);
        }
        this.declaredNames.put(string, (Object)Boolean.TRUE);
        this.declaredObjects.put(object, string);
        return string;
    }

    public void exportPolygons() throws IOException {
        if (this.polygons.polygons.isEmpty()) {
            this.out.print("vertex_vectors{1,0} face_indices{1,0}");
            this.out.println();
        } else {
            this.print(this.out, "vertex_vectors{", this.polygons.vertices.elements, null, this.polygons.vertices.size, this.polygons.dimension, false);
            this.print(this.out, "normal_vectors{", null, this.polygons, this.polygons.normals.size / 3, 1, false);
            if (!this.polygons.uv.isEmpty()) {
                this.print(this.out, "uv_vectors{", this.polygons.uv.elements, null, this.polygons.uv.size, 2, true);
            }
            POVExport.printFaces(this.out, "face_indices{", this.polygons);
        }
    }

    void exportLight(Light light) throws IOException {
        this.out.print("0, color rgb");
        Tuple3fType.setColor((Tuple3f)this.tmpColor, (int)light.getAverageColor());
        this.out.print((Tuple3f)this.tmpColor);
        if (light.isShadowless()) {
            this.out.write(" shadowless");
        }
        this.out.println();
        if (light instanceof PointLight) {
            float f;
            if (light instanceof SpotLight) {
                SpotLight spotLight = (SpotLight)light;
                this.out.print("spotlight radius ");
                this.out.print(spotLight.getInnerAngle() * 57.29578f);
                this.out.write(" falloff ");
                this.out.print(spotLight.getOuterAngle() * 57.29578f);
                this.out.write(" tightness 1 point_at <0,0,1>");
                this.out.println();
            }
            if ((f = ((PointLight)light).getAttenuationExponent()) > 0.0f) {
                this.out.print("fade_power ");
                this.out.print(f);
                this.out.write(" fade_distance ");
                this.out.print(((PointLight)light).getAttenuationDistance());
                this.out.println();
            }
        } else if (light instanceof DirectionalLight) {
            this.out.print("parallel point_at <0,0,1>");
            this.out.println();
        }
    }

    void print(POVWriter pOVWriter, String string, float[] fArray, PolygonArray polygonArray, int n, int n2, boolean bl) throws IOException {
        pOVWriter.print(string);
        pOVWriter.print(n / n2);
        pOVWriter.write(44);
        pOVWriter.println();
        pOVWriter.indent();
        int n3 = 0;
        for (int i = 0; i < n; i += n2) {
            if (n3 > 0) {
                pOVWriter.print(',');
            }
            if ((++n3 & 0xF) == 0) {
                pOVWriter.println();
            }
            if (polygonArray != null) {
                polygonArray.getNormal(this.ftmp, i);
                pOVWriter.print(this.ftmp[0], this.ftmp[1], this.ftmp[2]);
                continue;
            }
            if (bl) {
                pOVWriter.print(fArray[i], fArray[i + 1]);
                continue;
            }
            pOVWriter.print(fArray[i], n2 > 1 ? fArray[i + 1] : 0.0f, n2 > 2 ? fArray[i + 2] : 0.0f);
        }
        pOVWriter.unindent();
        pOVWriter.print('}');
        pOVWriter.println();
    }

    static void printTriangle(POVWriter pOVWriter, int[] nArray, int n, int n2, int n3) throws IOException {
        pOVWriter.print('<');
        pOVWriter.print(nArray[n]);
        pOVWriter.write(44);
        pOVWriter.print(nArray[n2]);
        pOVWriter.write(44);
        pOVWriter.print(nArray[n3]);
        pOVWriter.write(62);
    }

    static void printFaces(POVWriter pOVWriter, String string, PolygonArray polygonArray) throws IOException {
        int n = polygonArray.edgeCount;
        int n2 = polygonArray.polygons.size;
        int[] nArray = polygonArray.polygons.elements;
        pOVWriter.print(string);
        pOVWriter.print((n - 2) * n2 / n);
        pOVWriter.write(44);
        pOVWriter.println();
        pOVWriter.indent();
        int n3 = 0;
        for (int i = 0; i < n2; i += n) {
            if (n3 > 0) {
                pOVWriter.print(',');
            }
            if ((++n3 & 0xF) == 0) {
                pOVWriter.println();
            }
            POVExport.printTriangle(pOVWriter, nArray, i, i + 1, i + 2);
            if (n <= 3) continue;
            pOVWriter.print(',');
            POVExport.printTriangle(pOVWriter, nArray, i, i + 2, i + 3);
        }
        pOVWriter.unindent();
        pOVWriter.print('}');
        pOVWriter.println();
    }

    public boolean export(Object object, String string) throws IOException {
        this.objectType = string;
        return super.export(object);
    }

    public boolean export(Object object) throws IOException {
        this.objectType = null;
        return super.export(object);
    }

    public String getObjectType(String string) {
        return this.objectType != null ? this.objectType : string;
    }

    public SceneGraphExport.NodeExport getExportFor(Object object, boolean bl) {
        SceneGraphExport.NodeExport nodeExport;
        Object object2 = this.getGraphState().getObjectDefault(object, bl, Attributes.SHAPE, null);
        if (object2 != null) {
            nodeExport = super.getExportFor(object2, bl);
            if (nodeExport != null) {
                return nodeExport;
            }
            if (object2 instanceof Polygonizable) {
                return POLYGONIZABLE_EXPORT;
            }
            if (object2 instanceof Sky) {
                this.sky = object;
                this.skyIsNode = bl;
            }
        }
        return (nodeExport = (Light)this.getGraphState().getObjectDefault(object, bl, Attributes.LIGHT, null)) != null && nodeExport.getLightType() != 4 ? LIGHT_EXPORT : null;
    }

    public static void export(Context context, String string) {
        View3D view3D = View3D.getDefaultView((Context)context);
        if (view3D == null) {
            return;
        }
        IMP.export((View)view3D, (MimeType)MIME_TYPE, (File)new File(string));
    }
}

