/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.povray;

import de.grogra.ext.povray.POVExport;
import de.grogra.ext.povray.POVWriter;
import de.grogra.graph.impl.Node;
import de.grogra.graph.impl.SharedObjectNode;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.objects.SceneTreeWithShader;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.pf.registry.NodeReference;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.RegistryContext;
import java.io.IOException;

public abstract class POVObject {
    private final String type;
    private final String refType;

    public POVObject(String string, String string2) {
        this.type = string;
        this.refType = string2;
    }

    protected String getType() {
        return this.type;
    }

    protected boolean shouldDeclareObject(Object object) {
        return object instanceof Shareable && ((Shareable)object).getProvider() != null;
    }

    protected String createIdentifier(Object object, POVExport pOVExport) {
        if (object instanceof Shareable) {
            NodeReference nodeReference;
            Shareable shareable = (Shareable)object;
            SharedObjectProvider sharedObjectProvider = shareable.getProvider();
            if (sharedObjectProvider instanceof ObjectItem) {
                return ((ObjectItem)sharedObjectProvider).getName();
            }
            if (sharedObjectProvider instanceof SharedObjectNode && (nodeReference = NodeReference.get((RegistryContext)pOVExport, (String)"/objects", (Node)((SharedObjectNode)sharedObjectProvider))) != null) {
                return nodeReference.getName();
            }
        }
        return null;
    }

    protected void export(Object object, SceneTreeWithShader.Leaf leaf, SceneTree.InnerNode innerNode, String string, POVExport pOVExport) throws IOException {
        POVWriter pOVWriter = pOVExport.out;
        if (object != null && this.shouldDeclareObject(object)) {
            String string2 = pOVExport.getDeclaredName(object);
            if (string2 == null) {
                string2 = pOVExport.declareObject(object, this.createIdentifier(object, pOVExport));
                pOVWriter.print("#declare ");
                pOVWriter.write(string2);
                pOVWriter.write(" = ");
                pOVWriter.write(pOVExport.getObjectType(this.type));
                pOVWriter.write(123);
                pOVWriter.println();
                pOVWriter.indent();
                this.exportImpl(object, leaf, pOVExport);
                pOVWriter.unindent();
                pOVWriter.print("};");
                pOVWriter.println();
            }
            pOVWriter.print(pOVExport.getObjectType(string != null ? string : this.refType));
            pOVWriter.write(123);
            this.exportHeader(object, leaf, pOVExport);
            pOVWriter.write(string2);
            pOVWriter.println();
            pOVWriter.indent();
        } else {
            pOVWriter.print(pOVExport.getObjectType(string != null ? string : this.type));
            pOVWriter.write(123);
            this.exportHeader(object, leaf, pOVExport);
            pOVWriter.println();
            pOVWriter.indent();
            this.exportImpl(object, leaf, pOVExport);
        }
        this.exportFooter(object, leaf, innerNode, pOVExport);
        pOVWriter.unindent();
        pOVWriter.print('}');
        pOVWriter.println();
    }

    protected void exportHeader(Object object, SceneTreeWithShader.Leaf leaf, POVExport pOVExport) throws IOException {
    }

    protected abstract void exportFooter(Object var1, SceneTreeWithShader.Leaf var2, SceneTree.InnerNode var3, POVExport var4) throws IOException;

    protected abstract void exportImpl(Object var1, SceneTreeWithShader.Leaf var2, POVExport var3) throws IOException;
}

