/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.povray;

import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.pf.io.IndentWriter;
import java.io.IOException;
import java.io.Writer;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;

public class POVWriter
extends IndentWriter {
    public POVWriter(Writer writer) {
        super(writer, 1);
    }

    public void print(float f, float f2) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.print(f);
        this.write(44);
        this.print(f2);
        this.write(62);
    }

    public void print(Tuple3f tuple3f) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.print(tuple3f.x);
        this.write(44);
        this.print(tuple3f.y);
        this.write(44);
        this.print(tuple3f.z);
        this.write(62);
    }

    public void print(float f, float f2, float f3) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.print(f);
        this.write(44);
        this.print(f2);
        this.write(44);
        this.print(f3);
        this.write(62);
    }

    public void print(Tuple3d tuple3d) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.print(tuple3d.x);
        this.write(44);
        this.print(tuple3d.y);
        this.write(44);
        this.print(tuple3d.z);
        this.write(62);
    }

    public void print(Tuple4f tuple4f) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.print(tuple4f.x);
        this.write(44);
        this.print(tuple4f.y);
        this.write(44);
        this.print(tuple4f.z);
        this.write(44);
        this.print(tuple4f.w);
        this.write(62);
    }

    public void print(Tuple4d tuple4d) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.print(tuple4d.x);
        this.write(44);
        this.print(tuple4d.y);
        this.write(44);
        this.print(tuple4d.z);
        this.write(44);
        this.print(tuple4d.w);
        this.write(62);
    }

    public void print(float f, float f2, float f3, float f4) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.print(f);
        this.write(44);
        this.print(f2);
        this.write(44);
        this.print(f3);
        this.write(44);
        this.print(f4);
        this.write(62);
    }

    public void printRGB(int n) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.printRGBValues(n);
        this.write(62);
    }

    public void printRGBValues(int n) throws IOException {
        this.print((float)(n >> 16 & 0xFF) * 0.003921569f);
        this.write(44);
        this.print((float)(n >> 8 & 0xFF) * 0.003921569f);
        this.write(44);
        this.print((float)(n & 0xFF) * 0.003921569f);
    }

    public void printRGBT(int n) throws IOException {
        this.checkIndentation();
        this.write(60);
        this.printRGBValues(n);
        this.write(44);
        this.print((float)(255 - (n >> 24 & 0xFF)) * 0.003921569f);
        this.write(62);
    }

    public void print(SceneTree.InnerNode innerNode) throws IOException {
        this.print("matrix <");
        this.print(innerNode.m00);
        this.write(44);
        this.print(innerNode.m10);
        this.write(44);
        this.print(innerNode.m20);
        this.write(44);
        this.print(innerNode.m01);
        this.write(44);
        this.print(innerNode.m11);
        this.write(44);
        this.print(innerNode.m21);
        this.write(44);
        this.print(innerNode.m02);
        this.write(44);
        this.print(innerNode.m12);
        this.write(44);
        this.print(innerNode.m22);
        this.write(44);
        this.print(innerNode.m03);
        this.write(44);
        this.print(innerNode.m13);
        this.write(44);
        this.print(innerNode.m23);
        this.write(62);
    }

    public void print(Matrix4d matrix4d) throws IOException {
        this.print("matrix <");
        this.print(matrix4d.m00);
        this.write(44);
        this.print(matrix4d.m10);
        this.write(44);
        this.print(matrix4d.m20);
        this.write(44);
        this.print(matrix4d.m01);
        this.write(44);
        this.print(matrix4d.m11);
        this.write(44);
        this.print(matrix4d.m21);
        this.write(44);
        this.print(matrix4d.m02);
        this.write(44);
        this.print(matrix4d.m12);
        this.write(44);
        this.print(matrix4d.m22);
        this.write(44);
        this.print(matrix4d.m03);
        this.write(44);
        this.print(matrix4d.m13);
        this.write(44);
        this.print(matrix4d.m23);
        this.write(62);
    }

    public void print(Matrix3f matrix3f) throws IOException {
        this.print("matrix <");
        this.print(matrix3f.m00);
        this.write(44);
        this.print(matrix3f.m10);
        this.write(44);
        this.print(matrix3f.m20);
        this.write(44);
        this.print(matrix3f.m01);
        this.write(44);
        this.print(matrix3f.m11);
        this.write(44);
        this.print(matrix3f.m21);
        this.write(44);
        this.print(matrix3f.m02);
        this.write(44);
        this.print(matrix3f.m12);
        this.write(44);
        this.print(matrix3f.m22);
        this.write(",0,0,0>");
    }

    public void print(AffineUVTransformation affineUVTransformation) throws IOException {
        float f = affineUVTransformation.getShear();
        if (f != 0.0f) {
            this.print("matrix <1,0,0,");
            this.print(f);
            this.print(",1,0,0,0,1,0,0,0>");
            this.println();
        }
        f = affineUVTransformation.getScaleU();
        float f2 = affineUVTransformation.getScaleV();
        if (f != 1.0f || f2 != 1.0f) {
            this.print("scale ");
            this.print(1.0f / f, 1.0f / f2, 1.0f);
            this.println();
        }
        if ((f = affineUVTransformation.getAngle()) != 0.0f) {
            this.print("rotate ");
            this.print(0.0f, 0.0f, f * 57.29578f);
            this.println();
        }
        f = affineUVTransformation.getOffsetU();
        f2 = affineUVTransformation.getOffsetV();
        if (f != 0.0f || f2 != 0.0f) {
            this.print("translate ");
            this.print(f, f2, 0.0f);
            this.println();
        }
    }
}

