/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray;

import de.grogra.ray.RTCamera;
import de.grogra.ray.RTLight;
import de.grogra.ray.RTObject;
import de.grogra.ray.RTResources;
import de.grogra.ray.RTScene;
import de.grogra.ray.RTSceneVisitor;
import de.grogra.ray.antialiasing.AdaptiveSupersampling;
import de.grogra.ray.antialiasing.Antialiasing;
import de.grogra.ray.antialiasing.NoAntialiasing;
import de.grogra.ray.antialiasing.StochasticSupersampling;
import de.grogra.ray.debug3d.Debug3d;
import de.grogra.ray.event.ProgressNotifier;
import de.grogra.ray.intersection.DefaultIntersectionProcessor;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.intersection.OctreeIntersectionProcessor;
import de.grogra.ray.light.DefaultLightProcessor;
import de.grogra.ray.light.LightProcessor;
import de.grogra.ray.quality.Quality;
import de.grogra.ray.quality.Timer;
import de.grogra.ray.tracing.BidirectionalPathTracer;
import de.grogra.ray.tracing.DefaultRayTracer;
import de.grogra.ray.tracing.PathTracerHS;
import de.grogra.ray.tracing.PathTracerMT;
import de.grogra.ray.tracing.PhotonMapping;
import de.grogra.ray.tracing.RayProcessor;
import de.grogra.ray.util.Ray;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;

public class Raytracer
extends ProgressNotifier {
    public static final int NO_ANTIALISING = 0;
    public static final int ADAPTIVE_SUPERSAMPLING = 1;
    public static final int STOCHASTIC_SUPERSAMPLING = 2;
    public static final int CONVENTIONAL_RAYTRACING = 20;
    public static final int PATHTRACING_MT = 21;
    public static final int BIDIRECTIONAL_PATHTRACING = 22;
    public static final int PATHTRACING_HS = 23;
    public static final int PHOTONMAPPING = 24;
    public static final int NAIVE_INTERSECTION = 40;
    public static final int OCTREE_INTERSECTION = 41;
    public static final int DIRECT_LIGHTS = 60;
    public static final int LOW_PRIORITY = 0;
    public static final int MEDIUM_PRIORITY = 1;
    public static final int HIGH_PRIORITY = 2;
    public static final String PREPARING_TIMER = "timer.preparing";
    public static final String CALCULATION_TIMER = "timer.calculation";
    protected Antialiasing m_antialising = null;
    protected RayProcessor m_rayProcessor = null;
    protected IntersectionProcessor m_intersectionProcessor = null;
    protected LightProcessor m_lightProcessor = null;
    protected int m_raytracingDepth = 8;
    private int m_priority = 1;
    private int m_imageUpdateDistance = 5;
    private int m_lastWidth = 0;
    private int m_lastHeight = 0;
    private int m_objectsCount = 0;
    private int m_lightsCount = 0;
    private boolean m_debugPixel = false;
    private int m_debugPixelX = 0;
    private int m_debugPixelY = 0;
    private boolean m_debugPixelMarkIt = false;
    private float m_brightnessScaleFactor = 0.2f;

    public Raytracer() {
        this.setAntialisingPolicy(0);
        this.setRaytracingPolicy(20);
        this.setIntersectionPolicy(40);
        this.setPriority(2);
        this.setLightModel(60);
    }

    public void setAntialisingPolicy(int n) {
        switch (n) {
            case 0: {
                if (this.m_antialising instanceof NoAntialiasing) break;
                this.m_antialising = new NoAntialiasing();
                break;
            }
            case 1: {
                if (this.m_antialising instanceof AdaptiveSupersampling) break;
                this.m_antialising = new AdaptiveSupersampling();
                break;
            }
            case 2: {
                if (this.m_antialising instanceof StochasticSupersampling) break;
                this.m_antialising = new StochasticSupersampling();
                break;
            }
            default: {
                System.err.println("unknown antialising policy");
            }
        }
    }

    public void setRaytracingPolicy(int n) {
        switch (n) {
            case 20: {
                if (this.m_rayProcessor instanceof DefaultRayTracer) break;
                this.m_rayProcessor = new DefaultRayTracer();
                break;
            }
            case 21: {
                if (this.m_rayProcessor instanceof PathTracerMT) break;
                this.m_rayProcessor = new PathTracerMT();
                break;
            }
            case 22: {
                if (this.m_rayProcessor instanceof BidirectionalPathTracer) break;
                this.m_rayProcessor = new BidirectionalPathTracer();
                break;
            }
            case 23: {
                if (this.m_rayProcessor instanceof PathTracerHS) break;
                this.m_rayProcessor = new PathTracerHS();
                break;
            }
            case 24: {
                if (this.m_rayProcessor instanceof PhotonMapping) break;
                this.m_rayProcessor = new PhotonMapping();
                break;
            }
            default: {
                System.err.println("unknown raytracing policy");
            }
        }
    }

    public void setPathtracingPathCount(int n) {
        if (this.m_rayProcessor instanceof PathTracerMT) {
            ((PathTracerMT)this.m_rayProcessor).setPathCount(n);
        }
    }

    public void setIntersectionPolicy(int n) {
        switch (n) {
            case 40: {
                if (this.m_intersectionProcessor instanceof DefaultIntersectionProcessor) break;
                this.m_intersectionProcessor = new DefaultIntersectionProcessor();
                break;
            }
            case 41: {
                if (this.m_intersectionProcessor instanceof OctreeIntersectionProcessor) break;
                this.m_intersectionProcessor = new OctreeIntersectionProcessor();
                break;
            }
            default: {
                System.err.println("unknown intersection policy");
            }
        }
    }

    public void setLightModel(int n) {
        if (this.m_rayProcessor.hasFixedLightProcessor()) {
            System.err.println("ray processor has fixxed light model - light model cannot be changed or change raytracing policy");
        }
        switch (n) {
            case 60: {
                if (this.m_lightProcessor instanceof DefaultLightProcessor) break;
                this.m_lightProcessor = new DefaultLightProcessor();
                break;
            }
            default: {
                System.err.println("unknown light model policy");
            }
        }
    }

    public void setPriority(int n) {
        if (n >= 0 && n <= 2) {
            this.m_priority = n;
        }
    }

    public int getPriority() {
        return this.m_priority;
    }

    public void setRaytracingDepth(int n) {
        if (n >= 0) {
            this.m_raytracingDepth = n;
        }
    }

    public int getRaytracingDepth() {
        return this.m_raytracingDepth;
    }

    public void enableDebugPixel(int n, int n2, boolean bl) {
        this.m_debugPixel = true;
        this.m_debugPixelX = n;
        this.m_debugPixelY = n2;
        this.m_debugPixelMarkIt = bl;
    }

    public void disableDebugPixel() {
        this.m_debugPixel = false;
    }

    public void setBrightnessScaleFactor(float f) {
        this.m_brightnessScaleFactor = f;
    }

    public void renderScene(RTScene rTScene, RTCamera rTCamera, BufferedImage bufferedImage) {
        this.m_objectsCount = rTScene.getShadeablesCount();
        this.m_lightsCount = rTScene.getLightsCount();
        this.prepareRaytracing(rTScene, rTCamera);
        this.raytracing(bufferedImage);
        System.out.println();
    }

    protected void prepareRaytracing(RTScene rTScene, RTCamera rTCamera) {
        Timer timer = Quality.getQualityKit().getTimer(PREPARING_TIMER);
        timer.reset();
        this.fire_progressChanged(0, 0.0, RTResources.getString("de.grogra.ray.progress.raytracer.preprocessing.prepareIntersection"), 0, 0, 0, 0);
        timer.start();
        this.m_intersectionProcessor.prepareProcessing(rTScene);
        timer.stop();
        this.fire_progressChanged(0, 0.7, RTResources.getString("de.grogra.ray.progress.raytracer.preprocessing.prepareRaytracing"), 0, 0, 0, 0);
        timer.start();
        if (!this.m_rayProcessor.hasFixedLightProcessor()) {
            this.m_rayProcessor.setLightProcessor(this.m_lightProcessor);
        }
        this.m_rayProcessor.setRecursionDepth(this.m_raytracingDepth);
        this.m_rayProcessor.prepareRayProcessor(rTScene, this.m_intersectionProcessor);
        this.m_antialising.initialize(rTCamera, this.m_rayProcessor);
        timer.stop();
        this.fire_progressChanged(0, 1.0, RTResources.getString("de.grogra.ray.progress.done"), 0, 0, 0, 0);
        Debug3d.logCamera(rTCamera);
        Debug3d.logScene(rTScene);
    }

    protected void raytracing(BufferedImage bufferedImage) {
        Debug3d.enableDebug3D(this.m_debugPixel);
        Debug3d.clear();
        Timer timer = Quality.getQualityKit().getTimer(CALCULATION_TIMER);
        timer.reset();
        this.fire_progressChanged(1, 0.0, RTResources.getString("de.grogra.ray.progress.raytracer.processing.calculate"), 0, 0, 0, 0);
        timer.start();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.m_lastWidth = n;
        this.m_lastHeight = n2;
        double d = 2.0 / (double)n;
        double d2 = 2.0 / (double)n2;
        double d3 = -1.0;
        double d4 = -1.0;
        Color4f color4f = new Color4f();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (Thread.interrupted()) {
                return;
            }
            if (this.m_priority <= 0) {
                this.sleepALittle(100);
            }
            d3 = -1.0;
            for (n4 = 0; n4 < n; ++n4) {
                if (this.m_priority <= 1) {
                    this.sleepALittle(0);
                }
                if (this.m_debugPixel) {
                    if (n4 == this.m_debugPixelX && i == this.m_debugPixelY) {
                        Debug3d.enableDebug3D(true);
                    } else {
                        Debug3d.enableDebug3D(false);
                    }
                }
                this.m_antialising.getColorFromFrustum(d3, d4, d, d2, color4f);
                if (this.m_debugPixel && this.m_debugPixelMarkIt && this.m_debugPixelX - 2 <= n4 && n4 <= this.m_debugPixelX + 2 && this.m_debugPixelY - 2 <= i && i <= this.m_debugPixelY + 2 && (n4 != this.m_debugPixelX || i != this.m_debugPixelY)) {
                    color4f.set(1000.0f, 0.0f, 0.0f, 1.0f);
                }
                this.validateColor(color4f);
                this.addBackgroundToColor(n4, i, color4f);
                bufferedImage.setRGB(n4, i, this.getScaledIntColor(color4f));
                d3 += d;
            }
            if (i % this.m_imageUpdateDistance == this.m_imageUpdateDistance - 1 || i == n2 - 1) {
                if (i < n2 - 1) {
                    for (int j = 0; j < n; ++j) {
                        bufferedImage.setRGB(j, i + 1, -1);
                    }
                    n4 = i - n3 + 1;
                } else {
                    n4 = i - n3;
                }
                String string = RTResources.getString("de.grogra.ray.progress.raytracer.processing.calculate") + " - " + this.percentToString((double)i / ((double)n2 - 1.0) * 100.0);
                timer.stop();
                this.fire_progressChanged(1, (double)i / ((double)n2 - 1.0), string, 0, n3 + 1, n, n4);
                timer.start();
                n3 = i;
            }
            d4 += d2;
        }
        this.m_intersectionProcessor.cleanupProcessing();
        timer.stop();
        this.fire_progressChanged(1, 1.0, RTResources.getString("de.grogra.ray.progress.done"), 0, 0, 0, 0);
        Debug3d.enableDebug3D(this.m_debugPixel);
        Debug3d.flush();
    }

    protected String percentToString(double d) {
        double d2 = (double)Math.round(d * 100.0) / 100.0;
        String string = "" + d2;
        while (string.indexOf(".") >= string.length() - 2) {
            string = string + "0";
        }
        return string + "%";
    }

    private void addBackgroundToColor(int n, int n2, Color4f color4f) {
        if (color4f.w == 0.0f) {
            float f;
            color4f.x = f = n / 10 % 2 == 0 ^ n2 / 10 % 2 == 0 ? 0.75f : 0.7f;
            color4f.y = f;
            color4f.z = f;
        }
    }

    private int getScaledIntColor(Color4f color4f) {
        Color4f color4f2 = new Color4f(color4f);
        if (color4f.w > 0.0f) {
            color4f2.x *= this.m_brightnessScaleFactor;
            color4f2.y *= this.m_brightnessScaleFactor;
            color4f2.z *= this.m_brightnessScaleFactor;
        }
        color4f2.clampMax(1.0f);
        color4f2.clampMin(0.0f);
        Color color = color4f2.get();
        return (color.getAlpha() << 24) + (color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue();
    }

    public void printStatistics() {
        long l = Quality.getQualityKit().getTimer(PREPARING_TIMER).getLastMillis();
        long l2 = Quality.getQualityKit().getTimer(CALCULATION_TIMER).getLastMillis();
        System.out.println();
        System.out.println("RAYTRACER");
        System.out.println("----------------------------------------");
        System.out.println("Size:");
        System.out.println("  dimension: " + this.m_lastWidth + " x " + this.m_lastHeight + " pixel");
        System.out.println("Objects:");
        System.out.println("  objects: " + this.m_objectsCount);
        System.out.println("  lights:  " + this.m_lightsCount);
        System.out.println("Time:");
        System.out.println("  preparing:   " + l + " ms");
        System.out.println("  calculation: " + l2 + " ms");
        System.out.println("  overall:     " + (l + l2) + " ms");
    }

    public static RTLight[] getLights(RTScene rTScene) {
        RTLight[] rTLightArray = new RTLight[rTScene.getLightsCount()];
        GetLightsVisitor getLightsVisitor = new GetLightsVisitor(rTLightArray);
        rTScene.traversSceneLights(getLightsVisitor);
        return rTLightArray;
    }

    public static RTObject[] getShadeables(RTScene rTScene) {
        RTObject[] rTObjectArray = new RTObject[rTScene.getShadeablesCount()];
        GetShadeablesVisitor getShadeablesVisitor = new GetShadeablesVisitor(rTObjectArray);
        rTScene.traversSceneObjects(getShadeablesVisitor);
        return rTObjectArray;
    }

    public static float getT(Ray ray, Point3f point3f) {
        if ((double)ray.getDirection().x != 0.0) {
            return (point3f.x - ray.getOrigin().x) / ray.getDirection().x;
        }
        if ((double)ray.getDirection().y != 0.0) {
            return (point3f.y - ray.getOrigin().y) / ray.getDirection().y;
        }
        if ((double)ray.getDirection().z != 0.0) {
            return (point3f.z - ray.getOrigin().z) / ray.getDirection().z;
        }
        return Float.NaN;
    }

    private void sleepALittle(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void validateColor(Color4f color4f) {
        if (color4f.x != color4f.x || color4f.y != color4f.y || color4f.z != color4f.z || color4f.w != color4f.w) {
            System.err.println("  invalid color value:" + color4f);
        }
    }

    private static class GetShadeablesVisitor
    implements RTSceneVisitor {
        private RTObject[] m_objects = null;
        private int m_objectsOffset = 0;

        public GetShadeablesVisitor(RTObject[] rTObjectArray) {
            this.initialize(rTObjectArray);
        }

        public void initialize(RTObject[] rTObjectArray) {
            this.m_objects = rTObjectArray;
            this.m_objectsOffset = 0;
        }

        public void visitObject(RTObject rTObject) {
            if (!rTObject.isShadeable()) {
                return;
            }
            this.m_objects[this.m_objectsOffset] = rTObject;
            ++this.m_objectsOffset;
        }
    }

    private static class GetLightsVisitor
    implements RTSceneVisitor {
        private RTLight[] m_lights = null;
        private int m_lightsOffset = 0;

        public GetLightsVisitor(RTLight[] rTLightArray) {
            this.initialize(rTLightArray);
        }

        public void initialize(RTLight[] rTLightArray) {
            this.m_lights = rTLightArray;
            this.m_lightsOffset = 0;
        }

        public void visitObject(RTObject rTObject) {
            if (!(rTObject instanceof RTLight)) {
                return;
            }
            this.m_lights[this.m_lightsOffset++] = (RTLight)rTObject;
        }
    }
}

