/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.intersection;

import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.Intersections;
import de.grogra.ray.util.Ray;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class BoundingSphere
implements BoundingVolume {
    private Intersections.SphereIntersectionInput m_sphereInput = new Intersections.SphereIntersectionInput();
    private Intersections.SphereIntersectionLocalVariables m_sphereLocalVariables = new Intersections.SphereIntersectionLocalVariables();
    private final Vector3f m_minValues = new Vector3f();
    private final Vector3f m_maxValues = new Vector3f();

    public BoundingSphere(float f, Point3f point3f) {
        this.m_sphereInput.squareRadius = f * f;
        this.m_sphereInput.invers_transformation.setIdentity();
        this.m_sphereInput.invers_transformation.m03 = -point3f.x;
        this.m_sphereInput.invers_transformation.m13 = -point3f.y;
        this.m_sphereInput.invers_transformation.m23 = -point3f.z;
        this.m_minValues.x = point3f.x - f;
        this.m_minValues.y = point3f.y - f;
        this.m_minValues.z = point3f.z - f;
        this.m_maxValues.x = point3f.x + f;
        this.m_maxValues.y = point3f.y + f;
        this.m_maxValues.z = point3f.z + f;
    }

    public float getMinX() {
        return this.m_minValues.x;
    }

    public float getMinY() {
        return this.m_minValues.y;
    }

    public float getMinZ() {
        return this.m_minValues.z;
    }

    public float getMaxX() {
        return this.m_maxValues.x;
    }

    public float getMaxY() {
        return this.m_maxValues.y;
    }

    public float getMaxZ() {
        return this.m_maxValues.z;
    }

    public boolean hasIntersection(Ray ray) {
        this.m_sphereInput.ray.setRay(ray);
        return Intersections.getSphere_hasIntersection(this.m_sphereInput, this.m_sphereLocalVariables);
    }

    public boolean isInsideBox(Vector3f vector3f, Vector3f vector3f2) {
        return true;
    }
}

