/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.intersection;

import de.grogra.ray.RTObject;
import de.grogra.ray.shader.RTMedium;
import de.grogra.ray.shader.RTShader;
import de.grogra.ray.util.Ray;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class IntersectionDescription {
    public int intersectionIndex;
    private int m_intersectionCount = 0;
    private float m_t = 0.0f;
    private final Point3f m_point = new Point3f();
    private final Point3f m_localPoint = new Point3f();
    private final Vector3f m_normal = new Vector3f();
    private final Vector3f m_uTangente = new Vector3f();
    private final Vector3f m_vTangente = new Vector3f();
    private final Point2f m_uvCoordinates = new Point2f();
    private RTShader m_shader = null;
    private RTMedium m_medium = null;
    private RTObject m_object = null;

    public IntersectionDescription() {
    }

    public IntersectionDescription(Ray ray, int n) {
        this.m_intersectionCount = n;
    }

    public IntersectionDescription(Ray ray, float f) {
        this.m_t = f;
    }

    public IntersectionDescription(Ray ray, float f, Point3f point3f) {
        this.m_t = f;
        this.getPoint().set((Tuple3f)point3f);
    }

    public IntersectionDescription(IntersectionDescription intersectionDescription) {
        this.m_intersectionCount = intersectionDescription.getIntersectionCount();
        this.m_t = intersectionDescription.getT();
        this.m_point.set((Tuple3f)intersectionDescription.getPoint());
        this.m_localPoint.set((Tuple3f)intersectionDescription.getLocalPoint());
        this.m_normal.set((Tuple3f)intersectionDescription.getNormal());
        this.m_uTangente.set((Tuple3f)intersectionDescription.getTangenteU());
        this.m_vTangente.set((Tuple3f)intersectionDescription.getTangenteV());
        this.m_uvCoordinates.set((Tuple2f)intersectionDescription.getUVCoordinate());
        this.m_object = intersectionDescription.getRTObject();
    }

    public int getIntersectionCount() {
        return this.m_intersectionCount;
    }

    public void setIntersectionCount(int n) {
        this.m_intersectionCount = n;
    }

    public float getT() {
        return this.m_t;
    }

    public Point3f getPoint() {
        return this.m_point;
    }

    public Point3f getLocalPoint() {
        return this.m_localPoint;
    }

    public Vector3f getNormal() {
        return this.m_normal;
    }

    public Vector3f getTangenteU() {
        return this.m_uTangente;
    }

    public Vector3f getTangenteV() {
        return this.m_vTangente;
    }

    public Point2f getUVCoordinate() {
        return this.m_uvCoordinates;
    }

    public RTObject getRTObject() {
        return this.m_object;
    }

    public void setPoint(Point3f point3f, float f) {
        if (point3f != null) {
            this.getPoint().set((Tuple3f)point3f);
        }
        this.m_t = f;
    }

    public void setLocalPoint(Point3f point3f) {
        this.getLocalPoint().set((Tuple3f)point3f);
    }

    public void setNormal(Vector3f vector3f) {
        this.getNormal().set((Tuple3f)vector3f);
    }

    public void setRTObject(RTObject rTObject) {
        this.m_object = rTObject;
    }
}

