/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.intersection;

import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.shader.RTShader;
import de.grogra.ray.util.Ray;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class Intersections {
    public static final int EVALUATE_POINT = 2;
    public static final int EVALUATE_NORMAL = 4;
    public static final int EVALUATE_TANGET_VECTORS = 8;
    public static final int EVALUATE_UV_COORDINATES = 16;
    public static final int EVALUATE_TRANSPARENCY = 32;
    public static final int EVALUATE_SHADER = 64;
    private static final float FLOAT_PI = (float)Math.PI;
    public static final int UNDEFINED_PART = 0;
    public static final int BOX_FRONT = 1;
    public static final int BOX_BACK = 2;
    public static final int BOX_TOP = 3;
    public static final int BOX_BOTTOM = 4;
    public static final int BOX_LEFT = 5;
    public static final int BOX_RIGHT = 6;

    public static boolean isPointInsideBox(Point3d point3d, Vector3f vector3f, Vector3f vector3f2) {
        if (point3d.x < (double)vector3f.x || point3d.x > (double)vector3f2.x) {
            return false;
        }
        if (point3d.y < (double)vector3f.y || point3d.y > (double)vector3f2.y) {
            return false;
        }
        return !(point3d.z < (double)vector3f.z) && !(point3d.z > (double)vector3f2.z);
    }

    public static boolean isPointInsideBox(Point3f point3f, Vector3f vector3f, Vector3f vector3f2) {
        if (point3f.x < vector3f.x || point3f.x > vector3f2.x) {
            return false;
        }
        if (point3f.y < vector3f.y || point3f.y > vector3f2.y) {
            return false;
        }
        return !(point3f.z < vector3f.z) && !(point3f.z > vector3f2.z);
    }

    public static boolean getSphere_hasIntersection(SphereIntersectionInput sphereIntersectionInput, SphereIntersectionLocalVariables sphereIntersectionLocalVariables) {
        sphereIntersectionInput.ray.transform(sphereIntersectionInput.invers_transformation, sphereIntersectionLocalVariables.invers_ray);
        sphereIntersectionLocalVariables.dg.set((Tuple3f)sphereIntersectionLocalVariables.invers_ray.getDirection());
        sphereIntersectionLocalVariables.g.set((Tuple3f)sphereIntersectionLocalVariables.invers_ray.getOrigin());
        sphereIntersectionLocalVariables.a = sphereIntersectionLocalVariables.dg.dot(sphereIntersectionLocalVariables.dg);
        sphereIntersectionLocalVariables.b = 2.0f * sphereIntersectionLocalVariables.g.dot(sphereIntersectionLocalVariables.dg);
        sphereIntersectionLocalVariables.c = sphereIntersectionLocalVariables.g.dot(sphereIntersectionLocalVariables.g) - sphereIntersectionInput.squareRadius;
        sphereIntersectionLocalVariables.D = sphereIntersectionLocalVariables.b * sphereIntersectionLocalVariables.b - 4.0f * sphereIntersectionLocalVariables.a * sphereIntersectionLocalVariables.c;
        if ((double)sphereIntersectionLocalVariables.D < 0.0) {
            return false;
        }
        sphereIntersectionLocalVariables.invers_t = (-sphereIntersectionLocalVariables.b - (float)Math.sqrt(sphereIntersectionLocalVariables.D)) * 0.5f / sphereIntersectionLocalVariables.a;
        return (double)sphereIntersectionLocalVariables.invers_t > 0.0;
    }

    public static boolean getBox_hasIntersection(BoxIntersectionInput boxIntersectionInput, BoxIntersectionLocalVariables boxIntersectionLocalVariables) {
        if (boxIntersectionInput.ray.getDirection().x != 0.0f) {
            boxIntersectionLocalVariables.t = (boxIntersectionInput.minValues.x - boxIntersectionInput.ray.getOrigin().x) / boxIntersectionInput.ray.getDirection().x;
            if (boxIntersectionLocalVariables.t > 0.0f) {
                boxIntersectionLocalVariables.point.scaleAdd(boxIntersectionLocalVariables.t, (Tuple3f)boxIntersectionInput.ray.getDirection(), (Tuple3f)boxIntersectionInput.ray.getOrigin());
                if (boxIntersectionLocalVariables.point.y >= boxIntersectionInput.minValues.y && boxIntersectionLocalVariables.point.y <= boxIntersectionInput.maxValues.y && boxIntersectionLocalVariables.point.z >= boxIntersectionInput.minValues.z && boxIntersectionLocalVariables.point.z <= boxIntersectionInput.maxValues.z) {
                    return true;
                }
            }
            boxIntersectionLocalVariables.t = (boxIntersectionInput.maxValues.x - boxIntersectionInput.ray.getOrigin().x) / boxIntersectionInput.ray.getDirection().x;
            if (boxIntersectionLocalVariables.t > 0.0f) {
                boxIntersectionLocalVariables.point.scaleAdd(boxIntersectionLocalVariables.t, (Tuple3f)boxIntersectionInput.ray.getDirection(), (Tuple3f)boxIntersectionInput.ray.getOrigin());
                if (boxIntersectionLocalVariables.point.y >= boxIntersectionInput.minValues.y && boxIntersectionLocalVariables.point.y <= boxIntersectionInput.maxValues.y && boxIntersectionLocalVariables.point.z >= boxIntersectionInput.minValues.z && boxIntersectionLocalVariables.point.z <= boxIntersectionInput.maxValues.z) {
                    return true;
                }
            }
        }
        if (boxIntersectionInput.ray.getDirection().y != 0.0f) {
            boxIntersectionLocalVariables.t = (boxIntersectionInput.minValues.y - boxIntersectionInput.ray.getOrigin().y) / boxIntersectionInput.ray.getDirection().y;
            if (boxIntersectionLocalVariables.t > 0.0f) {
                boxIntersectionLocalVariables.point.scaleAdd(boxIntersectionLocalVariables.t, (Tuple3f)boxIntersectionInput.ray.getDirection(), (Tuple3f)boxIntersectionInput.ray.getOrigin());
                if (boxIntersectionLocalVariables.point.x >= boxIntersectionInput.minValues.x && boxIntersectionLocalVariables.point.x <= boxIntersectionInput.maxValues.x && boxIntersectionLocalVariables.point.z >= boxIntersectionInput.minValues.z && boxIntersectionLocalVariables.point.z <= boxIntersectionInput.maxValues.z) {
                    return true;
                }
            }
            boxIntersectionLocalVariables.t = (boxIntersectionInput.maxValues.y - boxIntersectionInput.ray.getOrigin().y) / boxIntersectionInput.ray.getDirection().y;
            if (boxIntersectionLocalVariables.t > 0.0f) {
                boxIntersectionLocalVariables.point.scaleAdd(boxIntersectionLocalVariables.t, (Tuple3f)boxIntersectionInput.ray.getDirection(), (Tuple3f)boxIntersectionInput.ray.getOrigin());
                if (boxIntersectionLocalVariables.point.x >= boxIntersectionInput.minValues.x && boxIntersectionLocalVariables.point.x <= boxIntersectionInput.maxValues.x && boxIntersectionLocalVariables.point.z >= boxIntersectionInput.minValues.z && boxIntersectionLocalVariables.point.z <= boxIntersectionInput.maxValues.z) {
                    return true;
                }
            }
        }
        if (boxIntersectionInput.ray.getDirection().z != 0.0f) {
            boxIntersectionLocalVariables.t = (boxIntersectionInput.minValues.z - boxIntersectionInput.ray.getOrigin().z) / boxIntersectionInput.ray.getDirection().z;
            if (boxIntersectionLocalVariables.t > 0.0f) {
                boxIntersectionLocalVariables.point.scaleAdd(boxIntersectionLocalVariables.t, (Tuple3f)boxIntersectionInput.ray.getDirection(), (Tuple3f)boxIntersectionInput.ray.getOrigin());
                if (boxIntersectionLocalVariables.point.x >= boxIntersectionInput.minValues.x && boxIntersectionLocalVariables.point.x <= boxIntersectionInput.maxValues.x && boxIntersectionLocalVariables.point.y >= boxIntersectionInput.minValues.y && boxIntersectionLocalVariables.point.y <= boxIntersectionInput.maxValues.y) {
                    return true;
                }
            }
            boxIntersectionLocalVariables.t = (boxIntersectionInput.maxValues.z - boxIntersectionInput.ray.getOrigin().z) / boxIntersectionInput.ray.getDirection().z;
            if (boxIntersectionLocalVariables.t > 0.0f) {
                boxIntersectionLocalVariables.point.scaleAdd(boxIntersectionLocalVariables.t, (Tuple3f)boxIntersectionInput.ray.getDirection(), (Tuple3f)boxIntersectionInput.ray.getOrigin());
                if (boxIntersectionLocalVariables.point.x >= boxIntersectionInput.minValues.x && boxIntersectionLocalVariables.point.x <= boxIntersectionInput.maxValues.x && boxIntersectionLocalVariables.point.y >= boxIntersectionInput.minValues.y && boxIntersectionLocalVariables.point.y <= boxIntersectionInput.maxValues.y) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean getSphere_T(SphereInput sphereInput, ObjectOutput objectOutput, SphereLocalVariables sphereLocalVariables) {
        if (sphereInput.minIndex > 1) {
            return false;
        }
        objectOutput.hasIntersection = false;
        sphereInput.ray.transform(sphereInput.invers_transformation, sphereLocalVariables.invers_ray);
        sphereLocalVariables.dg.set((Tuple3f)sphereLocalVariables.invers_ray.getDirection());
        sphereLocalVariables.g.set((Tuple3f)sphereLocalVariables.invers_ray.getOrigin());
        sphereLocalVariables.a = sphereLocalVariables.dg.dot(sphereLocalVariables.dg);
        sphereLocalVariables.b = 2.0f * sphereLocalVariables.g.dot(sphereLocalVariables.dg);
        sphereLocalVariables.c = sphereLocalVariables.g.dot(sphereLocalVariables.g) - sphereInput.squareRadius;
        sphereLocalVariables.D = sphereLocalVariables.b * sphereLocalVariables.b - 4.0f * sphereLocalVariables.a * sphereLocalVariables.c;
        if ((double)sphereLocalVariables.D <= 0.0) {
            objectOutput.hasIntersection = false;
        } else {
            if (sphereInput.minIndex == 0) {
                sphereLocalVariables.t_index = 0;
                sphereLocalVariables.invers_t = (-sphereLocalVariables.b - (float)Math.sqrt(sphereLocalVariables.D)) * 0.5f / sphereLocalVariables.a;
            } else if (sphereInput.minIndex == 1) {
                sphereLocalVariables.t_index = 1;
                sphereLocalVariables.invers_t = (-sphereLocalVariables.b + (float)Math.sqrt(sphereLocalVariables.D)) * 0.5f / sphereLocalVariables.a;
            }
            if (sphereLocalVariables.invers_t < 0.0f) {
                objectOutput.hasIntersection = false;
            } else {
                sphereLocalVariables.t = sphereLocalVariables.invers_t / sphereInput.ray.getDirection().length();
                objectOutput.hasIntersection = true;
                objectOutput.t = sphereLocalVariables.t;
            }
        }
        return objectOutput.hasIntersection;
    }

    public static void getSphere_IntersectionDescription(SphereInput sphereInput, int n, IntersectionDescription intersectionDescription, SphereLocalVariables sphereLocalVariables) {
        float f;
        float f2;
        float f3;
        if ((double)sphereLocalVariables.D < 0.0 || sphereLocalVariables.invers_t <= 0.0f) {
            intersectionDescription.setIntersectionCount(0);
            return;
        }
        intersectionDescription.setIntersectionCount(2);
        intersectionDescription.intersectionIndex = sphereLocalVariables.t_index;
        sphereLocalVariables.invers_point.scaleAdd(sphereLocalVariables.invers_t, (Tuple3f)sphereLocalVariables.dg, (Tuple3f)sphereLocalVariables.g);
        sphereLocalVariables.point.scaleAdd(sphereLocalVariables.t, (Tuple3f)sphereInput.ray.getDirection(), (Tuple3f)sphereInput.ray.getOrigin());
        intersectionDescription.setPoint(sphereLocalVariables.point, sphereLocalVariables.t);
        intersectionDescription.setLocalPoint(sphereLocalVariables.invers_point);
        Vector3f vector3f = sphereLocalVariables.normal;
        vector3f.set((Tuple3f)sphereLocalVariables.invers_point);
        vector3f.normalize();
        float f4 = vector3f.z;
        float f5 = 1.0f - vector3f.z * vector3f.z;
        float f6 = f3 = f5 <= 0.0f ? 0.0f : (float)Math.sqrt(f5);
        if (f3 == 0.0f) {
            f2 = 1.0f;
            f = 0.0f;
        } else {
            f2 = vector3f.x / f3;
            f = vector3f.y / f3;
        }
        sphereInput.transformation.transform(vector3f);
        vector3f.normalize();
        intersectionDescription.setNormal(vector3f);
        if ((n & 8) != 0) {
            intersectionDescription.getTangenteU().set((float)Math.PI * -2 * sphereLocalVariables.invers_point.y, (float)Math.PI * 2 * sphereLocalVariables.invers_point.x, 0.0f);
            sphereInput.transformation.transform(intersectionDescription.getTangenteU());
            intersectionDescription.getTangenteV().set((float)(-Math.PI) * sphereInput.radius * f2 * f4, (float)(-Math.PI) * sphereInput.radius * f * f4, (float)Math.PI * sphereInput.radius * f3);
            sphereInput.transformation.transform(intersectionDescription.getTangenteV());
        }
        if ((n & 0x10) != 0) {
            sphereLocalVariables.u = (float)Math.atan2(f, f2) * 0.15915494f;
            if (sphereLocalVariables.u < 0.0f) {
                sphereLocalVariables.u += 1.0f;
            }
            sphereLocalVariables.v = (float)Math.acos(-f4) * 0.31830987f;
            intersectionDescription.getUVCoordinate().set(sphereLocalVariables.u, sphereLocalVariables.v);
        }
    }

    public static boolean getPlane_T(PlaneInput planeInput, ObjectOutput objectOutput, PlaneLocalVariables planeLocalVariables) {
        objectOutput.hasIntersection = false;
        planeInput.ray.transform(planeInput.invers_transformation, planeLocalVariables.invers_ray);
        if (planeLocalVariables.invers_ray.getDirection().z >= 0.0f) {
            objectOutput.hasIntersection = false;
        } else {
            planeLocalVariables.invers_t = -planeLocalVariables.invers_ray.getOrigin().z / planeLocalVariables.invers_ray.getDirection().z;
            if (planeInput.transparencyShader != null) {
                planeLocalVariables.invers_point.scaleAdd(planeLocalVariables.invers_t, (Tuple3f)planeLocalVariables.invers_ray.getDirection(), (Tuple3f)planeLocalVariables.invers_ray.getOrigin());
                planeLocalVariables.t = planeLocalVariables.invers_t / planeInput.ray.getDirection().length();
                planeLocalVariables.point.scaleAdd(planeLocalVariables.t, (Tuple3f)planeInput.ray.getDirection(), (Tuple3f)planeInput.ray.getOrigin());
                planeLocalVariables.transparencyInput.localPoint.set((Tuple3f)planeLocalVariables.invers_point);
                planeLocalVariables.transparencyInput.point.set((Tuple3f)planeLocalVariables.point);
                planeLocalVariables.transparencyInput.uv.set(planeLocalVariables.invers_point.x, planeLocalVariables.invers_point.y);
                if (!planeInput.transparencyShader.isTransparent(planeLocalVariables.transparencyInput)) {
                    objectOutput.hasIntersection = true;
                    objectOutput.t = planeLocalVariables.t;
                } else {
                    objectOutput.hasIntersection = false;
                }
            } else {
                planeLocalVariables.t = planeLocalVariables.invers_t / planeInput.ray.getDirection().length();
                objectOutput.hasIntersection = true;
                objectOutput.t = planeLocalVariables.t;
            }
        }
        planeLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static void getPlane_IntersectionDescription(PlaneInput planeInput, int n, IntersectionDescription intersectionDescription, PlaneLocalVariables planeLocalVariables) {
        if (!planeLocalVariables.hasIntersection) {
            intersectionDescription.setIntersectionCount(0);
            return;
        }
        intersectionDescription.setIntersectionCount(1);
        if ((n & 2) != 0 || (n & 4) != 0 || (n & 8) != 0) {
            planeLocalVariables.invers_point.scaleAdd(planeLocalVariables.invers_t, (Tuple3f)planeLocalVariables.invers_ray.getDirection(), (Tuple3f)planeLocalVariables.invers_ray.getOrigin());
            planeLocalVariables.point.scaleAdd(planeLocalVariables.t, (Tuple3f)planeInput.ray.getDirection(), (Tuple3f)planeInput.ray.getOrigin());
            intersectionDescription.setPoint(planeLocalVariables.point, planeLocalVariables.t);
            intersectionDescription.setLocalPoint(planeLocalVariables.invers_point);
        }
        if ((n & 4) != 0) {
            intersectionDescription.getNormal().set((Tuple3f)planeInput.normal);
        }
        if ((n & 8) != 0) {
            intersectionDescription.getTangenteU().set((Tuple3f)planeInput.tangenteU);
            intersectionDescription.getTangenteU().set((Tuple3f)planeInput.tangenteV);
        }
        if ((n & 0x10) != 0) {
            intersectionDescription.getUVCoordinate().x = planeLocalVariables.invers_point.x;
            intersectionDescription.getUVCoordinate().y = planeLocalVariables.invers_point.y;
        }
    }

    public static boolean getParallelogram_T(ParallelogramInput parallelogramInput, ObjectOutput objectOutput, ParallelogramLocalVariables parallelogramLocalVariables) {
        objectOutput.hasIntersection = false;
        parallelogramInput.ray.transform(parallelogramInput.invers_transformation, parallelogramLocalVariables.invers_ray);
        if (parallelogramLocalVariables.invers_ray.getDirection().z != 0.0f) {
            parallelogramLocalVariables.invers_t = -parallelogramLocalVariables.invers_ray.getOrigin().z / parallelogramLocalVariables.invers_ray.getDirection().z;
            parallelogramLocalVariables.invers_point.scaleAdd(parallelogramLocalVariables.invers_t, (Tuple3f)parallelogramLocalVariables.invers_ray.getDirection(), (Tuple3f)parallelogramLocalVariables.invers_ray.getOrigin());
            objectOutput.hasIntersection = false;
            if (parallelogramLocalVariables.invers_point.x >= 0.0f && parallelogramLocalVariables.invers_point.x <= 1.0f && parallelogramLocalVariables.invers_point.y >= -1.0f && parallelogramLocalVariables.invers_point.y <= 1.0f) {
                if (parallelogramInput.transparencyShader != null) {
                    parallelogramLocalVariables.t = parallelogramLocalVariables.invers_t / parallelogramInput.ray.getDirection().length();
                    parallelogramLocalVariables.point.scaleAdd(parallelogramLocalVariables.t, (Tuple3f)parallelogramInput.ray.getDirection(), (Tuple3f)parallelogramInput.ray.getOrigin());
                    parallelogramLocalVariables.transparencyInput.localPoint.set((Tuple3f)parallelogramLocalVariables.invers_point);
                    parallelogramLocalVariables.transparencyInput.point.set((Tuple3f)parallelogramLocalVariables.point);
                    parallelogramLocalVariables.transparencyInput.uv.set(parallelogramLocalVariables.invers_point.y * 0.5f - 0.5f, parallelogramLocalVariables.invers_point.x);
                    if (!parallelogramInput.transparencyShader.isTransparent(parallelogramLocalVariables.transparencyInput)) {
                        objectOutput.hasIntersection = true;
                        objectOutput.t = parallelogramLocalVariables.t;
                    }
                } else {
                    parallelogramLocalVariables.t = parallelogramLocalVariables.invers_t / parallelogramInput.ray.getDirection().length();
                    objectOutput.hasIntersection = true;
                    objectOutput.t = parallelogramLocalVariables.t;
                }
            }
        } else {
            objectOutput.hasIntersection = false;
        }
        parallelogramLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static void getParallelogram_IntersectionDescription(ParallelogramInput parallelogramInput, int n, IntersectionDescription intersectionDescription, ParallelogramLocalVariables parallelogramLocalVariables) {
        if (!parallelogramLocalVariables.hasIntersection) {
            intersectionDescription.setIntersectionCount(0);
            return;
        }
        intersectionDescription.setIntersectionCount(1);
        if ((n & 2) != 0 || (n & 4) != 0 || (n & 8) != 0) {
            parallelogramLocalVariables.point.scaleAdd(parallelogramLocalVariables.t, (Tuple3f)parallelogramInput.ray.getDirection(), (Tuple3f)parallelogramInput.ray.getOrigin());
            intersectionDescription.setPoint(parallelogramLocalVariables.point, parallelogramLocalVariables.t);
            intersectionDescription.setLocalPoint(parallelogramLocalVariables.invers_point);
        }
        if ((n & 4) != 0) {
            intersectionDescription.getNormal().set((Tuple3f)parallelogramInput.normal);
        }
        if ((n & 8) != 0) {
            intersectionDescription.getTangenteU().set((Tuple3f)parallelogramInput.tangenteU);
            intersectionDescription.getTangenteU().set((Tuple3f)parallelogramInput.tangenteV);
        }
        if ((n & 0x10) != 0) {
            intersectionDescription.getUVCoordinate().x = parallelogramLocalVariables.invers_point.y * 0.5f - 0.5f;
            intersectionDescription.getUVCoordinate().y = parallelogramLocalVariables.invers_point.x;
        }
    }

    public static boolean getBox_T(BoxInput boxInput, ObjectOutput objectOutput, BoxLocalVariables boxLocalVariables) {
        objectOutput.hasIntersection = false;
        boxInput.ray.transform(boxInput.invers_transformation, boxLocalVariables.invers_ray);
        boxLocalVariables.t = Float.MAX_VALUE;
        objectOutput.hasIntersection = false;
        if (boxLocalVariables.invers_ray.getDirection().y > 0.0f ^ boxInput.minIndex == 1) {
            boxLocalVariables.invers_t = (-boxInput.expansion_y - boxLocalVariables.invers_ray.getOrigin().y) / boxLocalVariables.invers_ray.getDirection().y;
            boxLocalVariables.cur_invers_point.scaleAdd(boxLocalVariables.invers_t, (Tuple3f)boxLocalVariables.invers_ray.getDirection(), (Tuple3f)boxLocalVariables.invers_ray.getOrigin());
            if (boxLocalVariables.cur_invers_point.x >= -boxInput.expansion_x && boxLocalVariables.cur_invers_point.x <= boxInput.expansion_x && boxLocalVariables.cur_invers_point.z >= -boxInput.expansion_z && boxLocalVariables.cur_invers_point.z <= boxInput.expansion_z) {
                boxLocalVariables.cur_t = boxLocalVariables.invers_t / boxInput.ray.getDirection().length();
                if (boxLocalVariables.cur_t > 0.0f && boxLocalVariables.cur_t < boxLocalVariables.t) {
                    boxLocalVariables.intersection_part = (short)2;
                    boxLocalVariables.t = boxLocalVariables.cur_t;
                    boxLocalVariables.invers_point.set((Tuple3f)boxLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = boxLocalVariables.t;
                }
            }
        }
        if (boxLocalVariables.invers_ray.getDirection().y < 0.0f ^ boxInput.minIndex == 1) {
            boxLocalVariables.invers_t = (boxInput.expansion_y - boxLocalVariables.invers_ray.getOrigin().y) / boxLocalVariables.invers_ray.getDirection().y;
            boxLocalVariables.cur_invers_point.scaleAdd(boxLocalVariables.invers_t, (Tuple3f)boxLocalVariables.invers_ray.getDirection(), (Tuple3f)boxLocalVariables.invers_ray.getOrigin());
            if (boxLocalVariables.cur_invers_point.x >= -boxInput.expansion_x && boxLocalVariables.cur_invers_point.x <= boxInput.expansion_x && boxLocalVariables.cur_invers_point.z >= -boxInput.expansion_z && boxLocalVariables.cur_invers_point.z <= boxInput.expansion_z) {
                boxLocalVariables.cur_t = boxLocalVariables.invers_t / boxInput.ray.getDirection().length();
                if (boxLocalVariables.cur_t > 0.0f && boxLocalVariables.cur_t < boxLocalVariables.t) {
                    boxLocalVariables.intersection_part = (short)3;
                    boxLocalVariables.t = boxLocalVariables.cur_t;
                    boxLocalVariables.invers_point.set((Tuple3f)boxLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = boxLocalVariables.t;
                }
            }
        }
        if (boxLocalVariables.invers_ray.getDirection().z < 0.0f ^ boxInput.minIndex == 1) {
            boxLocalVariables.invers_t = (boxInput.expansion_z - boxLocalVariables.invers_ray.getOrigin().z) / boxLocalVariables.invers_ray.getDirection().z;
            boxLocalVariables.cur_invers_point.scaleAdd(boxLocalVariables.invers_t, (Tuple3f)boxLocalVariables.invers_ray.getDirection(), (Tuple3f)boxLocalVariables.invers_ray.getOrigin());
            if (boxLocalVariables.cur_invers_point.x >= -boxInput.expansion_x && boxLocalVariables.cur_invers_point.x <= boxInput.expansion_x && boxLocalVariables.cur_invers_point.y >= -boxInput.expansion_y && boxLocalVariables.cur_invers_point.y <= boxInput.expansion_y) {
                boxLocalVariables.cur_t = boxLocalVariables.invers_t / boxInput.ray.getDirection().length();
                if (boxLocalVariables.cur_t > 0.0f && boxLocalVariables.cur_t < boxLocalVariables.t) {
                    boxLocalVariables.intersection_part = 0;
                    boxLocalVariables.t = boxLocalVariables.cur_t;
                    boxLocalVariables.invers_point.set((Tuple3f)boxLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = boxLocalVariables.t;
                }
            }
        }
        if (boxLocalVariables.invers_ray.getDirection().z > 0.0f ^ boxInput.minIndex == 1) {
            boxLocalVariables.invers_t = (-boxInput.expansion_z - boxLocalVariables.invers_ray.getOrigin().z) / boxLocalVariables.invers_ray.getDirection().z;
            boxLocalVariables.cur_invers_point.scaleAdd(boxLocalVariables.invers_t, (Tuple3f)boxLocalVariables.invers_ray.getDirection(), (Tuple3f)boxLocalVariables.invers_ray.getOrigin());
            if (boxLocalVariables.cur_invers_point.x >= -boxInput.expansion_x && boxLocalVariables.cur_invers_point.x <= boxInput.expansion_x && boxLocalVariables.cur_invers_point.y >= -boxInput.expansion_y && boxLocalVariables.cur_invers_point.y <= boxInput.expansion_y) {
                boxLocalVariables.cur_t = boxLocalVariables.invers_t / boxInput.ray.getDirection().length();
                if (boxLocalVariables.cur_t > 0.0f && boxLocalVariables.cur_t < boxLocalVariables.t) {
                    boxLocalVariables.intersection_part = 1;
                    boxLocalVariables.t = boxLocalVariables.cur_t;
                    boxLocalVariables.invers_point.set((Tuple3f)boxLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = boxLocalVariables.t;
                }
            }
        }
        if (boxLocalVariables.invers_ray.getDirection().x > 0.0f ^ boxInput.minIndex == 1) {
            boxLocalVariables.invers_t = (-boxInput.expansion_x - boxLocalVariables.invers_ray.getOrigin().x) / boxLocalVariables.invers_ray.getDirection().x;
            boxLocalVariables.cur_invers_point.scaleAdd(boxLocalVariables.invers_t, (Tuple3f)boxLocalVariables.invers_ray.getDirection(), (Tuple3f)boxLocalVariables.invers_ray.getOrigin());
            if (boxLocalVariables.cur_invers_point.y >= -boxInput.expansion_y && boxLocalVariables.cur_invers_point.y <= boxInput.expansion_y && boxLocalVariables.cur_invers_point.z >= -boxInput.expansion_z && boxLocalVariables.cur_invers_point.z <= boxInput.expansion_z) {
                boxLocalVariables.cur_t = boxLocalVariables.invers_t / boxInput.ray.getDirection().length();
                if (boxLocalVariables.cur_t > 0.0f && boxLocalVariables.cur_t < boxLocalVariables.t) {
                    boxLocalVariables.intersection_part = (short)4;
                    boxLocalVariables.t = boxLocalVariables.cur_t;
                    boxLocalVariables.invers_point.set((Tuple3f)boxLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = boxLocalVariables.t;
                }
            }
        }
        if (boxLocalVariables.invers_ray.getDirection().x < 0.0f ^ boxInput.minIndex == 1) {
            boxLocalVariables.invers_t = (boxInput.expansion_x - boxLocalVariables.invers_ray.getOrigin().x) / boxLocalVariables.invers_ray.getDirection().x;
            boxLocalVariables.cur_invers_point.scaleAdd(boxLocalVariables.invers_t, (Tuple3f)boxLocalVariables.invers_ray.getDirection(), (Tuple3f)boxLocalVariables.invers_ray.getOrigin());
            if (boxLocalVariables.cur_invers_point.y >= -boxInput.expansion_y && boxLocalVariables.cur_invers_point.y <= boxInput.expansion_y && boxLocalVariables.cur_invers_point.z >= -boxInput.expansion_z && boxLocalVariables.cur_invers_point.z <= boxInput.expansion_z) {
                boxLocalVariables.cur_t = boxLocalVariables.invers_t / boxInput.ray.getDirection().length();
                if (boxLocalVariables.cur_t > 0.0f && boxLocalVariables.cur_t < boxLocalVariables.t) {
                    boxLocalVariables.intersection_part = (short)5;
                    boxLocalVariables.t = boxLocalVariables.cur_t;
                    boxLocalVariables.invers_point.set((Tuple3f)boxLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = boxLocalVariables.t;
                }
            }
        }
        boxLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static void getBox_IntersectionDescription(BoxInput boxInput, int n, IntersectionDescription intersectionDescription, BoxLocalVariables boxLocalVariables) {
        if ((n & 2) != 0 || (n & 4) != 0 || (n & 8) != 0) {
            boxLocalVariables.point.scaleAdd(boxLocalVariables.t, (Tuple3f)boxInput.ray.getDirection(), (Tuple3f)boxInput.ray.getOrigin());
            intersectionDescription.setPoint(boxLocalVariables.point, boxLocalVariables.t);
            intersectionDescription.setLocalPoint(boxLocalVariables.invers_point);
        }
        if ((n & 4) != 0) {
            switch (boxLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getNormal().set((Tuple3f)boxInput.top_normal);
                    break;
                }
                case 1: {
                    intersectionDescription.getNormal().set(-boxInput.top_normal.x, -boxInput.top_normal.y, -boxInput.top_normal.z);
                    break;
                }
                case 2: {
                    intersectionDescription.getNormal().set((Tuple3f)boxInput.front_normal);
                    break;
                }
                case 3: {
                    intersectionDescription.getNormal().set(-boxInput.front_normal.x, -boxInput.front_normal.y, -boxInput.front_normal.z);
                    break;
                }
                case 5: {
                    intersectionDescription.getNormal().set((Tuple3f)boxInput.right_normal);
                    break;
                }
                case 4: {
                    intersectionDescription.getNormal().set(-boxInput.right_normal.x, -boxInput.right_normal.y, -boxInput.right_normal.z);
                }
            }
        }
        if ((n & 8) != 0) {
            switch (boxLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getTangenteU().set((Tuple3f)boxInput.right_normal);
                    intersectionDescription.getTangenteV().set(-boxInput.front_normal.x, -boxInput.front_normal.y, -boxInput.front_normal.z);
                    break;
                }
                case 1: {
                    intersectionDescription.getTangenteU().set((Tuple3f)boxInput.right_normal);
                    intersectionDescription.getTangenteV().set((Tuple3f)boxInput.front_normal);
                    break;
                }
                case 2: {
                    intersectionDescription.getTangenteU().set((Tuple3f)boxInput.right_normal);
                    intersectionDescription.getTangenteV().set((Tuple3f)boxInput.top_normal);
                    break;
                }
                case 3: {
                    intersectionDescription.getTangenteU().set((Tuple3f)boxInput.right_normal);
                    intersectionDescription.getTangenteV().set(-boxInput.top_normal.x, -boxInput.top_normal.y, -boxInput.top_normal.z);
                    break;
                }
                case 4: {
                    intersectionDescription.getTangenteU().set((Tuple3f)boxInput.front_normal);
                    intersectionDescription.getTangenteV().set((Tuple3f)boxInput.top_normal);
                    break;
                }
                case 5: {
                    intersectionDescription.getTangenteU().set(-boxInput.front_normal.x, -boxInput.front_normal.y, -boxInput.front_normal.z);
                    intersectionDescription.getTangenteV().set((Tuple3f)boxInput.top_normal);
                }
            }
        }
        if ((n & 0x10) != 0) {
            switch (boxLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getUVCoordinate().x = (1.0f + boxLocalVariables.invers_point.x) / 2.0f;
                    intersectionDescription.getUVCoordinate().y = (1.0f + boxLocalVariables.invers_point.y) / 2.0f;
                    break;
                }
                case 1: {
                    intersectionDescription.getUVCoordinate().x = (1.0f + boxLocalVariables.invers_point.x) / 2.0f;
                    intersectionDescription.getUVCoordinate().y = (1.0f - boxLocalVariables.invers_point.y) / 2.0f;
                    break;
                }
                case 2: {
                    intersectionDescription.getUVCoordinate().x = (1.0f + boxLocalVariables.invers_point.x) / 2.0f;
                    intersectionDescription.getUVCoordinate().y = (1.0f + boxLocalVariables.invers_point.z) / 2.0f;
                    break;
                }
                case 3: {
                    intersectionDescription.getUVCoordinate().x = (1.0f + boxLocalVariables.invers_point.x) / 2.0f;
                    intersectionDescription.getUVCoordinate().y = (1.0f - boxLocalVariables.invers_point.z) / 2.0f;
                    break;
                }
                case 4: {
                    intersectionDescription.getUVCoordinate().x = (1.0f - boxLocalVariables.invers_point.y) / 2.0f;
                    intersectionDescription.getUVCoordinate().y = (1.0f + boxLocalVariables.invers_point.z) / 2.0f;
                    break;
                }
                case 5: {
                    intersectionDescription.getUVCoordinate().x = (1.0f + boxLocalVariables.invers_point.y) / 2.0f;
                    intersectionDescription.getUVCoordinate().y = (1.0f + boxLocalVariables.invers_point.z) / 2.0f;
                }
            }
        }
    }

    public static boolean getSolidCylinder_T(CylinderInput cylinderInput, ObjectOutput objectOutput, CylinderLocalVariables cylinderLocalVariables) {
        objectOutput.hasIntersection = false;
        cylinderInput.ray.transform(cylinderInput.invers_transformation, cylinderLocalVariables.invers_ray);
        cylinderLocalVariables.t = cylinderInput.minIndex == 0 ? Float.MAX_VALUE : 0.0f;
        cylinderLocalVariables.a = cylinderLocalVariables.invers_ray.getDirection().x * cylinderLocalVariables.invers_ray.getDirection().x + cylinderLocalVariables.invers_ray.getDirection().y * cylinderLocalVariables.invers_ray.getDirection().y;
        cylinderLocalVariables.b = 2.0f * cylinderLocalVariables.invers_ray.getDirection().x * cylinderLocalVariables.invers_ray.getOrigin().x + 2.0f * cylinderLocalVariables.invers_ray.getDirection().y * cylinderLocalVariables.invers_ray.getOrigin().y;
        cylinderLocalVariables.c = cylinderLocalVariables.invers_ray.getOrigin().x * cylinderLocalVariables.invers_ray.getOrigin().x + cylinderLocalVariables.invers_ray.getOrigin().y * cylinderLocalVariables.invers_ray.getOrigin().y - 1.0f;
        cylinderLocalVariables.D = cylinderLocalVariables.b * cylinderLocalVariables.b - 4.0f * cylinderLocalVariables.a * cylinderLocalVariables.c;
        if (cylinderLocalVariables.D >= 0.0f) {
            cylinderLocalVariables.invers_t = cylinderInput.minIndex == 0 ? (-cylinderLocalVariables.b - (float)Math.sqrt(cylinderLocalVariables.D)) * 0.5f / cylinderLocalVariables.a : (-cylinderLocalVariables.b + (float)Math.sqrt(cylinderLocalVariables.D)) * 0.5f / cylinderLocalVariables.a;
            cylinderLocalVariables.cur_invers_point.scaleAdd(cylinderLocalVariables.invers_t, (Tuple3f)cylinderLocalVariables.invers_ray.getDirection(), (Tuple3f)cylinderLocalVariables.invers_ray.getOrigin());
            if (cylinderLocalVariables.cur_invers_point.z <= 1.0f && cylinderLocalVariables.cur_invers_point.z >= 0.0f && cylinderLocalVariables.invers_t > 0.0f) {
                cylinderLocalVariables.intersection_part = (short)2;
                cylinderLocalVariables.t = cylinderLocalVariables.invers_t / cylinderInput.ray.getDirection().length();
                cylinderLocalVariables.invers_point.set((Tuple3f)cylinderLocalVariables.cur_invers_point);
                objectOutput.hasIntersection = true;
                objectOutput.t = cylinderLocalVariables.t;
            }
        }
        if (cylinderLocalVariables.invers_ray.getDirection().z != 0.0f) {
            cylinderLocalVariables.invers_t = (1.0f - cylinderLocalVariables.invers_ray.getOrigin().z) / cylinderLocalVariables.invers_ray.getDirection().z;
            cylinderLocalVariables.cur_invers_point.scaleAdd(cylinderLocalVariables.invers_t, (Tuple3f)cylinderLocalVariables.invers_ray.getDirection(), (Tuple3f)cylinderLocalVariables.invers_ray.getOrigin());
            if (cylinderLocalVariables.cur_invers_point.x * cylinderLocalVariables.cur_invers_point.x + cylinderLocalVariables.cur_invers_point.y * cylinderLocalVariables.cur_invers_point.y <= 1.0f) {
                cylinderLocalVariables.cur_t = cylinderLocalVariables.invers_t / cylinderInput.ray.getDirection().length();
                if (cylinderLocalVariables.cur_t >= 0.0f && (cylinderLocalVariables.cur_t < cylinderLocalVariables.t && cylinderInput.minIndex == 0 || cylinderLocalVariables.cur_t > cylinderLocalVariables.t && cylinderInput.minIndex == 1)) {
                    cylinderLocalVariables.intersection_part = 0;
                    cylinderLocalVariables.t = cylinderLocalVariables.cur_t;
                    cylinderLocalVariables.invers_point.set((Tuple3f)cylinderLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = cylinderLocalVariables.t;
                }
            }
        }
        if (cylinderLocalVariables.invers_ray.getDirection().z != 0.0f) {
            cylinderLocalVariables.invers_t = -cylinderLocalVariables.invers_ray.getOrigin().z / cylinderLocalVariables.invers_ray.getDirection().z;
            cylinderLocalVariables.cur_invers_point.scaleAdd(cylinderLocalVariables.invers_t, (Tuple3f)cylinderLocalVariables.invers_ray.getDirection(), (Tuple3f)cylinderLocalVariables.invers_ray.getOrigin());
            if (cylinderLocalVariables.cur_invers_point.x * cylinderLocalVariables.cur_invers_point.x + cylinderLocalVariables.cur_invers_point.y * cylinderLocalVariables.cur_invers_point.y <= 1.0f) {
                cylinderLocalVariables.cur_t = cylinderLocalVariables.invers_t / cylinderInput.ray.getDirection().length();
                if (cylinderLocalVariables.cur_t >= 0.0f && (cylinderLocalVariables.cur_t < cylinderLocalVariables.t && cylinderInput.minIndex == 0 || cylinderLocalVariables.cur_t > cylinderLocalVariables.t && cylinderInput.minIndex == 1)) {
                    cylinderLocalVariables.intersection_part = 1;
                    cylinderLocalVariables.t = cylinderLocalVariables.cur_t;
                    cylinderLocalVariables.invers_point.set((Tuple3f)cylinderLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = cylinderLocalVariables.t;
                }
            }
        }
        cylinderLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static boolean getCylinder_T(CylinderInput cylinderInput, ObjectOutput objectOutput, CylinderLocalVariables cylinderLocalVariables) {
        objectOutput.hasIntersection = false;
        cylinderInput.ray.transform(cylinderInput.invers_transformation, cylinderLocalVariables.invers_ray);
        cylinderLocalVariables.t = Float.MAX_VALUE;
        cylinderLocalVariables.a = cylinderLocalVariables.invers_ray.getDirection().x * cylinderLocalVariables.invers_ray.getDirection().x + cylinderLocalVariables.invers_ray.getDirection().y * cylinderLocalVariables.invers_ray.getDirection().y;
        cylinderLocalVariables.b = 2.0f * cylinderLocalVariables.invers_ray.getDirection().x * cylinderLocalVariables.invers_ray.getOrigin().x + 2.0f * cylinderLocalVariables.invers_ray.getDirection().y * cylinderLocalVariables.invers_ray.getOrigin().y;
        cylinderLocalVariables.c = cylinderLocalVariables.invers_ray.getOrigin().x * cylinderLocalVariables.invers_ray.getOrigin().x + cylinderLocalVariables.invers_ray.getOrigin().y * cylinderLocalVariables.invers_ray.getOrigin().y - 1.0f;
        cylinderLocalVariables.D = cylinderLocalVariables.b * cylinderLocalVariables.b - 4.0f * cylinderLocalVariables.a * cylinderLocalVariables.c;
        if (cylinderLocalVariables.D >= 0.0f) {
            cylinderLocalVariables.invers_t = (-cylinderLocalVariables.b - (float)Math.sqrt(cylinderLocalVariables.D)) * 0.5f / cylinderLocalVariables.a;
            cylinderLocalVariables.cur_invers_point.scaleAdd(cylinderLocalVariables.invers_t, (Tuple3f)cylinderLocalVariables.invers_ray.getDirection(), (Tuple3f)cylinderLocalVariables.invers_ray.getOrigin());
            if (cylinderLocalVariables.cur_invers_point.z <= 1.0f && cylinderLocalVariables.cur_invers_point.z >= 0.0f && cylinderLocalVariables.invers_t > 0.0f) {
                cylinderLocalVariables.intersection_part = (short)2;
                cylinderLocalVariables.t = cylinderLocalVariables.invers_t / cylinderInput.ray.getDirection().length();
                cylinderLocalVariables.invers_point.set((Tuple3f)cylinderLocalVariables.cur_invers_point);
                objectOutput.hasIntersection = true;
                objectOutput.t = cylinderLocalVariables.t;
            }
            if (!objectOutput.hasIntersection) {
                cylinderLocalVariables.invers_t = (-cylinderLocalVariables.b + (float)Math.sqrt(cylinderLocalVariables.D)) * 0.5f / cylinderLocalVariables.a;
                cylinderLocalVariables.cur_invers_point.scaleAdd(cylinderLocalVariables.invers_t, (Tuple3f)cylinderLocalVariables.invers_ray.getDirection(), (Tuple3f)cylinderLocalVariables.invers_ray.getOrigin());
                if (cylinderLocalVariables.cur_invers_point.z <= 1.0f && cylinderLocalVariables.cur_invers_point.z >= 0.0f && cylinderLocalVariables.invers_t > 0.0f) {
                    cylinderLocalVariables.intersection_part = (short)2;
                    cylinderLocalVariables.t = cylinderLocalVariables.invers_t / cylinderInput.ray.getDirection().length();
                    cylinderLocalVariables.invers_point.set((Tuple3f)cylinderLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = cylinderLocalVariables.t;
                } else {
                    objectOutput.hasIntersection = false;
                }
            }
        } else {
            objectOutput.hasIntersection = false;
        }
        if (!cylinderInput.open_top && cylinderLocalVariables.invers_ray.getDirection().z != 0.0f) {
            cylinderLocalVariables.invers_t = (1.0f - cylinderLocalVariables.invers_ray.getOrigin().z) / cylinderLocalVariables.invers_ray.getDirection().z;
            cylinderLocalVariables.cur_invers_point.scaleAdd(cylinderLocalVariables.invers_t, (Tuple3f)cylinderLocalVariables.invers_ray.getDirection(), (Tuple3f)cylinderLocalVariables.invers_ray.getOrigin());
            if (cylinderLocalVariables.cur_invers_point.x * cylinderLocalVariables.cur_invers_point.x + cylinderLocalVariables.cur_invers_point.y * cylinderLocalVariables.cur_invers_point.y <= 1.0f) {
                cylinderLocalVariables.cur_t = cylinderLocalVariables.invers_t / cylinderInput.ray.getDirection().length();
                if (cylinderLocalVariables.cur_t > 0.0f && cylinderLocalVariables.cur_t < cylinderLocalVariables.t) {
                    cylinderLocalVariables.intersection_part = 0;
                    cylinderLocalVariables.t = cylinderLocalVariables.cur_t;
                    cylinderLocalVariables.invers_point.set((Tuple3f)cylinderLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = cylinderLocalVariables.t;
                }
            }
        }
        if (!cylinderInput.open_bottom && cylinderLocalVariables.invers_ray.getDirection().z != 0.0f) {
            cylinderLocalVariables.invers_t = -cylinderLocalVariables.invers_ray.getOrigin().z / cylinderLocalVariables.invers_ray.getDirection().z;
            cylinderLocalVariables.cur_invers_point.scaleAdd(cylinderLocalVariables.invers_t, (Tuple3f)cylinderLocalVariables.invers_ray.getDirection(), (Tuple3f)cylinderLocalVariables.invers_ray.getOrigin());
            if (cylinderLocalVariables.cur_invers_point.x * cylinderLocalVariables.cur_invers_point.x + cylinderLocalVariables.cur_invers_point.y * cylinderLocalVariables.cur_invers_point.y <= 1.0f) {
                cylinderLocalVariables.cur_t = cylinderLocalVariables.invers_t / cylinderInput.ray.getDirection().length();
                if (cylinderLocalVariables.cur_t > 0.0f && cylinderLocalVariables.cur_t < cylinderLocalVariables.t) {
                    cylinderLocalVariables.intersection_part = 1;
                    cylinderLocalVariables.t = cylinderLocalVariables.cur_t;
                    cylinderLocalVariables.invers_point.set((Tuple3f)cylinderLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = cylinderLocalVariables.t;
                }
            }
        }
        cylinderLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static void getCylinder_IntersectionDescription(CylinderInput cylinderInput, int n, IntersectionDescription intersectionDescription, CylinderLocalVariables cylinderLocalVariables) {
        if (!cylinderLocalVariables.hasIntersection) {
            intersectionDescription.setIntersectionCount(0);
            return;
        }
        intersectionDescription.setIntersectionCount(1);
        if ((n & 2) != 0 || (n & 4) != 0 || (n & 8) != 0) {
            cylinderLocalVariables.point.scaleAdd(cylinderLocalVariables.t, (Tuple3f)cylinderInput.ray.getDirection(), (Tuple3f)cylinderInput.ray.getOrigin());
            intersectionDescription.setPoint(cylinderLocalVariables.point, cylinderLocalVariables.t);
            intersectionDescription.setLocalPoint(cylinderLocalVariables.invers_point);
        }
        if ((n & 4) != 0 || (n & 8) != 0) {
            switch (cylinderLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getNormal().set((Tuple3f)cylinderInput.top_normal);
                    break;
                }
                case 1: {
                    intersectionDescription.getNormal().set(-cylinderInput.top_normal.x, -cylinderInput.top_normal.y, -cylinderInput.top_normal.z);
                    break;
                }
                case 2: {
                    intersectionDescription.getNormal().set(cylinderLocalVariables.invers_point.x, cylinderLocalVariables.invers_point.y, 0.0f);
                    cylinderInput.transformation.transform(intersectionDescription.getNormal());
                    intersectionDescription.getNormal().normalize();
                }
            }
        }
        if ((n & 8) != 0) {
            switch (cylinderLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getTangenteU().set((Tuple3f)cylinderInput.top_tangenteU);
                    intersectionDescription.getTangenteV().set((Tuple3f)cylinderInput.top_tangenteV);
                    break;
                }
                case 1: {
                    intersectionDescription.getTangenteU().set((Tuple3f)cylinderInput.top_tangenteU);
                    intersectionDescription.getTangenteV().set(-cylinderInput.top_tangenteV.x, -cylinderInput.top_tangenteV.y, -cylinderInput.top_tangenteV.z);
                    break;
                }
                case 2: {
                    intersectionDescription.getTangenteU().set((Tuple3f)cylinderInput.top_normal);
                    intersectionDescription.getTangenteV().cross(intersectionDescription.getTangenteU(), intersectionDescription.getNormal());
                }
            }
        }
        if ((n & 0x10) != 0) {
            switch (cylinderLocalVariables.intersection_part) {
                case 0: {
                    cylinderLocalVariables.u = (1.0f + cylinderLocalVariables.invers_point.x) / 2.0f;
                    cylinderLocalVariables.v = (1.0f + cylinderLocalVariables.invers_point.y) / 2.0f;
                    break;
                }
                case 1: {
                    cylinderLocalVariables.u = (1.0f + cylinderLocalVariables.invers_point.x) / 2.0f;
                    cylinderLocalVariables.v = (1.0f - cylinderLocalVariables.invers_point.y) / 2.0f;
                    break;
                }
                case 2: {
                    if ((double)cylinderLocalVariables.invers_point.y >= 0.0) {
                        cylinderLocalVariables.beta = (float)Math.acos(cylinderLocalVariables.invers_point.x);
                        cylinderLocalVariables.u = cylinderLocalVariables.beta / (float)Math.PI * 0.5f;
                    } else {
                        cylinderLocalVariables.beta = (float)Math.acos(-cylinderLocalVariables.invers_point.x);
                        cylinderLocalVariables.u = 0.5f + cylinderLocalVariables.beta / (float)Math.PI * 0.5f;
                    }
                    cylinderLocalVariables.v = cylinderLocalVariables.invers_point.z;
                }
            }
            intersectionDescription.getUVCoordinate().set(cylinderLocalVariables.u, cylinderLocalVariables.v);
        }
    }

    public static boolean getSolidCone_T(ConeInput coneInput, ObjectOutput objectOutput, ConeLocalVariables coneLocalVariables) {
        objectOutput.hasIntersection = false;
        coneInput.ray.transform(coneInput.invers_transformation, coneLocalVariables.invers_ray);
        coneLocalVariables.t = coneInput.minIndex == 0 ? Float.MAX_VALUE : 0.0f;
        coneLocalVariables.a = coneLocalVariables.invers_ray.getDirection().x * coneLocalVariables.invers_ray.getDirection().x + coneLocalVariables.invers_ray.getDirection().y * coneLocalVariables.invers_ray.getDirection().y - coneLocalVariables.invers_ray.getDirection().z * coneLocalVariables.invers_ray.getDirection().z;
        coneLocalVariables.b = 2.0f * coneLocalVariables.invers_ray.getDirection().x * coneLocalVariables.invers_ray.getOrigin().x + 2.0f * coneLocalVariables.invers_ray.getDirection().y * coneLocalVariables.invers_ray.getOrigin().y + 2.0f * coneLocalVariables.invers_ray.getDirection().z * (1.0f - coneLocalVariables.invers_ray.getOrigin().z);
        coneLocalVariables.c = coneLocalVariables.invers_ray.getOrigin().x * coneLocalVariables.invers_ray.getOrigin().x + coneLocalVariables.invers_ray.getOrigin().y * coneLocalVariables.invers_ray.getOrigin().y - (1.0f - coneLocalVariables.invers_ray.getOrigin().z) * (1.0f - coneLocalVariables.invers_ray.getOrigin().z);
        coneLocalVariables.D = coneLocalVariables.b * coneLocalVariables.b - 4.0f * coneLocalVariables.a * coneLocalVariables.c;
        if (coneLocalVariables.D >= 0.0f) {
            coneLocalVariables.invers_t = coneInput.minIndex == 0 ? (-coneLocalVariables.b - (float)Math.sqrt(coneLocalVariables.D)) * 0.5f / coneLocalVariables.a : (-coneLocalVariables.b + (float)Math.sqrt(coneLocalVariables.D)) * 0.5f / coneLocalVariables.a;
            coneLocalVariables.cur_invers_point.scaleAdd(coneLocalVariables.invers_t, (Tuple3f)coneLocalVariables.invers_ray.getDirection(), (Tuple3f)coneLocalVariables.invers_ray.getOrigin());
            if (coneLocalVariables.cur_invers_point.z < 1.0f && coneLocalVariables.cur_invers_point.z >= 0.0f && coneLocalVariables.invers_t > 0.0f) {
                coneLocalVariables.intersection_part = 1;
                coneLocalVariables.t = coneLocalVariables.invers_t / coneInput.ray.getDirection().length();
                coneLocalVariables.invers_point.set((Tuple3f)coneLocalVariables.cur_invers_point);
                objectOutput.hasIntersection = true;
                objectOutput.t = coneLocalVariables.t;
            }
        }
        if (coneLocalVariables.invers_ray.getDirection().z != 0.0f) {
            coneLocalVariables.invers_t = -coneLocalVariables.invers_ray.getOrigin().z / coneLocalVariables.invers_ray.getDirection().z;
            coneLocalVariables.cur_invers_point.scaleAdd(coneLocalVariables.invers_t, (Tuple3f)coneLocalVariables.invers_ray.getDirection(), (Tuple3f)coneLocalVariables.invers_ray.getOrigin());
            if (coneLocalVariables.cur_invers_point.x * coneLocalVariables.cur_invers_point.x + coneLocalVariables.cur_invers_point.y * coneLocalVariables.cur_invers_point.y <= 1.0f) {
                coneLocalVariables.cur_t = coneLocalVariables.invers_t / coneInput.ray.getDirection().length();
                if (coneLocalVariables.cur_t > 0.0f && (coneLocalVariables.cur_t < coneLocalVariables.t && coneInput.minIndex == 0 || coneLocalVariables.cur_t > coneLocalVariables.t && coneInput.minIndex == 1)) {
                    coneLocalVariables.intersection_part = 0;
                    coneLocalVariables.t = coneLocalVariables.cur_t;
                    coneLocalVariables.invers_point.set((Tuple3f)coneLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = coneLocalVariables.t;
                }
            }
        }
        coneLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static boolean getCone_T(ConeInput coneInput, ObjectOutput objectOutput, ConeLocalVariables coneLocalVariables) {
        objectOutput.hasIntersection = false;
        coneInput.ray.transform(coneInput.invers_transformation, coneLocalVariables.invers_ray);
        coneLocalVariables.t = Float.MAX_VALUE;
        coneLocalVariables.a = coneLocalVariables.invers_ray.getDirection().x * coneLocalVariables.invers_ray.getDirection().x + coneLocalVariables.invers_ray.getDirection().y * coneLocalVariables.invers_ray.getDirection().y - coneLocalVariables.invers_ray.getDirection().z * coneLocalVariables.invers_ray.getDirection().z;
        coneLocalVariables.b = 2.0f * coneLocalVariables.invers_ray.getDirection().x * coneLocalVariables.invers_ray.getOrigin().x + 2.0f * coneLocalVariables.invers_ray.getDirection().y * coneLocalVariables.invers_ray.getOrigin().y + 2.0f * coneLocalVariables.invers_ray.getDirection().z * (1.0f - coneLocalVariables.invers_ray.getOrigin().z);
        coneLocalVariables.c = coneLocalVariables.invers_ray.getOrigin().x * coneLocalVariables.invers_ray.getOrigin().x + coneLocalVariables.invers_ray.getOrigin().y * coneLocalVariables.invers_ray.getOrigin().y - (1.0f - coneLocalVariables.invers_ray.getOrigin().z) * (1.0f - coneLocalVariables.invers_ray.getOrigin().z);
        coneLocalVariables.D = coneLocalVariables.b * coneLocalVariables.b - 4.0f * coneLocalVariables.a * coneLocalVariables.c;
        if (coneLocalVariables.D >= 0.0f) {
            coneLocalVariables.invers_t = (-coneLocalVariables.b - (float)Math.sqrt(coneLocalVariables.D)) * 0.5f / coneLocalVariables.a;
            coneLocalVariables.cur_invers_point.scaleAdd(coneLocalVariables.invers_t, (Tuple3f)coneLocalVariables.invers_ray.getDirection(), (Tuple3f)coneLocalVariables.invers_ray.getOrigin());
            if (coneLocalVariables.cur_invers_point.z < 1.0f && coneLocalVariables.cur_invers_point.z >= 0.0f && coneLocalVariables.invers_t > 0.0f) {
                coneLocalVariables.intersection_part = 1;
                coneLocalVariables.t = coneLocalVariables.invers_t / coneInput.ray.getDirection().length();
                coneLocalVariables.invers_point.set((Tuple3f)coneLocalVariables.cur_invers_point);
                objectOutput.hasIntersection = true;
                objectOutput.t = coneLocalVariables.t;
            }
            if (!objectOutput.hasIntersection) {
                coneLocalVariables.invers_t = (-coneLocalVariables.b + (float)Math.sqrt(coneLocalVariables.D)) * 0.5f / coneLocalVariables.a;
                coneLocalVariables.cur_invers_point.scaleAdd(coneLocalVariables.invers_t, (Tuple3f)coneLocalVariables.invers_ray.getDirection(), (Tuple3f)coneLocalVariables.invers_ray.getOrigin());
                if (coneLocalVariables.cur_invers_point.z < 1.0f && coneLocalVariables.cur_invers_point.z >= 0.0f && coneLocalVariables.invers_t > 0.0f) {
                    coneLocalVariables.intersection_part = 1;
                    coneLocalVariables.t = coneLocalVariables.invers_t / coneInput.ray.getDirection().length();
                    coneLocalVariables.invers_point.set((Tuple3f)coneLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = coneLocalVariables.t;
                } else {
                    objectOutput.hasIntersection = false;
                }
            }
        } else {
            objectOutput.hasIntersection = false;
        }
        if (!coneInput.open_bottom && coneLocalVariables.invers_ray.getDirection().z != 0.0f) {
            coneLocalVariables.invers_t = -coneLocalVariables.invers_ray.getOrigin().z / coneLocalVariables.invers_ray.getDirection().z;
            coneLocalVariables.cur_invers_point.scaleAdd(coneLocalVariables.invers_t, (Tuple3f)coneLocalVariables.invers_ray.getDirection(), (Tuple3f)coneLocalVariables.invers_ray.getOrigin());
            if (coneLocalVariables.cur_invers_point.x * coneLocalVariables.cur_invers_point.x + coneLocalVariables.cur_invers_point.y * coneLocalVariables.cur_invers_point.y <= 1.0f) {
                coneLocalVariables.cur_t = coneLocalVariables.invers_t / coneInput.ray.getDirection().length();
                if (coneLocalVariables.cur_t > 0.0f && coneLocalVariables.cur_t < coneLocalVariables.t) {
                    coneLocalVariables.intersection_part = 0;
                    coneLocalVariables.t = coneLocalVariables.cur_t;
                    coneLocalVariables.invers_point.set((Tuple3f)coneLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = coneLocalVariables.t;
                }
            }
        }
        coneLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static void getCone_IntersectionDescription(ConeInput coneInput, int n, IntersectionDescription intersectionDescription, ConeLocalVariables coneLocalVariables) {
        if (!coneLocalVariables.hasIntersection) {
            intersectionDescription.setIntersectionCount(0);
            return;
        }
        intersectionDescription.setIntersectionCount(1);
        if ((n & 2) != 0 || (n & 4) != 0 || (n & 8) != 0) {
            coneLocalVariables.point.scaleAdd(coneLocalVariables.t, (Tuple3f)coneInput.ray.getDirection(), (Tuple3f)coneInput.ray.getOrigin());
            intersectionDescription.setPoint(coneLocalVariables.point, coneLocalVariables.t);
            intersectionDescription.setLocalPoint(coneLocalVariables.invers_point);
        }
        if ((n & 4) != 0 || (n & 8) != 0 || (n & 0x10) != 0) {
            switch (coneLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getNormal().set((Tuple3f)coneInput.bottom_normal);
                    break;
                }
                case 1: {
                    intersectionDescription.getNormal().set(coneLocalVariables.invers_point.x, coneLocalVariables.invers_point.y, 0.0f);
                    intersectionDescription.getNormal().normalize();
                    intersectionDescription.getNormal().z = 1.0f;
                    coneInput.transformation.transform(intersectionDescription.getNormal());
                    intersectionDescription.getNormal().normalize();
                }
            }
        }
        if ((n & 8) != 0) {
            switch (coneLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getTangenteU().set((Tuple3f)coneInput.bottom_tangenteU);
                    intersectionDescription.getTangenteV().set((Tuple3f)coneInput.bottom_tangenteV);
                    break;
                }
                case 1: {
                    intersectionDescription.getTangenteV().set(0.0f, 0.0f, 1.0f);
                    intersectionDescription.getTangenteV().sub((Tuple3f)intersectionDescription.getPoint());
                    intersectionDescription.getTangenteV().normalize();
                    intersectionDescription.getTangenteU().cross(intersectionDescription.getNormal(), intersectionDescription.getTangenteV());
                }
            }
        }
        if ((n & 0x10) != 0) {
            switch (coneLocalVariables.intersection_part) {
                case 0: {
                    coneLocalVariables.u = (1.0f + coneLocalVariables.invers_point.x) / 2.0f;
                    coneLocalVariables.v = (1.0f - coneLocalVariables.invers_point.y) / 2.0f;
                    break;
                }
                case 1: {
                    if ((double)coneLocalVariables.invers_point.y >= 0.0) {
                        coneLocalVariables.beta = (float)Math.acos(coneLocalVariables.invers_point.x / (1.0f - coneLocalVariables.invers_point.z));
                        coneLocalVariables.u = coneLocalVariables.beta / (float)Math.PI * 0.5f;
                    } else {
                        coneLocalVariables.beta = (float)Math.acos(-coneLocalVariables.invers_point.x / (1.0f - coneLocalVariables.invers_point.z));
                        coneLocalVariables.u = 0.5f + coneLocalVariables.beta / (float)Math.PI * 0.5f;
                    }
                    coneLocalVariables.v = coneLocalVariables.invers_point.z;
                }
            }
            intersectionDescription.getUVCoordinate().set(coneLocalVariables.u, coneLocalVariables.v);
        }
    }

    public static boolean getSolidFrustum_T(FrustumInput frustumInput, ObjectOutput objectOutput, FrustumLocalVariables frustumLocalVariables) {
        objectOutput.hasIntersection = false;
        frustumInput.ray.transform(frustumInput.invers_transformation, frustumLocalVariables.invers_ray);
        frustumLocalVariables.t = frustumInput.minIndex == 0 ? Float.MAX_VALUE : 0.0f;
        if (frustumInput.radius_ratio == 1.0f) {
            frustumLocalVariables.a = frustumLocalVariables.invers_ray.getDirection().x * frustumLocalVariables.invers_ray.getDirection().x + frustumLocalVariables.invers_ray.getDirection().y * frustumLocalVariables.invers_ray.getDirection().y;
            frustumLocalVariables.b = 2.0f * frustumLocalVariables.invers_ray.getDirection().x * frustumLocalVariables.invers_ray.getOrigin().x + 2.0f * frustumLocalVariables.invers_ray.getDirection().y * frustumLocalVariables.invers_ray.getOrigin().y;
            frustumLocalVariables.c = frustumLocalVariables.invers_ray.getOrigin().x * frustumLocalVariables.invers_ray.getOrigin().x + frustumLocalVariables.invers_ray.getOrigin().y * frustumLocalVariables.invers_ray.getOrigin().y - 1.0f;
        } else {
            frustumLocalVariables.gz = frustumLocalVariables.invers_ray.getOrigin().z * (1.0f - frustumInput.radius_ratio);
            frustumLocalVariables.dgz = frustumLocalVariables.invers_ray.getDirection().z * (1.0f - frustumInput.radius_ratio);
            frustumLocalVariables.a = frustumLocalVariables.invers_ray.getDirection().x * frustumLocalVariables.invers_ray.getDirection().x + frustumLocalVariables.invers_ray.getDirection().y * frustumLocalVariables.invers_ray.getDirection().y - frustumLocalVariables.dgz * frustumLocalVariables.dgz;
            frustumLocalVariables.b = 2.0f * frustumLocalVariables.invers_ray.getDirection().x * frustumLocalVariables.invers_ray.getOrigin().x + 2.0f * frustumLocalVariables.invers_ray.getDirection().y * frustumLocalVariables.invers_ray.getOrigin().y + 2.0f * frustumLocalVariables.dgz * (1.0f - frustumLocalVariables.gz);
            frustumLocalVariables.c = frustumLocalVariables.invers_ray.getOrigin().x * frustumLocalVariables.invers_ray.getOrigin().x + frustumLocalVariables.invers_ray.getOrigin().y * frustumLocalVariables.invers_ray.getOrigin().y - (1.0f - frustumLocalVariables.gz) * (1.0f - frustumLocalVariables.gz);
        }
        frustumLocalVariables.D = frustumLocalVariables.b * frustumLocalVariables.b - 4.0f * frustumLocalVariables.a * frustumLocalVariables.c;
        if (frustumLocalVariables.D >= 0.0f) {
            frustumLocalVariables.invers_t = frustumInput.minIndex == 0 ? (-frustumLocalVariables.b - (float)Math.sqrt(frustumLocalVariables.D)) * 0.5f / frustumLocalVariables.a : (-frustumLocalVariables.b + (float)Math.sqrt(frustumLocalVariables.D)) * 0.5f / frustumLocalVariables.a;
            frustumLocalVariables.cur_invers_point.scaleAdd(frustumLocalVariables.invers_t, (Tuple3f)frustumLocalVariables.invers_ray.getDirection(), (Tuple3f)frustumLocalVariables.invers_ray.getOrigin());
            if (frustumLocalVariables.cur_invers_point.z <= 1.0f && frustumLocalVariables.cur_invers_point.z >= 0.0f && frustumLocalVariables.invers_t > 0.0f) {
                frustumLocalVariables.intersection_part = (short)2;
                frustumLocalVariables.t = frustumLocalVariables.invers_t / frustumInput.ray.getDirection().length();
                frustumLocalVariables.invers_point.set((Tuple3f)frustumLocalVariables.cur_invers_point);
                objectOutput.hasIntersection = true;
                objectOutput.t = frustumLocalVariables.t;
            }
        }
        if (frustumLocalVariables.invers_ray.getDirection().z != 0.0f) {
            frustumLocalVariables.invers_t = (1.0f - frustumLocalVariables.invers_ray.getOrigin().z) / frustumLocalVariables.invers_ray.getDirection().z;
            frustumLocalVariables.cur_invers_point.scaleAdd(frustumLocalVariables.invers_t, (Tuple3f)frustumLocalVariables.invers_ray.getDirection(), (Tuple3f)frustumLocalVariables.invers_ray.getOrigin());
            if (frustumLocalVariables.cur_invers_point.x * frustumLocalVariables.cur_invers_point.x + frustumLocalVariables.cur_invers_point.y * frustumLocalVariables.cur_invers_point.y <= frustumInput.radius_ratio_sq) {
                frustumLocalVariables.cur_t = frustumLocalVariables.invers_t / frustumInput.ray.getDirection().length();
                if (frustumLocalVariables.cur_t > 0.0f && (frustumLocalVariables.cur_t < frustumLocalVariables.t && frustumInput.minIndex == 0 || frustumLocalVariables.cur_t > frustumLocalVariables.t && frustumInput.minIndex == 1)) {
                    frustumLocalVariables.intersection_part = 0;
                    frustumLocalVariables.t = frustumLocalVariables.cur_t;
                    frustumLocalVariables.invers_point.set((Tuple3f)frustumLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = frustumLocalVariables.t;
                }
            }
        }
        if (frustumLocalVariables.invers_ray.getDirection().z != 0.0f) {
            frustumLocalVariables.invers_t = -frustumLocalVariables.invers_ray.getOrigin().z / frustumLocalVariables.invers_ray.getDirection().z;
            frustumLocalVariables.cur_invers_point.scaleAdd(frustumLocalVariables.invers_t, (Tuple3f)frustumLocalVariables.invers_ray.getDirection(), (Tuple3f)frustumLocalVariables.invers_ray.getOrigin());
            if (frustumLocalVariables.cur_invers_point.x * frustumLocalVariables.cur_invers_point.x + frustumLocalVariables.cur_invers_point.y * frustumLocalVariables.cur_invers_point.y <= 1.0f) {
                frustumLocalVariables.cur_t = frustumLocalVariables.invers_t / frustumInput.ray.getDirection().length();
                if (frustumLocalVariables.cur_t > 0.0f && (frustumLocalVariables.cur_t < frustumLocalVariables.t && frustumInput.minIndex == 0 || frustumLocalVariables.cur_t > frustumLocalVariables.t && frustumInput.minIndex == 1)) {
                    frustumLocalVariables.intersection_part = 1;
                    frustumLocalVariables.t = frustumLocalVariables.cur_t;
                    frustumLocalVariables.invers_point.set((Tuple3f)frustumLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = frustumLocalVariables.t;
                }
            }
        }
        frustumLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static boolean getFrustum_T(FrustumInput frustumInput, ObjectOutput objectOutput, FrustumLocalVariables frustumLocalVariables) {
        objectOutput.hasIntersection = false;
        frustumInput.ray.transform(frustumInput.invers_transformation, frustumLocalVariables.invers_ray);
        frustumLocalVariables.t = Float.MAX_VALUE;
        if (frustumInput.radius_ratio == 1.0f) {
            frustumLocalVariables.a = frustumLocalVariables.invers_ray.getDirection().x * frustumLocalVariables.invers_ray.getDirection().x + frustumLocalVariables.invers_ray.getDirection().y * frustumLocalVariables.invers_ray.getDirection().y;
            frustumLocalVariables.b = 2.0f * frustumLocalVariables.invers_ray.getDirection().x * frustumLocalVariables.invers_ray.getOrigin().x + 2.0f * frustumLocalVariables.invers_ray.getDirection().y * frustumLocalVariables.invers_ray.getOrigin().y;
            frustumLocalVariables.c = frustumLocalVariables.invers_ray.getOrigin().x * frustumLocalVariables.invers_ray.getOrigin().x + frustumLocalVariables.invers_ray.getOrigin().y * frustumLocalVariables.invers_ray.getOrigin().y - 1.0f;
        } else {
            frustumLocalVariables.gz = frustumLocalVariables.invers_ray.getOrigin().z * (1.0f - frustumInput.radius_ratio);
            frustumLocalVariables.dgz = frustumLocalVariables.invers_ray.getDirection().z * (1.0f - frustumInput.radius_ratio);
            frustumLocalVariables.a = frustumLocalVariables.invers_ray.getDirection().x * frustumLocalVariables.invers_ray.getDirection().x + frustumLocalVariables.invers_ray.getDirection().y * frustumLocalVariables.invers_ray.getDirection().y - frustumLocalVariables.dgz * frustumLocalVariables.dgz;
            frustumLocalVariables.b = 2.0f * frustumLocalVariables.invers_ray.getDirection().x * frustumLocalVariables.invers_ray.getOrigin().x + 2.0f * frustumLocalVariables.invers_ray.getDirection().y * frustumLocalVariables.invers_ray.getOrigin().y + 2.0f * frustumLocalVariables.dgz * (1.0f - frustumLocalVariables.gz);
            frustumLocalVariables.c = frustumLocalVariables.invers_ray.getOrigin().x * frustumLocalVariables.invers_ray.getOrigin().x + frustumLocalVariables.invers_ray.getOrigin().y * frustumLocalVariables.invers_ray.getOrigin().y - (1.0f - frustumLocalVariables.gz) * (1.0f - frustumLocalVariables.gz);
        }
        frustumLocalVariables.D = frustumLocalVariables.b * frustumLocalVariables.b - 4.0f * frustumLocalVariables.a * frustumLocalVariables.c;
        if (frustumLocalVariables.D >= 0.0f) {
            frustumLocalVariables.invers_t = (-frustumLocalVariables.b - (float)Math.sqrt(frustumLocalVariables.D)) * 0.5f / frustumLocalVariables.a;
            frustumLocalVariables.cur_invers_point.scaleAdd(frustumLocalVariables.invers_t, (Tuple3f)frustumLocalVariables.invers_ray.getDirection(), (Tuple3f)frustumLocalVariables.invers_ray.getOrigin());
            if (frustumLocalVariables.cur_invers_point.z <= 1.0f && frustumLocalVariables.cur_invers_point.z >= 0.0f && frustumLocalVariables.invers_t > 0.0f) {
                frustumLocalVariables.intersection_part = (short)2;
                frustumLocalVariables.t = frustumLocalVariables.invers_t / frustumInput.ray.getDirection().length();
                frustumLocalVariables.invers_point.set((Tuple3f)frustumLocalVariables.cur_invers_point);
                objectOutput.hasIntersection = true;
                objectOutput.t = frustumLocalVariables.t;
            }
            if (!objectOutput.hasIntersection) {
                frustumLocalVariables.invers_t = (-frustumLocalVariables.b + (float)Math.sqrt(frustumLocalVariables.D)) * 0.5f / frustumLocalVariables.a;
                frustumLocalVariables.cur_invers_point.scaleAdd(frustumLocalVariables.invers_t, (Tuple3f)frustumLocalVariables.invers_ray.getDirection(), (Tuple3f)frustumLocalVariables.invers_ray.getOrigin());
                if (frustumLocalVariables.cur_invers_point.z <= 1.0f && frustumLocalVariables.cur_invers_point.z >= 0.0f && frustumLocalVariables.invers_t > 0.0f) {
                    frustumLocalVariables.intersection_part = (short)2;
                    frustumLocalVariables.t = frustumLocalVariables.invers_t / frustumInput.ray.getDirection().length();
                    frustumLocalVariables.invers_point.set((Tuple3f)frustumLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = frustumLocalVariables.t;
                } else {
                    objectOutput.hasIntersection = false;
                }
            }
        } else {
            objectOutput.hasIntersection = false;
        }
        if (!frustumInput.open_top && frustumLocalVariables.invers_ray.getDirection().z != 0.0f) {
            frustumLocalVariables.invers_t = (1.0f - frustumLocalVariables.invers_ray.getOrigin().z) / frustumLocalVariables.invers_ray.getDirection().z;
            frustumLocalVariables.cur_invers_point.scaleAdd(frustumLocalVariables.invers_t, (Tuple3f)frustumLocalVariables.invers_ray.getDirection(), (Tuple3f)frustumLocalVariables.invers_ray.getOrigin());
            if (frustumLocalVariables.cur_invers_point.x * frustumLocalVariables.cur_invers_point.x + frustumLocalVariables.cur_invers_point.y * frustumLocalVariables.cur_invers_point.y <= frustumInput.radius_ratio_sq) {
                frustumLocalVariables.cur_t = frustumLocalVariables.invers_t / frustumInput.ray.getDirection().length();
                if (frustumLocalVariables.cur_t > 0.0f && frustumLocalVariables.cur_t < frustumLocalVariables.t) {
                    frustumLocalVariables.intersection_part = 0;
                    frustumLocalVariables.t = frustumLocalVariables.cur_t;
                    frustumLocalVariables.invers_point.set((Tuple3f)frustumLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = frustumLocalVariables.t;
                }
            }
        }
        if (!frustumInput.open_bottom && frustumLocalVariables.invers_ray.getDirection().z != 0.0f) {
            frustumLocalVariables.invers_t = -frustumLocalVariables.invers_ray.getOrigin().z / frustumLocalVariables.invers_ray.getDirection().z;
            frustumLocalVariables.cur_invers_point.scaleAdd(frustumLocalVariables.invers_t, (Tuple3f)frustumLocalVariables.invers_ray.getDirection(), (Tuple3f)frustumLocalVariables.invers_ray.getOrigin());
            if (frustumLocalVariables.cur_invers_point.x * frustumLocalVariables.cur_invers_point.x + frustumLocalVariables.cur_invers_point.y * frustumLocalVariables.cur_invers_point.y <= 1.0f) {
                frustumLocalVariables.cur_t = frustumLocalVariables.invers_t / frustumInput.ray.getDirection().length();
                if (frustumLocalVariables.cur_t > 0.0f && frustumLocalVariables.cur_t < frustumLocalVariables.t) {
                    frustumLocalVariables.intersection_part = 1;
                    frustumLocalVariables.t = frustumLocalVariables.cur_t;
                    frustumLocalVariables.invers_point.set((Tuple3f)frustumLocalVariables.cur_invers_point);
                    objectOutput.hasIntersection = true;
                    objectOutput.t = frustumLocalVariables.t;
                }
            }
        }
        frustumLocalVariables.hasIntersection = objectOutput.hasIntersection;
        return objectOutput.hasIntersection;
    }

    public static void getFrustum_IntersectionDescription(FrustumInput frustumInput, int n, IntersectionDescription intersectionDescription, FrustumLocalVariables frustumLocalVariables) {
        if (!frustumLocalVariables.hasIntersection) {
            intersectionDescription.setIntersectionCount(0);
            return;
        }
        intersectionDescription.setIntersectionCount(1);
        if ((n & 2) != 0 || (n & 4) != 0 || (n & 8) != 0) {
            frustumLocalVariables.point.scaleAdd(frustumLocalVariables.t, (Tuple3f)frustumInput.ray.getDirection(), (Tuple3f)frustumInput.ray.getOrigin());
            intersectionDescription.setPoint(frustumLocalVariables.point, frustumLocalVariables.t);
            intersectionDescription.setLocalPoint(frustumLocalVariables.invers_point);
        }
        if ((n & 4) != 0 || (n & 8) != 0) {
            switch (frustumLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getNormal().set((Tuple3f)frustumInput.top_normal);
                    break;
                }
                case 1: {
                    intersectionDescription.getNormal().set(-frustumInput.top_normal.x, -frustumInput.top_normal.y, -frustumInput.top_normal.z);
                    break;
                }
                case 2: {
                    intersectionDescription.getNormal().set(frustumLocalVariables.invers_point.x, frustumLocalVariables.invers_point.y, 0.0f);
                    intersectionDescription.getNormal().normalize();
                    intersectionDescription.getNormal().z = 1.0f - frustumInput.radius_ratio;
                    frustumInput.transformation.transform(intersectionDescription.getNormal());
                    intersectionDescription.getNormal().normalize();
                }
            }
        }
        if ((n & 8) != 0) {
            switch (frustumLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getTangenteU().set((Tuple3f)frustumInput.top_tangenteU);
                    intersectionDescription.getTangenteV().set((Tuple3f)frustumInput.top_tangenteV);
                    break;
                }
                case 1: {
                    intersectionDescription.getTangenteU().set((Tuple3f)frustumInput.top_tangenteU);
                    intersectionDescription.getTangenteV().set(-frustumInput.top_tangenteV.x, -frustumInput.top_tangenteV.y, -frustumInput.top_tangenteV.z);
                    break;
                }
                case 2: {
                    if (frustumInput.radius_ratio == 1.0f) {
                        intersectionDescription.getTangenteU().set((Tuple3f)frustumInput.top_normal);
                        intersectionDescription.getTangenteV().cross(intersectionDescription.getTangenteU(), intersectionDescription.getNormal());
                        break;
                    }
                    intersectionDescription.getTangenteV().set(0.0f, 0.0f, 1.0f / (1.0f - frustumInput.radius_ratio));
                    intersectionDescription.getTangenteV().sub((Tuple3f)intersectionDescription.getPoint());
                    intersectionDescription.getTangenteV().normalize();
                    intersectionDescription.getTangenteU().cross(intersectionDescription.getNormal(), intersectionDescription.getTangenteV());
                }
            }
        }
        if ((n & 0x10) != 0) {
            switch (frustumLocalVariables.intersection_part) {
                case 0: {
                    intersectionDescription.getUVCoordinate().x = (1.0f + frustumLocalVariables.invers_point.x) / 2.0f;
                    intersectionDescription.getUVCoordinate().y = (1.0f + frustumLocalVariables.invers_point.y) / 2.0f;
                    break;
                }
                case 1: {
                    intersectionDescription.getUVCoordinate().x = (1.0f + frustumLocalVariables.invers_point.x) / 2.0f;
                    intersectionDescription.getUVCoordinate().y = (1.0f - frustumLocalVariables.invers_point.y) / 2.0f;
                    break;
                }
                case 2: {
                    if ((double)frustumLocalVariables.invers_point.y >= 0.0) {
                        frustumLocalVariables.beta = (float)Math.acos(frustumLocalVariables.invers_point.x / (1.0f - (1.0f - frustumInput.radius_ratio) * frustumLocalVariables.invers_point.z));
                        intersectionDescription.getUVCoordinate().x = frustumLocalVariables.beta / (float)Math.PI * 0.5f;
                    } else {
                        frustumLocalVariables.beta = (float)Math.acos(-frustumLocalVariables.invers_point.x / (1.0f - (1.0f - frustumInput.radius_ratio) * frustumLocalVariables.invers_point.z));
                        intersectionDescription.getUVCoordinate().x = 0.5f + frustumLocalVariables.beta / (float)Math.PI * 0.5f;
                    }
                    intersectionDescription.getUVCoordinate().y = frustumLocalVariables.invers_point.z;
                }
            }
        }
    }

    public static class FrustumLocalVariables {
        public static final float FRUSTUM_BOTTOM_RADIUS_SQ = 1.0f;
        public static final float FRUSTUM_HEIGHT = 1.0f;
        public static final short TOP = 0;
        public static final short BOTTOM = 1;
        public static final short BODY = 2;
        public final RTShader.TransparencyInput transparencyInput = new RTShader.TransparencyInput();
        public float u;
        public float v;
        public final Ray invers_ray = new Ray();
        public float invers_t;
        public float t;
        public float cur_t;
        public boolean hasIntersection;
        public short intersection_part;
        public Point3f cur_invers_point = new Point3f();
        public Point3f invers_point = new Point3f();
        public float gz;
        public float dgz;
        public float a;
        public float b;
        public float c;
        public float D;
        public Point3f point = new Point3f();
        public float beta;
    }

    public static class FrustumInput {
        public final Ray ray = new Ray();
        public final Matrix4f transformation = new Matrix4f();
        public final Matrix4f invers_transformation = new Matrix4f();
        public int minIndex = 0;
        public float radius_ratio;
        public float radius_ratio_sq;
        public boolean open_top;
        public boolean open_bottom;
        public final Vector3f top_normal = new Vector3f();
        public final Vector3f top_tangenteU = new Vector3f();
        public final Vector3f top_tangenteV = new Vector3f();
    }

    public static class ConeLocalVariables {
        public static final float CONE_HEIGHT = 1.0f;
        public static final float CONE_RADIUS_SQ = 1.0f;
        public static final short BOTTOM = 0;
        public static final short BODY = 1;
        public final RTShader.TransparencyInput transparencyInput = new RTShader.TransparencyInput();
        public float u;
        public float v;
        public final Ray invers_ray = new Ray();
        public float invers_t;
        public float t;
        public float cur_t;
        public boolean hasIntersection;
        public short intersection_part;
        public Point3f cur_invers_point = new Point3f();
        public Point3f invers_point = new Point3f();
        public float a;
        public float b;
        public float c;
        public float D;
        public Point3f point = new Point3f();
        public float beta;
    }

    public static class ConeInput {
        public final Ray ray = new Ray();
        public final Matrix4f transformation = new Matrix4f();
        public final Matrix4f invers_transformation = new Matrix4f();
        public int minIndex = 0;
        public boolean open_bottom;
        public final Vector3f bottom_normal = new Vector3f();
        public final Vector3f bottom_tangenteU = new Vector3f();
        public final Vector3f bottom_tangenteV = new Vector3f();
    }

    public static class CylinderLocalVariables {
        public static final float CYLINDER_HEIGHT = 1.0f;
        public static final float CYLINDER_RADIUS = 1.0f;
        public static final float CYLINDER_RADIUS_SQ = 1.0f;
        public static final short TOP = 0;
        public static final short BOTTOM = 1;
        public static final short BODY = 2;
        public final RTShader.TransparencyInput transparencyInput = new RTShader.TransparencyInput();
        public float u;
        public float v;
        public final Ray invers_ray = new Ray();
        public float invers_t;
        public float cur_t;
        public float t;
        public boolean hasIntersection;
        public short intersection_part;
        public Point3f cur_invers_point = new Point3f();
        public Point3f invers_point = new Point3f();
        public float a;
        public float b;
        public float c;
        public float D;
        public Point3f point = new Point3f();
        public float beta;
    }

    public static class CylinderInput {
        public final Vector3f top_normal = new Vector3f();
        public final Vector3f top_tangenteU = new Vector3f();
        public final Vector3f top_tangenteV = new Vector3f();
        public boolean open_top;
        public boolean open_bottom;
        public final Ray ray = new Ray();
        public final Matrix4f transformation = new Matrix4f();
        public final Matrix4f invers_transformation = new Matrix4f();
        public int minIndex = 0;
    }

    public static class BoxLocalVariables {
        public static final short TOP = 0;
        public static final short BOTTOM = 1;
        public static final short FRONT = 2;
        public static final short BACK = 3;
        public static final short LEFT = 4;
        public static final short RIGHT = 5;
        public final RTShader.TransparencyInput transparencyInput = new RTShader.TransparencyInput();
        public float u;
        public float v;
        public final Ray invers_ray = new Ray();
        public float invers_t;
        public float cur_t;
        public float t;
        public boolean hasIntersection;
        public short intersection_part;
        public Point3f invers_point = new Point3f();
        public Point3f cur_invers_point = new Point3f();
        public Point3f point = new Point3f();
    }

    public static class BoxInput {
        public final Ray ray = new Ray();
        public final Matrix4f transformation = new Matrix4f();
        public final Matrix4f invers_transformation = new Matrix4f();
        public int minIndex = 0;
        public final Vector3f top_normal = new Vector3f();
        public final Vector3f front_normal = new Vector3f();
        public final Vector3f right_normal = new Vector3f();
        public float expansion_x;
        public float expansion_y;
        public float expansion_z;
    }

    public static class ParallelogramLocalVariables {
        public final RTShader.TransparencyInput transparencyInput = new RTShader.TransparencyInput();
        public final Ray invers_ray = new Ray();
        public float invers_t;
        public float t;
        public boolean hasIntersection;
        public Point3f invers_point = new Point3f();
        public Point3f point = new Point3f();
    }

    public static class ParallelogramInput {
        public final Ray ray = new Ray();
        public final Matrix4f transformation = new Matrix4f();
        public final Matrix4f invers_transformation = new Matrix4f();
        public RTShader transparencyShader;
        public final Vector3f normal = new Vector3f();
        public final Vector3f tangenteU = new Vector3f();
        public final Vector3f tangenteV = new Vector3f();
    }

    public static class PlaneLocalVariables {
        public final RTShader.TransparencyInput transparencyInput = new RTShader.TransparencyInput();
        public Ray invers_ray = new Ray();
        public float invers_t;
        public float t;
        public boolean hasIntersection;
        public Point3f invers_point = new Point3f();
        public Point3f point = new Point3f();
    }

    public static class PlaneInput {
        public Ray ray = new Ray();
        public Matrix4f transformation = new Matrix4f();
        public Matrix4f invers_transformation = new Matrix4f();
        public RTShader transparencyShader;
        public Vector3f normal = new Vector3f();
        public Vector3f tangenteU = new Vector3f();
        public Vector3f tangenteV = new Vector3f();
    }

    public static class SphereLocalVariables {
        public final RTShader.TransparencyInput transparencyInput = new RTShader.TransparencyInput();
        public float u;
        public float v;
        public Ray invers_ray = new Ray();
        public Vector3f dg = new Vector3f();
        public Vector3f g = new Vector3f();
        public float a;
        public float b;
        public float c;
        public float D;
        public float invers_t;
        public float t;
        public int t_index;
        public Point3f invers_point = new Point3f();
        public Point3f point = new Point3f();
        public Point3f center = new Point3f();
        public Vector3f normal = new Vector3f();
        public float x = 0.0f;
        public float z = 0.0f;
    }

    public static class SphereInput {
        public Ray ray = new Ray();
        public Matrix4f transformation = new Matrix4f();
        public Matrix4f invers_transformation = new Matrix4f();
        public int minIndex = 0;
        public float radius;
        public float squareRadius;
    }

    public static class ObjectOutput {
        public boolean hasIntersection;
        public float t;
    }

    public static class BoxIntersectionLocalVariables {
        public float t;
        public Point3f point = new Point3f();
    }

    public static class BoxIntersectionInput {
        public final Ray ray = new Ray();
        public final Vector3f minValues = new Vector3f();
        public final Vector3f maxValues = new Vector3f();
    }

    public static class SphereIntersectionLocalVariables {
        public Ray invers_ray = new Ray();
        public Vector3f dg = new Vector3f();
        public Vector3f g = new Vector3f();
        public float a;
        public float b;
        public float c;
        public float D;
        public float invers_t;
    }

    public static class SphereIntersectionInput {
        public Ray ray = new Ray();
        public Matrix4f invers_transformation = new Matrix4f();
        public float squareRadius;
    }
}

