/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

public final class HemiCube {
    private static boolean isInit = false;
    private static int pixelsWide;
    private static float worldWide;
    private static float[][] topPixels;
    private static float[][] sidePixels;

    public static void init(int n) {
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        int n3;
        pixelsWide = n;
        int n4 = pixelsWide / 2;
        topPixels = new float[pixelsWide][pixelsWide];
        sidePixels = new float[pixelsWide][n4];
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                f4 = (float)(n2 - n4) - 0.5f;
                f3 = (float)n3 + 0.5f;
                f2 = f4 * f4 + f3 * f3 + (float)(n4 * n4);
                f2 *= f2;
                HemiCube.topPixels[n2][n3] = f = (float)(n4 * n4) / ((float)Math.PI * f2);
            }
        }
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                float f5;
                f4 = (float)(n2 - n4) - 0.5f;
                f3 = (float)n3 + 0.5f;
                f2 = f4 * f4 + (float)(n4 * n4);
                f = f2 + f3 * f3;
                f *= f;
                f2 = (float)Math.sqrt(f2);
                HemiCube.sidePixels[n2][n3] = f5 = f3 * f2 / ((float)Math.PI * f);
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                HemiCube.topPixels[HemiCube.pixelsWide - n2 - 1][n3] = topPixels[n2][n3];
                HemiCube.sidePixels[HemiCube.pixelsWide - n2 - 1][n3] = sidePixels[n2][n3];
            }
            for (n2 = 0; n2 < pixelsWide; ++n2) {
                HemiCube.topPixels[n2][HemiCube.pixelsWide - n3 - 1] = topPixels[n2][n3];
            }
        }
        isInit = true;
    }

    public static float getFormFactor(int n, int n2, int n3) {
        if (!isInit) {
            System.err.println("ERROR: Hemicube not initialized");
            System.exit(1);
        }
        if (n == 0) {
            return topPixels[n2][n3];
        }
        if (n > 0) {
            return sidePixels[n2][n3];
        }
        return 0.0f;
    }

    public static float getWorldWide() {
        if (worldWide == -1.0f) {
            System.err.println("ERROR: Hemicube not initialized");
            System.exit(1);
        }
        return worldWide;
    }

    public static void setWorldWide(float f) {
        worldWide = f;
    }

    public static int getPixelsWide() {
        return pixelsWide;
    }

    public static void print() {
        int n;
        int n2;
        System.out.println("hemi cube top content:");
        for (n2 = 0; n2 < pixelsWide; ++n2) {
            for (n = 0; n < pixelsWide; ++n) {
                System.out.print(String.format("%f ", Float.valueOf(HemiCube.getFormFactor(0, n2, n))));
                if ((n + 1) % 5 != 0) continue;
                System.out.println();
            }
            System.out.println();
        }
        System.out.println("hemi cube side 2 content:");
        for (n2 = 0; n2 < pixelsWide; ++n2) {
            for (n = 0; n < pixelsWide / 2; ++n) {
                System.out.print(String.format("%f ", Float.valueOf(HemiCube.getFormFactor(2, n2, n))));
                if ((n + 1) % 5 != 0) continue;
                System.out.println();
            }
            System.out.println();
        }
    }

    static {
        worldWide = -1.0f;
    }
}

