/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

import javax.vecmath.Tuple3d;

public class Vector3d
extends javax.vecmath.Vector3d {
    private static double M_05PI = 1.5707963705062866;
    private static final long serialVersionUID = 1L;

    public Vector3d() {
    }

    public Vector3d(Tuple3d tuple3d) {
        super(tuple3d);
    }

    public Vector3d(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public void rotateX(double d, double d2) {
        double d3 = this.y;
        this.y = this.y * d2 - this.z * d;
        this.z = d3 * d + this.z * d2;
    }

    public void rotateY(double d, double d2) {
        double d3 = this.x;
        this.x = d2 * this.x + d * this.z;
        this.z = -d * d3 + d2 * this.z;
    }

    public void rotateZ(double d, double d2) {
        double d3 = this.x;
        this.x = d2 * this.x - d * this.y;
        this.y = d * d3 + d2 * this.y;
    }

    public Theta calcRotationToZ() {
        Vector3d vector3d = new Vector3d(this.x, this.y, this.z);
        double d = 0.0;
        Theta theta = new Theta();
        theta.thetaX = 0.0;
        if (vector3d.z == 0.0) {
            theta.thetaX = vector3d.y > 0.0 ? M_05PI : -M_05PI;
        } else {
            d = vector3d.y / -vector3d.z;
            theta.thetaX = -Math.atan(d);
            if (vector3d.z < 0.0) {
                theta.thetaX += Math.PI;
            }
        }
        double d2 = Math.cos(theta.thetaX);
        double d3 = Math.sin(theta.thetaX);
        vector3d.rotateX(d3, d2);
        double d4 = 0.0;
        theta.thetaY = 0.0;
        if (vector3d.z == 0.0) {
            theta.thetaY = vector3d.x > 0.0 ? -M_05PI : M_05PI;
        } else {
            d4 = vector3d.x / vector3d.z;
            theta.thetaY = -Math.atan(d4);
            if (vector3d.z < 0.0) {
                theta.thetaY += Math.PI;
            }
        }
        return theta;
    }

    public Object clone() {
        return new Vector3d((Tuple3d)this);
    }

    public class Theta {
        public double thetaX = 0.0;
        public double thetaY = 0.0;
    }
}

