/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

import de.grogra.ray2.radiosity.FormFactor;
import de.grogra.ray2.radiosity.SubPatch;
import de.grogra.ray2.radiosity.Vector3d;
import de.grogra.ray2.radiosity.ZBuffer;
import java.util.Map;
import javax.vecmath.Tuple3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewCube {
    private static float M_05PI = 1.5707964f;
    private ZBuffer top;
    private ZBuffer[] side = new ZBuffer[4];
    private Vector3d normalVector;
    private Vector3d deltaCenter = new Vector3d();
    private double thetaX;
    private double thetaY;

    public ViewCube(Vector3d vector3d, Vector3d vector3d2) {
        this.normalVector = vector3d2;
        Vector3d vector3d3 = new Vector3d(0.0, 0.0, 0.0);
        this.deltaCenter.sub((Tuple3d)vector3d3, (Tuple3d)vector3d);
        Vector3d.Theta theta = this.normalVector.calcRotationToZ();
        this.thetaX = theta.thetaX;
        this.thetaY = theta.thetaY;
        this.top = new ZBuffer(true);
        for (int i = 0; i < 4; ++i) {
            this.side[i] = new ZBuffer(false);
        }
    }

    public void projPatchOnCube(SubPatch subPatch) {
        SubPatch subPatch2 = new SubPatch(subPatch);
        subPatch2.move(this.deltaCenter);
        subPatch2.rotateX(this.thetaX);
        subPatch2.rotateY(this.thetaY);
        this.top.insert(subPatch2, subPatch);
        float f = M_05PI;
        subPatch2.rotateY(-f);
        subPatch2.rotateZ(-f);
        this.side[0].insert(subPatch2, subPatch);
        for (int i = 1; i < 4; ++i) {
            subPatch2.rotateY(-f);
            this.side[i].insert(subPatch2, subPatch);
        }
    }

    public void computeFormFactorMap(Map<SubPatch, FormFactor> map) {
        this.top.fillFormFactors(map, 0);
        for (int i = 0; i < 4; ++i) {
            this.side[i].fillFormFactors(map, 1);
        }
    }
}

