/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Shader;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Resources;
import de.grogra.ray2.Scene;
import de.grogra.ray2.light.DefaultLightProcessor;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.ProcessorBase;
import de.grogra.ray2.tracing.RayProcessorBase;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import java.util.Random;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PathTracer
extends RayProcessorBase {
    public static final String BRIGHTNESS = "pathtracer.brightness";
    private static final float MIN_WEIGHT = 0.01f;
    private long secondaryCount = 0L;
    private RayList rays;
    private Vector3f view;
    private float brightness;

    public PathTracer() {
        DefaultLightProcessor defaultLightProcessor = new DefaultLightProcessor();
        defaultLightProcessor.useGeometryTerm(true);
        defaultLightProcessor.useOneSamplePerLight(true);
        this.setLightProcessor(defaultLightProcessor);
    }

    protected void initLocals() {
        super.initLocals();
        this.rays = new RayList(this.scene.createSpectrum());
        this.view = new Vector3f();
    }

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        super.initialize(pixelwiseRenderer, scene);
        this.brightness = pixelwiseRenderer.getNumericOption(BRIGHTNESS, new Float(200.0f)).floatValue();
    }

    float getBrightness() {
        return this.brightness;
    }

    int getEnvironmentType() {
        return 1;
    }

    float traceRay(int n, Intersection intersection, Spectrum spectrum, Tuple3d tuple3d, RayProcessorBase.Locals locals, Random random) {
        if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
            System.err.println("traceRay " + n + ' ' + intersection + ' ' + spectrum);
        }
        Spectrum spectrum2 = locals.newWeight;
        Spectrum spectrum3 = locals.tmpSpectrum;
        Line line = locals.tmpRay;
        float f = 0.0f;
        boolean bl = intersection.parameter < Double.POSITIVE_INFINITY;
        this.view.set((Tuple3d)intersection.line.direction);
        this.view.negate();
        assert (Math.abs(this.view.lengthSquared() - 1.0f) < 1.0E-4f);
        Shader shader = this.scene.getShader(intersection.volume);
        int n2 = this.scene.getLight(intersection.volume);
        Light light = n2 >= 0 ? this.scene.getLights()[n2] : null;
        locals.env.set(intersection, (shader != null ? shader.getFlags() : 0) | (light != null ? light.getFlags() : 0), this.scene);
        locals.env.iorRatio = (float)this.getIOR(intersection, spectrum);
        if (light != null && !light.isIgnoredWhenHit()) {
            this.rays.setSize(1);
            Ray ray = this.rays.rays[0];
            ray.direction.set((Tuple3d)intersection.getNormal());
            locals.env.localToGlobal.set(this.scene.getLightTransformation(n2));
            locals.env.globalToLocal.set(this.scene.getInverseLightTransformation(n2));
            light.computeExitance(locals.env, ray.spectrum);
            light.computeBSDF(locals.env, this.view, ray.spectrum, ray.direction, true, spectrum3);
            spectrum3.dot(spectrum, this.tmpColor);
            if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
                System.err.println("hit light source " + light + " " + this.tmpColor);
            }
            tuple3d.add(this.tmpColor);
        }
        if (bl && shader != null) {
            this.rays.clear();
            this.lightProcessor.getLightRays(intersection.line.direction.dot(intersection.getNormal()) < 0.0, intersection, this.rays, locals.lightCache, random);
            for (int i = this.rays.size() - 1; i >= 0; --i) {
                shader.computeBSDF(locals.env, this.view, this.rays.rays[i].spectrum, this.rays.rays[i].direction, true, spectrum3);
                spectrum3.dot(spectrum, this.tmpColor);
                if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
                    System.err.println("contribution of light " + i + " " + this.tmpColor);
                    System.err.println("    " + this.rays.rays[i] + " " + locals.env);
                }
                tuple3d.add(this.tmpColor);
            }
        }
        if (bl && n <= this.maxDepth) {
            line.origin.set((Tuple3d)intersection.getPoint());
            this.rays.setSize(1);
            if (shader != null) {
                shader.generateRandomRays(locals.env, this.view, spectrum, this.rays, false, random);
            } else {
                this.rays.rays[0].direction.set((Tuple3d)intersection.line.direction);
                this.rays.rays[0].spectrum.set(spectrum);
            }
            spectrum2.set(this.rays.rays[0].spectrum);
            if (spectrum2.integrate() > (double)0.01f) {
                boolean bl2 = this.rays.rays[0].reflected;
                ++this.secondaryCount;
                int n3 = this.ilist.size;
                line.direction.set((Tuple3f)this.rays.rays[0].direction);
                this.scene.computeIntersections(line, 1, this.ilist, intersection, null);
                if (this.ilist.size > n3) {
                    int n4 = this.record(intersection, bl2);
                    f = this.traceRay(n + 1, this.ilist.elements[n3], spectrum2, tuple3d, locals.nextReflected(), random);
                    this.unrecord(intersection, n4);
                    this.ilist.setSize(n3);
                } else {
                    f = (float)spectrum2.integrate();
                }
                if (bl2) {
                    f = 0.0f;
                }
            }
        }
        if (PixelwiseRenderer.DEBUG_SUBPIXEL) {
            System.err.println("traceRay " + n + ' ' + tuple3d);
        }
        return f;
    }

    protected void mergeStatistics(ProcessorBase processorBase) {
        super.mergeStatistics(processorBase);
        this.secondaryCount += ((PathTracer)processorBase).secondaryCount;
    }

    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        stringBuffer.append(Resources.msg("rayprocessor.pathtracer.statistics", new Long(this.primaryCount), new Long(this.secondaryCount)));
        this.lightProcessor.appendStatistics(stringBuffer);
    }
}

