/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Shader;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Scene;
import de.grogra.ray2.light.DefaultLightProcessor;
import de.grogra.ray2.photonmap.OptionReader;
import de.grogra.ray2.photonmap.PhotonMap;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.RayProcessorBase;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.xl.util.ObjectList;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.goui.util.MTRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotonMapRayProcessor
extends RayProcessorBase {
    private static int SHOWPHOTONMAPWITHCOLOREDTYPE_MODE = 1;
    private static int SHOWPHOTONMAP_MODE = 2;
    private int debug_mode = 0;
    private static PhotonMap photonMap = null;
    private float[] lightProp = null;
    private Color3f[] photonColor = null;
    private int selectedLight = 0;
    private int globalPhotonCount = 10000;
    private int causticPhotonCount = 50000;
    private int photonDepth = 5;
    private Environment[] lightEnvironments = null;
    private MTRandom random = new MTRandom();
    private final Line line = new Line();
    boolean newMapCreated = false;
    private Spectrum tmpSpectrum0;
    private Environment env;
    private final Vector3f out = new Vector3f();
    private ObjectList<Spectrum> radiantPower = new ObjectList();
    private static long pmTime = 0L;
    private RayList rays;
    private Vector3f view;
    private Vector3f reflectedVariance = new Vector3f();
    private Vector3f refractedVariance = new Vector3f();
    private static final float MAX_VARIANCE = 1.7608814f;
    private static final float MIN_WEIGHT = 0.03f;
    private final Vector3d tmpVector = new Vector3d();

    public PhotonMapRayProcessor() {
        DefaultLightProcessor defaultLightProcessor = new DefaultLightProcessor();
        defaultLightProcessor.useGeometryTerm(true);
        defaultLightProcessor.useOneSamplePerLight(true);
        this.setLightProcessor(defaultLightProcessor);
    }

    @Override
    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        super.initialize(pixelwiseRenderer, scene);
        OptionReader optionReader = new OptionReader(pixelwiseRenderer);
        if (photonMap == null || optionReader.isPhotonMapCalcNeeded(scene)) {
            long l = System.currentTimeMillis();
            this.globalPhotonCount = optionReader.getGlobalPhotonCount();
            this.causticPhotonCount = optionReader.getCausticPhotonCount();
            this.photonDepth = optionReader.getPhotonDepth();
            Spectrum spectrum = scene.createSpectrum();
            this.env = new Environment(scene.getBoundingBox(), spectrum, 2);
            this.tmpSpectrum0 = spectrum.newInstance();
            photonMap = new PhotonMap(optionReader.getPhotonArea());
            this.createPhotonMap(pixelwiseRenderer);
            this.newMapCreated = true;
            pmTime = System.currentTimeMillis() - l;
        }
        optionReader.calcFinished(scene);
    }

    @Override
    protected void initLocals() {
        super.initLocals();
        this.rays = new RayList(this.scene.createSpectrum());
        this.view = new Vector3f();
    }

    private void computeLightProbs(ArrayList<Light> arrayList, int n) {
        this.lightProp = new float[arrayList.size()];
        this.photonColor = new Color3f[arrayList.size()];
        RayList rayList = new RayList(1);
        float f = 0.0f;
        this.lightEnvironments = new Environment[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.lightEnvironments[i] = new Environment(this.scene.getBoundingBox(), this.scene.createSpectrum(), this.getEnvironmentType());
            this.lightEnvironments[i].localToGlobal.set(this.scene.getLightTransformation(i));
            arrayList.get(i).generateRandomOrigins(this.lightEnvironments[i], rayList, this.random);
            this.photonColor[i] = new Color3f((Color3f)rayList.rays[0].color);
            f += this.photonColor[i].x + this.photonColor[i].y + this.photonColor[i].z;
        }
        float f2 = f / (float)n;
        for (int i = 0; i < arrayList.size(); ++i) {
            this.lightProp[i] = (this.photonColor[i].x + this.photonColor[i].y + this.photonColor[i].z) / f2;
            this.photonColor[i].scale(1.0f / this.lightProp[i]);
        }
    }

    private int selectLight() {
        if (this.lightProp[this.selectedLight] > 0.0f) {
            int n = this.selectedLight;
            this.lightProp[n] = this.lightProp[n] - 1.0f;
            return this.selectedLight;
        }
        int n = ++this.selectedLight;
        this.lightProp[n] = this.lightProp[n] - 1.0f;
        return this.selectedLight;
    }

    private Ray generatePhoton(int n, ArrayList<Light> arrayList) {
        RayList rayList = new RayList(1);
        Vector3f vector3f = new Vector3f();
        Light light = arrayList.get(n);
        light.generateRandomOrigins(this.lightEnvironments[n], rayList, this.random);
        light.generateRandomRays(this.lightEnvironments[n], vector3f, this.scene.createSpectrum(), rayList, true, this.random);
        Ray ray = new Ray(rayList.rays[0]);
        ray.color.set((Tuple3f)this.photonColor[this.selectedLight]);
        return ray;
    }

    private void createPhotonMap(PixelwiseRenderer pixelwiseRenderer) {
        int n;
        int n2;
        ArrayList<Light> arrayList = new ArrayList<Light>();
        for (Light light : this.scene.getLights()) {
            if (light.getLightType() == 0) continue;
            arrayList.add(light);
        }
        if (arrayList.size() == 0) {
            System.err.println("Warning: Scene contains no Lights. No Photon Map created.\n");
            return;
        }
        this.computeLightProbs(arrayList, this.globalPhotonCount);
        for (n2 = this.globalPhotonCount; n2 != 0 && !this.isStopped(pixelwiseRenderer); --n2) {
            this.renderer.setMessage("Creating Photonmap.", 1.0f - 1.0f / ((float)this.globalPhotonCount / ((float)n2 + 1.0f)));
            n = this.selectLight();
            Ray ray = this.generatePhoton(n, arrayList);
            this.shootPhoton(this.photonDepth, ray, null, false);
        }
        this.selectedLight = 0;
        this.computeLightProbs(arrayList, this.causticPhotonCount);
        for (n2 = this.causticPhotonCount; n2 != 0 && !this.isStopped(pixelwiseRenderer); --n2) {
            this.renderer.setMessage("Creating Caustic Photonmap.", 1.0f - 1.0f / ((float)this.causticPhotonCount / ((float)n2 + 1.0f)));
            n = this.selectLight();
            Ray ray = this.generatePhoton(n, arrayList);
            this.shootPhoton(this.photonDepth, ray, null, true);
        }
    }

    private void shootPhoton(int n, Ray ray, Intersection intersection, boolean bl) {
        this.line.origin.set((Tuple3f)ray.getOrigin());
        this.line.direction.set((Tuple3f)ray.getDirection());
        this.line.start = 1.0E-5;
        this.line.end = Double.POSITIVE_INFINITY;
        Spectrum spectrum = this.tmpSpectrum0;
        spectrum.set(ray.spectrum);
        IntersectionList intersectionList = new IntersectionList();
        this.scene.computeIntersections(this.line, 1, intersectionList, null, null);
        if (intersectionList.size > 0) {
            boolean bl2;
            Ray ray2;
            Intersection intersection2 = intersectionList.elements[0];
            int n2 = intersection2.volume.getId();
            this.out.set((Tuple3d)this.line.direction);
            this.out.negate();
            this.env.iorRatio = (float)this.getIOR(intersection2, spectrum);
            Shader shader = this.scene.getShader(intersection2.volume);
            if (shader == null) {
                this.rays.setSize(1);
                ray2 = this.rays.rays[0];
                ray2.direction.set((Tuple3d)this.line.direction);
                ray2.spectrum.set(spectrum);
            } else {
                this.setEnvironment(this.env, intersection2, shader.getFlags(), this.scene);
                this.rays.setSize(1);
                shader.generateRandomRays(this.env, this.out, spectrum, this.rays, true, this.random);
            }
            ray2 = this.rays.lastRay();
            ray2.origin.set((Tuple3d)intersection2.getPoint());
            spectrum.sub(ray2.spectrum);
            spectrum.clampMinZero();
            Spectrum spectrum2 = (Spectrum)this.radiantPower.get(n2);
            if (spectrum2 == null) {
                this.radiantPower.set(n2, (Object)spectrum.clone());
            } else {
                spectrum2.add(spectrum);
            }
            boolean bl3 = Math.abs(intersection2.getNormal().dot(new Vector3d(this.out)) - intersection2.getNormal().dot(new Vector3d(ray2.direction))) < 0.001;
            boolean bl4 = intersection2.getNormal().dot(new Vector3d(this.out)) * intersection2.getNormal().dot(new Vector3d(ray2.direction)) <= 0.0;
            boolean bl5 = this.out.dot(new Vector3f(intersection2.getNormal())) <= 0.0f;
            boolean bl6 = bl2 = !bl5 && !bl3 && !bl4;
            if (this.debug_mode == SHOWPHOTONMAPWITHCOLOREDTYPE_MODE) {
                if (bl5) {
                    photonMap.insertPhoton(new Color3f(1.0f, 0.0f, 0.0f), intersection2.getPoint(), this.out);
                } else if (bl3) {
                    photonMap.insertPhoton(new Color3f(0.0f, 1.0f, 0.0f), intersection2.getPoint(), this.out);
                } else if (bl4) {
                    photonMap.insertPhoton(new Color3f(0.0f, 0.0f, 1.0f), intersection2.getPoint(), this.out);
                } else {
                    photonMap.insertPhoton(new Color3f(1.0f, 1.0f, 1.0f), intersection2.getPoint(), this.out);
                }
            } else {
                Color3f color3f = new Color3f();
                ray2.spectrum.get((Tuple3f)color3f);
                if (bl) {
                    if (n != this.photonDepth && bl2) {
                        photonMap.insertPhoton(color3f, intersection2.getPoint(), new Vector3f(this.out));
                    }
                } else if (!(bl5 || bl3 || bl4)) {
                    photonMap.insertPhoton(color3f, intersection2.getPoint(), new Vector3f(this.out));
                }
            }
            if (n > 0 && intersection2.parameter < Double.POSITIVE_INFINITY) {
                if (bl) {
                    if (!bl2) {
                        int n3 = this.record(intersection2, ray2.reflected);
                        this.shootPhoton(n - 1, ray2, intersection2, bl);
                        this.unrecord(intersection2, n3);
                    }
                } else {
                    int n4 = this.record(intersection2, ray2.reflected);
                    this.shootPhoton(n - 1, ray2, intersection2, bl);
                    this.unrecord(intersection2, n4);
                }
            }
        }
    }

    @Override
    float traceRay(int n, Intersection intersection, Spectrum spectrum, Tuple3d tuple3d, RayProcessorBase.Locals locals, Random random) {
        if (this.debug_mode == SHOWPHOTONMAP_MODE || this.debug_mode == SHOWPHOTONMAPWITHCOLOREDTYPE_MODE) {
            return photonMap.traceRay(intersection, tuple3d);
        }
        Spectrum spectrum2 = locals.newWeight;
        Ray ray = locals.reflected;
        Ray ray2 = locals.transmitted;
        Spectrum spectrum3 = locals.tmpSpectrum;
        Line line = locals.tmpRay;
        float f = 0.0f;
        boolean bl = intersection.parameter < Double.POSITIVE_INFINITY;
        this.view.set((Tuple3d)intersection.line.direction);
        this.view.negate();
        assert (Math.abs(this.view.lengthSquared() - 1.0f) < 1.0E-4f);
        Shader shader = this.scene.getShader(intersection.volume);
        int n2 = this.scene.getLight(intersection.volume);
        Light light = n2 >= 0 ? this.scene.getLights()[n2] : null;
        locals.env.set(intersection, (shader != null ? shader.getFlags() : 0) | (light != null ? light.getFlags() : 0), this.scene);
        locals.env.iorRatio = (float)this.getIOR(intersection, spectrum);
        if (light != null && !light.isIgnoredWhenHit()) {
            this.rays.setSize(1);
            Ray ray3 = this.rays.rays[0];
            ray3.direction.set((Tuple3d)intersection.getNormal());
            ray3.direction.negate();
            ray3.direction.normalize();
            locals.env.localToGlobal.set(this.scene.getLightTransformation(n2));
            locals.env.globalToLocal.set(this.scene.getInverseLightTransformation(n2));
            light.computeExitance(locals.env, ray3.spectrum);
            light.computeBSDF(locals.env, ray3.direction, ray3.spectrum, this.view, false, spectrum3);
            spectrum3.dot(spectrum, this.tmpColor);
            ray3.spectrum.set(spectrum3);
            tuple3d.add(this.tmpColor);
        }
        this.rays.clear();
        if (bl && shader != null) {
            this.lightProcessor.getLightRays(intersection.line.direction.dot(intersection.getNormal()) < 0.0, intersection, this.rays, locals.lightCache, random);
            if (this.rays.size() > 0) {
                shader.shade(locals.env, this.rays, this.view, spectrum, this.tmpColor);
                tuple3d.add(this.tmpColor);
            }
            photonMap.sumPhotons(intersection.getPoint(), new Vector3f(intersection.getNormal()), tuple3d);
        }
        if (bl && n <= this.maxDepth) {
            int n3;
            int n4;
            line.origin.set((Tuple3d)intersection.getPoint());
            if (shader != null) {
                shader.computeMaxRays(locals.env, this.view, spectrum, ray, (Tuple3f)this.reflectedVariance, ray2, (Tuple3f)this.refractedVariance);
            } else {
                this.reflectedVariance.set(1.7608814f, 1.7608814f, 1.7608814f);
                ray.spectrum.setZero();
                this.refractedVariance.set(0.0f, 0.0f, 0.0f);
                ray2.direction.set((Tuple3d)intersection.line.direction);
                ray2.spectrum.set(spectrum);
            }
            float f2 = this.reflectedVariance.x + this.reflectedVariance.y + this.reflectedVariance.z;
            float f3 = this.refractedVariance.x + this.refractedVariance.y + this.refractedVariance.z;
            if (f2 < 1.7608814f && ray.spectrum.integrate() > (double)0.03f) {
                spectrum2.set(ray.spectrum);
                n4 = this.ilist.size;
                line.direction.set((Tuple3f)ray.direction);
                this.scene.computeIntersections(line, 1, this.ilist, intersection, null);
                if (this.ilist.size > n4) {
                    n3 = this.record(intersection, true);
                    this.traceRay(n + 1, this.ilist.elements[n4], spectrum2, tuple3d, locals.nextReflected(), random);
                    this.unrecord(intersection, n3);
                    this.ilist.setSize(n4);
                }
            }
            if (f3 < 1.7608814f && ray2.spectrum.integrate() > (double)0.03f) {
                spectrum2.set(ray2.spectrum);
                n4 = this.ilist.size;
                line.direction.set((Tuple3f)ray2.direction);
                this.scene.computeIntersections(line, 1, this.ilist, intersection, null);
                if (this.ilist.size > n4) {
                    n3 = this.record(intersection, false);
                    f = this.traceRay(n + 1, this.ilist.elements[n4], spectrum2, tuple3d, locals.nextTransmitted(), random);
                    this.unrecord(intersection, n3);
                    this.ilist.setSize(n4);
                } else {
                    f = (float)spectrum2.integrate();
                }
            }
        }
        return f;
    }

    private void setEnvironment(Environment environment, Intersection intersection, int n, Scene scene) {
        if ((n & 2) != 0) {
            if (intersection.parameter == Double.POSITIVE_INFINITY) {
                this.tmpVector.normalize(intersection.line.direction);
                environment.point.set((Tuple3d)this.tmpVector);
                this.tmpVector.scale(1.0E100);
                scene.transform(intersection.volume, (Tuple3d)this.tmpVector, (Tuple3d)this.tmpVector);
                this.tmpVector.normalize();
                environment.localPoint.set((Tuple3d)this.tmpVector);
            } else {
                Point3d point3d = intersection.getPoint();
                environment.point.set((Tuple3d)point3d);
                scene.transform(intersection.volume, (Tuple3d)point3d, (Tuple3d)this.tmpVector);
                environment.localPoint.set((Tuple3d)this.tmpVector);
            }
        }
        if ((n & 4) != 0) {
            environment.normal.set((Tuple3d)intersection.getNormal());
        }
        if ((n & 0x10) != 0) {
            environment.uv.set((Tuple2d)intersection.getUV());
        }
        if ((n & 8) != 0) {
            environment.dpdu.set((Tuple3d)intersection.getUTangent());
            environment.dpdv.set((Tuple3d)intersection.getVTangent());
        }
        environment.solid = intersection.type != 0;
    }

    @Override
    int getEnvironmentType() {
        return 1;
    }

    private boolean isStopped(PixelwiseRenderer pixelwiseRenderer) {
        boolean bl = this.renderer.isStopped();
        if (bl) {
            photonMap = null;
        }
        return bl;
    }

    @Override
    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        stringBuffer.append("Photon Map Statistics\n");
        stringBuffer.append("    New Photon Map created  : " + (this.newMapCreated ? "yes" : "no") + "\n");
        stringBuffer.append("    Photon Map creation time: " + (int)(pmTime / 60000L) + " minutes " + (float)(pmTime % 60000L) * 0.001f + " seconds\n");
        stringBuffer.append("    Number of Map entries   : " + photonMap.getEntryCount());
        if (this.debug_mode != 0) {
            stringBuffer.append("    DEBUG MODE              : " + this.debug_mode);
        }
    }
}

