/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray2.ProgressMonitor;
import de.grogra.ray2.Resources;
import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.LightModelProcessor;
import de.grogra.task.PartialTask;
import de.grogra.task.Solver;
import de.grogra.task.SolverInOwnThread;
import de.grogra.task.Task;
import de.grogra.xl.util.ObjectList;
import java.util.Random;
import net.goui.util.MTRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RadiationModelTask
extends Task {
    ProgressMonitor monitor;
    long seed;
    long totalRayCount;
    long pendingRayCount;
    long[] totalRaysFromLight;
    double[] lightFactors;
    long[] sentRaysFromLight;
    int threadCount;
    int depth;
    double minPower;
    Scene originalScene;
    LightModelProcessor processor;

    RadiationModelTask() {
    }

    void compute(Scene scene, long l, long l2, ProgressMonitor progressMonitor, int n, double d, ObjectList<Spectrum> objectList, ObjectList<Spectrum> objectList2, int[] nArray, int n2) {
        int n3;
        this.depth = n;
        this.minPower = d;
        this.seed = l2;
        this.totalRayCount = l;
        this.monitor = progressMonitor;
        if (n2 <= 0) {
            n2 = Runtime.getRuntime().availableProcessors();
        }
        this.threadCount = n2;
        this.originalScene = scene;
        int n4 = scene.getLights().length;
        Light[] lightArray = scene.getLights();
        if (n4 == 0) {
            if (progressMonitor != null) {
                progressMonitor.showMessage(Resources.msg("radiation.no-lights"));
            }
            return;
        }
        Environment environment = new Environment(scene.getBoundingBox(), scene.createSpectrum(), 2);
        double[] dArray = new double[n4];
        double d2 = 0.0;
        for (int i = 0; i < n4; ++i) {
            dArray[i] = lightArray[i].getTotalPower(environment);
            d2 += dArray[i];
        }
        if (!(d2 > 0.0)) {
            progressMonitor.showMessage(Resources.msg("radiation.total-power-0"));
            return;
        }
        this.totalRaysFromLight = new long[n4];
        long l3 = 0L;
        for (int i = 0; i < n4; ++i) {
            this.totalRaysFromLight[i] = (long)((double)this.totalRayCount * dArray[i] / d2);
            l3 += this.totalRaysFromLight[i];
        }
        MTRandom mTRandom = new MTRandom(l2);
        while (this.totalRayCount > l3) {
            n3 = mTRandom.nextInt(n4);
            if (!(dArray[n3] > 0.0)) continue;
            int n5 = n3;
            this.totalRaysFromLight[n5] = this.totalRaysFromLight[n5] + 1L;
            ++l3;
        }
        this.pendingRayCount = this.totalRayCount;
        this.sentRaysFromLight = new long[n4];
        this.lightFactors = new double[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.lightFactors[n3] = 1.0 / (double)this.totalRaysFromLight[n3];
        }
        this.processor = new LightModelProcessor(scene, objectList, objectList2, nArray);
        if (n2 < 2) {
            this.addSolver(this.createLocalSolver(true));
        } else {
            for (n3 = Math.min(32, n2); n3 > 0; --n3) {
                this.addSolver(this.createLocalSolver(false));
            }
        }
        this.solve();
        this.removeSolvers();
    }

    public Solver createLocalSolver(final boolean bl) {
        final LightModelProcessor lightModelProcessor = this.processor.dup(this.originalScene.dup());
        return new SolverInOwnThread(){
            private final Random rnd = new MTRandom();

            protected void solveImpl(PartialTask partialTask) {
                RadiationTask radiationTask = (RadiationTask)partialTask;
                lightModelProcessor.computeImpl(radiationTask.raysFromLight, radiationTask.seedOffsets, RadiationModelTask.this.lightFactors, this.rnd, null, RadiationModelTask.this.depth, RadiationModelTask.this.minPower);
                radiationTask.raysFromLight = null;
                RadiationModelTask.this.raysProcessed(radiationTask.rayCount);
            }

            protected Thread createThread() {
                if (bl) {
                    return null;
                }
                Thread thread = new Thread((Runnable)this, this.toString());
                thread.setPriority(1);
                return thread;
            }
        };
    }

    synchronized void raysProcessed(long l) {
        this.pendingRayCount -= l;
        if (this.monitor != null) {
            long l2 = this.totalRayCount - this.pendingRayCount;
            this.monitor.setProgress(Resources.msg("radiation.progress", l2 * 1000L, this.totalRayCount * 1000L, this.threadCount), (float)l2 / (float)this.totalRayCount);
        }
    }

    @Override
    protected synchronized boolean done() {
        return this.pendingRayCount == 0L;
    }

    @Override
    protected PartialTask nextPartialTask(int n) {
        int n2 = this.getSolverCount();
        RadiationTask radiationTask = new RadiationTask();
        radiationTask.raysFromLight = new long[this.totalRaysFromLight.length];
        radiationTask.seedOffsets = new long[this.totalRaysFromLight.length];
        long l = 0L;
        int n3 = 0;
        while (n3 < this.totalRaysFromLight.length) {
            long l2 = this.totalRaysFromLight[n3] - this.sentRaysFromLight[n3];
            if (l2 > 0L) {
                l2 = Math.min(Math.max(l2 / (long)(3 * n2) + 1L, Math.min(l2, this.totalRaysFromLight[n3] / (long)(5 * n2))), 100L);
            }
            radiationTask.raysFromLight[n3] = l2;
            radiationTask.seedOffsets[n3] = (this.seed * (long)this.totalRaysFromLight.length + (long)n3) * this.totalRayCount + this.sentRaysFromLight[n3];
            l += l2;
            int n4 = n3++;
            this.sentRaysFromLight[n4] = this.sentRaysFromLight[n4] + l2;
        }
        radiationTask.rayCount = l;
        return l == 0L ? null : radiationTask;
    }

    @Override
    protected void dispose(PartialTask partialTask) {
        long[] lArray = ((RadiationTask)partialTask).raysFromLight;
        if (lArray != null) {
            for (int i = 0; i < lArray.length; ++i) {
                int n = i;
                this.sentRaysFromLight[n] = this.sentRaysFromLight[n] - lArray[i];
            }
        }
    }

    public static class RadiationTask
    implements PartialTask {
        long rayCount;
        long[] raysFromLight;
        long[] seedOffsets;
    }
}

