/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Interior;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.util.Ray;
import de.grogra.ray2.Scene;
import de.grogra.ray2.light.LightProcessor;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.ProcessorBase;
import de.grogra.ray2.tracing.RayProcessor;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.Volume;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import net.goui.util.MTRandom;

public abstract class RayProcessorBase
extends ProcessorBase
implements RayProcessor {
    public static final String RECURSION_DEPTH = "rayprocessor.depth";
    int maxDepth = 5;
    protected PixelwiseRenderer renderer;
    LightProcessor lightProcessor = null;
    public Scene scene;
    IntersectionList ilist = new IntersectionList();
    Tuple3d tmpColor = new Point3d();
    protected Tuple3d sumColor = new Point3d();
    public ArrayList<Volume> enteredSolids = new ArrayList();
    long primaryCount = 0L;
    Locals locals;

    public void setLightProcessor(LightProcessor lightProcessor) {
        this.lightProcessor = lightProcessor;
    }

    public LightProcessor getLightProcessor() {
        return this.lightProcessor;
    }

    public void setRecursionDepth(int n) {
        if (n >= 0) {
            this.maxDepth = n;
        }
    }

    public RayProcessor dup(Scene scene) {
        RayProcessorBase rayProcessorBase = (RayProcessorBase)this.clone();
        rayProcessorBase.lightProcessor = this.lightProcessor.dup(scene);
        rayProcessorBase.scene = scene;
        rayProcessorBase.initLocals();
        return rayProcessorBase;
    }

    protected void mergeStatistics(ProcessorBase processorBase) {
        this.primaryCount += ((RayProcessorBase)processorBase).primaryCount;
    }

    protected void initLocals() {
        this.ilist = new IntersectionList();
        this.enteredSolids = new ArrayList();
        this.locals = new Locals();
        this.tmpColor = new Point3d();
        this.sumColor = new Point3d();
    }

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        this.renderer = pixelwiseRenderer;
        this.scene = scene;
        this.initLocals();
        this.lightProcessor.initialize(scene, this.getEnvironmentType(), new MTRandom(pixelwiseRenderer.getSeed()));
        this.setRecursionDepth(Math.min(Math.max(pixelwiseRenderer.getNumericOption(RECURSION_DEPTH, this.maxDepth).intValue(), 0), 10));
    }

    public void initializeBeforeTracing(Random random) {
    }

    private double getIOR(Volume volume, Spectrum spectrum) {
        Interior interior = this.scene.getInterior(volume);
        return interior != null ? (double)interior.getIndexOfRefraction(spectrum) : 1.0;
    }

    public double getIOR(Intersection intersection, Spectrum spectrum) {
        switch (intersection.type) {
            case 0: {
                return 1.0;
            }
            case 1: {
                double d = this.enteredSolids.isEmpty() ? 1.0 : this.getIOR(this.enteredSolids.get(this.enteredSolids.size() - 1), spectrum);
                double d2 = this.getIOR(intersection.solid, spectrum);
                return d / d2;
            }
            case -1: {
                int n = this.enteredSolids.size();
                if (n == 0) {
                    return 1.0;
                }
                if (this.enteredSolids.get(n - 1) != intersection.solid) {
                    return 1.0;
                }
                double d = n == 1 ? 1.0 : this.getIOR(this.enteredSolids.get(n - 2), spectrum);
                double d3 = this.getIOR(intersection.solid, spectrum);
                return d / d3;
            }
        }
        throw new AssertionError();
    }

    public int record(Intersection intersection, boolean bl) {
        switch (intersection.type) {
            case 0: {
                return -2;
            }
            case 1: {
                if (bl) {
                    return -2;
                }
                this.enteredSolids.add(intersection.solid);
                return -1;
            }
            case -1: {
                if (bl) {
                    return -2;
                }
                int n = this.enteredSolids.lastIndexOf(intersection.solid);
                if (n >= 0) {
                    this.enteredSolids.remove(n);
                    return n;
                }
                return -2;
            }
        }
        throw new AssertionError();
    }

    public void unrecord(Intersection intersection, int n) {
        if (n >= 0) {
            this.enteredSolids.add(n, intersection.solid);
        } else if (n == -1) {
            this.enteredSolids.remove(this.enteredSolids.size() - 1);
        }
    }

    @Deprecated
    public double record(Intersection intersection, boolean bl, Spectrum spectrum) {
        if (intersection == null) {
            return 1.0;
        }
        switch (intersection.type) {
            case 0: {
                return 1.0;
            }
            case -1: {
                bl = !bl;
            }
            case 1: {
                double d;
                int n;
                if (!bl && (n = this.enteredSolids.lastIndexOf(intersection.solid)) >= 0) {
                    this.enteredSolids.remove(n);
                }
                Interior interior = this.enteredSolids.isEmpty() ? null : this.scene.getInterior(this.enteredSolids.get(this.enteredSolids.size() - 1));
                double d2 = d = interior != null ? (double)interior.getIndexOfRefraction(spectrum) : 1.0;
                if (bl) {
                    this.enteredSolids.add(intersection.solid);
                }
                double d3 = (interior = this.scene.getInterior(intersection.solid)) != null ? (double)interior.getIndexOfRefraction(spectrum) : 1.0;
                return d / d3;
            }
        }
        throw new AssertionError();
    }

    float getBrightness() {
        return 1.0f;
    }

    public void getColorFromRay(Line line, Spectrum spectrum, Color4f color4f, Random random) {
        ++this.primaryCount;
        this.enteredSolids.clear();
        this.ilist.clear();
        this.scene.computeIntersections(line, 1, this.ilist, null, null);
        if (this.ilist.size == 0) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        Intersection intersection = this.ilist.elements[0];
        this.sumColor.set(0.0, 0.0, 0.0);
        float f = this.traceRay(1, intersection, spectrum, this.sumColor, this.locals.nextReflected(), random);
        this.sumColor.scale((double)this.getBrightness());
        color4f.x = (float)this.sumColor.x;
        color4f.y = (float)this.sumColor.y;
        color4f.z = (float)this.sumColor.z;
        color4f.w = f < 1.0f ? 1.0f - f : 0.0f;
    }

    abstract int getEnvironmentType();

    abstract float traceRay(int var1, Intersection var2, Spectrum var3, Tuple3d var4, Locals var5, Random var6);

    public class Locals {
        public Locals nextTransmitted;
        public Locals nextReflected;
        public Spectrum newWeight;
        public Ray reflected;
        public Ray transmitted;
        public Spectrum tmpSpectrum;
        public Line tmpRay;
        public Environment env;
        public ArrayList lightCache;

        public Locals() {
            this.newWeight = RayProcessorBase.this.scene.createSpectrum();
            this.reflected = new Ray(this.newWeight);
            this.transmitted = new Ray(this.newWeight);
            this.tmpSpectrum = RayProcessorBase.this.scene.createSpectrum();
            this.tmpRay = new Line();
            this.env = new Environment(RayProcessorBase.this.scene.getBoundingBox(), this.newWeight, RayProcessorBase.this.getEnvironmentType());
            this.lightCache = new ArrayList();
            this.tmpRay.start = 0.0;
            this.tmpRay.end = Double.POSITIVE_INFINITY;
        }

        public Locals nextTransmitted() {
            if (this.nextTransmitted == null) {
                this.nextTransmitted = new Locals();
            }
            return this.nextTransmitted;
        }

        public Locals nextReflected() {
            if (this.nextReflected == null) {
                this.nextReflected = new Locals();
            }
            return this.nextReflected;
        }
    }
}

