/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing.modular;

import de.grogra.ray.physics.Emitter;
import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Sensor;
import de.grogra.ray.physics.Shader;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray.physics.Spectrum3f;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.BiDirectionalProcessor;
import de.grogra.ray2.tracing.PathTracer;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.modular.ConditionObject;
import de.grogra.ray2.tracing.modular.MemoryHelper;
import de.grogra.ray2.tracing.modular.PathValues;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class LineTracer
extends PathTracer {
    static final double EPSILON = 1.0E-4;
    private static final float MIN_WEIGHT = 0.01f;
    public static final int SPECULAR_CONDITION = 1;
    public int STOP_CONDITION = 1;
    public ConditionObject condition = null;
    public int abbortCode;
    public static final int MAX_DEPTH_REACHED = 1;
    public static final int NO_OBJECT_HIT = 2;
    public static final int OUTGOING_RAY_TOO_WEAK = 3;
    public static final int RAY_WAS_INFINITE = 4;
    public static final int RAY_WAS_ABSORBED = 5;
    public static final int RAY_WAS_STOPPED_ON_CONDITION = 6;
    public boolean traceSubPath = false;
    MemoryHelper envHelper;
    public int recursionCounter;
    BiDirectionalProcessor processor;
    Random randomCreation;
    int maxDepth;
    boolean isLightRay;
    String kind;
    PathValues pV = null;
    IntersectionList ilist = null;
    float outgoingDirectionDensity;
    float actualGeometryFactor;
    RayList rays = null;
    Vector3f view = null;
    Light hitLight = null;
    Sensor hitSensor = null;
    int lightID;
    int sensorID;
    boolean finite;
    Shader shader = null;
    Spectrum3d tmpSpec;
    RayList tmpRaylist;
    Environment tmpEnv;

    public LineTracer(BiDirectionalProcessor biDirectionalProcessor) {
        this.processor = biDirectionalProcessor;
    }

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        super.initialize(pixelwiseRenderer, scene);
        this.ilist = new IntersectionList();
        this.rays = new RayList(1);
        this.view = new Vector3f();
        this.tmpSpec = new Spectrum3d();
        this.tmpRaylist = new RayList();
        this.tmpEnv = new Environment(scene.getBoundingBox(), scene.createSpectrum(), 1);
    }

    public void setRandom(Random random) {
        this.randomCreation = random;
    }

    public void setMaxDepth(int n) {
        this.maxDepth = n;
        this.enteredSolids = new ArrayList(n);
    }

    public void set2LightPathTracing(boolean bl) {
        this.isLightRay = bl;
        this.kind = bl ? "light" : "eye";
    }

    public PathValues traceLine(int n, PathValues pathValues, Line line, Spectrum spectrum, int n2, boolean bl, Random random) {
        this.clearVariables();
        this.pV = pathValues;
        this.setRandom(random);
        this.setMaxDepth(n);
        this.set2LightPathTracing(bl);
        this.initializeFirstPathVertex(line, n2, spectrum);
        this.recursionCounter = 0;
        float f = this.traceRecursively(1, line, null, spectrum);
        this.pV.saveResult(f);
        return this.pV;
    }

    private void initializeFirstPathVertex(Line line, int n, Spectrum spectrum) {
        Environment environment = this.pV.envList.size() > 0 ? this.pV.envList.get(0) : new Environment(this.scene.getBoundingBox(), this.scene.createSpectrum(), 1);
        environment.iorRatio = 1.0f;
        Emitter emitter = null;
        if (this.isLightRay) {
            environment.localToGlobal.set(this.scene.getLightTransformation(n));
            environment.globalToLocal.set(this.scene.getInverseLightTransformation(n));
            emitter = this.scene.getLights()[n];
        } else {
            emitter = this.renderer.getCamera();
            environment.localToGlobal.set(this.renderer.getCameraTransformation());
            environment.globalToLocal.m33 = 1.0f;
            Math2.invertAffine((Matrix4f)environment.localToGlobal, (Matrix4f)environment.globalToLocal);
            line.directionDensity = Math2.M_1_2PI / 2.0f;
        }
        environment.point.set(line.origin);
        Float f = new Float(line.directionDensity);
        Intersection intersection = null;
        this.pV.saveValues(0, line, intersection, environment, spectrum, emitter, false, false);
        this.pV.initialSpectrum.set(spectrum);
        this.pV.saveProbabilityDensity(0, f.floatValue());
        this.pV.savePathLenght(1);
    }

    private float traceRecursively(int n, Line line, Intersection intersection, Spectrum spectrum) {
        this.abbortCode = -1;
        ++this.recursionCounter;
        float f = 0.0f;
        Line line2 = null;
        Spectrum3f spectrum3f = null;
        Environment environment = this.pV.envList.get(n - 1);
        int n2 = this.ilist.size;
        Intersection intersection2 = this.getNextIntersection(line, intersection);
        if (intersection2 != null) {
            Environment environment2 = this.initializeEnvironment(n, intersection2, spectrum, intersection2.line.direction);
            this.actualGeometryFactor = this.calculateGeometryFactor(n, environment2, environment);
            if (this.finite && n < this.maxDepth) {
                line2 = this.getNextRayAndSpec(n, environment2, intersection2, spectrum, line.direction);
                spectrum3f = new Spectrum3f(line2.spectrum.x, line2.spectrum.y, line2.spectrum.z);
                boolean bl = (double)Math.abs(environment2.normal.dot(this.view) - environment2.normal.dot(new Vector3f(line2.direction))) <= 1.0E-4;
                boolean bl2 = environment2.iorRatio != 1.0f || intersection2.type == -1;
                this.saveActualValues(n, line2, intersection2, environment2, spectrum3f, bl, bl2);
                if (this.condition == null || !this.condition.stopOnCondition()) {
                    if (line2.valid) {
                        if (spectrum3f.integrate() > (double)0.01f) {
                            int n3 = this.record(intersection2, line2.reflected);
                            f = this.traceRecursively(n + 1, line2, intersection2, spectrum3f);
                            this.unrecord(intersection2, n3);
                            this.ilist.setSize(n2);
                        } else {
                            this.abbortCode = 3;
                            f = 0.0f;
                        }
                    } else {
                        this.abbortCode = 5;
                    }
                } else {
                    this.abbortCode = 6;
                }
                if (line2.reflected) {
                    f = 0.0f;
                }
            } else {
                this.abbortCode = !this.finite ? 4 : 1;
            }
            this.ilist.setSize(n2);
        } else {
            this.abbortCode = 2;
            f = (float)spectrum.integrate();
        }
        return f;
    }

    Intersection getNextIntersection(Line line, Intersection intersection) {
        int n = this.ilist.size;
        this.scene.computeIntersections(line, 1, this.ilist, intersection, null);
        if (this.ilist.size > n) {
            return this.ilist.elements[n].deepCopy();
        }
        return null;
    }

    Environment initializeEnvironment(int n, Intersection intersection, Spectrum spectrum, Vector3d vector3d) {
        this.finite = intersection.parameter < Double.POSITIVE_INFINITY;
        this.view.set((Tuple3d)vector3d);
        this.view.negate();
        assert (Math.abs(this.view.lengthSquared() - 1.0f) < 1.0E-4f);
        this.shader = this.scene.getShader(intersection.volume);
        this.lightID = this.scene.getLight(intersection.volume);
        this.hitLight = this.lightID >= 0 ? this.scene.getLights()[this.lightID] : null;
        this.sensorID = this.scene.getSensor(intersection.volume);
        Sensor sensor = this.hitSensor = this.sensorID >= 0 ? this.scene.getSensors()[this.sensorID] : null;
        Environment environment = this.envHelper == null && this.pV.envList.size() > n ? this.pV.envList.get(n) : (this.envHelper != null ? this.envHelper.getFreeEnvironment() : new Environment(this.scene.getBoundingBox(), this.scene.createSpectrum(), 1));
        environment.set(intersection, (this.shader != null ? this.shader.getFlags() : 0) | (this.hitLight != null ? this.hitLight.getFlags() : 0), this.scene);
        environment.iorRatio = (float)this.getIOR(intersection, spectrum);
        environment.point.set((Tuple3d)((Point3d)intersection.getPoint().clone()));
        environment.normal.set((Tuple3d)((Vector3d)intersection.getNormal().clone()));
        return environment;
    }

    float calculateGeometryFactor(int n, Environment environment, Environment environment2) {
        Vector3f vector3f = new Vector3f();
        vector3f.sub((Tuple3f)environment.point, (Tuple3f)environment2.point);
        vector3f.normalize();
        if (environment2.normal.length() != 0.0f) {
            environment2.normal.normalize();
        }
        if (environment.normal.length() != 0.0f) {
            environment.normal.normalize();
        }
        double d = environment2.normal.length() != 0.0f ? environment2.normal.dot(vector3f) : 1.0f;
        vector3f.negate();
        double d2 = environment.normal.length() != 0.0f ? environment.normal.dot(vector3f) : 1.0f;
        double d3 = Math.max(1.0f, environment.point.distanceSquared(environment2.point));
        float f = (float)(Math.abs(d * d2) / d3);
        return f;
    }

    Line getNextRayAndSpec(int n, Environment environment, Intersection intersection, Spectrum spectrum, Vector3d vector3d) {
        this.rays.setSize(1);
        if (this.shader != null) {
            this.shader.generateRandomRays(environment, this.view, spectrum, this.rays, this.isLightRay, this.randomCreation);
        } else {
            this.rays.rays[0].direction.set((Tuple3d)vector3d);
            this.rays.rays[0].spectrum.set(spectrum);
        }
        Line line = this.rays.rays[0].convert2Line();
        line.setLineAttributes(0.0, Double.POSITIVE_INFINITY);
        line.origin.set((Tuple3f)environment.point);
        this.outgoingDirectionDensity = this.rays.rays[0].directionDensity;
        Color3f color3f = new Color3f();
        spectrum.get((Tuple3f)color3f);
        return line;
    }

    void saveActualValues(int n, Line line, Intersection intersection, Environment environment, Spectrum spectrum, boolean bl, boolean bl2) {
        this.pV.saveValues(n, line, intersection, environment, spectrum, this.shader, bl, bl2);
        this.pV.saveProbabilityDensity(n, this.outgoingDirectionDensity);
        this.pV.saveGeometryFactor(n - 1, this.actualGeometryFactor);
        this.pV.saveHitLight(n, this.hitLight);
        this.pV.savePathLenght(n + 1);
    }

    void clearVariables() {
        this.pV = null;
        this.traceSubPath = false;
        this.ilist.clear();
        this.ilist.elements = new Intersection[1];
        this.ilist.setSize(10);
        this.ilist.setSize(0);
        this.outgoingDirectionDensity = 0.0f;
        this.actualGeometryFactor = 0.0f;
        this.enteredSolids.clear();
        this.rays.clear();
        this.view = new Vector3f();
        this.hitLight = null;
        this.hitSensor = null;
        this.lightID = 0;
        this.sensorID = 0;
        this.finite = false;
        this.shader = null;
    }

    public PathValues getPathValues() {
        return this.pV;
    }

    public void setCondition(ConditionObject conditionObject) {
        this.condition = conditionObject;
    }

    private boolean testOnSTop() {
        return false;
    }

    public void traceSubPath(PathValues pathValues, int n, int n2, boolean bl, Vector3d vector3d) {
        this.clearVariables();
        this.pV = pathValues;
        this.traceSubPath = true;
        this.setMaxDepth(n + n2 + 1);
        this.set2LightPathTracing(bl);
        Intersection intersection = this.pV.intersecList.get(n);
        Spectrum spectrum = this.pV.weightListBE.get(n - 1);
        Line line = this.pV.rayListBE.get(n - 1);
        if (!line.valid) {
            this.abbortCode = 5;
            return;
        }
        Environment environment = intersection != null ? this.initializeEnvironment(n, intersection, spectrum, line.direction) : this.pV.envList.get(n);
        Line line2 = this.getNextRayAndSpec(n, environment, intersection, spectrum, line.direction);
        if (vector3d != null) {
            line2.direction.set((Tuple3d)vector3d);
        }
        Spectrum3d spectrum3d = new Spectrum3d();
        spectrum3d.set(line2.spectrum.x, line2.spectrum.y, line2.spectrum.z);
        if (pathValues.rayListBE.size() > n) {
            pathValues.rayListBE.set(n, line2);
        } else {
            pathValues.rayListBE.add(n, line2);
        }
        if (pathValues.weightListBE.size() > n) {
            pathValues.weightListBE.set(n, spectrum3d);
        } else {
            pathValues.weightListBE.add(n, spectrum3d);
        }
        if (!line2.valid) {
            this.abbortCode = 5;
            return;
        }
        if (this.maxDepth > n) {
            this.recursionCounter = 0;
            float f = this.traceRecursively(n + 1, line2, intersection, spectrum3d);
            this.pV.saveResult(f);
        } else {
            this.abbortCode = 1;
        }
    }

    public void setSafeMemoryMode(MemoryHelper memoryHelper) {
        this.envHelper = memoryHelper;
    }

    public int getAbbortCode() {
        return this.abbortCode;
    }

    public String getTracingAbbortDescription() {
        switch (this.abbortCode) {
            case 1: {
                return " Maximum depth of " + this.maxDepth + " was reached!";
            }
            case 3: {
                return " The weight of the outgoing ray was too weak for continuing tracing!";
            }
            case 2: {
                return " The ray didn't intersect another object!";
            }
            case 4: {
                return " The ray reached infinity!";
            }
            case 5: {
                return " The ray was absorbed by the object surface!";
            }
            case 6: {
                return " The ray was stopped by condition!";
            }
        }
        return " Something wrong abborted the Line tracer";
    }

    public String printIList() {
        String string = "ilist.Size=" + this.ilist.size + " ilist.elements.Size=" + this.ilist.elements.length + "\n";
        for (int i = 0; i < this.ilist.elements.length; ++i) {
            string = this.ilist.elements[i] != null && this.ilist.elements[i].line != null ? string + "   element[" + i + "]=" + this.ilist.elements[i].getPoint() + "\n" : string + "   element[" + i + "]= null \n";
        }
        return string;
    }
}

