/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.AttributeSet;
import de.grogra.xl.util.ObjectList;

public class AccessorMap
extends AttributeSet {
    AttributeAccessor[] accessors;
    AttributeAccessor[] accessorsById;

    public AccessorMap() {
        this(true);
    }

    public AccessorMap(boolean bl) {
        this.accessors = new AttributeAccessor[0];
        this.accessorsById = bl ? new AttributeAccessor[]{} : null;
    }

    public AccessorMap(AccessorMap accessorMap) {
        super(accessorMap);
        this.accessors = (AttributeAccessor[])accessorMap.accessors.clone();
        this.accessorsById = accessorMap.accessorsById != null ? (AttributeAccessor[])accessorMap.accessorsById.clone() : null;
    }

    public void add(AttributeAccessor attributeAccessor) {
        int n;
        int n2 = attributeAccessor.getAttribute().id;
        if (this.accessorsById == null) {
            n = this.findIndex(n2);
            if (n >= 0) {
                this.accessors[n] = attributeAccessor;
                return;
            }
        } else if (n2 < this.accessorsById.length && this.accessorsById[n2] != null) {
            for (int i = this.accessors.length - 1; i >= 0; --i) {
                if (this.accessors[i] != this.accessorsById[n2]) continue;
                this.accessors[i] = attributeAccessor;
                this.accessorsById[n2] = attributeAccessor;
                return;
            }
            throw new AssertionError();
        }
        n = this.accessors.length;
        this.accessors = new AttributeAccessor[n + 1];
        System.arraycopy(this.accessors, 0, this.accessors, 0, n);
        this.accessors[n] = attributeAccessor;
        if (this.accessorsById != null) {
            if (n2 >= this.accessorsById.length) {
                AttributeAccessor[] attributeAccessorArray = new AttributeAccessor[n2 + 1];
                System.arraycopy(this.accessorsById, 0, attributeAccessorArray, 0, this.accessorsById.length);
                this.accessorsById = attributeAccessorArray;
            }
            this.accessorsById[n2] = attributeAccessor;
        }
        super.add(attributeAccessor.getAttribute());
    }

    public final int size() {
        return this.accessors.length;
    }

    private int findIndex(int n) {
        for (int i = this.accessors.length - 1; i >= 0; --i) {
            if (this.accessors[i].getAttribute().id != n) continue;
            return i;
        }
        return -1;
    }

    public final AttributeAccessor getAccessor(int n) {
        return this.accessors[n];
    }

    public final AttributeAccessor getAccessorById(int n) {
        if (this.accessorsById != null) {
            return n < this.accessorsById.length ? this.accessorsById[n] : null;
        }
        return (n = this.findIndex(n)) >= 0 ? this.accessors[n] : null;
    }

    public AttributeAccessor getAccessor(Attribute attribute) {
        int n = attribute.id;
        return this.accessorsById == null ? this.getAccessorById(n) : (n < this.accessorsById.length ? this.accessorsById[n] : null);
    }

    public final Attribute[] getAttributes(Attribute[] attributeArray) {
        if (attributeArray != null) {
            int n;
            ObjectList<Attribute> objectList = new ObjectList<Attribute>(this.accessors.length + (attributeArray != null ? attributeArray.length : 0));
            for (n = attributeArray.length - 1; n >= 0; --n) {
                if (this.findIndex(attributeArray[n].id) >= 0) continue;
                objectList.add(attributeArray[n]);
            }
            for (n = this.accessors.length - 1; n >= 0; --n) {
                objectList.add(this.accessors[n].getAttribute());
            }
            return objectList.toArray(new Attribute[objectList.size()]);
        }
        int n = this.accessors.length;
        Attribute[] attributeArray2 = new Attribute[n];
        while (--n >= 0) {
            attributeArray2[n] = this.accessors[n].getAttribute();
        }
        return attributeArray2;
    }

    public final AttributeAccessor find(String string) {
        return Attribute.find(this.accessors, string);
    }
}

