/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.AccessorMap;
import de.grogra.graph.ArrayPath;
import de.grogra.graph.Attribute;
import de.grogra.graph.AttributeAccessor;
import de.grogra.graph.BooleanAttribute;
import de.grogra.graph.ByteAttribute;
import de.grogra.graph.CharAttribute;
import de.grogra.graph.DoubleAttribute;
import de.grogra.graph.FloatAttribute;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphFilter;
import de.grogra.graph.GraphState;
import de.grogra.graph.IntAttribute;
import de.grogra.graph.LongAttribute;
import de.grogra.graph.ObjectAttribute;
import de.grogra.graph.ShortAttribute;
import de.grogra.graph.Visitor;

public abstract class AttributeOverwritingFilter
extends GraphFilter {
    private final AccessorMap nodeAccessors = new AccessorMap();
    private final AccessorMap edgeAccessors = new AccessorMap();

    public AttributeOverwritingFilter(Graph graph) {
        super(graph);
    }

    protected void initAttributeOverwritingFilter() {
        this.initNodeAccessors(this.nodeAccessors);
        this.nodeAccessors.setReadOnly();
        this.initEdgeAccessors(this.edgeAccessors);
        this.edgeAccessors.setReadOnly();
    }

    protected void initNodeAccessors(AccessorMap accessorMap) {
    }

    protected void initEdgeAccessors(AccessorMap accessorMap) {
    }

    public void accept(Object object, Visitor visitor, ArrayPath arrayPath) {
        this.accept(object, visitor, arrayPath, false);
    }

    public Attribute[] getAttributes(Object object, boolean bl) {
        return (bl ? this.nodeAccessors : this.edgeAccessors).getAttributes(super.getAttributes(object, bl));
    }

    public AttributeAccessor getAccessor(Object object, boolean bl, Attribute attribute) {
        AttributeAccessor attributeAccessor = (bl ? this.nodeAccessors : this.edgeAccessors).getAccessor(attribute);
        return attributeAccessor != null ? attributeAccessor : super.getAccessor(object, bl, attribute);
    }

    protected boolean getBoolean(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getBoolean(object, accessorBridge.forNode, (BooleanAttribute)accessorBridge.getAttribute());
    }

    protected boolean setBoolean(Object object, GraphFilter.AccessorBridge accessorBridge, boolean bl, GraphState graphState) {
        return ((BooleanAttribute)accessorBridge.getAttribute()).setBoolean(object, accessorBridge.forNode, bl, AttributeOverwritingFilter.getSourceState(graphState));
    }

    protected byte getByte(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getByte(object, accessorBridge.forNode, (ByteAttribute)accessorBridge.getAttribute());
    }

    protected byte setByte(Object object, GraphFilter.AccessorBridge accessorBridge, byte by, GraphState graphState) {
        return ((ByteAttribute)accessorBridge.getAttribute()).setByte(object, accessorBridge.forNode, by, AttributeOverwritingFilter.getSourceState(graphState));
    }

    protected short getShort(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getShort(object, accessorBridge.forNode, (ShortAttribute)accessorBridge.getAttribute());
    }

    protected short setShort(Object object, GraphFilter.AccessorBridge accessorBridge, short s, GraphState graphState) {
        return ((ShortAttribute)accessorBridge.getAttribute()).setShort(object, accessorBridge.forNode, s, AttributeOverwritingFilter.getSourceState(graphState));
    }

    protected char getChar(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getChar(object, accessorBridge.forNode, (CharAttribute)accessorBridge.getAttribute());
    }

    protected char setChar(Object object, GraphFilter.AccessorBridge accessorBridge, char c, GraphState graphState) {
        return ((CharAttribute)accessorBridge.getAttribute()).setChar(object, accessorBridge.forNode, c, AttributeOverwritingFilter.getSourceState(graphState));
    }

    protected int getInt(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getInt(object, accessorBridge.forNode, (IntAttribute)accessorBridge.getAttribute());
    }

    protected int setInt(Object object, GraphFilter.AccessorBridge accessorBridge, int n, GraphState graphState) {
        return ((IntAttribute)accessorBridge.getAttribute()).setInt(object, accessorBridge.forNode, n, AttributeOverwritingFilter.getSourceState(graphState));
    }

    protected long getLong(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getLong(object, accessorBridge.forNode, (LongAttribute)accessorBridge.getAttribute());
    }

    protected long setLong(Object object, GraphFilter.AccessorBridge accessorBridge, long l, GraphState graphState) {
        return ((LongAttribute)accessorBridge.getAttribute()).setLong(object, accessorBridge.forNode, l, AttributeOverwritingFilter.getSourceState(graphState));
    }

    protected float getFloat(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getFloat(object, accessorBridge.forNode, (FloatAttribute)accessorBridge.getAttribute());
    }

    protected float setFloat(Object object, GraphFilter.AccessorBridge accessorBridge, float f, GraphState graphState) {
        return ((FloatAttribute)accessorBridge.getAttribute()).setFloat(object, accessorBridge.forNode, f, AttributeOverwritingFilter.getSourceState(graphState));
    }

    protected double getDouble(Object object, GraphFilter.AccessorBridge accessorBridge, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getDouble(object, accessorBridge.forNode, (DoubleAttribute)accessorBridge.getAttribute());
    }

    protected double setDouble(Object object, GraphFilter.AccessorBridge accessorBridge, double d, GraphState graphState) {
        return ((DoubleAttribute)accessorBridge.getAttribute()).setDouble(object, accessorBridge.forNode, d, AttributeOverwritingFilter.getSourceState(graphState));
    }

    protected Object getObject(Object object, GraphFilter.AccessorBridge accessorBridge, Object object2, GraphState graphState) {
        return AttributeOverwritingFilter.getSourceState(graphState).getObject(object, accessorBridge.forNode, object2, (ObjectAttribute)accessorBridge.getAttribute());
    }

    protected Object setObject(Object object, GraphFilter.AccessorBridge accessorBridge, Object object2, GraphState graphState) {
        return ((ObjectAttribute)accessorBridge.getAttribute()).setObject(object, accessorBridge.forNode, object2, AttributeOverwritingFilter.getSourceState(graphState));
    }
}

