/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.graph;

import de.grogra.graph.ContextDependent;
import de.grogra.graph.GraphState;
import de.grogra.xl.util.EHashMap;
import de.grogra.xl.util.FloatList;
import java.util.WeakHashMap;

public abstract class Cache {
    protected final GraphState gs;
    private final EHashMap<HashEntry> infos = new EHashMap();

    public Cache(GraphState graphState) {
        this.gs = graphState;
    }

    public void clearUnused() {
        int n = this.gs.getGraph().getStamp();
        HashEntry hashEntry = this.infos.getFirstEntry();
        while (hashEntry != null) {
            HashEntry hashEntry2 = (HashEntry)hashEntry.listNext;
            if (((Info)hashEntry.value).stamp != n) {
                this.infos.remove(hashEntry);
            }
            hashEntry = hashEntry2;
        }
    }

    public void clear() {
        this.infos.clear();
    }

    public GraphState getGraphState() {
        return this.gs;
    }

    public Object getValue(Object object, boolean bl, ContextDependent contextDependent, Object object2) {
        Entry entry;
        Info info;
        HashEntry hashEntry = this.infos.popEntryFromPool();
        if (hashEntry == null) {
            hashEntry = new HashEntry();
        }
        hashEntry.setKey(contextDependent, object2);
        HashEntry hashEntry2 = this.infos.getOrPut(hashEntry);
        if (hashEntry2 != null) {
            info = (Info)hashEntry2.value;
        } else {
            info = new Info();
            hashEntry.value = info;
        }
        if (contextDependent.dependsOnContext()) {
            if (info.object == null) {
                info.object = object;
                info.asNode = bl;
                info.entry = entry = this.createEntry(object, bl, contextDependent, object2);
            } else if (info.object == object && info.asNode == bl) {
                entry = info.entry;
            } else {
                WeakHashMap<Object, Entry> weakHashMap;
                WeakHashMap<Object, Entry> weakHashMap2 = weakHashMap = bl ? info.nodeEntries : info.edgeEntries;
                if (weakHashMap == null) {
                    entry = null;
                    weakHashMap = new WeakHashMap();
                    if (bl) {
                        info.nodeEntries = weakHashMap;
                    } else {
                        info.edgeEntries = weakHashMap;
                    }
                } else {
                    entry = weakHashMap.get(object);
                }
                if (entry == null) {
                    entry = this.createEntry(object, bl, contextDependent, object2);
                    weakHashMap.put(object, entry);
                }
            }
        } else {
            if (info.object != null) {
                info.object = null;
                info.entry = null;
            }
            if (info.nodeEntries != null) {
                info.nodeEntries.clear();
                info.nodeEntries = null;
            }
            if (info.edgeEntries != null) {
                info.edgeEntries.clear();
                info.edgeEntries = null;
            }
            if ((entry = info.entry) == null) {
                info.entry = entry = this.createEntry(null, false, contextDependent, object2);
            }
        }
        info.stamp = this.gs.getGraph().getStamp();
        return entry.getValue();
    }

    protected abstract Entry createEntry(Object var1, boolean var2, ContextDependent var3, Object var4);

    private static final class Info {
        int stamp;
        Object object;
        boolean asNode;
        Entry entry;
        WeakHashMap<Object, Entry> nodeEntries;
        WeakHashMap<Object, Entry> edgeEntries;

        private Info() {
        }
    }

    public static abstract class Entry {
        private final GraphState gs;
        private final Object object;
        private final boolean asNode;
        private final ContextDependent dependent;
        private final Object strategy;
        private final FloatList data = new FloatList();
        private int index;
        private boolean dirty = true;
        private int stamp;
        private Object value;

        public Entry(Object object, boolean bl, ContextDependent contextDependent, Object object2, GraphState graphState) {
            this.object = object;
            this.asNode = bl;
            this.dependent = contextDependent;
            this.strategy = object2;
            this.gs = graphState;
        }

        public final void write(int n) {
            this.write((float)((char)n));
            this.write((float)(n >>> 16));
        }

        public final void write(float f) {
            if (this.dirty) {
                this.data.set(this.index++, f);
            } else if (this.data.set(this.index++, f) != f) {
                this.dirty = true;
            }
        }

        public final void write(float[] fArray) {
            this.write(fArray, 0, fArray.length);
        }

        public final void write(float[] fArray, int n, int n2) {
            int n3 = this.index + n2;
            if (this.data.size < n3) {
                this.data.setSize(n3);
                this.dirty = true;
            }
            n2 += n;
            while (n < n2 && !this.dirty) {
                float f;
                if (this.data.set(this.index++, f = fArray[n++]) == f) continue;
                this.dirty = true;
            }
            if (this.dirty) {
                System.arraycopy(fArray, n, this.data.elements, this.index, n2 - n);
                this.index = n3;
            }
        }

        final Object getValue() {
            int n = this.gs.getGraph().getStamp();
            if (!this.dirty && n == this.stamp) {
                return this.value;
            }
            this.stamp = n;
            this.gs.setObjectContext(this.object, this.asNode);
            this.index = 0;
            int n2 = this.data.size;
            this.dependent.writeStamp(this, this.gs);
            if (n2 != this.index) {
                this.dirty = true;
                this.data.setSize(this.index);
            }
            if (this.dirty) {
                this.value = this.computeValue(this.value, this.dependent, this.strategy, this.gs);
                this.dirty = false;
            }
            return this.value;
        }

        protected abstract Object computeValue(Object var1, ContextDependent var2, Object var3, GraphState var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HashEntry
    extends EHashMap.ObjectEntry<ContextDependent, Info> {
        private Object strategy;

        private HashEntry() {
        }

        void setKey(ContextDependent contextDependent, Object object) {
            super.setKey(contextDependent);
            this.strategy = object;
            if (object != null) {
                this.hashCode ^= object.hashCode();
            }
        }

        @Override
        protected boolean keyEquals(EHashMap.Entry entry) {
            if (!super.keyEquals(entry)) {
                return false;
            }
            return this.strategy == ((HashEntry)entry).strategy || this.strategy != null && this.strategy.equals(((HashEntry)entry).strategy);
        }

        @Override
        protected void clear() {
            super.clear();
            this.strategy = null;
        }
    }
}

